/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueDate
extends Value {
    public static final int PRECISION = 10;
    private final long dateValue;

    private ValueDate(long dateValue) {
        this.dateValue = dateValue;
    }

    public static ValueDate fromDateValue(long dateValue) {
        return (ValueDate)ValueDate.cache(new ValueDate(dateValue));
    }

    public static ValueDate get(Date date) {
        long ms = date.getTime();
        return ValueDate.fromDateValue(DateTimeUtils.dateValueFromLocalMillis(ms + (long)DateTimeUtils.getTimeZoneOffset(ms)));
    }

    public static ValueDate fromMillis(long ms) {
        return ValueDate.fromDateValue(DateTimeUtils.dateValueFromLocalMillis(ms + (long)DateTimeUtils.getTimeZoneOffset(ms)));
    }

    public static ValueDate parse(String s2) {
        try {
            return ValueDate.fromDateValue(DateTimeUtils.parseDateValue(s2, 0, s2.length()));
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "DATE", s2);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    @Override
    public Date getDate() {
        return DateTimeUtils.convertDateValueToDate(this.dateValue);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_DATE;
    }

    @Override
    public int getValueType() {
        return 10;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder(10);
        DateTimeUtils.appendDate(buff, this.dateValue);
        return buff.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("DATE '");
        DateTimeUtils.appendDate(builder, this.dateValue);
        return builder.append('\'');
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Long.compare(this.dateValue, ((ValueDate)o).dateValue);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ValueDate && this.dateValue == ((ValueDate)other).dateValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getDate();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDate(parameterIndex, this.getDate());
    }
}

