/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import org.gridgain.internal.h2.api.CustomDataTypesHandler;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.ExtTypeInfoEnum;
import org.gridgain.internal.h2.value.ExtTypeInfoGeometry;
import org.gridgain.internal.h2.value.ValueInterval;

public class TypeInfo {
    public static final TypeInfo TYPE_UNKNOWN;
    public static final TypeInfo TYPE_NULL;
    public static final TypeInfo TYPE_BOOLEAN;
    public static final TypeInfo TYPE_BYTE;
    public static final TypeInfo TYPE_SHORT;
    public static final TypeInfo TYPE_INT;
    public static final TypeInfo TYPE_LONG;
    public static final TypeInfo TYPE_DECIMAL;
    public static final TypeInfo TYPE_DECIMAL_DEFAULT;
    public static final TypeInfo TYPE_DOUBLE;
    public static final TypeInfo TYPE_FLOAT;
    public static final TypeInfo TYPE_TIME;
    public static final TypeInfo TYPE_DATE;
    public static final TypeInfo TYPE_TIMESTAMP;
    public static final TypeInfo TYPE_STRING;
    public static final TypeInfo TYPE_ARRAY;
    public static final TypeInfo TYPE_RESULT_SET;
    public static final TypeInfo TYPE_JAVA_OBJECT;
    public static final TypeInfo TYPE_UUID;
    public static final TypeInfo TYPE_GEOMETRY;
    public static final TypeInfo TYPE_TIMESTAMP_TZ;
    public static final TypeInfo TYPE_ENUM_UNDEFINED;
    public static final TypeInfo TYPE_INTERVAL_DAY;
    public static final TypeInfo TYPE_INTERVAL_DAY_TO_SECOND;
    public static final TypeInfo TYPE_INTERVAL_HOUR_TO_SECOND;
    public static final TypeInfo TYPE_ROW;
    private static final TypeInfo[] TYPE_INFOS_BY_VALUE_TYPE;
    private final int valueType;
    private final long precision;
    private final int scale;
    private final int displaySize;
    private final ExtTypeInfo extTypeInfo;

    public static TypeInfo getTypeInfo(int type) {
        DataType dt;
        TypeInfo t2;
        if (type == -1) {
            throw DbException.get(50004, "?");
        }
        if (type >= 0 && type < 40 && (t2 = TYPE_INFOS_BY_VALUE_TYPE[type]) != null) {
            return t2;
        }
        CustomDataTypesHandler handler = JdbcUtils.customDataTypesHandler;
        if (handler != null && (dt = handler.getDataTypeById(type)) != null) {
            return handler.getTypeInfoById(type, dt.maxPrecision, dt.maxScale, null);
        }
        return TYPE_NULL;
    }

    public static TypeInfo getTypeInfo(int type, long precision, int scale, ExtTypeInfo extTypeInfo) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 39: {
                return TYPE_INFOS_BY_VALUE_TYPE[type];
            }
            case -1: {
                return TYPE_UNKNOWN;
            }
            case 6: {
                if (precision < 0L) {
                    precision = 65535L;
                }
                if (scale < 0) {
                    scale = Short.MAX_VALUE;
                }
                if (precision < (long)scale) {
                    precision = scale;
                }
                return new TypeInfo(6, precision, scale, MathUtils.convertLongToInt(precision + 2L), null);
            }
            case 9: {
                if (scale < 0 || scale >= 9) {
                    return TYPE_TIME;
                }
                int d = scale == 0 ? 8 : 9 + scale;
                return new TypeInfo(9, d, scale, d, null);
            }
            case 11: {
                if (scale < 0 || scale >= 9) {
                    return TYPE_TIMESTAMP;
                }
                int d = scale == 0 ? 19 : 20 + scale;
                return new TypeInfo(11, d, scale, d, null);
            }
            case 24: {
                if (scale < 0 || scale >= 9) {
                    return TYPE_TIMESTAMP_TZ;
                }
                int d = scale == 0 ? 25 : 26 + scale;
                return new TypeInfo(24, d, scale, d, null);
            }
            case 12: {
                if (precision < 0L) {
                    precision = Integer.MAX_VALUE;
                }
                return new TypeInfo(12, precision, 0, MathUtils.convertLongToInt(precision) * 2, null);
            }
            case 13: {
                if (precision < 0L) {
                    return TYPE_STRING;
                }
            }
            case 14: 
            case 21: {
                if (precision < 0L) {
                    precision = Integer.MAX_VALUE;
                }
                return new TypeInfo(type, precision, 0, MathUtils.convertLongToInt(precision), null);
            }
            case 15: 
            case 16: {
                if (precision < 0L) {
                    precision = Long.MAX_VALUE;
                }
                return new TypeInfo(type, precision, 0, MathUtils.convertLongToInt(precision), null);
            }
            case 22: {
                if (extTypeInfo instanceof ExtTypeInfoGeometry) {
                    return new TypeInfo(22, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, extTypeInfo);
                }
                return TYPE_GEOMETRY;
            }
            case 25: {
                if (extTypeInfo instanceof ExtTypeInfoEnum) {
                    return ((ExtTypeInfoEnum)extTypeInfo).getType();
                }
                return TYPE_ENUM_UNDEFINED;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                if (precision < 1L || precision > 18L) {
                    precision = 18L;
                }
                return new TypeInfo(type, precision, 0, ValueInterval.getDisplaySize(type, (int)precision, 0), null);
            }
            case 31: 
            case 35: 
            case 37: 
            case 38: {
                if (precision < 1L || precision > 18L) {
                    precision = 18L;
                }
                if (scale < 0 || scale > 9) {
                    scale = 9;
                }
                return new TypeInfo(type, precision, scale, ValueInterval.getDisplaySize(type, (int)precision, scale), null);
            }
        }
        CustomDataTypesHandler handler = JdbcUtils.customDataTypesHandler;
        if (handler != null && handler.getDataTypeById(type) != null) {
            return handler.getTypeInfoById(type, precision, scale, extTypeInfo);
        }
        return TYPE_NULL;
    }

    public TypeInfo(int valueType, long precision, int scale, int displaySize, ExtTypeInfo extTypeInfo) {
        this.valueType = valueType;
        this.precision = precision;
        this.scale = scale;
        this.displaySize = displaySize;
        this.extTypeInfo = extTypeInfo;
    }

    public int getValueType() {
        return this.valueType;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public ExtTypeInfo getExtTypeInfo() {
        return this.extTypeInfo;
    }

    public StringBuilder getSQL(StringBuilder builder) {
        DataType dataType = DataType.getDataType(this.valueType);
        if (this.valueType == 24) {
            builder.append("TIMESTAMP");
        } else {
            builder.append(dataType.name);
        }
        switch (this.valueType) {
            case 6: {
                builder.append('(').append(this.precision).append(", ").append(this.scale).append(')');
                break;
            }
            case 22: {
                if (this.extTypeInfo == null) break;
            }
            case 25: {
                builder.append(this.extTypeInfo.getCreateSQL());
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                if (this.precision >= Integer.MAX_VALUE) break;
                builder.append('(').append(this.precision).append(')');
                break;
            }
            case 9: 
            case 11: 
            case 24: {
                if (this.scale != dataType.defaultScale) {
                    builder.append('(').append(this.scale).append(')');
                }
                if (this.valueType != 24) break;
                builder.append(" WITH TIME ZONE");
            }
        }
        return builder;
    }

    static {
        TypeInfo[] infos = new TypeInfo[40];
        TYPE_UNKNOWN = new TypeInfo(-1, -1L, -1, -1, null);
        infos[0] = TYPE_NULL = new TypeInfo(0, 1L, 0, 4, null);
        infos[1] = TYPE_BOOLEAN = new TypeInfo(1, 1L, 0, 5, null);
        infos[2] = TYPE_BYTE = new TypeInfo(2, 3L, 0, 4, null);
        infos[3] = TYPE_SHORT = new TypeInfo(3, 5L, 0, 6, null);
        infos[4] = TYPE_INT = new TypeInfo(4, 10L, 0, 11, null);
        infos[5] = TYPE_LONG = new TypeInfo(5, 19L, 0, 20, null);
        infos[6] = TYPE_DECIMAL = new TypeInfo(6, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null);
        TYPE_DECIMAL_DEFAULT = new TypeInfo(6, 65535L, Short.MAX_VALUE, 65537, null);
        infos[7] = TYPE_DOUBLE = new TypeInfo(7, 17L, 0, 24, null);
        infos[8] = TYPE_FLOAT = new TypeInfo(8, 7L, 0, 15, null);
        infos[9] = TYPE_TIME = new TypeInfo(9, 18L, 9, 18, null);
        infos[10] = TYPE_DATE = new TypeInfo(10, 10L, 0, 10, null);
        infos[11] = TYPE_TIMESTAMP = new TypeInfo(11, 29L, 9, 29, null);
        infos[12] = new TypeInfo(12, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[13] = TYPE_STRING = new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[14] = new TypeInfo(14, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[15] = new TypeInfo(15, Long.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[16] = new TypeInfo(16, Long.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[17] = TYPE_ARRAY = new TypeInfo(17, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[18] = TYPE_RESULT_SET = new TypeInfo(18, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null);
        infos[19] = TYPE_JAVA_OBJECT = new TypeInfo(19, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[20] = TYPE_UUID = new TypeInfo(20, 16L, 0, 36, null);
        infos[21] = new TypeInfo(21, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[22] = TYPE_GEOMETRY = new TypeInfo(22, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        infos[24] = TYPE_TIMESTAMP_TZ = new TypeInfo(24, 35L, 9, 35, null);
        infos[25] = TYPE_ENUM_UNDEFINED = new TypeInfo(25, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        for (int i = 26; i <= 38; ++i) {
            infos[i] = new TypeInfo(i, 18L, IntervalQualifier.valueOf(i - 26).hasSeconds() ? 9 : 0, ValueInterval.getDisplaySize(i, 18, 9), null);
        }
        TYPE_INTERVAL_DAY = infos[28];
        TYPE_INTERVAL_DAY_TO_SECOND = infos[35];
        TYPE_INTERVAL_HOUR_TO_SECOND = infos[37];
        infos[39] = TYPE_ROW = new TypeInfo(39, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        TYPE_INFOS_BY_VALUE_TYPE = infos;
    }
}

