/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.SimpleResult;
import org.gridgain.internal.h2.security.SHA256;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataReader;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.NetUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueEnumBase;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueJavaObject;
import org.gridgain.internal.h2.value.ValueLobDb;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueStringFixed;
import org.gridgain.internal.h2.value.ValueStringIgnoreCase;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;
import org.gridgain.internal.h2.value.ValueUuid;

public class Transfer {
    private static final int BUFFER_SIZE = 65536;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int INT = 4;
    private static final int LONG = 5;
    private static final int DECIMAL = 6;
    private static final int DOUBLE = 7;
    private static final int FLOAT = 8;
    private static final int TIME = 9;
    private static final int DATE = 10;
    private static final int TIMESTAMP = 11;
    private static final int BYTES = 12;
    private static final int STRING = 13;
    private static final int STRING_IGNORECASE = 14;
    private static final int BLOB = 15;
    private static final int CLOB = 16;
    private static final int ARRAY = 17;
    private static final int RESULT_SET = 18;
    private static final int JAVA_OBJECT = 19;
    private static final int UUID = 20;
    private static final int STRING_FIXED = 21;
    private static final int GEOMETRY = 22;
    private static final int TIMESTAMP_TZ = 24;
    private static final int ENUM = 25;
    private static final int INTERVAL = 26;
    private static final int ROW = 27;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    public Transfer(SessionInterface session, Socket s2) {
        this.session = session;
        this.socket = s2;
    }

    public synchronized void init() throws IOException {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean x) throws IOException {
        this.out.writeByte((byte)(x ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() != 0;
    }

    private Transfer writeByte(byte x) throws IOException {
        this.out.writeByte(x);
        return this;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int x) throws IOException {
        this.out.writeInt(x);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long x) throws IOException {
        this.out.writeLong(x);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    private Transfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String s2) throws IOException {
        if (s2 == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(s2.length());
            this.out.writeChars(s2);
        }
        return this;
    }

    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        StringBuilder buff = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buff.append(this.in.readChar());
        }
        String s2 = buff.toString();
        s2 = StringUtils.cache(s2);
        return s2;
    }

    public Transfer writeBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.out.write(data);
        }
        return this;
    }

    public Transfer writeBytes(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        return this;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = Utils.newBytes(len);
        this.in.readFully(b);
        return b;
    }

    public void readBytes(byte[] buff, int off, int len) throws IOException {
        this.in.readFully(buff, off, len);
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                DbException.traceThrowable(e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value v) throws IOException {
        int type = v.getValueType();
        switch (type) {
            case 0: {
                this.writeInt(0);
                break;
            }
            case 12: {
                this.writeInt(12);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 19: {
                this.writeInt(19);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 20: {
                this.writeInt(20);
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 1: {
                this.writeInt(1);
                this.writeBoolean(v.getBoolean());
                break;
            }
            case 2: {
                this.writeInt(2);
                this.writeByte(v.getByte());
                break;
            }
            case 9: {
                this.writeInt(9);
                this.writeLong(((ValueTime)v).getNanos());
                break;
            }
            case 10: {
                this.writeInt(10);
                this.writeLong(((ValueDate)v).getDateValue());
                break;
            }
            case 11: {
                this.writeInt(11);
                ValueTimestamp ts = (ValueTimestamp)v;
                this.writeLong(ts.getDateValue());
                this.writeLong(ts.getTimeNanos());
                break;
            }
            case 24: {
                this.writeInt(24);
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                this.writeLong(ts.getDateValue());
                this.writeLong(ts.getTimeNanos());
                this.writeInt(ts.getTimeZoneOffsetMins());
                break;
            }
            case 6: {
                this.writeInt(6);
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeInt(7);
                this.writeDouble(v.getDouble());
                break;
            }
            case 8: {
                this.writeInt(8);
                this.writeFloat(v.getFloat());
                break;
            }
            case 4: {
                this.writeInt(4);
                this.writeInt(v.getInt());
                break;
            }
            case 5: {
                this.writeInt(5);
                this.writeLong(v.getLong());
                break;
            }
            case 3: {
                this.writeInt(3);
                this.writeInt(v.getShort());
                break;
            }
            case 13: {
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            case 14: {
                this.writeInt(14);
                this.writeString(v.getString());
                break;
            }
            case 21: {
                this.writeInt(21);
                this.writeString(v.getString());
                break;
            }
            case 15: {
                ValueLobDb lob;
                this.writeInt(15);
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getType().getPrecision());
                    break;
                }
                long length = v.getType().getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                long written = IOUtils.copyAndCloseInput(v.getInputStream(), this.out);
                if (written != length) {
                    throw DbException.get(90067, "length:" + length + " written:" + written);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                ValueLobDb lob;
                this.writeInt(16);
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getType().getPrecision());
                    break;
                }
                long length = v.getType().getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                Reader reader = v.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                this.writeInt(17);
                ValueArray va = (ValueArray)v;
                Value[] list = va.getList();
                int len = list.length;
                Class<?> componentType = va.getComponentType();
                if (componentType == Object.class) {
                    this.writeInt(len);
                } else {
                    this.writeInt(-(len + 1));
                    this.writeString(componentType.getName());
                }
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 39: {
                this.writeInt(this.version >= 18 ? 27 : 17);
                ValueRow va = (ValueRow)v;
                Value[] list = va.getList();
                int len = list.length;
                this.writeInt(len);
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 25: {
                this.writeInt(25);
                this.writeInt(v.getInt());
                this.writeString(v.getString());
                break;
            }
            case 18: {
                this.writeInt(18);
                ResultInterface result = ((ValueResultSet)v).getResult();
                int columnCount = result.getVisibleColumnCount();
                this.writeInt(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    TypeInfo columnType = result.getColumnType(i);
                    if (this.version >= 18) {
                        this.writeString(result.getAlias(i));
                        this.writeString(result.getColumnName(i));
                        this.writeInt(columnType.getValueType());
                        this.writeLong(columnType.getPrecision());
                    } else {
                        this.writeString(result.getColumnName(i));
                        this.writeInt(DataType.getDataType((int)columnType.getValueType()).sqlType);
                        this.writeInt(MathUtils.convertLongToInt(columnType.getPrecision()));
                    }
                    this.writeInt(columnType.getScale());
                }
                while (result.next()) {
                    this.writeBoolean(true);
                    Value[] row = result.currentRow();
                    for (int i = 0; i < columnCount; ++i) {
                        this.writeValue(row[i]);
                    }
                }
                this.writeBoolean(false);
                break;
            }
            case 22: {
                this.writeInt(22);
                if (this.version >= 14) {
                    this.writeBytes(v.getBytesNoCopy());
                    break;
                }
                this.writeString(v.getString());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (this.version >= 18) {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 26;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)ordinal);
                    this.writeLong(interval.getLeading());
                    break;
                }
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                if (this.version >= 18) {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 26;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)ordinal);
                    this.writeLong(interval.getLeading());
                    this.writeLong(interval.getRemaining());
                    break;
                }
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    this.writeInt(type);
                    this.writeBytes(v.getBytesNoCopy());
                    break;
                }
                throw DbException.get(90067, "type=" + type);
            }
        }
    }

    public Value readValue() throws IOException {
        int type = this.readInt();
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, this.readBytes(), this.session.getDataHandler());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                return ValueDate.fromDateValue(this.readLong());
            }
            case 9: {
                return ValueTime.fromNanos(this.readLong());
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
            }
            case 24: {
                return ValueTimestampTimeZone.fromDateValueAndNanos(this.readLong(), this.readLong(), (short)this.readInt());
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 25: {
                int ordinal = this.readInt();
                String label = this.readString();
                return ValueEnumBase.get(label, ordinal);
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long length = this.readLong();
                if (this.version >= 11 && length == -1L) {
                    int tableId = this.readInt();
                    long id = this.readLong();
                    byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                    long precision = this.readLong();
                    return ValueLobDb.create(15, this.session.getDataHandler(), tableId, id, hmac, precision);
                }
                Value v = this.session.getDataHandler().getLobStorage().createBlob(this.in, length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 16: {
                long length = this.readLong();
                if (this.version >= 11) {
                    if (length == -1L) {
                        int tableId = this.readInt();
                        long id = this.readLong();
                        byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                        long precision = this.readLong();
                        return ValueLobDb.create(16, this.session.getDataHandler(), tableId, id, hmac, precision);
                    }
                    if (length < 0L) {
                        throw DbException.get(90067, "length=" + length);
                    }
                }
                Value v = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 17: {
                int len = this.readInt();
                Class componentType = Object.class;
                if (len < 0) {
                    len = -(len + 1);
                    componentType = JdbcUtils.loadUserClass(this.readString());
                }
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(componentType, list);
            }
            case 27: {
                int len = this.readInt();
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueRow.get(list);
            }
            case 18: {
                SimpleResult rs = new SimpleResult();
                int columns = this.readInt();
                for (int i = 0; i < columns; ++i) {
                    if (this.version >= 18) {
                        rs.addColumn(this.readString(), this.readString(), this.readInt(), this.readLong(), this.readInt());
                        continue;
                    }
                    String name = this.readString();
                    rs.addColumn(name, name, DataType.convertSQLTypeToValueType(this.readInt()), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Value[] o = new Value[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = this.readValue();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
            case 22: {
                if (this.version >= 14) {
                    return ValueGeometry.get(this.readBytes());
                }
                return ValueGeometry.get(this.readString());
            }
            case 26: {
                boolean negative;
                int ordinal = this.readByte();
                boolean bl = negative = ordinal < 0;
                if (negative) {
                    ordinal ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(ordinal), negative, this.readLong(), ordinal < 5 ? 0L : this.readLong());
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(this.readBytes()), type);
        }
        throw DbException.get(90067, "type=" + type);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface session) {
        this.session = session;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress address = this.socket.getInetAddress();
        int port = this.socket.getPort();
        Socket s2 = NetUtils.createSocket(address, port, this.ssl);
        Transfer trans = new Transfer(null, s2);
        trans.setSSL(this.ssl);
        return trans;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] hmac, long lobId) {
        byte[] result = this.calculateLobMac(lobId);
        if (!Utils.compareSecure(hmac, result)) {
            throw DbException.get(90067, "Invalid lob hmac; possibly the connection was re-opened internally");
        }
    }

    private byte[] calculateLobMac(long lobId) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] data = new byte[8];
        Bits.writeLong(data, 0, lobId);
        return SHA256.getHashWithSalt(data, this.lobMacSalt);
    }
}

