/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.util.Arrays;
import java.util.Locale;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueEnum;

public final class ExtTypeInfoEnum
extends ExtTypeInfo {
    private final String[] enumerators;
    private final String[] cleaned;
    private TypeInfo type;

    public static ExtTypeInfoEnum getEnumeratorsForBinaryOperation(Value left, Value right) {
        if (left.getValueType() == 25) {
            return ((ValueEnum)left).getEnumerators();
        }
        if (right.getValueType() == 25) {
            return ((ValueEnum)right).getEnumerators();
        }
        throw DbException.get(50004, "type1=" + left.getValueType() + ", type2=" + right.getValueType());
    }

    private static String sanitize(String label) {
        return label == null ? null : label.trim().toUpperCase(Locale.ENGLISH);
    }

    private static String toSQL(String[] enumerators) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (int i = 0; i < enumerators.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append('\'');
            String s2 = enumerators[i];
            int length = s2.length();
            for (int j = 0; j < length; ++j) {
                char c = s2.charAt(j);
                if (c == '\'') {
                    result.append('\'');
                }
                result.append(c);
            }
            result.append('\'');
        }
        result.append(')');
        return result.toString();
    }

    public ExtTypeInfoEnum(String[] enumerators) {
        if (enumerators == null || enumerators.length == 0) {
            throw DbException.get(22032);
        }
        Object[] cleaned = new String[enumerators.length];
        for (int i = 0; i < enumerators.length; ++i) {
            String l = ExtTypeInfoEnum.sanitize(enumerators[i]);
            if (l == null || l.isEmpty()) {
                throw DbException.get(22032);
            }
            for (int j = 0; j < i; ++j) {
                if (!l.equals(cleaned[j])) continue;
                throw DbException.get(22033, ExtTypeInfoEnum.toSQL(enumerators));
            }
            cleaned[i] = l;
        }
        this.enumerators = enumerators;
        this.cleaned = Arrays.equals(cleaned, enumerators) ? enumerators : cleaned;
    }

    TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int p = 0;
            for (String s2 : this.enumerators) {
                int l = s2.length();
                if (l <= p) continue;
                p = l;
            }
            this.type = type = new TypeInfo(25, p, 0, p, this);
        }
        return type;
    }

    @Override
    public Value cast(Value value) {
        String s2;
        switch (value.getValueType()) {
            case 25: {
                if (value instanceof ValueEnum && ((ValueEnum)value).getEnumerators().equals(this)) {
                    return value;
                }
            }
            case 13: 
            case 14: 
            case 21: {
                ValueEnum v = this.getValueOrNull(value.getString());
                if (v == null) break;
                return v;
            }
            default: {
                int ordinal = value.getInt();
                if (ordinal < 0 || ordinal >= this.enumerators.length) break;
                return new ValueEnum(this, this.enumerators[ordinal], ordinal);
            }
        }
        if ((s2 = value.getTraceSQL()).length() > 127) {
            s2 = s2.substring(0, 128) + "...";
        }
        throw DbException.get(22030, this.toString(), s2);
    }

    public String getEnumerator(int ordinal) {
        return this.enumerators[ordinal];
    }

    public ValueEnum getValue(int ordinal) {
        if (ordinal < 0 || ordinal >= this.enumerators.length) {
            throw DbException.get(22030, this.enumerators.toString(), Integer.toString(ordinal));
        }
        return new ValueEnum(this, this.enumerators[ordinal], ordinal);
    }

    public ValueEnum getValue(String label) {
        ValueEnum value = this.getValueOrNull(label);
        if (value == null) {
            throw DbException.get(22030, this.toString(), label);
        }
        return value;
    }

    private ValueEnum getValueOrNull(String label) {
        String l = ExtTypeInfoEnum.sanitize(label);
        if (l != null) {
            for (int ordinal = 0; ordinal < this.cleaned.length; ++ordinal) {
                if (!l.equals(this.cleaned[ordinal])) continue;
                return new ValueEnum(this, this.enumerators[ordinal], ordinal);
            }
        }
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.enumerators) + 203117;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ExtTypeInfoEnum.class) {
            return false;
        }
        return Arrays.equals(this.enumerators, ((ExtTypeInfoEnum)obj).enumerators);
    }

    @Override
    public String getCreateSQL() {
        return ExtTypeInfoEnum.toSQL(this.enumerators);
    }
}

