/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.Utils;

public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreatedNs;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;
    private static final int TO_UPPER_CACHE_LENGTH = 2048;
    private static final int TO_UPPER_CACHE_MAX_ENTRY_LENGTH = 64;
    private static final String[][] TO_UPPER_CACHE;

    private StringUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache() {
        String[] cache;
        if (softCache != null && (cache = softCache.get()) != null) {
            return cache;
        }
        long time = System.nanoTime();
        if (softCacheCreatedNs != 0L && time - softCacheCreatedNs < TimeUnit.SECONDS.toNanos(5L)) {
            return null;
        }
        try {
            cache = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(cache);
            String[] stringArray = cache;
            return stringArray;
        }
        finally {
            softCacheCreatedNs = System.nanoTime();
        }
    }

    public static String toUpperEnglish(String s2) {
        if (s2.length() > 64) {
            return s2.toUpperCase(Locale.ENGLISH);
        }
        int index = s2.hashCode() & 0x7FF;
        String[] e = TO_UPPER_CACHE[index];
        if (e != null && e[0].equals(s2)) {
            return e[1];
        }
        String s22 = s2.toUpperCase(Locale.ENGLISH);
        e = new String[]{s2, s22};
        StringUtils.TO_UPPER_CACHE[index] = e;
        return s22;
    }

    public static String toLowerEnglish(String s2) {
        return s2.toLowerCase(Locale.ENGLISH);
    }

    public static String quoteStringSQL(String s2) {
        if (s2 == null) {
            return "NULL";
        }
        return StringUtils.quoteStringSQL(new StringBuilder(s2.length() + 2), s2).toString();
    }

    public static StringBuilder quoteStringSQL(StringBuilder builder, String s2) {
        if (s2 == null) {
            return builder.append("NULL");
        }
        int builderLength = builder.length();
        int length = s2.length();
        builder.append('\'');
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c == '\'') {
                builder.append(c);
            } else if (c < ' ' || c > '\u007f') {
                builder.setLength(builderLength);
                builder.append("STRINGDECODE('");
                StringUtils.javaEncode(s2, builder, true);
                return builder.append("')");
            }
            builder.append(c);
        }
        return builder.append('\'');
    }

    public static String javaEncode(String s2) {
        StringBuilder buff = new StringBuilder(s2.length());
        StringUtils.javaEncode(s2, buff, false);
        return buff.toString();
    }

    public static void javaEncode(String s2, StringBuilder buff, boolean forSQL) {
        int length = s2.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\t': {
                    buff.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buff.append("\\\"");
                    continue block9;
                }
                case '\'': {
                    if (forSQL) {
                        buff.append('\'');
                    }
                    buff.append('\'');
                    continue block9;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        buff.append(c);
                        continue block9;
                    }
                    buff.append("\\u").append(HEX[c >>> 12]).append(HEX[c >>> 8 & 0xF]).append(HEX[c >>> 4 & 0xF]).append(HEX[c & 0xF]);
                }
            }
        }
    }

    public static String addAsterisk(String s2, int index) {
        if (s2 != null) {
            int len = s2.length();
            index = Math.min(index, len);
            s2 = new StringBuilder(len + 3).append(s2, 0, index).append("[*]").append(s2, index, len).toString();
        }
        return s2;
    }

    private static DbException getFormatException(String s2, int i) {
        return DbException.get(90095, StringUtils.addAsterisk(s2, i));
    }

    public static String javaDecode(String s2) {
        int length = s2.length();
        StringBuilder buff = new StringBuilder(length);
        block17: for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c == '\\') {
                if (i + 1 >= s2.length()) {
                    throw StringUtils.getFormatException(s2, i);
                }
                c = s2.charAt(++i);
                switch (c) {
                    case 't': {
                        buff.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        buff.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        buff.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        buff.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        buff.append('\f');
                        continue block17;
                    }
                    case '#': {
                        buff.append('#');
                        continue block17;
                    }
                    case '=': {
                        buff.append('=');
                        continue block17;
                    }
                    case ':': {
                        buff.append(':');
                        continue block17;
                    }
                    case '\"': {
                        buff.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        buff.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(s2.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException e) {
                            throw StringUtils.getFormatException(s2, i);
                        }
                        i += 4;
                        buff.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(s2.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException e) {
                                throw StringUtils.getFormatException(s2, i);
                            }
                            i += 2;
                            buff.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(s2, i);
                    }
                }
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static String quoteJavaString(String s2) {
        if (s2 == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(s2.length() + 2).append('\"');
        StringUtils.javaEncode(s2, builder, false);
        return builder.append('\"').toString();
    }

    public static String quoteJavaStringArray(String[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buff = new StringBuilder("new String[]{");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(StringUtils.quoteJavaString(array[i]));
        }
        return buff.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder("new int[]{");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(array[i]);
        }
        return builder.append('}').toString();
    }

    public static String unEnclose(String s2) {
        if (s2.startsWith("(") && s2.endsWith(")")) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public static String urlEncode(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8");
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static String urlDecode(String encoded) {
        int length = encoded.length();
        byte[] buff = new byte[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            char ch = encoded.charAt(i);
            if (ch == '+') {
                buff[j++] = 32;
                continue;
            }
            if (ch == '%') {
                buff[j++] = (byte)Integer.parseInt(encoded.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (ch <= '\u007f' && ch >= ' ') {
                buff[j++] = (byte)ch;
                continue;
            }
            throw new IllegalArgumentException("Unexpected char " + ch + " decoding " + encoded);
        }
        return new String(buff, 0, j, StandardCharsets.UTF_8);
    }

    public static String[] arraySplit(String s2, char separatorChar, boolean trim) {
        if (s2 == null) {
            return null;
        }
        int length = s2.length();
        if (length == 0) {
            return new String[0];
        }
        ArrayList<String> list = Utils.newSmallArrayList();
        StringBuilder buff = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c == separatorChar) {
                String e = buff.toString();
                list.add(trim ? e.trim() : e);
                buff.setLength(0);
                continue;
            }
            if (c == '\\' && i < length - 1) {
                buff.append(s2.charAt(++i));
                continue;
            }
            buff.append(c);
        }
        String e = buff.toString();
        list.add(trim ? e.trim() : e);
        return list.toArray(new String[0]);
    }

    public static String arrayCombine(String[] list, char separatorChar) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String s2;
            if (i > 0) {
                builder.append(separatorChar);
            }
            if ((s2 = list[i]) == null) continue;
            int length = s2.length();
            for (int j = 0; j < length; ++j) {
                char c = s2.charAt(j);
                if (c == '\\' || c == separatorChar) {
                    builder.append('\\');
                }
                builder.append(c);
            }
        }
        return builder.toString();
    }

    public static StringBuilder join(StringBuilder builder, ArrayList<String> strings, String separator) {
        int l = strings.size();
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            builder.append(strings.get(i));
        }
        return builder;
    }

    public static String xmlAttr(String name, String value) {
        return " " + name + "=\"" + StringUtils.xmlText(value) + "\"";
    }

    public static String xmlNode(String name, String attributes, String content) {
        return StringUtils.xmlNode(name, attributes, content, true);
    }

    public static String xmlNode(String name, String attributes, String content, boolean indent) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(name);
        if (attributes != null) {
            builder.append(attributes);
        }
        if (content == null) {
            builder.append("/>\n");
            return builder.toString();
        }
        builder.append('>');
        if (indent && content.indexOf(10) >= 0) {
            builder.append('\n');
            StringUtils.indent(builder, content, 4, true);
        } else {
            builder.append(content);
        }
        builder.append("</").append(name).append(">\n");
        return builder.toString();
    }

    public static StringBuilder indent(StringBuilder builder, String s2, int spaces, boolean newline) {
        int i = 0;
        int length = s2.length();
        while (i < length) {
            for (int j = 0; j < spaces; ++j) {
                builder.append(' ');
            }
            int n = s2.indexOf(10, i);
            n = n < 0 ? length : n + 1;
            builder.append(s2, i, n);
            i = n;
        }
        if (newline && !s2.endsWith("\n")) {
            builder.append('\n');
        }
        return builder;
    }

    public static String xmlComment(String data) {
        int idx = 0;
        while ((idx = data.indexOf("--", idx)) >= 0) {
            data = data.substring(0, idx + 1) + " " + data.substring(idx + 1);
        }
        if (data.indexOf(10) >= 0) {
            StringBuilder builder = new StringBuilder(data.length() + 18).append("<!--\n");
            return StringUtils.indent(builder, data, 4, true).append("-->\n").toString();
        }
        return "<!-- " + data + " -->\n";
    }

    public static String xmlCData(String data) {
        if (data.contains("]]>")) {
            return StringUtils.xmlText(data);
        }
        boolean newline = data.endsWith("\n");
        data = "<![CDATA[" + data + "]]>";
        return newline ? data + "\n" : data;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String text) {
        return StringUtils.xmlText(text, false);
    }

    public static String xmlText(String text, boolean escapeNewline) {
        int length = text.length();
        StringBuilder buff = new StringBuilder(length);
        block9: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buff.append("&lt;");
                    continue block9;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block9;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    buff.append("&#39;");
                    continue block9;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (escapeNewline) {
                        buff.append("&#x").append(Integer.toHexString(ch)).append(';');
                        continue block9;
                    }
                    buff.append(ch);
                    continue block9;
                }
                case '\t': {
                    buff.append(ch);
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch > '\u007f') {
                        buff.append("&#x").append(Integer.toHexString(ch)).append(';');
                        continue block9;
                    }
                    buff.append(ch);
                }
            }
        }
        return buff.toString();
    }

    public static String replaceAll(String s2, String before, String after) {
        int next = s2.indexOf(before);
        if (next < 0 || before.isEmpty()) {
            return s2;
        }
        StringBuilder buff = new StringBuilder(s2.length() - before.length() + after.length());
        int index = 0;
        do {
            buff.append(s2, index, next).append(after);
        } while ((next = s2.indexOf(before, index = next + before.length())) >= 0);
        buff.append(s2, index, s2.length());
        return buff.toString();
    }

    public static String quoteIdentifier(String s2) {
        return StringUtils.quoteIdentifier(new StringBuilder(s2.length() + 2), s2).toString();
    }

    public static StringBuilder quoteIdentifier(StringBuilder builder, String s2) {
        builder.append('\"');
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c == '\"') {
                builder.append(c);
            }
            builder.append(c);
        }
        return builder.append('\"');
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static String quoteRemarkSQL(String sql) {
        sql = StringUtils.replaceAll(sql, "*/", "++/");
        return StringUtils.replaceAll(sql, "/*", "/++");
    }

    public static String pad(String string, int n, String padding, boolean right) {
        if (n < 0) {
            n = 0;
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        if (n == string.length()) {
            return string;
        }
        char paddingChar = padding == null || padding.isEmpty() ? (char)' ' : (char)padding.charAt(0);
        StringBuilder buff = new StringBuilder(n);
        n -= string.length();
        if (right) {
            buff.append(string);
        }
        for (int i = 0; i < n; ++i) {
            buff.append(paddingChar);
        }
        if (!right) {
            buff.append(string);
        }
        return buff.toString();
    }

    public static char[] cloneCharArray(char[] chars) {
        if (chars == null) {
            return null;
        }
        int len = chars.length;
        if (len == 0) {
            return chars;
        }
        return Arrays.copyOf(chars, len);
    }

    public static String trim(String s2, boolean leading, boolean trailing, String sp) {
        int begin;
        char space = sp == null || sp.isEmpty() ? (char)' ' : (char)sp.charAt(0);
        int end = s2.length();
        if (leading) {
            for (begin = 0; begin < end && s2.charAt(begin) == space; ++begin) {
            }
        }
        if (trailing) {
            while (end > begin && s2.charAt(end - 1) == space) {
                --end;
            }
        }
        return s2.substring(begin, end);
    }

    public static String trimSubstring(String s2, int beginIndex) {
        return StringUtils.trimSubstring(s2, beginIndex, s2.length());
    }

    public static String trimSubstring(String s2, int beginIndex, int endIndex) {
        while (beginIndex < endIndex && s2.charAt(beginIndex) <= ' ') {
            ++beginIndex;
        }
        while (beginIndex < endIndex && s2.charAt(endIndex - 1) <= ' ') {
            --endIndex;
        }
        return s2.substring(beginIndex, endIndex);
    }

    public static StringBuilder trimSubstring(StringBuilder builder, String s2, int beginIndex, int endIndex) {
        while (beginIndex < endIndex && s2.charAt(beginIndex) <= ' ') {
            ++beginIndex;
        }
        while (beginIndex < endIndex && s2.charAt(endIndex - 1) <= ' ') {
            --endIndex;
        }
        return builder.append(s2, beginIndex, endIndex);
    }

    public static String cache(String s2) {
        if (!SysProperties.OBJECT_CACHE) {
            return s2;
        }
        if (s2 == null) {
            return s2;
        }
        if (s2.isEmpty()) {
            return "";
        }
        String[] cache = StringUtils.getCache();
        if (cache != null) {
            int hash = s2.hashCode();
            int index = hash & SysProperties.OBJECT_CACHE_SIZE - 1;
            String cached = cache[index];
            if (s2.equals(cached)) {
                return cached;
            }
            cache[index] = s2;
        }
        return s2;
    }

    public static void clearCache() {
        softCache = null;
    }

    public static int parseUInt31(String s2, int start, int end) {
        if (end > s2.length() || start < 0 || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            throw new NumberFormatException("");
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            char ch = s2.charAt(i);
            if (ch < '0' || ch > '9' || result > 0xCCCCCCC) {
                throw new NumberFormatException(s2.substring(start, end));
            }
            if ((result = result * 10 + ch - 48) >= 0) continue;
            throw new NumberFormatException(s2.substring(start, end));
        }
        return result;
    }

    public static byte[] convertHexToBytes(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            throw DbException.get(90003, s2);
        }
        byte[] buff = new byte[len /= 2];
        int mask = 0;
        int[] hex = HEX_DECODE;
        try {
            for (int i = 0; i < len; ++i) {
                int d = hex[s2.charAt(i + i)] << 4 | hex[s2.charAt(i + i + 1)];
                mask |= d;
                buff[i] = (byte)d;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw DbException.get(90004, s2);
        }
        if ((mask & 0xFFFFFF00) != 0) {
            throw DbException.get(90004, s2);
        }
        return buff;
    }

    public static String convertBytesToHex(byte[] value) {
        return StringUtils.convertBytesToHex(value, value.length);
    }

    public static String convertBytesToHex(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    public static StringBuilder convertBytesToHex(StringBuilder builder, byte[] value) {
        return StringUtils.convertBytesToHex(builder, value, value.length);
    }

    public static StringBuilder convertBytesToHex(StringBuilder builder, byte[] value, int len) {
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            builder.append(hex[c >>> 4]).append(hex[c & 0xF]);
        }
        return builder;
    }

    public static StringBuilder appendHex(StringBuilder builder, long x, int bytes) {
        char[] hex = HEX;
        int i = bytes * 8;
        while (i > 0) {
            builder.append(hex[(int)(x >> (i -= 4)) & 0xF]).append(hex[(int)(x >> (i -= 4)) & 0xF]);
        }
        return builder;
    }

    public static boolean isNumber(String s2) {
        int l = s2.length();
        if (l == 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespaceOrEmpty(String s2) {
        int l = s2.length();
        for (int i = 0; i < l; ++i) {
            if (s2.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static void appendZeroPadded(StringBuilder buff, int length, long positiveValue) {
        if (length == 2) {
            if (positiveValue < 10L) {
                buff.append('0');
            }
            buff.append(positiveValue);
        } else {
            String s2 = Long.toString(positiveValue);
            length -= s2.length();
            while (length > 0) {
                buff.append('0');
                --length;
            }
            buff.append(s2);
        }
    }

    public static String escapeMetaDataPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return pattern;
        }
        return StringUtils.replaceAll(pattern, "\\", "\\\\");
    }

    static {
        int i;
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        TO_UPPER_CACHE = new String[2048][];
        for (i = 0; i < HEX_DECODE.length; ++i) {
            StringUtils.HEX_DECODE[i] = -1;
        }
        for (i = 0; i <= 9; ++i) {
            StringUtils.HEX_DECODE[i + 48] = i;
        }
        for (i = 0; i <= 5; ++i) {
            int n = i + 10;
            StringUtils.HEX_DECODE[i + 65] = n;
            StringUtils.HEX_DECODE[i + 97] = n;
        }
    }
}

