/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int ARRAY = 4;
    public static final int CASE = 5;
    public static final int CHECK = 6;
    public static final int CONSTRAINT = 7;
    public static final int CROSS = 8;
    public static final int CURRENT_DATE = 9;
    public static final int CURRENT_TIME = 10;
    public static final int CURRENT_TIMESTAMP = 11;
    public static final int CURRENT_USER = 12;
    public static final int DISTINCT = 13;
    public static final int EXCEPT = 14;
    public static final int EXISTS = 15;
    public static final int FALSE = 16;
    public static final int FETCH = 17;
    public static final int FOR = 18;
    public static final int FOREIGN = 19;
    public static final int FROM = 20;
    public static final int FULL = 21;
    public static final int GROUP = 22;
    public static final int HAVING = 23;
    public static final int IF = 24;
    public static final int INNER = 25;
    public static final int INTERSECT = 26;
    public static final int INTERSECTS = 27;
    public static final int INTERVAL = 28;
    public static final int IS = 29;
    public static final int JOIN = 30;
    public static final int LIKE = 31;
    public static final int LIMIT = 32;
    public static final int LOCALTIME = 33;
    public static final int LOCALTIMESTAMP = 34;
    public static final int MINUS = 35;
    public static final int NATURAL = 36;
    public static final int NOT = 37;
    public static final int NULL = 38;
    public static final int OFFSET = 39;
    public static final int ON = 40;
    public static final int ORDER = 41;
    public static final int PRIMARY = 42;
    public static final int QUALIFY = 43;
    public static final int ROW = 44;
    public static final int _ROWID_ = 45;
    public static final int ROWNUM = 46;
    public static final int SELECT = 47;
    public static final int TABLE = 48;
    public static final int TRUE = 49;
    public static final int UNION = 50;
    public static final int UNIQUE = 51;
    public static final int VALUES = 52;
    public static final int WHERE = 53;
    public static final int WINDOW = 54;
    public static final int WITH = 55;
    private static final int UPPER_OR_OTHER_LETTER = 50;
    private static final int UPPER_OR_OTHER_LETTER_OR_DIGIT = 562;
    private static final int LOWER_OR_OTHER_LETTER = 52;
    private static final int LOWER_OR_OTHER_LETTER_OR_DIGIT = 564;
    private static final int LETTER = 62;
    private static final int LETTER_OR_DIGIT = 574;

    private ParserUtil() {
    }

    public static boolean isKeyword(String s2, boolean ignoreCase) {
        int length = s2.length();
        if (length == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(s2, ignoreCase, 0, length, false) != 2;
    }

    public static boolean isSimpleIdentifier(String s2, boolean databaseToUpper, boolean databaseToLower) {
        int partFlags;
        int startFlags;
        int length = s2.length();
        if (length == 0) {
            return false;
        }
        if (databaseToUpper) {
            if (databaseToLower) {
                throw new IllegalArgumentException("databaseToUpper && databaseToLower");
            }
            startFlags = 50;
            partFlags = 562;
        } else if (databaseToLower) {
            startFlags = 52;
            partFlags = 564;
        } else {
            startFlags = 62;
            partFlags = 574;
        }
        char c = s2.charAt(0);
        if ((startFlags >>> Character.getType(c) & 1) == 0 && c != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = s2.charAt(i);
            if ((partFlags >>> Character.getType(c) & 1) != 0 || c == '_') continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(s2, !databaseToUpper, 0, length, true) == 2;
    }

    public static int getSaveTokenType(String s2, boolean ignoreCase, int start, int end, boolean additionalKeywords) {
        char c = s2.charAt(start);
        if (ignoreCase) {
            c = (char)(c & 0xFFDF);
        }
        switch (c) {
            case 'A': {
                if (ParserUtil.eq("ALL", s2, ignoreCase, start, end)) {
                    return 3;
                }
                if (ParserUtil.eq("ARRAY", s2, ignoreCase, start, end)) {
                    return 4;
                }
                if (additionalKeywords && (ParserUtil.eq("AND", s2, ignoreCase, start, end) || ParserUtil.eq("AS", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'B': {
                if (additionalKeywords && (ParserUtil.eq("BETWEEN", s2, ignoreCase, start, end) || ParserUtil.eq("BOTH", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'C': {
                if (ParserUtil.eq("CASE", s2, ignoreCase, start, end)) {
                    return 5;
                }
                if (ParserUtil.eq("CHECK", s2, ignoreCase, start, end)) {
                    return 6;
                }
                if (ParserUtil.eq("CONSTRAINT", s2, ignoreCase, start, end)) {
                    return 7;
                }
                if (ParserUtil.eq("CROSS", s2, ignoreCase, start, end)) {
                    return 8;
                }
                if (ParserUtil.eq("CURRENT_DATE", s2, ignoreCase, start, end)) {
                    return 9;
                }
                if (ParserUtil.eq("CURRENT_TIME", s2, ignoreCase, start, end)) {
                    return 10;
                }
                if (ParserUtil.eq("CURRENT_TIMESTAMP", s2, ignoreCase, start, end)) {
                    return 11;
                }
                if (ParserUtil.eq("CURRENT_USER", s2, ignoreCase, start, end)) {
                    return 12;
                }
                return 2;
            }
            case 'D': {
                if (ParserUtil.eq("DISTINCT", s2, ignoreCase, start, end)) {
                    return 13;
                }
                return 2;
            }
            case 'E': {
                if (ParserUtil.eq("EXCEPT", s2, ignoreCase, start, end)) {
                    return 14;
                }
                if (ParserUtil.eq("EXISTS", s2, ignoreCase, start, end)) {
                    return 15;
                }
                return 2;
            }
            case 'F': {
                if (ParserUtil.eq("FETCH", s2, ignoreCase, start, end)) {
                    return 17;
                }
                if (ParserUtil.eq("FROM", s2, ignoreCase, start, end)) {
                    return 20;
                }
                if (ParserUtil.eq("FOR", s2, ignoreCase, start, end)) {
                    return 18;
                }
                if (ParserUtil.eq("FOREIGN", s2, ignoreCase, start, end)) {
                    return 19;
                }
                if (ParserUtil.eq("FULL", s2, ignoreCase, start, end)) {
                    return 21;
                }
                if (ParserUtil.eq("FALSE", s2, ignoreCase, start, end)) {
                    return 16;
                }
                if (additionalKeywords && ParserUtil.eq("FILTER", s2, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'G': {
                if (ParserUtil.eq("GROUP", s2, ignoreCase, start, end)) {
                    return 22;
                }
                if (additionalKeywords && ParserUtil.eq("GROUPS", s2, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'H': {
                if (ParserUtil.eq("HAVING", s2, ignoreCase, start, end)) {
                    return 23;
                }
                return 2;
            }
            case 'I': {
                if (ParserUtil.eq("IF", s2, ignoreCase, start, end)) {
                    return 24;
                }
                if (ParserUtil.eq("INNER", s2, ignoreCase, start, end)) {
                    return 25;
                }
                if (ParserUtil.eq("INTERSECT", s2, ignoreCase, start, end)) {
                    return 26;
                }
                if (ParserUtil.eq("INTERSECTS", s2, ignoreCase, start, end)) {
                    return 27;
                }
                if (ParserUtil.eq("INTERVAL", s2, ignoreCase, start, end)) {
                    return 28;
                }
                if (ParserUtil.eq("IS", s2, ignoreCase, start, end)) {
                    return 29;
                }
                if (additionalKeywords && (ParserUtil.eq("ILIKE", s2, ignoreCase, start, end) || ParserUtil.eq("IN", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'J': {
                if (ParserUtil.eq("JOIN", s2, ignoreCase, start, end)) {
                    return 30;
                }
                return 2;
            }
            case 'L': {
                if (ParserUtil.eq("LIMIT", s2, ignoreCase, start, end)) {
                    return 32;
                }
                if (ParserUtil.eq("LIKE", s2, ignoreCase, start, end)) {
                    return 31;
                }
                if (ParserUtil.eq("LOCALTIME", s2, ignoreCase, start, end)) {
                    return 33;
                }
                if (ParserUtil.eq("LOCALTIMESTAMP", s2, ignoreCase, start, end)) {
                    return 34;
                }
                if (additionalKeywords && (ParserUtil.eq("LEADING", s2, ignoreCase, start, end) || ParserUtil.eq("LEFT", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'M': {
                if (ParserUtil.eq("MINUS", s2, ignoreCase, start, end)) {
                    return 35;
                }
                return 2;
            }
            case 'N': {
                if (ParserUtil.eq("NOT", s2, ignoreCase, start, end)) {
                    return 37;
                }
                if (ParserUtil.eq("NATURAL", s2, ignoreCase, start, end)) {
                    return 36;
                }
                if (ParserUtil.eq("NULL", s2, ignoreCase, start, end)) {
                    return 38;
                }
                return 2;
            }
            case 'O': {
                if (ParserUtil.eq("OFFSET", s2, ignoreCase, start, end)) {
                    return 39;
                }
                if (ParserUtil.eq("ON", s2, ignoreCase, start, end)) {
                    return 40;
                }
                if (ParserUtil.eq("ORDER", s2, ignoreCase, start, end)) {
                    return 41;
                }
                if (additionalKeywords && (ParserUtil.eq("OR", s2, ignoreCase, start, end) || ParserUtil.eq("OVER", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'P': {
                if (ParserUtil.eq("PRIMARY", s2, ignoreCase, start, end)) {
                    return 42;
                }
                if (additionalKeywords && ParserUtil.eq("PARTITION", s2, ignoreCase, start, end)) {
                    return 1;
                }
                return 2;
            }
            case 'Q': {
                if (ParserUtil.eq("QUALIFY", s2, ignoreCase, start, end)) {
                    return 43;
                }
                return 2;
            }
            case 'R': {
                if (ParserUtil.eq("ROW", s2, ignoreCase, start, end)) {
                    return 44;
                }
                if (ParserUtil.eq("ROWNUM", s2, ignoreCase, start, end)) {
                    return 46;
                }
                if (additionalKeywords && (ParserUtil.eq("RANGE", s2, ignoreCase, start, end) || ParserUtil.eq("REGEXP", s2, ignoreCase, start, end) || ParserUtil.eq("ROWS", s2, ignoreCase, start, end) || ParserUtil.eq("RIGHT", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'S': {
                if (ParserUtil.eq("SELECT", s2, ignoreCase, start, end)) {
                    return 47;
                }
                if (additionalKeywords && (ParserUtil.eq("SYSDATE", s2, ignoreCase, start, end) || ParserUtil.eq("SYSTIME", s2, ignoreCase, start, end) || ParserUtil.eq("SYSTIMESTAMP", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if (ParserUtil.eq("TABLE", s2, ignoreCase, start, end)) {
                    return 48;
                }
                if (ParserUtil.eq("TRUE", s2, ignoreCase, start, end)) {
                    return 49;
                }
                if (additionalKeywords && (ParserUtil.eq("TODAY", s2, ignoreCase, start, end) || ParserUtil.eq("TOP", s2, ignoreCase, start, end) || ParserUtil.eq("TRAILING", s2, ignoreCase, start, end))) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if (ParserUtil.eq("UNIQUE", s2, ignoreCase, start, end)) {
                    return 51;
                }
                if (ParserUtil.eq("UNION", s2, ignoreCase, start, end)) {
                    return 50;
                }
                return 2;
            }
            case 'V': {
                if (ParserUtil.eq("VALUES", s2, ignoreCase, start, end)) {
                    return 52;
                }
                return 2;
            }
            case 'W': {
                if (ParserUtil.eq("WHERE", s2, ignoreCase, start, end)) {
                    return 53;
                }
                if (ParserUtil.eq("WINDOW", s2, ignoreCase, start, end)) {
                    return 54;
                }
                if (ParserUtil.eq("WITH", s2, ignoreCase, start, end)) {
                    return 55;
                }
                return 2;
            }
            case '_': {
                if (end - start != 7 || !"_ROWID_".regionMatches(ignoreCase, 0, s2, start, 7)) break;
                return 45;
            }
        }
        return 2;
    }

    private static boolean eq(String expected, String s2, boolean ignoreCase, int start, int end) {
        int len = expected.length();
        return end - start == len && expected.regionMatches(ignoreCase, 1, s2, start + 1, len - 1);
    }
}

