/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    public static final int EPOCH_DATE_VALUE = 1008673;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    private static final int[] CONVERT_SCALE_TABLE = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10};
    private static final ThreadLocal<GregorianCalendar> CACHED_CALENDAR = new ThreadLocal();
    private static final ThreadLocal<GregorianCalendar> CACHED_CALENDAR_NON_DEFAULT_TIMEZONE = new ThreadLocal();
    private static volatile TimeZone timeZone;
    private static int zoneOffsetMillis;

    private DateTimeUtils() {
    }

    public static int getTimeZoneOffset(long ms) {
        TimeZone tz = timeZone;
        if (tz == null) {
            timeZone = tz = TimeZone.getDefault();
        }
        return tz.getOffset(ms);
    }

    public static void resetCalendar() {
        CACHED_CALENDAR.remove();
        timeZone = null;
        zoneOffsetMillis = DateTimeUtils.createGregorianCalendar().get(15);
    }

    public static GregorianCalendar getCalendar() {
        GregorianCalendar c = CACHED_CALENDAR.get();
        if (c == null) {
            c = DateTimeUtils.createGregorianCalendar();
            CACHED_CALENDAR.set(c);
        }
        c.clear();
        return c;
    }

    private static GregorianCalendar getCalendar(TimeZone tz) {
        GregorianCalendar c = CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.get();
        if (c == null || !c.getTimeZone().equals(tz)) {
            c = DateTimeUtils.createGregorianCalendar(tz);
            CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.set(c);
        }
        c.clear();
        return c;
    }

    public static GregorianCalendar createGregorianCalendar() {
        return new GregorianCalendar();
    }

    public static GregorianCalendar createGregorianCalendar(TimeZone tz) {
        return new GregorianCalendar(tz);
    }

    public static java.sql.Date convertDate(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueDate d = (ValueDate)value.convertTo(10);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long dateValue = d.getDateValue();
        long ms = DateTimeUtils.convertToMillis(cal, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), 0, 0, 0, 0);
        return new java.sql.Date(ms);
    }

    public static Time convertTime(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTime t2 = (ValueTime)value.convertTo(9);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long nanos = t2.getNanos();
        long millis = nanos / 1000000L;
        nanos -= millis * 1000000L;
        long s2 = millis / 1000L;
        millis -= s2 * 1000L;
        long m4 = s2 / 60L;
        s2 -= m4 * 60L;
        long h2 = m4 / 60L;
        return new Time(DateTimeUtils.convertToMillis(cal, 1970, 1, 1, (int)h2, (int)(m4 -= h2 * 60L), (int)s2, (int)millis));
    }

    public static Timestamp convertTimestamp(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTimestamp ts = (ValueTimestamp)value.convertTo(11);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long dateValue = ts.getDateValue();
        long nanos = ts.getTimeNanos();
        long millis = nanos / 1000000L;
        nanos -= millis * 1000000L;
        long s2 = millis / 1000L;
        millis -= s2 * 1000L;
        long m4 = s2 / 60L;
        s2 -= m4 * 60L;
        long h2 = m4 / 60L;
        long ms = DateTimeUtils.convertToMillis(cal, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), (int)h2, (int)(m4 -= h2 * 60L), (int)s2, (int)millis);
        Timestamp x = new Timestamp(ms);
        x.setNanos((int)(nanos + millis * 1000000L));
        return x;
    }

    public static ValueDate convertDate(java.sql.Date x, Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long dateValue = DateTimeUtils.dateValueFromCalendar(cal);
        return ValueDate.fromDateValue(dateValue);
    }

    public static ValueTime convertTime(Time x, Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long nanos = DateTimeUtils.nanosFromCalendar(cal);
        return ValueTime.fromNanos(nanos);
    }

    public static ValueTimestamp convertTimestamp(Timestamp x, Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long dateValue = DateTimeUtils.dateValueFromCalendar(cal);
        long nanos = DateTimeUtils.nanosFromCalendar(cal);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos += (long)(x.getNanos() % 1000000));
    }

    public static long parseDateValue(String s2, int start, int end) {
        int dStart;
        int mEnd;
        int mStart;
        int yEnd;
        if (s2.charAt(start) == '+') {
            ++start;
        }
        if ((yEnd = s2.indexOf(45, start + 1)) > 0) {
            mStart = yEnd + 1;
            mEnd = s2.indexOf(45, mStart);
            if (mEnd <= mStart) {
                throw new IllegalArgumentException(s2);
            }
            dStart = mEnd + 1;
        } else {
            dStart = end - 2;
            mEnd = dStart;
            mStart = mEnd - 2;
            yEnd = mStart;
            if (yEnd < start + 3) {
                throw new IllegalArgumentException(s2);
            }
        }
        int year = Integer.parseInt(s2.substring(start, yEnd));
        int month = StringUtils.parseUInt31(s2, mStart, mEnd);
        int day = StringUtils.parseUInt31(s2, dStart, end);
        if (!DateTimeUtils.isValidDate(year, month, day)) {
            throw new IllegalArgumentException(year + "-" + month + "-" + day);
        }
        return DateTimeUtils.dateValue(year, month, day);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseTimeNanos(String s2, int start, int end) {
        int nanos;
        int second;
        int sEnd;
        int sStart;
        int mEnd;
        int mStart;
        int hEnd = s2.indexOf(58, start);
        if (hEnd > 0) {
            mStart = hEnd + 1;
            mEnd = s2.indexOf(58, mStart);
            if (mEnd >= mStart) {
                sStart = mEnd + 1;
                sEnd = s2.indexOf(46, sStart);
            } else {
                mEnd = end;
                sEnd = -1;
                sStart = -1;
            }
        } else {
            int t2 = s2.indexOf(46, start);
            if (t2 < 0) {
                hEnd = mStart = start + 2;
                mEnd = mStart + 2;
                int len = end - start;
                if (len == 6) {
                    sStart = mEnd;
                    sEnd = -1;
                } else {
                    if (len != 4) throw new IllegalArgumentException(s2);
                    sEnd = -1;
                    sStart = -1;
                }
            } else if (t2 >= start + 6) {
                if (t2 - start != 6) {
                    throw new IllegalArgumentException(s2);
                }
                hEnd = mStart = start + 2;
                mEnd = sStart = mStart + 2;
                sEnd = t2;
            } else {
                hEnd = t2;
                mStart = hEnd + 1;
                mEnd = s2.indexOf(46, mStart);
                if (mEnd <= mStart) {
                    throw new IllegalArgumentException(s2);
                }
                sStart = mEnd + 1;
                sEnd = s2.indexOf(46, sStart);
            }
        }
        int hour = StringUtils.parseUInt31(s2, start, hEnd);
        if (hour >= 24) {
            throw new IllegalArgumentException(s2);
        }
        int minute = StringUtils.parseUInt31(s2, mStart, mEnd);
        if (sStart > 0) {
            if (sEnd < 0) {
                second = StringUtils.parseUInt31(s2, sStart, end);
                nanos = 0;
            } else {
                second = StringUtils.parseUInt31(s2, sStart, sEnd);
                nanos = DateTimeUtils.parseNanos(s2, sEnd + 1, end);
            }
        } else {
            nanos = 0;
            second = 0;
        }
        if (minute < 60 && second < 60) return (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos;
        throw new IllegalArgumentException(s2);
    }

    static int parseNanos(String s2, int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException(s2);
        }
        int nanos = 0;
        int mul = 100000000;
        do {
            char c;
            if ((c = s2.charAt(start)) < '0' || c > '9') {
                throw new IllegalArgumentException(s2);
            }
            nanos += mul * (c - 48);
            mul /= 10;
        } while (++start < end);
        return nanos;
    }

    private static int findNthIndexOf(String str, char chr, int n) {
        int pos = str.indexOf(chr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(chr, pos + 1);
        }
        return pos;
    }

    public static Value parseTimestamp(String s2, Mode mode, boolean withTimeZone) {
        long nanos;
        int timeStart;
        int dateEnd = s2.indexOf(32);
        if (dateEnd < 0 && (dateEnd = s2.indexOf(84)) < 0 && mode != null && mode.allowDB2TimestampFormat) {
            dateEnd = DateTimeUtils.findNthIndexOf(s2, '-', 3);
        }
        if (dateEnd < 0) {
            dateEnd = s2.length();
            timeStart = -1;
        } else {
            timeStart = dateEnd + 1;
        }
        long dateValue = DateTimeUtils.parseDateValue(s2, 0, dateEnd);
        short tzMinutes = 0;
        if (timeStart < 0) {
            nanos = 0L;
        } else {
            int timeEnd = s2.length();
            TimeZone tz = null;
            if (s2.endsWith("Z")) {
                tz = UTC;
                --timeEnd;
            } else {
                int timeZoneStart = s2.indexOf(43, dateEnd + 1);
                if (timeZoneStart < 0) {
                    timeZoneStart = s2.indexOf(45, dateEnd + 1);
                }
                if (timeZoneStart >= 0) {
                    String tzName;
                    int offsetEnd = s2.indexOf(91, timeZoneStart + 1);
                    if (offsetEnd < 0) {
                        offsetEnd = s2.length();
                    }
                    if (!(tz = TimeZone.getTimeZone(tzName = "GMT" + s2.substring(timeZoneStart, offsetEnd))).getID().startsWith(tzName)) {
                        throw new IllegalArgumentException(tzName + " (" + tz.getID() + "?)");
                    }
                    if (s2.charAt(timeZoneStart - 1) == ' ') {
                        --timeZoneStart;
                    }
                    timeEnd = timeZoneStart;
                } else {
                    timeZoneStart = s2.indexOf(32, dateEnd + 1);
                    if (timeZoneStart > 0) {
                        String tzName = s2.substring(timeZoneStart + 1);
                        tz = TimeZone.getTimeZone(tzName);
                        if (!tz.getID().startsWith(tzName)) {
                            throw new IllegalArgumentException(tzName);
                        }
                        timeEnd = timeZoneStart;
                    }
                }
            }
            nanos = DateTimeUtils.parseTimeNanos(s2, dateEnd + 1, timeEnd);
            if (tz != null) {
                if (withTimeZone) {
                    if (tz != UTC) {
                        long millis = DateTimeUtils.convertDateTimeValueToMillis(tz, dateValue, nanos / 1000000L);
                        tzMinutes = (short)(tz.getOffset(millis) / 60000);
                    }
                } else {
                    long millis = DateTimeUtils.convertDateTimeValueToMillis(tz, dateValue, nanos / 1000000L);
                    millis += (long)DateTimeUtils.getTimeZoneOffset(millis);
                    dateValue = DateTimeUtils.dateValueFromLocalMillis(millis);
                    nanos = nanos % 1000000L + DateTimeUtils.nanosFromLocalMillis(millis);
                }
            }
        }
        if (withTimeZone) {
            return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tzMinutes);
        }
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
    }

    public static int getTimeZoneOffsetMillis(TimeZone tz, long dateValue, long timeNanos) {
        long msec = timeNanos / 1000000L;
        long utc = DateTimeUtils.convertDateTimeValueToMillis(tz, dateValue, msec);
        long local = DateTimeUtils.absoluteDayFromDateValue(dateValue) * 86400000L + msec;
        return (int)(local - utc);
    }

    public static long getMillis(long dateValue, long timeNanos, short offsetMins) {
        return DateTimeUtils.absoluteDayFromDateValue(dateValue) * 86400000L + timeNanos / 1000000L - (long)(offsetMins * 60000);
    }

    public static long getMillis(TimeZone tz, int year, int month, int day, int hour, int minute, int second, int millis) {
        GregorianCalendar c = tz == null ? DateTimeUtils.getCalendar() : DateTimeUtils.getCalendar(tz);
        c.setLenient(false);
        try {
            return DateTimeUtils.convertToMillis(c, year, month, day, hour, minute, second, millis);
        }
        catch (IllegalArgumentException e) {
            String message = e.toString();
            if (message.indexOf("HOUR_OF_DAY") > 0) {
                if (hour < 0 || hour > 23) {
                    throw e;
                }
            } else if (message.indexOf("DAY_OF_MONTH") > 0) {
                int maxDay = month == 2 ? (c.isLeapYear(year) ? 29 : 28) : NORMAL_DAYS_PER_MONTH[month];
                if (day < 1 || day > maxDay) {
                    throw e;
                }
                hour += 6;
            }
            c.setLenient(true);
            return DateTimeUtils.convertToMillis(c, year, month, day, hour, minute, second, millis);
        }
    }

    private static long convertToMillis(Calendar cal, int year, int month, int day, int hour, int minute, int second, int millis) {
        if (year <= 0) {
            cal.set(0, 0);
            cal.set(1, 1 - year);
        } else {
            cal.set(0, 1);
            cal.set(1, year);
        }
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millis);
        return cal.getTimeInMillis();
    }

    public static long[] dateAndTimeFromValue(Value value) {
        long dateValue = 1008673L;
        long timeNanos = 0L;
        if (value instanceof ValueTimestamp) {
            ValueTimestamp v = (ValueTimestamp)value;
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        } else if (value instanceof ValueDate) {
            dateValue = ((ValueDate)value).getDateValue();
        } else if (value instanceof ValueTime) {
            timeNanos = ((ValueTime)value).getNanos();
        } else if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone v = (ValueTimestampTimeZone)value;
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        } else {
            ValueTimestamp v = (ValueTimestamp)value.convertTo(11);
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        }
        return new long[]{dateValue, timeNanos};
    }

    public static Value dateTimeToValue(Value original, long dateValue, long timeNanos, boolean forceTimestamp) {
        if (!(original instanceof ValueTimestamp)) {
            if (!forceTimestamp) {
                if (original instanceof ValueDate) {
                    return ValueDate.fromDateValue(dateValue);
                }
                if (original instanceof ValueTime) {
                    return ValueTime.fromNanos(timeNanos);
                }
            }
            if (original instanceof ValueTimestampTimeZone) {
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, ((ValueTimestampTimeZone)original).getTimeZoneOffsetMins());
            }
        }
        return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
    }

    public static long getTimeLocalWithoutDst(Date d) {
        return d.getTime() + (long)zoneOffsetMillis;
    }

    public static long getTimeUTCWithoutDst(long millis) {
        return millis - (long)zoneOffsetMillis;
    }

    public static int getDayOfWeek(long dateValue, int firstDayOfWeek) {
        return DateTimeUtils.getDayOfWeekFromAbsolute(DateTimeUtils.absoluteDayFromDateValue(dateValue), firstDayOfWeek);
    }

    public static int getDayOfWeekFromAbsolute(long absoluteValue, int firstDayOfWeek) {
        return absoluteValue >= 0L ? (int)((absoluteValue - (long)firstDayOfWeek + 11L) % 7L) + 1 : (int)((absoluteValue - (long)firstDayOfWeek - 2L) % 7L) + 7;
    }

    public static int getDayOfYear(long dateValue) {
        return (int)(DateTimeUtils.absoluteDayFromDateValue(dateValue) - DateTimeUtils.absoluteDayFromYear(DateTimeUtils.yearFromDateValue(dateValue))) + 1;
    }

    public static int getIsoDayOfWeek(long dateValue) {
        return DateTimeUtils.getDayOfWeek(dateValue, 1);
    }

    public static int getIsoWeekOfYear(long dateValue) {
        return DateTimeUtils.getWeekOfYear(dateValue, 1, 4);
    }

    public static int getIsoWeekYear(long dateValue) {
        return DateTimeUtils.getWeekYear(dateValue, 1, 4);
    }

    public static int getSundayDayOfWeek(long dateValue) {
        return DateTimeUtils.getDayOfWeek(dateValue, 0);
    }

    public static int getWeekOfYear(long dateValue, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        int year;
        long base;
        long abs = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        if (abs - (base = DateTimeUtils.getWeekOfYearBase(year = DateTimeUtils.yearFromDateValue(dateValue), firstDayOfWeek, minimalDaysInFirstWeek)) < 0L) {
            base = DateTimeUtils.getWeekOfYearBase(year - 1, firstDayOfWeek, minimalDaysInFirstWeek);
        } else if (DateTimeUtils.monthFromDateValue(dateValue) == 12 && 24 + minimalDaysInFirstWeek < DateTimeUtils.dayFromDateValue(dateValue) && abs >= DateTimeUtils.getWeekOfYearBase(year + 1, firstDayOfWeek, minimalDaysInFirstWeek)) {
            return 1;
        }
        return (int)((abs - base) / 7L) + 1;
    }

    private static long getWeekOfYearBase(int year, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        long first = DateTimeUtils.absoluteDayFromYear(year);
        int daysInFirstWeek = 8 - DateTimeUtils.getDayOfWeekFromAbsolute(first, firstDayOfWeek);
        long base = first + (long)daysInFirstWeek;
        if (daysInFirstWeek >= minimalDaysInFirstWeek) {
            base -= 7L;
        }
        return base;
    }

    public static int getWeekYear(long dateValue, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        int year;
        long base;
        long abs = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        if (abs - (base = DateTimeUtils.getWeekOfYearBase(year = DateTimeUtils.yearFromDateValue(dateValue), firstDayOfWeek, minimalDaysInFirstWeek)) < 0L) {
            return year - 1;
        }
        if (DateTimeUtils.monthFromDateValue(dateValue) == 12 && 24 + minimalDaysInFirstWeek < DateTimeUtils.dayFromDateValue(dateValue) && abs >= DateTimeUtils.getWeekOfYearBase(year + 1, firstDayOfWeek, minimalDaysInFirstWeek)) {
            return year + 1;
        }
        return year;
    }

    public static int getDaysInMonth(int year, int month) {
        if (month != 2) {
            return NORMAL_DAYS_PER_MONTH[month];
        }
        return (year & 3) == 0 && (year < 1582 || year % 100 != 0 || year % 400 == 0) ? 29 : 28;
    }

    public static boolean isValidDate(int year, int month, int day) {
        if (month < 1 || month > 12 || day < 1) {
            return false;
        }
        if (year == 1582 && month == 10) {
            return day < 5 || day > 14 && day <= 31;
        }
        return day <= DateTimeUtils.getDaysInMonth(year, month);
    }

    public static java.sql.Date convertDateValueToDate(long dateValue) {
        long millis = DateTimeUtils.getMillis(DateTimeUtils.getTimeZone(), DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), 0, 0, 0, 0);
        return new java.sql.Date(millis);
    }

    public static long convertDateTimeValueToMillis(TimeZone tz, long dateValue, long ms) {
        long second = ms / 1000L;
        ms -= second * 1000L;
        int minute = (int)(second / 60L);
        second -= (long)(minute * 60);
        int hour = minute / 60;
        return DateTimeUtils.getMillis(tz, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), hour, minute -= hour * 60, (int)second, (int)ms);
    }

    public static Timestamp convertDateValueToTimestamp(long dateValue, long timeNanos) {
        Timestamp ts = new Timestamp(DateTimeUtils.convertDateTimeValueToMillis(DateTimeUtils.getTimeZone(), dateValue, timeNanos / 1000000L));
        ts.setNanos((int)(timeNanos % 1000000000L));
        return ts;
    }

    public static Timestamp convertTimestampTimeZoneToTimestamp(long dateValue, long timeNanos, short offsetMins) {
        Timestamp ts = new Timestamp(DateTimeUtils.getMillis(dateValue, timeNanos, offsetMins));
        ts.setNanos((int)(timeNanos % 1000000000L));
        return ts;
    }

    public static Time convertNanoToTime(long nanosSinceMidnight) {
        long millis = nanosSinceMidnight / 1000000L;
        long s2 = millis / 1000L;
        millis -= s2 * 1000L;
        long m4 = s2 / 60L;
        s2 -= m4 * 60L;
        long h2 = m4 / 60L;
        long ms = DateTimeUtils.getMillis(DateTimeUtils.getTimeZone(), 1970, 1, 1, (int)(h2 % 24L), (int)(m4 -= h2 * 60L), (int)s2, (int)millis);
        return new Time(ms);
    }

    public static int yearFromDateValue(long x) {
        return (int)(x >>> 9);
    }

    public static int monthFromDateValue(long x) {
        return (int)(x >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long x) {
        return (int)(x & 0x1FL);
    }

    public static long dateValue(long year, int month, int day) {
        return year << 9 | (long)(month << 5) | (long)day;
    }

    public static long dateValueFromDenormalizedDate(long year, long month, int day) {
        long mm1 = month - 1L;
        long yd = mm1 / 12L;
        if (mm1 < 0L && yd * 12L != mm1) {
            --yd;
        }
        int y = (int)(year + yd);
        int m4 = (int)(month - yd * 12L);
        if (day < 1) {
            day = 1;
        } else {
            int max = DateTimeUtils.getDaysInMonth(y, m4);
            if (day > max) {
                day = max;
            }
        }
        return DateTimeUtils.dateValue(y, m4, day);
    }

    public static long dateValueFromLocalMillis(long ms) {
        long absoluteDay = ms / 86400000L;
        if (ms < 0L && absoluteDay * 86400000L != ms) {
            --absoluteDay;
        }
        return DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay);
    }

    private static long dateValueFromCalendar(Calendar cal) {
        int year = cal.get(1);
        if (cal.get(0) == 0) {
            year = 1 - year;
        }
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return (long)year << 9 | (long)(month << 5) | (long)day;
    }

    public static long nanosFromLocalMillis(long ms) {
        long absoluteDay = ms / 86400000L;
        if (ms < 0L && absoluteDay * 86400000L != ms) {
            --absoluteDay;
        }
        return (ms - absoluteDay * 86400000L) * 1000000L;
    }

    private static long nanosFromCalendar(Calendar cal) {
        int h2 = cal.get(11);
        int m4 = cal.get(12);
        int s2 = cal.get(13);
        int millis = cal.get(14);
        return ((((long)h2 * 60L + (long)m4) * 60L + (long)s2) * 1000L + (long)millis) * 1000000L;
    }

    public static ValueTimestamp normalizeTimestamp(long absoluteDay, long nanos) {
        if (nanos > 86400000000000L || nanos < 0L) {
            long d = nanos > 86400000000000L ? nanos / 86400000000000L : (nanos - 86400000000000L + 1L) / 86400000000000L;
            nanos -= d * 86400000000000L;
            absoluteDay += d;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), nanos);
    }

    public static ValueTimestampTimeZone timestampTimeZoneFromLocalDateValueAndNanos(long dateValue, long timeNanos) {
        int timeZoneOffset = DateTimeUtils.getTimeZoneOffsetMillis(null, dateValue, timeNanos);
        int offsetMins = timeZoneOffset / 60000;
        int correction = timeZoneOffset % 60000;
        if (correction != 0) {
            if ((timeNanos -= (long)correction) < 0L) {
                timeNanos += 86400000000000L;
                dateValue = DateTimeUtils.decrementDateValue(dateValue);
            } else if (timeNanos >= 86400000000000L) {
                timeNanos -= 86400000000000L;
                dateValue = DateTimeUtils.incrementDateValue(dateValue);
            }
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, (short)offsetMins);
    }

    public static ValueTimestampTimeZone timestampTimeZoneFromMillis(long ms) {
        int offset = DateTimeUtils.getTimeZoneOffset(ms);
        long absoluteDay = (ms += (long)offset) / 86400000L;
        if (ms < 0L && absoluteDay * 86400000L != ms) {
            --absoluteDay;
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), (ms - absoluteDay * 86400000L) * 1000000L, (short)(offset / 60000));
    }

    public static long absoluteDayFromYear(long year) {
        long a = (--year * 1461L >> 2) - 719177L;
        if (year < 1582L) {
            a += 13L;
        } else if (year < 1900L || year > 2099L) {
            a += year / 400L - year / 100L + 15L;
        }
        return a;
    }

    public static long absoluteDayFromDateValue(long dateValue) {
        long y = DateTimeUtils.yearFromDateValue(dateValue);
        int m4 = DateTimeUtils.monthFromDateValue(dateValue);
        int d = DateTimeUtils.dayFromDateValue(dateValue);
        if (m4 <= 2) {
            --y;
            m4 += 12;
        }
        long a = (y * 1461L >> 2) + (long)DAYS_OFFSET[m4 - 3] + (long)d - 719484L;
        if (y <= 1582L && (y < 1582L || m4 * 100 + d < 1015)) {
            a += 13L;
        } else if (y < 1900L || y > 2099L) {
            a += y / 400L - y / 100L + 15L;
        }
        return a;
    }

    public static long prolepticGregorianAbsoluteDayFromDateValue(long dateValue) {
        long y = DateTimeUtils.yearFromDateValue(dateValue);
        int m4 = DateTimeUtils.monthFromDateValue(dateValue);
        int d = DateTimeUtils.dayFromDateValue(dateValue);
        if (m4 <= 2) {
            --y;
            m4 += 12;
        }
        long a = (y * 1461L >> 2) + (long)DAYS_OFFSET[m4 - 3] + (long)d - 719484L;
        if (y < 1900L || y > 2099L) {
            a += y / 400L - y / 100L + 15L;
        }
        return a;
    }

    public static long dateValueFromAbsoluteDay(long absoluteDay) {
        long offset;
        long y100;
        long d = absoluteDay + 719468L;
        if (d > 578040L) {
            long y400 = d / 146097L;
            y100 = (d -= y400 * 146097L) / 36524L;
            d -= y100 * 36524L;
            offset = y400 * 400L + y100 * 100L;
        } else {
            y100 = 0L;
            d += 292200000002L;
            offset = -800000000L;
        }
        long y4 = d / 1461L;
        long y = (d -= y4 * 1461L) / 365L;
        if ((d -= y * 365L) == 0L && (y == 4L || y100 == 4L)) {
            --y;
            d += 365L;
        }
        y += offset + y4 * 4L;
        int m4 = ((int)d * 2 + 1) * 5 / 306;
        d -= (long)(DAYS_OFFSET[m4] - 1);
        if (m4 >= 10) {
            ++y;
            m4 -= 12;
        }
        return DateTimeUtils.dateValue(y, m4 + 3, (int)d);
    }

    public static long incrementDateValue(long dateValue) {
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        if (year == 1582) {
            return DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) + 1L);
        }
        int day = DateTimeUtils.dayFromDateValue(dateValue);
        if (day < 28) {
            return dateValue + 1L;
        }
        int month = DateTimeUtils.monthFromDateValue(dateValue);
        if (day < DateTimeUtils.getDaysInMonth(year, month)) {
            return dateValue + 1L;
        }
        if (month < 12) {
            ++month;
        } else {
            month = 1;
            ++year;
        }
        return DateTimeUtils.dateValue(year, month, 1);
    }

    public static long decrementDateValue(long dateValue) {
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        if (year == 1582) {
            return DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) - 1L);
        }
        if (DateTimeUtils.dayFromDateValue(dateValue) > 1) {
            return dateValue - 1L;
        }
        int month = DateTimeUtils.monthFromDateValue(dateValue);
        if (month > 1) {
            --month;
        } else {
            month = 12;
            --year;
        }
        return DateTimeUtils.dateValue(year, month, DateTimeUtils.getDaysInMonth(year, month));
    }

    public static void appendDate(StringBuilder buff, long dateValue) {
        int y = DateTimeUtils.yearFromDateValue(dateValue);
        int m4 = DateTimeUtils.monthFromDateValue(dateValue);
        int d = DateTimeUtils.dayFromDateValue(dateValue);
        if (y > 0 && y < 10000) {
            StringUtils.appendZeroPadded(buff, 4, y);
        } else {
            buff.append(y);
        }
        buff.append('-');
        StringUtils.appendZeroPadded(buff, 2, m4);
        buff.append('-');
        StringUtils.appendZeroPadded(buff, 2, d);
    }

    public static void appendTime(StringBuilder buff, long nanos) {
        if (nanos < 0L) {
            buff.append('-');
            nanos = -nanos;
        }
        long ms = -nanos / -1000000L;
        nanos -= ms * 1000000L;
        long s2 = ms / 1000L;
        ms -= s2 * 1000L;
        long m4 = s2 / 60L;
        s2 -= m4 * 60L;
        long h2 = m4 / 60L;
        StringUtils.appendZeroPadded(buff, 2, h2);
        buff.append(':');
        StringUtils.appendZeroPadded(buff, 2, m4 -= h2 * 60L);
        buff.append(':');
        StringUtils.appendZeroPadded(buff, 2, s2);
        if (ms > 0L || nanos > 0L) {
            buff.append('.');
            StringUtils.appendZeroPadded(buff, 3, ms);
            if (nanos > 0L) {
                StringUtils.appendZeroPadded(buff, 6, nanos);
            }
            DateTimeUtils.stripTrailingZeroes(buff);
        }
    }

    static void stripTrailingZeroes(StringBuilder buff) {
        int i = buff.length() - 1;
        if (buff.charAt(i) == '0') {
            while (buff.charAt(--i) == '0') {
            }
            buff.setLength(i + 1);
        }
    }

    public static void appendTimeZone(StringBuilder buff, short tz) {
        if (tz < 0) {
            buff.append('-');
            tz = -tz;
        } else {
            buff.append('+');
        }
        int hours = tz / 60;
        short mins = tz = (short)(tz - hours * 60);
        StringUtils.appendZeroPadded(buff, 2, hours);
        if (mins != 0) {
            buff.append(':');
            StringUtils.appendZeroPadded(buff, 2, mins);
        }
    }

    public static void appendTimestampTimeZone(StringBuilder buff, long dateValue, long timeNanos, short timeZoneOffsetMins) {
        DateTimeUtils.appendDate(buff, dateValue);
        buff.append(' ');
        DateTimeUtils.appendTime(buff, timeNanos);
        DateTimeUtils.appendTimeZone(buff, timeZoneOffsetMins);
    }

    public static String timeZoneNameFromOffsetMins(int offsetMins) {
        if (offsetMins == 0) {
            return "UTC";
        }
        StringBuilder b = new StringBuilder(9);
        b.append("GMT");
        if (offsetMins < 0) {
            b.append('-');
            offsetMins = -offsetMins;
        } else {
            b.append('+');
        }
        StringUtils.appendZeroPadded(b, 2, offsetMins / 60);
        b.append(':');
        StringUtils.appendZeroPadded(b, 2, offsetMins % 60);
        return b.toString();
    }

    public static long convertScale(long nanosOfDay, int scale) {
        if (scale >= 9) {
            return nanosOfDay;
        }
        int m4 = CONVERT_SCALE_TABLE[scale];
        long mod = nanosOfDay % (long)m4;
        if (mod >= (long)(m4 >>> 1)) {
            nanosOfDay += (long)m4;
        }
        return nanosOfDay - mod;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static void setTimeZone(TimeZone tz) {
        timeZone = tz;
    }

    static {
        zoneOffsetMillis = DateTimeUtils.createGregorianCalendar().get(15);
    }
}

