/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.util.regex.Pattern;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.message.DbException;

public class ColumnNamerConfiguration {
    private static final String DEFAULT_COMMAND = "DEFAULT";
    private static final String REGULAR_EXPRESSION_MATCH_DISALLOWED = "REGULAR_EXPRESSION_MATCH_DISALLOWED = ";
    private static final String REGULAR_EXPRESSION_MATCH_ALLOWED = "REGULAR_EXPRESSION_MATCH_ALLOWED = ";
    private static final String DEFAULT_COLUMN_NAME_PATTERN = "DEFAULT_COLUMN_NAME_PATTERN = ";
    private static final String MAX_IDENTIFIER_LENGTH = "MAX_IDENTIFIER_LENGTH = ";
    private static final String EMULATE_COMMAND = "EMULATE = ";
    private static final String GENERATE_UNIQUE_COLUMN_NAMES = "GENERATE_UNIQUE_COLUMN_NAMES = ";
    private int maxIdentiferLength;
    private String regularExpressionMatchAllowed;
    private String regularExpressionMatchDisallowed;
    private String defaultColumnNamePattern;
    private boolean generateUniqueColumnNames;
    private Pattern compiledRegularExpressionMatchAllowed;
    private Pattern compiledRegularExpressionMatchDisallowed;

    public ColumnNamerConfiguration(int maxIdentiferLength, String regularExpressionMatchAllowed, String regularExpressionMatchDisallowed, String defaultColumnNamePattern, boolean generateUniqueColumnNames) {
        this.maxIdentiferLength = maxIdentiferLength;
        this.regularExpressionMatchAllowed = regularExpressionMatchAllowed;
        this.regularExpressionMatchDisallowed = regularExpressionMatchDisallowed;
        this.defaultColumnNamePattern = defaultColumnNamePattern;
        this.generateUniqueColumnNames = generateUniqueColumnNames;
        this.recompilePatterns();
    }

    public int getMaxIdentiferLength() {
        return this.maxIdentiferLength;
    }

    public void setMaxIdentiferLength(int maxIdentiferLength) {
        this.maxIdentiferLength = Math.max(30, maxIdentiferLength);
        if (maxIdentiferLength != this.getMaxIdentiferLength()) {
            throw DbException.getInvalidValueException("Illegal value (<30) in SET COLUMN_NAME_RULES", "MAX_IDENTIFIER_LENGTH=" + maxIdentiferLength);
        }
    }

    public String getRegularExpressionMatchAllowed() {
        return this.regularExpressionMatchAllowed;
    }

    public void setRegularExpressionMatchAllowed(String regularExpressionMatchAllowed) {
        this.regularExpressionMatchAllowed = regularExpressionMatchAllowed;
    }

    public String getRegularExpressionMatchDisallowed() {
        return this.regularExpressionMatchDisallowed;
    }

    public void setRegularExpressionMatchDisallowed(String regularExpressionMatchDisallowed) {
        this.regularExpressionMatchDisallowed = regularExpressionMatchDisallowed;
    }

    public String getDefaultColumnNamePattern() {
        return this.defaultColumnNamePattern;
    }

    public void setDefaultColumnNamePattern(String defaultColumnNamePattern) {
        this.defaultColumnNamePattern = defaultColumnNamePattern;
    }

    public Pattern getCompiledRegularExpressionMatchAllowed() {
        return this.compiledRegularExpressionMatchAllowed;
    }

    public void setCompiledRegularExpressionMatchAllowed(Pattern compiledRegularExpressionMatchAllowed) {
        this.compiledRegularExpressionMatchAllowed = compiledRegularExpressionMatchAllowed;
    }

    public Pattern getCompiledRegularExpressionMatchDisallowed() {
        return this.compiledRegularExpressionMatchDisallowed;
    }

    public void setCompiledRegularExpressionMatchDisallowed(Pattern compiledRegularExpressionMatchDisallowed) {
        this.compiledRegularExpressionMatchDisallowed = compiledRegularExpressionMatchDisallowed;
    }

    public void configure(String stringValue) {
        try {
            if (stringValue.equalsIgnoreCase(DEFAULT_COMMAND)) {
                this.configure(Mode.ModeEnum.REGULAR);
            } else if (stringValue.startsWith(EMULATE_COMMAND)) {
                this.configure(Mode.ModeEnum.valueOf(ColumnNamerConfiguration.unquoteString(stringValue.substring(EMULATE_COMMAND.length()))));
            } else if (stringValue.startsWith(MAX_IDENTIFIER_LENGTH)) {
                int maxLength = Integer.parseInt(stringValue.substring(MAX_IDENTIFIER_LENGTH.length()));
                this.setMaxIdentiferLength(maxLength);
            } else if (stringValue.startsWith(GENERATE_UNIQUE_COLUMN_NAMES)) {
                this.setGenerateUniqueColumnNames(Integer.parseInt(stringValue.substring(GENERATE_UNIQUE_COLUMN_NAMES.length())) == 1);
            } else if (stringValue.startsWith(DEFAULT_COLUMN_NAME_PATTERN)) {
                this.setDefaultColumnNamePattern(ColumnNamerConfiguration.unquoteString(stringValue.substring(DEFAULT_COLUMN_NAME_PATTERN.length())));
            } else if (stringValue.startsWith(REGULAR_EXPRESSION_MATCH_ALLOWED)) {
                this.setRegularExpressionMatchAllowed(ColumnNamerConfiguration.unquoteString(stringValue.substring(REGULAR_EXPRESSION_MATCH_ALLOWED.length())));
            } else if (stringValue.startsWith(REGULAR_EXPRESSION_MATCH_DISALLOWED)) {
                this.setRegularExpressionMatchDisallowed(ColumnNamerConfiguration.unquoteString(stringValue.substring(REGULAR_EXPRESSION_MATCH_DISALLOWED.length())));
            } else {
                throw DbException.getInvalidValueException("SET COLUMN_NAME_RULES: unknown id:" + stringValue, stringValue);
            }
            this.recompilePatterns();
        }
        catch (RuntimeException e) {
            throw DbException.getInvalidValueException("SET COLUMN_NAME_RULES:" + e.getMessage(), stringValue);
        }
    }

    private void recompilePatterns() {
        try {
            this.setCompiledRegularExpressionMatchAllowed(this.regularExpressionMatchAllowed != null ? Pattern.compile(this.regularExpressionMatchAllowed) : null);
            this.setCompiledRegularExpressionMatchDisallowed(this.regularExpressionMatchDisallowed != null ? Pattern.compile(this.regularExpressionMatchDisallowed) : null);
        }
        catch (Exception e) {
            this.configure(Mode.ModeEnum.REGULAR);
            throw e;
        }
    }

    public static ColumnNamerConfiguration getDefault() {
        return new ColumnNamerConfiguration(Integer.MAX_VALUE, null, null, "_UNNAMED_$$", false);
    }

    private static String unquoteString(String s2) {
        if (s2.startsWith("'") && s2.endsWith("'")) {
            s2 = s2.substring(1, s2.length() - 1);
            return s2;
        }
        return s2;
    }

    public boolean isGenerateUniqueColumnNames() {
        return this.generateUniqueColumnNames;
    }

    public void setGenerateUniqueColumnNames(boolean generateUniqueColumnNames) {
        this.generateUniqueColumnNames = generateUniqueColumnNames;
    }

    public void configure(Mode.ModeEnum modeEnum) {
        switch (modeEnum) {
            case Oracle: {
                this.setMaxIdentiferLength(128);
                this.setRegularExpressionMatchAllowed("(?m)(?s)\"?[A-Za-z0-9_\\$#]+\"?");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\"\\$#]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case MSSQLServer: {
                this.setMaxIdentiferLength(128);
                this.setRegularExpressionMatchAllowed("(?m)(?s)[A-Za-z0-9_\\[\\]]+");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\\[\\]]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case PostgreSQL: {
                this.setMaxIdentiferLength(63);
                this.setRegularExpressionMatchAllowed("(?m)(?s)[A-Za-z0-9_\\$]+");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\\$]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case MySQL: {
                this.setMaxIdentiferLength(64);
                this.setRegularExpressionMatchAllowed("(?m)(?s)`?[A-Za-z0-9_`\\$]+`?");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_`\\$]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            default: {
                this.setMaxIdentiferLength(Integer.MAX_VALUE);
                this.setRegularExpressionMatchAllowed(null);
                this.setRegularExpressionMatchDisallowed(null);
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
            }
        }
        this.recompilePatterns();
    }
}

