/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.util.ColumnNamerConfiguration;
import org.gridgain.internal.h2.util.StringUtils;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        if (session != null && session.getColumnNamerConfiguration() != null) {
            this.configuration = session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression columnExp, int indexOfColumn, String[] columnNameOverides) {
        String columnNameOverride = null;
        if (columnNameOverides != null && columnNameOverides.length > indexOfColumn) {
            columnNameOverride = columnNameOverides[indexOfColumn];
        }
        return this.getColumnName(columnExp, indexOfColumn, columnNameOverride);
    }

    public String getColumnName(Expression columnExp, int indexOfColumn, String columnNameOverride) {
        String columnName = this.getColumnName(columnNameOverride, null);
        if (columnName == null && (columnName = this.getColumnName(columnExp.getAlias(), DEFAULT_COLUMN_NAME)) == null && (columnName = this.getColumnName(columnExp.getColumnName(), DEFAULT_COLUMN_NAME)) == null && (columnName = this.getColumnName(columnExp.getSQL(false), DEFAULT_COLUMN_NAME)) == null) {
            columnName = this.configuration.getDefaultColumnNamePattern().replace("$$", Integer.toString(indexOfColumn + 1));
        }
        if (this.existingColumnNames.contains(columnName) && this.configuration.isGenerateUniqueColumnNames()) {
            columnName = this.generateUniqueName(columnName);
        }
        this.existingColumnNames.add(columnName);
        return columnName;
    }

    private String getColumnName(String proposedName, String disallowedName) {
        String columnName = null;
        if (proposedName != null && !proposedName.equals(disallowedName)) {
            if (this.isAllowableColumnName(proposedName)) {
                columnName = proposedName;
            } else if (this.isAllowableColumnName(proposedName = this.fixColumnName(proposedName))) {
                columnName = proposedName;
            }
        }
        return columnName;
    }

    private String generateUniqueName(String columnName) {
        String newColumnName = columnName;
        int loopCount = 2;
        while (this.existingColumnNames.contains(newColumnName)) {
            String loopCountString = "_" + loopCount;
            newColumnName = columnName.substring(0, Math.min(columnName.length(), this.configuration.getMaxIdentiferLength() - loopCountString.length())) + loopCountString;
            ++loopCount;
        }
        return newColumnName;
    }

    private boolean isAllowableColumnName(String proposedName) {
        if (proposedName == null) {
            return false;
        }
        int length = proposedName.length();
        if (length > this.configuration.getMaxIdentiferLength() || length == 0) {
            return false;
        }
        Pattern allowed = this.configuration.getCompiledRegularExpressionMatchAllowed();
        return allowed == null || allowed.matcher(proposedName).matches();
    }

    private String fixColumnName(String proposedName) {
        int maxLength;
        Pattern disallowed = this.configuration.getCompiledRegularExpressionMatchDisallowed();
        proposedName = disallowed == null ? StringUtils.replaceAll(proposedName, "\u0000", "") : disallowed.matcher(proposedName).replaceAll("");
        int length = proposedName.length();
        if (length > (maxLength = this.configuration.getMaxIdentiferLength())) {
            proposedName = proposedName.substring(0, maxLength);
        }
        return proposedName;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

