/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.gridgain.internal.h2.api.JavaObjectSerializer;
import org.gridgain.internal.h2.compress.CompressLZF;
import org.gridgain.internal.h2.engine.MetaRecord;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.MVStoreTool;
import org.gridgain.internal.h2.mvstore.StreamStore;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.RowFactory;
import org.gridgain.internal.h2.result.SimpleRow;
import org.gridgain.internal.h2.security.SHA256;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.DataReader;
import org.gridgain.internal.h2.store.FileLister;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.store.FileStoreInputStream;
import org.gridgain.internal.h2.store.LobStorageBackend;
import org.gridgain.internal.h2.store.LobStorageMap;
import org.gridgain.internal.h2.store.PageFreeList;
import org.gridgain.internal.h2.store.PageLog;
import org.gridgain.internal.h2.store.PageStore;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.IntArray;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.SmallLRUCache;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.TempFileDeleter;
import org.gridgain.internal.h2.util.Tool;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueLob;
import org.gridgain.internal.h2.value.ValueLobDb;
import org.gridgain.internal.h2.value.ValueLong;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean transactionLog;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private HashMap<String, String> columnTypeMap;
    private boolean remove;
    private int pageSize;
    private FileStore store;
    private int[] parents;
    private Stats stat;
    private boolean lobMaps;

    public static void main(String ... args) throws SQLException {
        new Recover().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String dir = ".";
        String db = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if ("-dir".equals(arg)) {
                dir = args[++i];
                continue;
            }
            if ("-db".equals(arg)) {
                db = args[++i];
                continue;
            }
            if ("-removePassword".equals(arg)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(arg)) {
                this.trace = true;
                continue;
            }
            if ("-transactionLog".equals(arg)) {
                this.transactionLog = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        this.process(dir, db);
    }

    public static Reader readClob(String fileName) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(fileName), StandardCharsets.UTF_8));
    }

    public static InputStream readBlob(String fileName) throws IOException {
        return new BufferedInputStream(FileUtils.newInputStream(fileName));
    }

    public static ValueLobDb readBlobDb(Connection conn, long lobId, long precision) {
        DataHandler h2 = ((JdbcConnection)conn).getSession().getDataHandler();
        Recover.verifyPageStore(h2);
        ValueLobDb lob = ValueLobDb.create(15, h2, -2, lobId, null, precision);
        lob.setRecoveryReference(true);
        return lob;
    }

    private static void verifyPageStore(DataHandler h2) {
        if (h2.getLobStorage() instanceof LobStorageMap) {
            throw DbException.get(50100, "Restore page store recovery SQL script can only be restored to a PageStore file");
        }
    }

    public static ValueLobDb readClobDb(Connection conn, long lobId, long precision) {
        DataHandler h2 = ((JdbcConnection)conn).getSession().getDataHandler();
        Recover.verifyPageStore(h2);
        ValueLobDb lob = ValueLobDb.create(16, h2, -2, lobId, null, precision);
        lob.setRecoveryReference(true);
        return lob;
    }

    public static InputStream readBlobMap(Connection conn, long lobId, long precision) throws SQLException {
        final PreparedStatement prep = conn.prepareStatement("SELECT DATA FROM INFORMATION_SCHEMA.LOB_BLOCKS WHERE LOB_ID = ? AND SEQ = ? AND ? > 0");
        prep.setLong(1, lobId);
        prep.setLong(3, precision);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private int seq;
            private byte[] data = this.fetch();

            private byte[] fetch() {
                try {
                    prep.setInt(2, this.seq++);
                    ResultSet rs = prep.executeQuery();
                    if (rs.next()) {
                        return rs.getBytes(1);
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.data != null;
            }

            @Override
            public InputStream nextElement() {
                ByteArrayInputStream in = new ByteArrayInputStream(this.data);
                this.data = this.fetch();
                return in;
            }
        });
    }

    public static Reader readClobMap(Connection conn, long lobId, long precision) throws Exception {
        InputStream in = Recover.readBlobMap(conn, lobId, precision);
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    private void trace(String message) {
        if (this.trace) {
            this.out.println(message);
        }
    }

    private void traceError(String message, Throwable t2) {
        this.out.println(message + ": " + t2.toString());
        if (this.trace) {
            t2.printStackTrace(this.out);
        }
    }

    public static void execute(String dir, String db) throws SQLException {
        try {
            new Recover().process(dir, db);
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    private void process(String dir, String db) {
        ArrayList<String> list = FileLister.getDatabaseFiles(dir, db, true);
        if (list.isEmpty()) {
            this.printNoDatabaseFilesFound(dir, db);
        }
        for (String fileName : list) {
            if (fileName.endsWith(".h2.db")) {
                this.dumpPageStore(fileName);
                continue;
            }
            if (fileName.endsWith(".lob.db")) {
                this.dumpLob(fileName, false);
                continue;
            }
            if (!fileName.endsWith(".mv.db")) continue;
            String f = fileName.substring(0, fileName.length() - ".h2.db".length());
            try (PrintWriter writer = this.getWriter(fileName, ".txt");){
                MVStoreTool.dump(fileName, writer, true);
                MVStoreTool.info(fileName, writer);
            }
            writer = this.getWriter(f + ".h2.db", ".sql");
            var8_8 = null;
            try {
                this.dumpMVStoreFile(writer, fileName);
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (writer == null) continue;
                if (var8_8 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    private PrintWriter getWriter(String fileName, String suffix) {
        fileName = fileName.substring(0, fileName.length() - 3);
        String outputFile = fileName + suffix;
        this.trace("Created file: " + outputFile);
        try {
            return new PrintWriter(IOUtils.getBufferedWriter(FileUtils.newOutputStream(outputFile, false)));
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private void writeDataError(PrintWriter writer, String error, byte[] data) {
        int x;
        writer.println("-- ERROR: " + error + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder sb = new StringBuilder();
        for (byte aData1 : data) {
            x = aData1 & 0xFF;
            if (x >= 32 && x < 128) {
                sb.append((char)x);
                continue;
            }
            sb.append('?');
        }
        writer.println("-- dump: " + sb.toString());
        sb = new StringBuilder();
        for (byte aData : data) {
            x = aData & 0xFF;
            sb.append(' ');
            if (x < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(x));
        }
        writer.println("-- dump: " + sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpLob(String fileName, boolean lobCompression) {
        OutputStream fileOut = null;
        FileStore fileStore = null;
        long size = 0L;
        String n = fileName + (lobCompression ? ".comp" : "") + ".txt";
        FileStoreInputStream in = null;
        try {
            fileOut = FileUtils.newOutputStream(n, false);
            fileStore = FileStore.open(null, fileName, "r");
            fileStore.init();
            in = new FileStoreInputStream(fileStore, this, lobCompression, false);
            size = IOUtils.copy(in, fileOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(fileOut);
            IOUtils.closeSilently(in);
            Recover.closeSilently(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(fileOut);
                IOUtils.closeSilently(in);
                Recover.closeSilently(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(fileOut);
        IOUtils.closeSilently(in);
        Recover.closeSilently(fileStore);
        if (size == 0L) {
            try {
                FileUtils.delete(n);
            }
            catch (Exception e) {
                this.traceError(n, e);
            }
        }
    }

    private void getSQL(StringBuilder builder, String column, Value v) {
        ValueLobDb lob;
        byte[] small;
        if (v instanceof ValueLob) {
            ValueLob lob2 = (ValueLob)v;
            byte[] small2 = lob2.getSmall();
            if (small2 == null) {
                String type;
                String file = lob2.getFileName();
                String string = type = lob2.getValueType() == 15 ? "BLOB" : "CLOB";
                if (lob2.isCompressed()) {
                    this.dumpLob(file, true);
                    file = file + ".comp";
                }
                builder.append("READ_").append(type).append("('").append(file).append(".txt')");
                return;
            }
        } else if (v instanceof ValueLobDb && (small = (lob = (ValueLobDb)v).getSmall()) == null) {
            String columnType;
            int type = lob.getValueType();
            long id = lob.getLobId();
            long precision = lob.getType().getPrecision();
            if (type == 15) {
                columnType = "BLOB";
                builder.append("READ_BLOB");
            } else {
                columnType = "CLOB";
                builder.append("READ_CLOB");
            }
            if (this.lobMaps) {
                builder.append("_MAP");
            } else {
                builder.append("_DB");
            }
            this.columnTypeMap.put(column, columnType);
            builder.append('(').append(id).append(", ").append(precision).append(')');
            return;
        }
        v.getSQL(builder);
    }

    private void setDatabaseName(String name) {
        this.databaseName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String fileName) {
        this.setDatabaseName(fileName.substring(0, fileName.length() - ".h2.db".length()));
        PrintWriter writer = null;
        this.stat = new Stats();
        try {
            writer = this.getWriter(fileName, ".sql");
            writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            this.resetSchema();
            this.store = FileStore.open(null, fileName, this.remove ? "rw" : "r");
            long length = this.store.length();
            try {
                this.store.init();
            }
            catch (Exception e) {
                this.writeError(writer, e);
            }
            Data s2 = Data.create((DataHandler)this, 128, false);
            this.seek(0L);
            this.store.readFully(s2.getBytes(), 0, 128);
            s2.setPos(48);
            this.pageSize = s2.readInt();
            byte writeVersion = s2.readByte();
            byte readVersion = s2.readByte();
            writer.println("-- pageSize: " + this.pageSize + " writeVersion: " + writeVersion + " readVersion: " + readVersion);
            if (this.pageSize < 64 || this.pageSize > 32768) {
                this.pageSize = 4096;
                writer.println("-- ERROR: page size; using " + this.pageSize);
            }
            long pageCount = length / (long)this.pageSize;
            this.parents = new int[(int)pageCount];
            s2 = Data.create((DataHandler)this, this.pageSize, false);
            for (long i = 3L; i < pageCount; ++i) {
                s2.reset();
                this.seek(i);
                this.store.readFully(s2.getBytes(), 0, 32);
                s2.readByte();
                s2.readShortInt();
                this.parents[(int)i] = s2.readInt();
            }
            int logKey = 0;
            int logFirstTrunkPage = 0;
            int logFirstDataPage = 0;
            s2 = Data.create((DataHandler)this, this.pageSize, false);
            for (long i = 1L; i != 3L; ++i) {
                s2.reset();
                this.seek(i);
                this.store.readFully(s2.getBytes(), 0, this.pageSize);
                CRC32 crc = new CRC32();
                crc.update(s2.getBytes(), 4, this.pageSize - 4);
                int expected = (int)crc.getValue();
                int got = s2.readInt();
                long writeCounter = s2.readLong();
                int key = s2.readInt();
                int firstTrunkPage = s2.readInt();
                int firstDataPage = s2.readInt();
                if (expected == got) {
                    logKey = key;
                    logFirstTrunkPage = firstTrunkPage;
                    logFirstDataPage = firstDataPage;
                }
                writer.println("-- head " + i + ": writeCounter: " + writeCounter + " log " + key + ":" + firstTrunkPage + "/" + firstDataPage + " crc " + got + " (" + (expected == got ? "ok" : "expected: " + expected) + ")");
            }
            writer.println("-- log " + logKey + ":" + logFirstTrunkPage + "/" + logFirstDataPage);
            PrintWriter devNull = new PrintWriter(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            this.dumpPageStore(devNull, pageCount);
            this.stat = new Stats();
            this.schema.clear();
            this.objectIdSet = new HashSet();
            this.dumpPageStore(writer, pageCount);
            this.writeSchemaSET(writer);
            this.writeSchema(writer);
            try {
                this.dumpPageLogStream(writer, logKey, logFirstTrunkPage, logFirstDataPage, pageCount);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            writer.println("---- Statistics ----");
            writer.println("-- page count: " + pageCount + ", free: " + this.stat.free);
            long total = Math.max(1L, this.stat.pageDataRows + this.stat.pageDataEmpty + this.stat.pageDataHead);
            writer.println("-- page data bytes: head " + this.stat.pageDataHead + ", empty " + this.stat.pageDataEmpty + ", rows " + this.stat.pageDataRows + " (" + (100L - 100L * this.stat.pageDataEmpty / total) + "% full)");
            for (int i = 0; i < this.stat.pageTypeCount.length; ++i) {
                int count = this.stat.pageTypeCount[i];
                if (count <= 0) continue;
                writer.println("-- " + Recover.getPageType(i) + " " + (long)(100 * count) / pageCount + "%, " + count + " page(s)");
            }
            writer.close();
        }
        catch (Throwable e) {
            try {
                this.writeError(writer, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(writer);
                Recover.closeSilently(this.store);
                throw throwable;
            }
            IOUtils.closeSilently(writer);
            Recover.closeSilently(this.store);
        }
        IOUtils.closeSilently(writer);
        Recover.closeSilently(this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMVStoreFile(PrintWriter writer, String fileName) {
        writer.println("-- MVStore");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_MAP FOR \"" + this.getClass().getName() + ".readBlobMap\";");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_MAP FOR \"" + this.getClass().getName() + ".readClobMap\";");
        this.resetSchema();
        this.setDatabaseName(fileName.substring(0, fileName.length() - ".mv.db".length()));
        MVStore mv = new MVStore.Builder().fileName(fileName).readOnly().open();
        this.dumpLobMaps(writer, mv);
        writer.println("-- Meta");
        Recover.dumpMeta(writer, mv);
        writer.println("-- Tables");
        TransactionStore store = new TransactionStore(mv);
        try {
            store.init();
        }
        catch (Throwable e) {
            this.writeError(writer, e);
        }
        try {
            Iterator<Object> dataIt;
            TransactionMap dataMap;
            String tableId;
            ValueDataType type = new ValueDataType();
            for (String mapName : mv.getMapNames()) {
                if (!mapName.startsWith("table.") || Integer.parseInt(tableId = mapName.substring("table.".length())) != 0) continue;
                dataMap = store.begin().openMap(mapName, type, type);
                dataIt = dataMap.keyIterator(null);
                while (dataIt.hasNext()) {
                    Value rowId = dataIt.next();
                    Value[] values = ((ValueArray)dataMap.get(rowId)).getList();
                    try {
                        SimpleRow r = new SimpleRow(values);
                        MetaRecord meta = new MetaRecord(r);
                        this.schema.add(meta);
                        if (meta.getObjectType() != 0) continue;
                        String sql = values[3].getString();
                        String name = Recover.extractTableOrViewName(sql);
                        this.tableMap.put(meta.getId(), name);
                    }
                    catch (Throwable t2) {
                        this.writeError(writer, t2);
                    }
                }
            }
            this.writeSchemaSET(writer);
            writer.println("---- Table Data ----");
            for (String mapName : mv.getMapNames()) {
                if (!mapName.startsWith("table.") || Integer.parseInt(tableId = mapName.substring("table.".length())) == 0) continue;
                dataMap = store.begin().openMap(mapName, type, type);
                dataIt = dataMap.keyIterator(null);
                boolean init = false;
                while (dataIt.hasNext()) {
                    String columnName;
                    Value rowId = dataIt.next();
                    Value[] values = ((ValueArray)dataMap.get(rowId)).getList();
                    this.recordLength = values.length;
                    if (!init) {
                        this.setStorage(Integer.parseInt(tableId));
                        StringBuilder builder = new StringBuilder();
                        this.valueId = 0;
                        while (this.valueId < this.recordLength) {
                            columnName = this.storageName + "." + this.valueId;
                            builder.setLength(0);
                            this.getSQL(builder, columnName, values[this.valueId]);
                            ++this.valueId;
                        }
                        this.createTemporaryTable(writer);
                        init = true;
                    }
                    StringBuilder buff = new StringBuilder();
                    buff.append("INSERT INTO O_").append(tableId).append(" VALUES(");
                    this.valueId = 0;
                    while (this.valueId < this.recordLength) {
                        if (this.valueId > 0) {
                            buff.append(", ");
                        }
                        columnName = this.storageName + "." + this.valueId;
                        this.getSQL(buff, columnName, values[this.valueId]);
                        ++this.valueId;
                    }
                    buff.append(");");
                    writer.println(buff.toString());
                }
            }
            this.writeSchema(writer);
            writer.println("DROP ALIAS READ_BLOB_MAP;");
            writer.println("DROP ALIAS READ_CLOB_MAP;");
            writer.println("DROP TABLE IF EXISTS INFORMATION_SCHEMA.LOB_BLOCKS;");
        }
        catch (Throwable e) {
            this.writeError(writer, e);
        }
        finally {
            mv.close();
        }
    }

    private static void dumpMeta(PrintWriter writer, MVStore mv) {
        MVMap<String, String> meta = mv.getMetaMap();
        for (Map.Entry<String, String> e : meta.entrySet()) {
            writer.println("-- " + e.getKey() + " = " + e.getValue());
        }
    }

    private void dumpLobMaps(PrintWriter writer, MVStore mv) {
        this.lobMaps = mv.hasMap("lobData");
        if (!this.lobMaps) {
            return;
        }
        MVMap<Long, byte[]> lobData = mv.openMap("lobData");
        StreamStore streamStore = new StreamStore(lobData);
        MVMap lobMap = mv.openMap("lobMap");
        writer.println("-- LOB");
        writer.println("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_BLOCKS(LOB_ID BIGINT, SEQ INT, DATA BINARY, PRIMARY KEY(LOB_ID, SEQ));");
        boolean hasErrors = false;
        block2: for (Map.Entry e : lobMap.entrySet()) {
            long lobId = (Long)e.getKey();
            Object[] value = (Object[])e.getValue();
            byte[] streamStoreId = (byte[])value[0];
            InputStream in = streamStore.get(streamStoreId);
            int len = 8192;
            byte[] block = new byte[len];
            try {
                int seq = 0;
                while (true) {
                    int l;
                    if ((l = IOUtils.readFully(in, block, block.length)) > 0) {
                        writer.print("INSERT INTO INFORMATION_SCHEMA.LOB_BLOCKS VALUES(" + lobId + ", " + seq + ", '");
                        writer.print(StringUtils.convertBytesToHex(block, l));
                        writer.println("');");
                    }
                    if (l != len) continue block2;
                    ++seq;
                }
            }
            catch (IOException ex) {
                this.writeError(writer, ex);
                hasErrors = true;
            }
        }
        writer.println("-- lobMap.size: " + lobMap.sizeAsLong());
        writer.println("-- lobData.size: " + lobData.sizeAsLong());
        if (hasErrors) {
            writer.println("-- lobMap");
            for (Long k : lobMap.keyList()) {
                Object[] value = (Object[])lobMap.get(k);
                byte[] streamStoreId = (byte[])value[0];
                writer.println("--     " + k + " " + StreamStore.toString(streamStoreId));
            }
            writer.println("-- lobData");
            for (Long k : lobData.keyList()) {
                writer.println("--     " + k + " len " + lobData.get(k).length);
            }
        }
    }

    private static String getPageType(int type) {
        switch (type) {
            case 0: {
                return "free";
            }
            case 1: {
                return "data leaf";
            }
            case 2: {
                return "data node";
            }
            case 3: {
                return "data overflow";
            }
            case 4: {
                return "btree leaf";
            }
            case 5: {
                return "btree node";
            }
            case 6: {
                return "free list";
            }
            case 7: {
                return "stream trunk";
            }
            case 8: {
                return "stream data";
            }
        }
        return "[" + type + "]";
    }

    private void dumpPageStore(PrintWriter writer, long pageCount) {
        Data s2 = Data.create((DataHandler)this, this.pageSize, false);
        for (long page = 3L; page < pageCount; ++page) {
            s2 = Data.create((DataHandler)this, this.pageSize, false);
            this.seek(page);
            this.store.readFully(s2.getBytes(), 0, this.pageSize);
            this.dumpPage(writer, s2, page, pageCount);
        }
    }

    private void dumpPage(PrintWriter writer, Data s2, long page, long pageCount) {
        try {
            int type = s2.readByte();
            switch (type) {
                case 0: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    return;
                }
            }
            boolean last = (type & 0x10) != 0;
            type &= 0xFFFFFFEF;
            if (!PageStore.checksumTest(s2.getBytes(), (int)page, this.pageSize)) {
                this.writeDataError(writer, "checksum mismatch type: " + type, s2.getBytes());
            }
            s2.readShortInt();
            switch (type) {
                case 1: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    int parentPageId = s2.readInt();
                    this.setStorage(s2.readVarInt());
                    int columnCount = s2.readVarInt();
                    short entries = s2.readShortInt();
                    writer.println("-- page " + page + ": data leaf " + (last ? "(last) " : "") + "parent: " + parentPageId + " table: " + this.storageId + " entries: " + entries + " columns: " + columnCount);
                    this.dumpPageDataLeaf(writer, s2, last, page, columnCount, entries);
                    break;
                }
                case 2: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    int parentPageId = s2.readInt();
                    this.setStorage(s2.readVarInt());
                    int rowCount = s2.readInt();
                    short entries = s2.readShortInt();
                    writer.println("-- page " + page + ": data node " + (last ? "(last) " : "") + "parent: " + parentPageId + " table: " + this.storageId + " entries: " + entries + " rowCount: " + rowCount);
                    this.dumpPageDataNode(writer, s2, page, entries);
                    break;
                }
                case 3: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    writer.println("-- page " + page + ": data overflow " + (last ? "(last) " : ""));
                    break;
                }
                case 4: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    int parentPageId = s2.readInt();
                    this.setStorage(s2.readVarInt());
                    short entries = s2.readShortInt();
                    writer.println("-- page " + page + ": b-tree leaf " + (last ? "(last) " : "") + "parent: " + parentPageId + " index: " + this.storageId + " entries: " + entries);
                    if (this.trace) {
                        this.dumpPageBtreeLeaf(writer, s2, entries, !last);
                    }
                    break;
                }
                case 5: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    int parentPageId = s2.readInt();
                    this.setStorage(s2.readVarInt());
                    writer.println("-- page " + page + ": b-tree node " + (last ? "(last) " : "") + "parent: " + parentPageId + " index: " + this.storageId);
                    this.dumpPageBtreeNode(writer, s2, page, !last);
                    break;
                }
                case 6: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    writer.println("-- page " + page + ": free list " + (last ? "(last)" : ""));
                    this.stat.free += this.dumpPageFreeList(writer, s2, page, pageCount);
                    break;
                }
                case 7: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    writer.println("-- page " + page + ": log trunk");
                    break;
                }
                case 8: {
                    int n = type;
                    this.stat.pageTypeCount[n] = this.stat.pageTypeCount[n] + 1;
                    writer.println("-- page " + page + ": log data");
                    break;
                }
                default: {
                    writer.println("-- ERROR page " + page + " unknown type " + type);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.writeError(writer, e);
        }
    }

    private void dumpPageLogStream(PrintWriter writer, int logKey, int logFirstTrunkPage, int logFirstDataPage, long pageCount) throws IOException {
        byte x;
        Data s2 = Data.create((DataHandler)this, this.pageSize, false);
        DataReader in = new DataReader(new PageInputStream(writer, this, this.store, logKey, logFirstTrunkPage, logFirstDataPage, this.pageSize));
        writer.println("---- Transaction log ----");
        CompressLZF compress = new CompressLZF();
        while ((x = in.readByte()) >= 0) {
            int sessionId;
            if (x == 0) continue;
            if (x == 1) {
                int pageId = in.readVarInt();
                int size = in.readVarInt();
                byte[] data = new byte[this.pageSize];
                if (size == 0) {
                    in.readFully(data, this.pageSize);
                } else if (size != 1) {
                    byte[] compressBuffer = new byte[size];
                    in.readFully(compressBuffer, size);
                    try {
                        compress.expand(compressBuffer, 0, size, data, 0, this.pageSize);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw DbException.convertToIOException(e);
                    }
                }
                String typeName = "";
                int type = data[0];
                boolean last = (type & 0x10) != 0;
                switch (type &= 0xFFFFFFEF) {
                    case 0: {
                        typeName = "empty";
                        break;
                    }
                    case 1: {
                        typeName = "data leaf " + (last ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        typeName = "data node " + (last ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        typeName = "data overflow " + (last ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        typeName = "b-tree leaf " + (last ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        typeName = "b-tree node " + (last ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        typeName = "free list " + (last ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        typeName = "log trunk";
                        break;
                    }
                    case 8: {
                        typeName = "log data";
                        break;
                    }
                    default: {
                        typeName = "ERROR: unknown type " + type;
                    }
                }
                writer.println("-- undo page " + pageId + " " + typeName);
                if (!this.trace) continue;
                Data d = Data.create(null, data, false);
                this.dumpPage(writer, d, pageId, pageCount);
                continue;
            }
            if (x == 5) {
                sessionId = in.readVarInt();
                this.setStorage(in.readVarInt());
                Row row = PageLog.readRow(RowFactory.DEFAULT, in, s2);
                writer.println("-- session " + sessionId + " table " + this.storageId + " + " + row.toString());
                if (!this.transactionLog) continue;
                if (this.storageId == 0 && row.getColumnCount() >= 4) {
                    int tableId = (int)row.getKey();
                    String sql = row.getValue(3).getString();
                    String name = Recover.extractTableOrViewName(sql);
                    if (row.getValue(2).getInt() == 0) {
                        this.tableMap.put(tableId, name);
                    }
                    writer.println(sql + ";");
                    continue;
                }
                String tableName = this.tableMap.get(this.storageId);
                if (tableName == null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("INSERT INTO ").append(tableName).append(" VALUES(");
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    row.getValue(i).getSQL(builder);
                }
                builder.append(");");
                writer.println(builder.toString());
                continue;
            }
            if (x == 6) {
                sessionId = in.readVarInt();
                this.setStorage(in.readVarInt());
                long key = in.readVarLong();
                writer.println("-- session " + sessionId + " table " + this.storageId + " - " + key);
                if (!this.transactionLog) continue;
                if (this.storageId == 0) {
                    int tableId = (int)key;
                    String tableName = this.tableMap.get(tableId);
                    if (tableName == null) continue;
                    writer.println("DROP TABLE IF EXISTS " + tableName + ";");
                    continue;
                }
                String tableName = this.tableMap.get(this.storageId);
                if (tableName == null) continue;
                String sql = "DELETE FROM " + tableName + " WHERE _ROWID_ = " + key + ";";
                writer.println(sql);
                continue;
            }
            if (x == 7) {
                sessionId = in.readVarInt();
                this.setStorage(in.readVarInt());
                writer.println("-- session " + sessionId + " table " + this.storageId + " truncate");
                if (!this.transactionLog) continue;
                writer.println("TRUNCATE TABLE " + this.storageId);
                continue;
            }
            if (x == 2) {
                sessionId = in.readVarInt();
                writer.println("-- commit " + sessionId);
                continue;
            }
            if (x == 4) {
                sessionId = in.readVarInt();
                writer.println("-- rollback " + sessionId);
                continue;
            }
            if (x == 3) {
                sessionId = in.readVarInt();
                String transaction = in.readString();
                writer.println("-- prepare commit " + sessionId + " " + transaction);
                continue;
            }
            if (x == 0) continue;
            if (x == 8) {
                writer.println("-- checkpoint");
                continue;
            }
            if (x == 9) {
                int size = in.readVarInt();
                StringBuilder buff = new StringBuilder("-- free");
                for (int i = 0; i < size; ++i) {
                    buff.append(' ').append(in.readVarInt());
                }
                writer.println(buff);
                continue;
            }
            writer.println("-- ERROR: unknown operation " + x);
            break;
        }
    }

    private String setStorage(int storageId) {
        this.storageId = storageId;
        this.storageName = "O_" + Integer.toString(storageId).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter writer, Data s2, long pageId, boolean positionOnly) {
        int off;
        int i;
        int rowCount = s2.readInt();
        int entryCount = s2.readShortInt();
        int[] children = new int[entryCount + 1];
        int[] offsets = new int[entryCount];
        children[entryCount] = s2.readInt();
        this.checkParent(writer, pageId, children, entryCount);
        int empty = Integer.MAX_VALUE;
        for (i = 0; i < entryCount; ++i) {
            children[i] = s2.readInt();
            this.checkParent(writer, pageId, children, i);
            off = s2.readShortInt();
            empty = Math.min(off, empty);
            offsets[i] = off;
        }
        empty -= s2.length();
        if (!this.trace) {
            return;
        }
        writer.println("--   empty: " + empty);
        for (i = 0; i < entryCount; ++i) {
            Value data;
            off = offsets[i];
            s2.setPos(off);
            long key = s2.readVarLong();
            if (positionOnly) {
                data = ValueLong.get(key);
            } else {
                try {
                    data = (Value)s2.readValue();
                }
                catch (Throwable e) {
                    this.writeDataError(writer, "exception " + e, s2.getBytes());
                    continue;
                }
            }
            writer.println("-- [" + i + "] child: " + children[i] + " key: " + key + " data: " + data);
        }
        writer.println("-- [" + entryCount + "] child: " + children[entryCount] + " rowCount: " + rowCount);
    }

    private int dumpPageFreeList(PrintWriter writer, Data s2, long pageId, long pageCount) {
        int pagesAddressed = PageFreeList.getPagesAddressed(this.pageSize);
        int len = pagesAddressed >> 3;
        byte[] b = new byte[len];
        s2.read(b, 0, len);
        BitSet used = BitSet.valueOf(b);
        int free = 0;
        long i = 0L;
        for (long j = pageId; i < (long)pagesAddressed && j < pageCount; ++i, ++j) {
            if (i == 0L || j % 100L == 0L) {
                if (i > 0L) {
                    writer.println();
                }
                writer.print("-- " + j + " ");
            } else if (j % 20L == 0L) {
                writer.print(" - ");
            } else if (j % 10L == 0L) {
                writer.print(' ');
            }
            writer.print(used.get((int)i) ? (char)'1' : '0');
            if (used.get((int)i)) continue;
            ++free;
        }
        writer.println();
        return free;
    }

    private void dumpPageBtreeLeaf(PrintWriter writer, Data s2, int entryCount, boolean positionOnly) {
        int off;
        int i;
        int[] offsets = new int[entryCount];
        int empty = Integer.MAX_VALUE;
        for (i = 0; i < entryCount; ++i) {
            off = s2.readShortInt();
            empty = Math.min(off, empty);
            offsets[i] = off;
        }
        writer.println("--   empty: " + (empty -= s2.length()));
        for (i = 0; i < entryCount; ++i) {
            Value data;
            off = offsets[i];
            s2.setPos(off);
            long key = s2.readVarLong();
            if (positionOnly) {
                data = ValueLong.get(key);
            } else {
                try {
                    data = (Value)s2.readValue();
                }
                catch (Throwable e) {
                    this.writeDataError(writer, "exception " + e, s2.getBytes());
                    continue;
                }
            }
            writer.println("-- [" + i + "] key: " + key + " data: " + data);
        }
    }

    private void checkParent(PrintWriter writer, long pageId, int[] children, int index) {
        int child = children[index];
        if (child < 0 || child >= this.parents.length) {
            writer.println("-- ERROR [" + pageId + "] child[" + index + "]: " + child + " >= page count: " + this.parents.length);
        } else if ((long)this.parents[child] != pageId) {
            writer.println("-- ERROR [" + pageId + "] child[" + index + "]: " + child + " parent: " + this.parents[child]);
        }
    }

    private void dumpPageDataNode(PrintWriter writer, Data s2, long pageId, int entryCount) {
        int i;
        int[] children = new int[entryCount + 1];
        long[] keys = new long[entryCount];
        children[entryCount] = s2.readInt();
        this.checkParent(writer, pageId, children, entryCount);
        for (i = 0; i < entryCount; ++i) {
            children[i] = s2.readInt();
            this.checkParent(writer, pageId, children, i);
            keys[i] = s2.readVarLong();
        }
        if (!this.trace) {
            return;
        }
        for (i = 0; i < entryCount; ++i) {
            writer.println("-- [" + i + "] child: " + children[i] + " key: " + keys[i]);
        }
        writer.println("-- [" + entryCount + "] child: " + children[entryCount]);
    }

    private void dumpPageDataLeaf(PrintWriter writer, Data s2, boolean last, long pageId, int columnCount, int entryCount) {
        int i;
        int[] offsets;
        long[] keys;
        block12: {
            keys = new long[entryCount];
            offsets = new int[entryCount];
            long next = 0L;
            if (!last) {
                next = s2.readInt();
                writer.println("--   next: " + next);
            }
            int empty = this.pageSize;
            for (i = 0; i < entryCount; ++i) {
                keys[i] = s2.readVarLong();
                short off = s2.readShortInt();
                empty = Math.min(off, empty);
                offsets[i] = off;
            }
            this.stat.pageDataRows += (long)(this.pageSize - empty);
            this.stat.pageDataHead += (long)s2.length();
            this.stat.pageDataEmpty += (long)(empty -= s2.length());
            if (this.trace) {
                writer.println("--   empty: " + empty);
            }
            if (!last) {
                byte type;
                Data s22 = Data.create((DataHandler)this, this.pageSize, false);
                s2.setPos(this.pageSize);
                long parent = pageId;
                while (true) {
                    int size;
                    this.checkParent(writer, parent, new int[]{(int)next}, 0);
                    parent = next;
                    this.seek(next);
                    this.store.readFully(s22.getBytes(), 0, this.pageSize);
                    s22.reset();
                    type = s22.readByte();
                    s22.readShortInt();
                    s22.readInt();
                    if (type == 19) {
                        size = s22.readShortInt();
                        writer.println("-- chain: " + next + " type: " + type + " size: " + size);
                        s2.checkCapacity(size);
                        s2.write(s22.getBytes(), s22.length(), size);
                        break block12;
                    }
                    if (type != 3) break;
                    next = s22.readInt();
                    if (next == 0L) {
                        this.writeDataError(writer, "next:0", s22.getBytes());
                        break block12;
                    }
                    size = this.pageSize - s22.length();
                    writer.println("-- chain: " + next + " type: " + type + " size: " + size + " next: " + next);
                    s2.checkCapacity(size);
                    s2.write(s22.getBytes(), s22.length(), size);
                }
                this.writeDataError(writer, "type: " + type, s22.getBytes());
            }
        }
        for (i = 0; i < entryCount; ++i) {
            int saltIndex;
            String sql;
            long key = keys[i];
            int off = offsets[i];
            if (this.trace) {
                writer.println("-- [" + i + "] storage: " + this.storageId + " key: " + key + " off: " + off);
            }
            s2.setPos(off);
            Value[] data = this.createRecord(writer, s2, columnCount);
            if (data == null) continue;
            this.createTemporaryTable(writer);
            this.writeRow(writer, s2, data);
            if (!this.remove || this.storageId != 0 || !(sql = data[3].getString()).startsWith("CREATE USER ") || (saltIndex = Utils.indexOf(s2.getBytes(), "SALT ".getBytes(), off)) < 0) continue;
            String userName = sql.substring("CREATE USER ".length(), sql.indexOf("SALT ") - 1);
            if (userName.startsWith("IF NOT EXISTS ")) {
                userName = userName.substring("IF NOT EXISTS ".length());
            }
            if (userName.startsWith("\"")) {
                userName = userName.substring(1, userName.length() - 1);
            }
            byte[] userPasswordHash = SHA256.getKeyPasswordHash(userName, "".toCharArray());
            byte[] salt = MathUtils.secureRandomBytes(8);
            byte[] passwordHash = SHA256.getHashWithSalt(userPasswordHash, salt);
            StringBuilder buff = new StringBuilder().append("SALT '");
            StringUtils.convertBytesToHex(buff, salt).append("' HASH '");
            StringUtils.convertBytesToHex(buff, passwordHash).append('\'');
            byte[] replacement = buff.toString().getBytes();
            System.arraycopy(replacement, 0, s2.getBytes(), saltIndex, replacement.length);
            this.seek(pageId);
            this.store.write(s2.getBytes(), 0, this.pageSize);
            if (this.trace) {
                this.out.println("User: " + userName);
            }
            this.remove = false;
        }
    }

    private void seek(long page) {
        this.store.seek(page * (long)this.pageSize);
    }

    private Value[] createRecord(PrintWriter writer, Data s2, int columnCount) {
        Value[] data;
        this.recordLength = columnCount;
        if (columnCount <= 0) {
            this.writeDataError(writer, "columnCount<0", s2.getBytes());
            return null;
        }
        try {
            data = new Value[columnCount];
        }
        catch (OutOfMemoryError e) {
            this.writeDataError(writer, "out of memory", s2.getBytes());
            return null;
        }
        return data;
    }

    private void writeRow(PrintWriter writer, Data s2, Value[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.storageName).append(" VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                Value v;
                data[this.valueId] = v = (Value)s2.readValue();
                if (this.valueId > 0) {
                    sb.append(", ");
                }
                String columnName = this.storageName + "." + this.valueId;
                this.getSQL(sb, columnName, v);
            }
            catch (Exception e) {
                this.writeDataError(writer, "exception " + e, s2.getBytes());
            }
            catch (OutOfMemoryError e) {
                this.writeDataError(writer, "out of memory", s2.getBytes());
            }
            ++this.valueId;
        }
        sb.append(");");
        writer.println(sb.toString());
        if (this.storageId == 0) {
            try {
                SimpleRow r = new SimpleRow(data);
                MetaRecord meta = new MetaRecord(r);
                this.schema.add(meta);
                if (meta.getObjectType() == 0) {
                    String sql = data[3].getString();
                    String name = Recover.extractTableOrViewName(sql);
                    this.tableMap.put(meta.getId(), name);
                }
            }
            catch (Throwable t2) {
                this.writeError(writer, t2);
            }
        }
    }

    private void resetSchema() {
        this.schema = new ArrayList();
        this.objectIdSet = new HashSet();
        this.tableMap = new HashMap();
        this.columnTypeMap = new HashMap();
    }

    private void writeSchemaSET(PrintWriter writer) {
        writer.println("---- Schema SET ----");
        for (MetaRecord m4 : this.schema) {
            if (m4.getObjectType() != 6) continue;
            String sql = m4.getSQL();
            writer.println(sql + ";");
        }
    }

    private void writeSchema(PrintWriter writer) {
        String name;
        Integer objectId;
        writer.println("---- Schema ----");
        Collections.sort(this.schema);
        for (MetaRecord m4 : this.schema) {
            if (m4.getObjectType() == 6 || Recover.isSchemaObjectTypeDelayed(m4)) continue;
            String sql = m4.getSQL();
            writer.println(sql + ";");
        }
        boolean deleteLobs = false;
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            objectId = entry.getKey();
            name = entry.getValue();
            if (!this.objectIdSet.contains(objectId) || !Recover.isLobTable(name)) continue;
            this.setStorage(objectId);
            writer.println("DELETE FROM " + name + ";");
            writer.println("INSERT INTO " + name + " SELECT * FROM " + this.storageName + ";");
            if (!name.equals("INFORMATION_SCHEMA.LOBS") && !name.equalsIgnoreCase("\"INFORMATION_SCHEMA\".\"LOBS\"")) continue;
            writer.println("UPDATE " + name + " SET `TABLE` = " + -2 + ";");
            deleteLobs = true;
        }
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            objectId = entry.getKey();
            name = entry.getValue();
            if (!this.objectIdSet.contains(objectId)) continue;
            this.setStorage(objectId);
            if (Recover.isLobTable(name)) continue;
            writer.println("INSERT INTO " + name + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer objectId2 : this.objectIdSet) {
            this.setStorage(objectId2);
            writer.println("DROP TABLE " + this.storageName + ";");
        }
        writer.println("DROP ALIAS READ_BLOB;");
        writer.println("DROP ALIAS READ_CLOB;");
        writer.println("DROP ALIAS READ_BLOB_DB;");
        writer.println("DROP ALIAS READ_CLOB_DB;");
        if (deleteLobs) {
            writer.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE `TABLE` = -2;");
        }
        for (MetaRecord m5 : this.schema) {
            if (!Recover.isSchemaObjectTypeDelayed(m5)) continue;
            String sql = m5.getSQL();
            writer.println(sql + ";");
        }
    }

    private static boolean isLobTable(String name) {
        return name.startsWith("INFORMATION_SCHEMA.LOB") || name.startsWith("\"INFORMATION_SCHEMA\".\"LOB") || name.startsWith("\"information_schema\".\"lob");
    }

    private static boolean isSchemaObjectTypeDelayed(MetaRecord m4) {
        switch (m4.getObjectType()) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void createTemporaryTable(PrintWriter writer) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            writer.write("CREATE TABLE ");
            writer.write(this.storageName);
            writer.write(40);
            for (int i = 0; i < this.recordLength; ++i) {
                if (i > 0) {
                    writer.print(", ");
                }
                writer.write(67);
                writer.print(i);
                writer.write(32);
                String columnType = this.columnTypeMap.get(this.storageName + "." + i);
                writer.write(columnType == null ? "VARCHAR" : columnType);
            }
            writer.println(");");
            writer.flush();
        }
    }

    private static String extractTableOrViewName(String sql) {
        int indexTable = sql.indexOf(" TABLE ");
        int indexView = sql.indexOf(" VIEW ");
        if (indexTable > 0 && indexView > 0) {
            if (indexTable < indexView) {
                indexView = -1;
            } else {
                indexTable = -1;
            }
        }
        if (indexView > 0) {
            sql = sql.substring(indexView + " VIEW ".length());
        } else if (indexTable > 0) {
            sql = sql.substring(indexTable + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (sql.startsWith("IF NOT EXISTS ")) {
            sql = sql.substring("IF NOT EXISTS ".length());
        }
        boolean ignore = false;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\"') {
                ignore = !ignore;
                continue;
            }
            if (ignore || ch > ' ' && ch != '(') continue;
            sql = sql.substring(0, i);
            return sql;
        }
        return "UNKNOWN";
    }

    private static void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter writer, Throwable e) {
        if (writer != null) {
            writer.println("// error: " + e);
        }
        this.traceError("Error", e);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        return FileStore.open(this, name, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int type) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageBackend getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.throwInternalError();
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        return null;
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final Data page;
        private final int pageSize;
        private long trunkPage;
        private long nextTrunkPage;
        private long dataPage;
        private final IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;
        private int logKey;

        public PageInputStream(PrintWriter writer, DataHandler handler, FileStore store, int logKey, long firstTrunkPage, long firstDataPage, int pageSize) {
            this.writer = writer;
            this.store = store;
            this.pageSize = pageSize;
            this.logKey = logKey - 1;
            this.nextTrunkPage = firstTrunkPage;
            this.dataPage = firstDataPage;
            this.page = Data.create(handler, pageSize, false);
        }

        @Override
        public int read() {
            byte[] b = new byte[]{0};
            int len = this.read(b);
            return len < 0 ? -1 : b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int r;
            if (len == 0) {
                return 0;
            }
            int read = 0;
            while (len > 0 && (r = this.readBlock(b, off, len)) >= 0) {
                read += r;
                off += r;
                len -= r;
            }
            return read == 0 ? -1 : read;
        }

        private int readBlock(byte[] buff, int off, int len) {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int l = Math.min(this.remaining, len);
            this.page.read(buff, off, l);
            this.remaining -= l;
            return l;
        }

        private void fillBuffer() {
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            while (this.dataPages.size() == 0) {
                if (this.nextTrunkPage == 0L) {
                    this.endOfFile = true;
                    return;
                }
                this.trunkPage = this.nextTrunkPage;
                this.store.seek(this.trunkPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                if (!PageStore.checksumTest(this.page.getBytes(), (int)this.trunkPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + this.trunkPage);
                    this.endOfFile = true;
                    return;
                }
                byte t2 = this.page.readByte();
                this.page.readShortInt();
                if (t2 != 7) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + t2 + " expected type: " + 7);
                    this.endOfFile = true;
                    return;
                }
                this.page.readInt();
                int key = this.page.readInt();
                ++this.logKey;
                if (key != this.logKey) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + t2 + " expected key: " + this.logKey + " got: " + key);
                }
                this.nextTrunkPage = this.page.readInt();
                this.writer.println("-- log " + key + ":" + this.trunkPage + " next: " + this.nextTrunkPage);
                int pageCount = this.page.readShortInt();
                for (int i = 0; i < pageCount; ++i) {
                    int d = this.page.readInt();
                    if (this.dataPage != 0L) {
                        if ((long)d != this.dataPage) continue;
                        this.dataPage = 0L;
                    }
                    this.dataPages.add(d);
                }
            }
            if (this.dataPages.size() > 0) {
                this.page.reset();
                long nextPage = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek(nextPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                byte t3 = this.page.readByte();
                if (t3 != 0 && !PageStore.checksumTest(this.page.getBytes(), (int)nextPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + nextPage);
                    this.endOfFile = true;
                    return;
                }
                this.page.readShortInt();
                int p = this.page.readInt();
                int k = this.page.readInt();
                this.writer.println("-- log " + k + ":" + this.trunkPage + "/" + nextPage);
                if (t3 != 8) {
                    this.writer.println("-- log eof " + nextPage + " type: " + t3 + " parent: " + p + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                if (k != this.logKey) {
                    this.writer.println("-- log eof " + nextPage + " type: " + t3 + " parent: " + p + " expected key: " + this.logKey + " got: " + k);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.pageSize - this.page.length();
            }
        }
    }

    static class Stats {
        long pageDataEmpty;
        long pageDataRows;
        long pageDataHead;
        final int[] pageTypeCount = new int[10];
        int free;

        Stats() {
        }
    }
}

