/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.tools.SimpleResultSet;
import org.gridgain.internal.h2.tools.SimpleRowSource;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class Csv
implements SimpleRowSource {
    private String[] columnNames;
    private String characterSet;
    private char escapeCharacter = (char)34;
    private char fieldDelimiter = (char)34;
    private char fieldSeparatorRead = (char)44;
    private String fieldSeparatorWrite = ",";
    private boolean caseSensitiveColumnNames;
    private boolean preserveWhitespace;
    private boolean writeColumnHeader = true;
    private char lineComment;
    private String lineSeparator = SysProperties.LINE_SEPARATOR;
    private String nullString = "";
    private String fileName;
    private Reader input;
    private char[] inputBuffer;
    private int inputBufferPos;
    private int inputBufferStart = -1;
    private int inputBufferEnd;
    private Writer output;
    private boolean endOfLine;
    private boolean endOfFile;

    private int writeResultSet(ResultSet rs) throws SQLException {
        try {
            int i;
            int rows = 0;
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            String[] row = new String[columnCount];
            int[] sqlTypes = new int[columnCount];
            for (i = 0; i < columnCount; ++i) {
                row[i] = meta.getColumnLabel(i + 1);
                sqlTypes[i] = meta.getColumnType(i + 1);
            }
            if (this.writeColumnHeader) {
                this.writeRow(row);
            }
            while (rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    Object o;
                    switch (sqlTypes[i]) {
                        case 91: {
                            o = rs.getDate(i + 1);
                            break;
                        }
                        case 92: {
                            o = rs.getTime(i + 1);
                            break;
                        }
                        case 93: {
                            o = rs.getTimestamp(i + 1);
                            break;
                        }
                        default: {
                            o = rs.getString(i + 1);
                        }
                    }
                    row[i] = o == null ? null : o.toString();
                }
                this.writeRow(row);
                ++rows;
            }
            this.output.close();
            int n = rows;
            return n;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(rs);
        }
    }

    public int write(Writer writer, ResultSet rs) throws SQLException {
        this.output = writer;
        return this.writeResultSet(rs);
    }

    public int write(String outputFileName, ResultSet rs, String charset) throws SQLException {
        this.init(outputFileName, charset);
        try {
            this.initWrite();
            return this.writeResultSet(rs);
        }
        catch (IOException e) {
            throw Csv.convertException("IOException writing " + outputFileName, e);
        }
    }

    public int write(Connection conn, String outputFileName, String sql, String charset) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(sql);
        int rows = this.write(outputFileName, rs, charset);
        stat.close();
        return rows;
    }

    public ResultSet read(String inputFileName, String[] colNames, String charset) throws SQLException {
        this.init(inputFileName, charset);
        try {
            return this.readResultSet(colNames);
        }
        catch (IOException e) {
            throw Csv.convertException("IOException reading " + inputFileName, e);
        }
    }

    public ResultSet read(Reader reader, String[] colNames) throws IOException {
        this.init(null, null);
        this.input = reader;
        return this.readResultSet(colNames);
    }

    private ResultSet readResultSet(String[] colNames) throws IOException {
        this.columnNames = colNames;
        this.initRead();
        SimpleResultSet result = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (String columnName : this.columnNames) {
            result.addColumn(columnName, 12, Integer.MAX_VALUE, 0);
        }
        return result;
    }

    private void makeColumnNamesUnique() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            StringBuilder buff = new StringBuilder();
            String n = this.columnNames[i];
            if (n == null || n.isEmpty()) {
                buff.append('C').append(i + 1);
            } else {
                buff.append(n);
            }
            for (int j = 0; j < i; ++j) {
                String y = this.columnNames[j];
                if (!buff.toString().equals(y)) continue;
                buff.append('1');
                j = -1;
            }
            this.columnNames[i] = buff.toString();
        }
    }

    private void init(String newFileName, String charset) {
        this.fileName = newFileName;
        this.characterSet = charset;
    }

    private void initWrite() throws IOException {
        if (this.output == null) {
            try {
                OutputStream out = FileUtils.newOutputStream(this.fileName, false);
                out = new BufferedOutputStream(out, 4096);
                this.output = new BufferedWriter(this.characterSet != null ? new OutputStreamWriter(out, this.characterSet) : new OutputStreamWriter(out));
            }
            catch (Exception e) {
                this.close();
                throw DbException.convertToIOException(e);
            }
        }
    }

    private void writeRow(String[] values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            String s2;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.output.write(this.fieldSeparatorWrite);
            }
            if ((s2 = values[i]) != null) {
                if (this.escapeCharacter != '\u0000') {
                    if (this.fieldDelimiter != '\u0000') {
                        this.output.write(this.fieldDelimiter);
                    }
                    this.output.write(this.escape(s2));
                    if (this.fieldDelimiter == '\u0000') continue;
                    this.output.write(this.fieldDelimiter);
                    continue;
                }
                this.output.write(s2);
                continue;
            }
            if (this.nullString == null || this.nullString.length() <= 0) continue;
            this.output.write(this.nullString);
        }
        this.output.write(this.lineSeparator);
    }

    private String escape(String data) {
        if (data.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || data.indexOf(this.escapeCharacter) < 0)) {
            return data;
        }
        int length = data.length();
        StringBuilder buff = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = data.charAt(i);
            if (ch == this.fieldDelimiter || ch == this.escapeCharacter) {
                buff.append(this.escapeCharacter);
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    private void initRead() throws IOException {
        if (this.input == null) {
            try {
                InputStream in = FileUtils.newInputStream(this.fileName);
                in = new BufferedInputStream(in, 4096);
                this.input = this.characterSet != null ? new InputStreamReader(in, this.characterSet) : new InputStreamReader(in);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
        if (!this.input.markSupported()) {
            this.input = new BufferedReader(this.input);
        }
        this.input.mark(1);
        int bom = this.input.read();
        if (bom != 65279) {
            this.input.reset();
        }
        this.inputBuffer = new char[8192];
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            String v;
            if ((v = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && list.isEmpty()) continue;
                    break;
                }
                v = "COLUMN" + list.size();
                list.add(v);
                continue;
            }
            if (v.isEmpty()) {
                v = "COLUMN" + list.size();
            } else if (!this.caseSensitiveColumnNames && Csv.isSimpleColumnName(v)) {
                v = StringUtils.toUpperEnglish(v);
            }
            list.add(v);
            if (this.endOfLine) break;
        }
        this.columnNames = list.toArray(new String[0]);
    }

    private static boolean isSimpleColumnName(String columnName) {
        int length = columnName.length();
        for (int i = 0; i < length; ++i) {
            char ch = columnName.charAt(i);
            if (!(i == 0 ? ch != '_' && !Character.isLetter(ch) : ch != '_' && !Character.isLetterOrDigit(ch))) continue;
            return false;
        }
        return columnName.length() != 0;
    }

    private void pushBack() {
        --this.inputBufferPos;
    }

    private int readChar() throws IOException {
        if (this.inputBufferPos >= this.inputBufferEnd) {
            return this.readBuffer();
        }
        return this.inputBuffer[this.inputBufferPos++];
    }

    private int readBuffer() throws IOException {
        int keep;
        if (this.endOfFile) {
            return -1;
        }
        if (this.inputBufferStart >= 0) {
            keep = this.inputBufferPos - this.inputBufferStart;
            if (keep > 0) {
                char[] src = this.inputBuffer;
                if (keep + 4096 > src.length) {
                    this.inputBuffer = new char[src.length * 2];
                }
                System.arraycopy(src, this.inputBufferStart, this.inputBuffer, 0, keep);
            }
            this.inputBufferStart = 0;
        } else {
            keep = 0;
        }
        this.inputBufferPos = keep;
        int len = this.input.read(this.inputBuffer, keep, 4096);
        if (len == -1) {
            this.inputBufferEnd = -1024;
            this.endOfFile = true;
            ++this.inputBufferPos;
            return -1;
        }
        this.inputBufferEnd = keep + len;
        return this.inputBuffer[this.inputBufferPos++];
    }

    private String readValue() throws IOException {
        int ch;
        this.endOfLine = false;
        this.inputBufferStart = this.inputBufferPos;
        do {
            if ((ch = this.readChar()) == this.fieldDelimiter) {
                int sep;
                boolean containsEscape;
                block16: {
                    containsEscape = false;
                    this.inputBufferStart = this.inputBufferPos;
                    while (true) {
                        if ((ch = this.readChar()) == this.fieldDelimiter) {
                            ch = this.readChar();
                            if (ch != this.fieldDelimiter) {
                                sep = 2;
                                break block16;
                            }
                            containsEscape = true;
                            continue;
                        }
                        if (ch == this.escapeCharacter) {
                            ch = this.readChar();
                            if (ch < 0) {
                                sep = 1;
                                break block16;
                            }
                            containsEscape = true;
                            continue;
                        }
                        if (ch < 0) break;
                    }
                    sep = 1;
                }
                String s2 = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - sep);
                if (containsEscape) {
                    s2 = this.unEscape(s2);
                }
                this.inputBufferStart = -1;
                while (ch != this.fieldSeparatorRead) {
                    if (ch == 10 || ch < 0 || ch == 13) {
                        this.endOfLine = true;
                        break;
                    }
                    if (ch != 32 && ch != 9) {
                        this.pushBack();
                        break;
                    }
                    ch = this.readChar();
                }
                return s2;
            }
            if (ch == 10 || ch < 0 || ch == 13) {
                this.endOfLine = true;
                return null;
            }
            if (ch != this.fieldSeparatorRead) continue;
            return null;
        } while (ch <= 32);
        if (this.lineComment != '\u0000' && ch == this.lineComment) {
            this.inputBufferStart = -1;
            while ((ch = this.readChar()) != 10 && ch >= 0 && ch != 13) {
            }
            this.endOfLine = true;
            return null;
        }
        while ((ch = this.readChar()) != this.fieldSeparatorRead) {
            if (ch != 10 && ch >= 0 && ch != 13) continue;
            this.endOfLine = true;
            break;
        }
        String s3 = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - 1);
        if (!this.preserveWhitespace) {
            s3 = s3.trim();
        }
        this.inputBufferStart = -1;
        return this.readNull(s3);
    }

    private String readNull(String s2) {
        return s2.equals(this.nullString) ? null : s2;
    }

    private String unEscape(String s2) {
        int idx;
        StringBuilder buff = new StringBuilder(s2.length());
        int start = 0;
        char[] chars = null;
        while ((idx = s2.indexOf(this.escapeCharacter, start)) >= 0 || (idx = s2.indexOf(this.fieldDelimiter, start)) >= 0) {
            if (chars == null) {
                chars = s2.toCharArray();
            }
            buff.append(chars, start, idx - start);
            if (idx == s2.length() - 1) {
                start = s2.length();
                break;
            }
            buff.append(chars[idx + 1]);
            start = idx + 2;
        }
        buff.append(s2, start, s2.length());
        return buff.toString();
    }

    @Override
    public Object[] readRow() throws SQLException {
        if (this.input == null) {
            return null;
        }
        Object[] row = new String[this.columnNames.length];
        try {
            int i = 0;
            while (true) {
                String v;
                if ((v = this.readValue()) == null && this.endOfLine) {
                    if (i == 0) {
                        if (!this.endOfFile) continue;
                        return null;
                    }
                    break;
                }
                if (i < row.length) {
                    row[i++] = v;
                }
                if (this.endOfLine) break;
            }
        }
        catch (IOException e) {
            throw Csv.convertException("IOException reading from " + this.fileName, e);
        }
        return row;
    }

    private static SQLException convertException(String message, Exception e) {
        return DbException.getJdbcSQLException(90028, e, message);
    }

    @Override
    public void close() {
        IOUtils.closeSilently(this.input);
        this.input = null;
        IOUtils.closeSilently(this.output);
        this.output = null;
    }

    @Override
    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }

    public void setFieldSeparatorWrite(String fieldSeparatorWrite) {
        this.fieldSeparatorWrite = fieldSeparatorWrite;
    }

    public String getFieldSeparatorWrite() {
        return this.fieldSeparatorWrite;
    }

    public void setCaseSensitiveColumnNames(boolean caseSensitiveColumnNames) {
        this.caseSensitiveColumnNames = caseSensitiveColumnNames;
    }

    public boolean getCaseSensitiveColumnNames() {
        return this.caseSensitiveColumnNames;
    }

    public void setFieldSeparatorRead(char fieldSeparatorRead) {
        this.fieldSeparatorRead = fieldSeparatorRead;
    }

    public char getFieldSeparatorRead() {
        return this.fieldSeparatorRead;
    }

    public void setLineCommentCharacter(char lineCommentCharacter) {
        this.lineComment = lineCommentCharacter;
    }

    public char getLineCommentCharacter() {
        return this.lineComment;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setPreserveWhitespace(boolean value) {
        this.preserveWhitespace = value;
    }

    public boolean getPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setWriteColumnHeader(boolean value) {
        this.writeColumnHeader = value;
    }

    public boolean getWriteColumnHeader() {
        return this.writeColumnHeader;
    }

    public String setOptions(String options) {
        String[] keyValuePairs;
        String charset = null;
        for (String pair : keyValuePairs = StringUtils.arraySplit(options, ' ', false)) {
            char ch;
            if (pair.isEmpty()) continue;
            int index = pair.indexOf(61);
            String key = StringUtils.trim(pair.substring(0, index), true, true, " ");
            String value = pair.substring(index + 1);
            char c = ch = value.isEmpty() ? (char)'\u0000' : value.charAt(0);
            if (Csv.isParam(key, "escape", "esc", "escapeCharacter")) {
                this.setEscapeCharacter(ch);
                continue;
            }
            if (Csv.isParam(key, "fieldDelimiter", "fieldDelim")) {
                this.setFieldDelimiter(ch);
                continue;
            }
            if (Csv.isParam(key, "fieldSeparator", "fieldSep")) {
                this.setFieldSeparatorRead(ch);
                this.setFieldSeparatorWrite(value);
                continue;
            }
            if (Csv.isParam(key, "lineComment", "lineCommentCharacter")) {
                this.setLineCommentCharacter(ch);
                continue;
            }
            if (Csv.isParam(key, "lineSeparator", "lineSep")) {
                this.setLineSeparator(value);
                continue;
            }
            if (Csv.isParam(key, "null", "nullString")) {
                this.setNullString(value);
                continue;
            }
            if (Csv.isParam(key, "charset", "characterSet")) {
                charset = value;
                continue;
            }
            if (Csv.isParam(key, "preserveWhitespace")) {
                this.setPreserveWhitespace(Utils.parseBoolean(value, false, false));
                continue;
            }
            if (Csv.isParam(key, "writeColumnHeader")) {
                this.setWriteColumnHeader(Utils.parseBoolean(value, true, false));
                continue;
            }
            if (Csv.isParam(key, "caseSensitiveColumnNames")) {
                this.setCaseSensitiveColumnNames(Utils.parseBoolean(value, false, false));
                continue;
            }
            throw DbException.getUnsupportedException(key);
        }
        return charset;
    }

    private static boolean isParam(String key, String ... values) {
        for (String v : values) {
            if (!key.equalsIgnoreCase(v)) continue;
            return true;
        }
        return false;
    }
}

