/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.JdbcUtils;

public class TableLinkConnection {
    private final HashMap<TableLinkConnection, TableLinkConnection> map;
    private final String driver;
    private final String url;
    private final String user;
    private final String password;
    private Connection conn;
    private int useCounter;

    private TableLinkConnection(HashMap<TableLinkConnection, TableLinkConnection> map, String driver, String url, String user, String password) {
        this.map = map;
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableLinkConnection open(HashMap<TableLinkConnection, TableLinkConnection> map, String driver, String url, String user, String password, boolean shareLinkedConnections) {
        TableLinkConnection t2 = new TableLinkConnection(map, driver, url, user, password);
        if (!shareLinkedConnections) {
            t2.open();
            return t2;
        }
        HashMap<TableLinkConnection, TableLinkConnection> hashMap = map;
        synchronized (hashMap) {
            TableLinkConnection result = map.get(t2);
            if (result == null) {
                t2.open();
                map.put(t2, t2);
                result = t2;
            }
            ++result.useCounter;
            return result;
        }
    }

    private void open() {
        try {
            this.conn = JdbcUtils.getConnection(this.driver, this.url, this.user, this.password);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.driver) ^ Objects.hashCode(this.url) ^ Objects.hashCode(this.user) ^ Objects.hashCode(this.password);
    }

    public boolean equals(Object o) {
        if (o instanceof TableLinkConnection) {
            TableLinkConnection other = (TableLinkConnection)o;
            return Objects.equals(this.driver, other.driver) && Objects.equals(this.url, other.url) && Objects.equals(this.user, other.user) && Objects.equals(this.password, other.password);
        }
        return false;
    }

    Connection getConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean force) {
        boolean actuallyClose = false;
        HashMap<TableLinkConnection, TableLinkConnection> hashMap = this.map;
        synchronized (hashMap) {
            if (--this.useCounter <= 0 || force) {
                actuallyClose = true;
                this.map.remove(this);
            }
        }
        if (actuallyClose) {
            JdbcUtils.closeSilently(this.conn);
        }
    }
}

