/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.constraint.ConstraintReferential;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableBase;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.value.DataType;

public abstract class RegularTable
extends TableBase {
    protected final boolean containsLargeObject;
    protected volatile Session lockExclusiveSession;
    protected final ConcurrentHashMap<Session, Session> lockSharedSessions = new ConcurrentHashMap();
    private Column rowIdColumn;

    protected static void addRowsToIndex(Session session, ArrayList<Row> list, Index index) {
        RegularTable.sortRows(list, index);
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    protected static String getDeadlockDetails(ArrayList<Session> sessions, boolean exclusive) {
        StringBuilder builder = new StringBuilder();
        for (Session s2 : sessions) {
            Table lock = s2.getWaitForLock();
            Thread thread = s2.getWaitForLockThread();
            builder.append("\nSession ").append(s2.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(lock.toString()).append(exclusive ? " (exclusive)" : " (shared)").append(" while locking ");
            Table[] locks = s2.getLocks();
            int length = locks.length;
            for (int i = 0; i < length; ++i) {
                Table t2 = locks[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(t2.toString());
                if (!(t2 instanceof RegularTable)) continue;
                if (((RegularTable)t2).lockExclusiveSession == s2) {
                    builder.append(" (exclusive)");
                    continue;
                }
                builder.append(" (shared)");
            }
            builder.append('.');
        }
        return builder.toString();
    }

    protected static void sortRows(ArrayList<? extends SearchRow> list, final Index index) {
        Collections.sort(list, new Comparator<SearchRow>(){

            @Override
            public int compare(SearchRow r1, SearchRow r2) {
                return index.compareRows(r1, r2);
            }
        });
    }

    protected RegularTable(CreateTableData data) {
        super(data);
        this.isHidden = data.isHidden;
        boolean b = false;
        for (Column col : this.getColumns()) {
            if (!DataType.isLargeObject(col.getType().getValueType())) continue;
            b = true;
            break;
        }
        this.containsLargeObject = b;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> constraints;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (constraints = this.getConstraints()) != null) {
            for (Constraint c : constraints) {
                ConstraintReferential ref;
                if (c.getConstraintType() != Constraint.Type.REFERENTIAL || (ref = (ConstraintReferential)c).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session clash, Set<Session> visited) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Table t2;
            if (clash == null) {
                clash = session;
                visited = new HashSet<Session>();
            } else {
                if (clash == session) {
                    return new ArrayList<Session>(0);
                }
                if (visited.contains(session)) {
                    return null;
                }
            }
            visited.add(session);
            ArrayList<Session> error = null;
            for (Session s2 : this.lockSharedSessions.keySet()) {
                Table t3;
                if (s2 == session || (t3 = s2.getWaitForLock()) == null || (error = t3.checkDeadlock(s2, clash, visited)) == null) continue;
                error.add(session);
                break;
            }
            Session copyOfLockExclusiveSession = this.lockExclusiveSession;
            if (error == null && copyOfLockExclusiveSession != null && (t2 = copyOfLockExclusiveSession.getWaitForLock()) != null && (error = t2.checkDeadlock(copyOfLockExclusiveSession, clash, visited)) != null) {
                error.add(session);
            }
            return error;
        }
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
            this.rowIdColumn.setRowId(true);
        }
        return this.rowIdColumn;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusiveSession == session;
    }

    @Override
    public String toString() {
        return this.getSQL(false);
    }
}

