/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.RangeIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;

public class RangeTable
extends Table {
    public static final String NAME = "SYSTEM_RANGE";
    public static final String ALIAS = "GENERATE_SERIES";
    private Expression min;
    private Expression max;
    private Expression step;
    private boolean optimized;

    public RangeTable(Schema schema, Expression min2, Expression max, boolean noColumns) {
        super(schema, 0, NAME, true, true);
        Column[] columnArray;
        if (noColumns) {
            columnArray = new Column[]{};
        } else {
            Column[] columnArray2 = new Column[1];
            columnArray = columnArray2;
            columnArray2[0] = new Column("X", 5);
        }
        Column[] cols = columnArray;
        this.min = min2;
        this.max = max;
        this.setColumns(cols);
    }

    public RangeTable(Schema schema, Expression min2, Expression max, Expression step, boolean noColumns) {
        this(schema, min2, max, noColumns);
        this.step = step;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append(NAME).append('(');
        this.min.getSQL(builder, alwaysQuote).append(", ");
        this.max.getSQL(builder, alwaysQuote);
        if (this.step != null) {
            builder.append(", ");
            this.step.getSQL(builder, alwaysQuote);
        }
        return builder.append(')');
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        long step = this.getStep(session);
        if (step == 0L) {
            throw DbException.get(90142);
        }
        long delta = this.getMax(session) - this.getMin(session);
        if (step > 0L ? delta < 0L : delta > 0L) {
            return 0L;
        }
        return delta / step + 1L;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        if (this.getStep(session) == 0L) {
            throw DbException.get(90142);
        }
        return new RangeIndex(this, IndexColumn.wrap(this.columns));
    }

    public long getMin(Session session) {
        this.optimize(session);
        return this.min.getValue(session).getLong();
    }

    public long getMax(Session session) {
        this.optimize(session);
        return this.max.getValue(session).getLong();
    }

    public long getStep(Session session) {
        this.optimize(session);
        if (this.step == null) {
            return 1L;
        }
        return this.step.getValue(session).getLong();
    }

    private void optimize(Session s2) {
        if (!this.optimized) {
            this.min = this.min.optimize(s2);
            this.max = this.max.optimize(s2);
            if (this.step != null) {
                this.step = this.step.optimize(s2);
            }
            this.optimized = true;
        }
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

