/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.constraint.ConstraintActionType;
import org.gridgain.internal.h2.constraint.ConstraintCheck;
import org.gridgain.internal.h2.constraint.ConstraintReferential;
import org.gridgain.internal.h2.constraint.ConstraintUnique;
import org.gridgain.internal.h2.engine.Constants;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.FunctionAlias;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.QueryStatisticsData;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.engine.UserAggregate;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.MetaIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.schema.Constant;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.store.InDoubtTransaction;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableSynonym;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.tools.Csv;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int META_TABLE_TYPE_COUNT = 33;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int id, int type) {
        super(schema, id, null, true, true);
        Column[] cols;
        this.type = type;
        String indexColumnName = null;
        switch (type) {
            case 0: {
                this.setMetaTableName("TABLES");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "DATETIME_PRECISION INT", "INTERVAL_TYPE", "INTERVAL_PRECISION INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE", "IS_VISIBLE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS", "AFFINITY BIT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                cols = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                cols = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                cols = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                cols = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                cols = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                cols = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                cols = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                cols = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                cols = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                cols = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                cols = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                cols = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                cols = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                cols = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                cols = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                cols = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                cols = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                indexColumnName = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setMetaTableName("CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                cols = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                cols = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                cols = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                cols = this.createColumns("ID INT", "USER_NAME", "SESSION_START TIMESTAMP WITH TIME ZONE", "STATEMENT", "STATEMENT_START TIMESTAMP WITH TIME ZONE", "CONTAINS_UNCOMMITTED BIT", "STATE", "BLOCKER_ID INT");
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                cols = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                cols = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                cols = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                cols = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                indexColumnName = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "POSITION_IN_UNIQUE_CONSTRAINT INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        if (indexColumnName == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(indexColumnName)).getColumnId();
            IndexColumn[] indexCols = IndexColumn.wrap(new Column[]{cols[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexCols, false);
        }
    }

    private void setMetaTableName(String upperName) {
        this.setObjectName(this.database.sysIdentifier(upperName));
    }

    private Column[] createColumns(String ... names) {
        Column[] cols = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name;
            int dataType;
            String nameType = names[i];
            int idx = nameType.indexOf(32);
            if (idx < 0) {
                dataType = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                name = nameType;
            } else {
                dataType = DataType.getTypeByName((String)nameType.substring((int)(idx + 1)), (Mode)this.database.getMode()).type;
                name = nameType.substring(0, idx);
            }
            cols[i] = new Column(this.database.sysIdentifier(name), dataType);
        }
        return cols;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String s2) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            s2 = s2 == null ? null : StringUtils.toLowerEnglish(s2);
        }
        return s2;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> tables = this.database.getAllTablesAndViews(true);
        ArrayList<Table> tempTables = session.getLocalTempTables();
        tables.addAll(tempTables);
        return tables;
    }

    private ArrayList<Table> getTablesByName(Session session, String tableName) {
        ArrayList<Table> tables = this.database.getTableOrViewByName(tableName);
        for (Table temp : session.getLocalTempTables()) {
            if (!temp.getName().equals(tableName)) continue;
            tables.add(temp);
        }
        return tables;
    }

    private boolean checkIndex(Session session, String value, Value indexFrom, Value indexTo) {
        if (value == null || indexFrom == null && indexTo == null) {
            return true;
        }
        Database db = session.getDatabase();
        Value v = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(value) : ValueString.get(value);
        if (indexFrom != null && db.compare(v, indexFrom) < 0) {
            return false;
        }
        return indexTo == null || db.compare(v, indexTo) <= 0;
    }

    private static String replaceNullWithEmpty(String s2) {
        return s2 == null ? "" : s2;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ArrayList<Row> generateRows(Session session, SearchRow first, SearchRow last) {
        indexFrom = null;
        indexTo = null;
        if (this.indexColumn >= 0) {
            if (first != null) {
                indexFrom = first.getValue(this.indexColumn);
            }
            if (last != null) {
                indexTo = last.getValue(this.indexColumn);
            }
        }
        rows = Utils.newSmallArrayList();
        catalog = this.database.getShortName();
        admin = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    storageType = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() != false ? "CACHED" : "MEMORY");
                    sql = table.getCreateSQL();
                    if (!admin && sql != null && sql.contains("--hide--")) {
                        sql = "-";
                    }
                    this.add(rows, new Object[]{catalog, table.getSchema().getName(), tableName, table.getTableType().toString(), storageType, sql, MetaTable.replaceNullWithEmpty(table.getComment()), ValueLong.get(table.getMaxDataModificationId()), ValueInt.get(table.getId()), null, table.getClass().getName(), ValueLong.get(table.getRowCountApproximation(session))});
                }
                break;
            }
            case 1: {
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    tableName = indexFrom.getString();
                    if (tableName == null) break;
                    tablesToList = this.getTablesByName(session, tableName);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    cols = table.getColumns();
                    collation = this.database.getCompareMode().getName();
                    for (j = 0; j < cols.length; ++j) {
                        c = cols[j];
                        domain = c.getDomain();
                        dataType = c.getDataType();
                        precision = ValueInt.get(c.getPrecisionAsInt());
                        scale = ValueInt.get(c.getType().getScale());
                        sequence = c.getSequence();
                        type = dataType.type;
                        switch (type) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 24: 
                            case 31: 
                            case 35: 
                            case 37: 
                            case 38: {
                                hasDateTimePrecision = true;
                                break;
                            }
                            default: {
                                hasDateTimePrecision = false;
                            }
                        }
                        isInterval = DataType.isIntervalType(type);
                        createSQLWithoutName = c.getCreateSQLWithoutName();
                        this.add(rows, new Object[]{catalog, table.getSchema().getName(), tableName, c.getName(), ValueInt.get(j + 1), domain != null ? catalog : null, domain != null ? this.database.getMainSchema().getName() : null, domain != null ? domain.getName() : null, c.getDefaultSQL(), c.isNullable() != false ? "YES" : "NO", ValueInt.get(dataType.sqlType), precision, precision, precision, ValueInt.get(10), scale, hasDateTimePrecision != false ? scale : null, isInterval != false ? createSQLWithoutName.substring(9) : null, isInterval != false ? precision : null, "Unicode", collation, this.identifier(isInterval != false ? "INTERVAL" : dataType.name), ValueInt.get(c.isNullable() != false ? 1 : 0), ValueBoolean.get(c.getComputed()), ValueInt.get(c.getSelectivity()), c.getCheckConstraintSQL(session, c.getName()), sequence == null ? null : sequence.getName(), MetaTable.replaceNullWithEmpty(c.getComment()), null, createSQLWithoutName, c.getOnUpdateSQL(), ValueBoolean.get(c.getVisible())});
                    }
                }
                break;
            }
            case 2: {
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    tableName = indexFrom.getString();
                    if (tableName == null) break;
                    tablesToList = this.getTablesByName(session, tableName);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    indexes = table.getIndexes();
                    constraints = table.getConstraints();
                    for (j = 0; indexes != null && j < indexes.size(); ++j) {
                        index = indexes.get(j);
                        if (index.getCreateSQL() == null) continue;
                        constraintName = null;
                        for (k = 0; constraints != null && k < constraints.size(); ++k) {
                            constraint = constraints.get(k);
                            if (!constraint.usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                constraintName = constraint.getName();
                                continue;
                            }
                            constraintName = constraint.getName();
                        }
                        cols = index.getIndexColumns();
                        indexClass = index.getClass().getName();
                        for (k = 0; k < cols.length; ++k) {
                            idxCol = cols[k];
                            column = idxCol.column;
                            this.add(rows, new Object[]{catalog, table.getSchema().getName(), tableName, ValueBoolean.get(index.getIndexType().isUnique() == false), index.getName(), ValueShort.get((short)(k + 1)), column.getName(), ValueInt.get(0), ValueBoolean.get(index.getIndexType().isPrimaryKey()), index.getIndexType().getSQL(), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), ValueShort.get((short)3), (idxCol.sortType & 1) != 0 ? "D" : "A", ValueInt.get(0), "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), ValueInt.get(index.getId()), ValueInt.get(idxCol.sortType), constraintName, indexClass, ValueBoolean.get(index.getIndexType().isAffinity())});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(rows, new Object[]{TableType.TABLE.toString()});
                this.add(rows, new Object[]{TableType.TABLE_LINK.toString()});
                this.add(rows, new Object[]{TableType.SYSTEM_TABLE.toString()});
                this.add(rows, new Object[]{TableType.VIEW.toString()});
                this.add(rows, new Object[]{TableType.EXTERNAL_TABLE_ENGINE.toString()});
                break;
            }
            case 4: {
                for (DataType t : DataType.getTypes()) {
                    if (t.hidden || t.sqlType == 0) continue;
                    this.add(rows, new Object[]{t.name, ValueInt.get(t.sqlType), ValueInt.get(MathUtils.convertLongToInt(t.maxPrecision)), t.prefix, t.suffix, t.params, ValueBoolean.get(t.autoIncrement), ValueShort.get((short)t.minScale), ValueShort.get((short)t.maxScale), t.decimal != false ? ValueInt.get(10) : null, ValueInt.get(t.sqlTypePos), ValueBoolean.get(t.caseSensitive), ValueShort.get((short)1), ValueShort.get((short)3)});
                }
                break;
            }
            case 5: {
                this.add(rows, new Object[]{catalog});
                break;
            }
            case 6: {
                for (String[] s : this.database.getAllSettings()) {
                    value = s.getStringValue();
                    if (value == null) {
                        value = Integer.toString(s.getIntValue());
                    }
                    this.add(rows, new Object[]{this.identifier(s.getName()), value});
                }
                this.add(rows, new Object[]{"info.BUILD_ID", "199"});
                this.add(rows, new Object[]{"info.VERSION_MAJOR", "1"});
                this.add(rows, new Object[]{"info.VERSION_MINOR", "4"});
                this.add(rows, new Object[]{"info.VERSION", Constants.getFullVersion()});
                if (admin) {
                    for (String s : settings = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"}) {
                        this.add(rows, new Object[]{"property." + s, Utils.getProperty(s, "")});
                    }
                }
                this.add(rows, new Object[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(rows, new Object[]{"MODE", this.database.getMode().getName()});
                this.add(rows, new Object[]{"MULTI_THREADED", this.database.isMultiThreaded() != false ? "1" : "0"});
                this.add(rows, new Object[]{"QUERY_TIMEOUT", Integer.toString(session.getQueryTimeout())});
                this.add(rows, new Object[]{"RETENTION_TIME", Integer.toString(this.database.getRetentionTime())});
                this.add(rows, new Object[]{"LOG", Integer.toString(this.database.getLogMode())});
                s = this.database.getSettings().getSettings();
                settingNames = new ArrayList<String>(s.size());
                settingNames.addAll(s.keySet());
                Collections.sort(settingNames);
                for (String k : settingNames) {
                    this.add(rows, new Object[]{k, s.get(k)});
                }
                if (!this.database.isPersistent()) break;
                pageStore = this.database.getPageStore();
                if (pageStore != null) {
                    this.add(rows, new Object[]{"info.FILE_WRITE_TOTAL", Long.toString(pageStore.getWriteCountTotal())});
                    this.add(rows, new Object[]{"info.FILE_WRITE", Long.toString(pageStore.getWriteCount())});
                    this.add(rows, new Object[]{"info.FILE_READ", Long.toString(pageStore.getReadCount())});
                    this.add(rows, new Object[]{"info.PAGE_COUNT", Integer.toString(pageStore.getPageCount())});
                    this.add(rows, new Object[]{"info.PAGE_SIZE", Integer.toString(pageStore.getPageSize())});
                    this.add(rows, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(pageStore.getCache().getMaxMemory())});
                    this.add(rows, new Object[]{"info.CACHE_SIZE", Integer.toString(pageStore.getCache().getMemory())});
                }
                if ((store = this.database.getStore()) == null) break;
                mvStore = store.getMvStore();
                fs = mvStore.getFileStore();
                this.add(rows, new Object[]{"info.FILE_WRITE", Long.toString(fs.getWriteCount())});
                this.add(rows, new Object[]{"info.FILE_READ", Long.toString(fs.getReadCount())});
                this.add(rows, new Object[]{"info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", new Object[]{100.0 * mvStore.getUpdateFailureRatio()})});
                try {
                    size = fs.getFile().size();
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, "Can not get size");
                }
                pageSize = 4096;
                pageCount = size / (long)pageSize;
                this.add(rows, new Object[]{"info.PAGE_COUNT", Long.toString(pageCount)});
                this.add(rows, new Object[]{"info.PAGE_SIZE", Integer.toString(mvStore.getPageSplitSize())});
                this.add(rows, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(mvStore.getCacheSize())});
                this.add(rows, new Object[]{"info.CACHE_SIZE", Integer.toString(mvStore.getCacheSizeUsed())});
                break;
            }
            case 7: {
                resource = "/org/gridgain/internal/h2/res/help.csv";
                try {
                    data = Utils.getResource(resource);
                    reader = new InputStreamReader(new ByteArrayInputStream(data));
                    csv = new Csv();
                    csv.setLineCommentCharacter('#');
                    rs = csv.read(reader, null);
                    i = 0;
                    while (rs.next()) {
                        this.add(rows, new Object[]{ValueInt.get(i), rs.getString(1).trim(), rs.getString(2).trim(), rs.getString(3).trim(), rs.getString(4).trim()});
                        ++i;
                    }
                    break;
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            }
            case 8: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(3)) {
                    s = (Sequence)obj;
                    this.add(rows, new Object[]{catalog, s.getSchema().getName(), s.getName(), ValueLong.get(s.getCurrentValue()), ValueLong.get(s.getIncrement()), ValueBoolean.get(s.getBelongsToTable()), MetaTable.replaceNullWithEmpty(s.getComment()), ValueLong.get(s.getCacheSize()), ValueLong.get(s.getMinValue()), ValueLong.get(s.getMaxValue()), ValueBoolean.get(s.getCycle()), ValueInt.get(s.getId())});
                }
                break;
            }
            case 9: {
                for (User u : this.database.getAllUsers()) {
                    if (!admin && session.getUser() != u) continue;
                    this.add(rows, new Object[]{this.identifier(u.getName()), String.valueOf(u.isAdmin()), MetaTable.replaceNullWithEmpty(u.getComment()), ValueInt.get(u.getId())});
                }
                break;
            }
            case 10: {
                for (Role r : this.database.getAllRoles()) {
                    if (!admin && !session.getUser().isRoleGranted(r)) continue;
                    this.add(rows, new Object[]{this.identifier(r.getName()), MetaTable.replaceNullWithEmpty(r.getComment()), ValueInt.get(r.getId())});
                }
                break;
            }
            case 11: {
                if (!admin) break;
                for (Right r : this.database.getAllRights()) {
                    role = r.getGrantedRole();
                    grantee = r.getGrantee();
                    v0 = rightType = grantee.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        object = r.getGrantedObject();
                        schema = null;
                        table = null;
                        if (object != null) {
                            if (object instanceof Schema) {
                                schema = (Schema)object;
                            } else if (object instanceof Table) {
                                table = (Table)object;
                                schema = table.getSchema();
                            }
                        }
                        tableName = table != null ? table.getName() : "";
                        v1 = schemaName = schema != null ? schema.getName() : "";
                        if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                        this.add(rows, new Object[]{this.identifier(grantee.getName()), rightType, "", r.getRights(), schemaName, tableName, ValueInt.get(r.getId())});
                        continue;
                    }
                    this.add(rows, new Object[]{this.identifier(grantee.getName()), rightType, this.identifier(role.getName()), "", "", "", ValueInt.get(r.getId())});
                }
                break;
            }
            case 12: {
                for (SchemaObject aliasAsSchemaObject : this.database.getAllSchemaObjects(9)) {
                    alias = (FunctionAlias)aliasAsSchemaObject;
                    try {
                        methods = alias.getJavaMethods();
                    }
                    catch (DbException e) {
                        methods = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod method : methods) {
                        this.add(rows, new Object[]{catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInt.get(DataType.convertTypeToSQLType(method.getDataType())), DataType.getDataType((int)method.getDataType()).name, ValueInt.get(method.getParameterCount()), ValueShort.get(method.getDataType() == 0 ? 1 : 2), MetaTable.replaceNullWithEmpty(alias.getComment()), ValueInt.get(alias.getId()), alias.getSource()});
                    }
                }
                for (UserAggregate agg : this.database.getAllAggregates()) {
                    this.add(rows, new Object[]{catalog, this.database.getMainSchema().getName(), agg.getName(), agg.getJavaClassName(), "", ValueInt.get(0), DataType.getDataType((int)0).name, ValueInt.get(1), ValueShort.get((short)2), MetaTable.replaceNullWithEmpty(agg.getComment()), ValueInt.get(agg.getId()), ""});
                }
                break;
            }
            case 21: {
                for (SchemaObject aliasAsSchemaObject : this.database.getAllSchemaObjects(9)) {
                    alias = (FunctionAlias)aliasAsSchemaObject;
                    try {
                        methods = alias.getJavaMethods();
                    }
                    catch (DbException e) {
                        methods = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod method : methods) {
                        if (method.getDataType() != 0) {
                            dt = DataType.getDataType(method.getDataType());
                            this.add(rows, new Object[]{catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInt.get(method.getParameterCount()), ValueInt.get(0), "P0", ValueInt.get(DataType.convertTypeToSQLType(method.getDataType())), dt.name, ValueInt.get(MathUtils.convertLongToInt(dt.defaultPrecision)), ValueShort.get((short)dt.defaultScale), ValueShort.get((short)10), ValueShort.get((short)2), ValueShort.get((short)5), "", null});
                        }
                        columnList = method.getColumnClasses();
                        for (k = 0; k < columnList.length; ++k) {
                            if (method.hasConnectionParam() && k == 0) continue;
                            clazz = columnList[k];
                            dataType = DataType.getTypeFromClass(clazz);
                            dt = DataType.getDataType(dataType);
                            this.add(rows, new Object[]{catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInt.get(method.getParameterCount()), ValueInt.get(k + (method.hasConnectionParam() != false ? 0 : 1)), "P" + (k + 1), ValueInt.get(DataType.convertTypeToSQLType(dt.type)), dt.name, ValueInt.get(MathUtils.convertLongToInt(dt.defaultPrecision)), ValueShort.get((short)dt.defaultScale), ValueShort.get((short)10), ValueShort.get(clazz.isPrimitive() != false ? 0 : 1), ValueShort.get((short)1), "", null});
                        }
                    }
                }
                break;
            }
            case 13: {
                collation = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(rows, new Object[]{catalog, schema.getName(), this.identifier(schema.getOwner().getName()), "Unicode", collation, ValueBoolean.get(schema.getId() == 0), MetaTable.replaceNullWithEmpty(schema.getComment()), ValueInt.get(schema.getId())});
                }
                break;
            }
            case 14: {
                for (Right r : this.database.getAllRights()) {
                    object = r.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    this.addPrivileges(rows, r.getGrantee(), catalog, table, null, r.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right r : this.database.getAllRights()) {
                    object = r.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    grantee = r.getGrantee();
                    mask = r.getRightMask();
                    for (Column column : table.getColumns()) {
                        this.addPrivileges(rows, grantee, catalog, table, column.getName(), mask);
                    }
                }
                break;
            }
            case 16: {
                for (Locale l : Collator.getAvailableLocales()) {
                    this.add(rows, new Object[]{CompareMode.getName(l), l.toString()});
                }
                break;
            }
            case 17: {
                for (Table table : this.getAllTables(session)) {
                    if (table.getTableType() != TableType.VIEW || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    view = (TableView)table;
                    this.add(rows, new Object[]{catalog, table.getSchema().getName(), tableName, table.getCreateSQL(), "NONE", "NO", view.isInvalid() != false ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(view.getComment()), ValueInt.get(view.getId())});
                }
                break;
            }
            case 18: {
                prepared = this.database.getInDoubtTransactions();
                if (prepared == null || !admin) break;
                for (InDoubtTransaction prep : prepared) {
                    this.add(rows, new Object[]{prep.getTransactionName(), prep.getState()});
                }
                break;
            }
            case 19: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    ref = (ConstraintReferential)constraint;
                    cols = ref.getColumns();
                    refCols = ref.getRefColumns();
                    tab = ref.getTable();
                    refTab = ref.getRefTable();
                    tableName = refTab.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    update = ValueShort.get(MetaTable.getRefAction(ref.getUpdateAction()));
                    delete = ValueShort.get(MetaTable.getRefAction(ref.getDeleteAction()));
                    for (j = 0; j < cols.length; ++j) {
                        this.add(rows, new Object[]{catalog, refTab.getSchema().getName(), refTab.getName(), refCols[j].column.getName(), catalog, tab.getSchema().getName(), tab.getName(), cols[j].column.getName(), ValueShort.get((short)(j + 1)), update, delete, ref.getName(), ref.getUniqueIndex().getName(), ValueShort.get((short)7)});
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    checkExpression = null;
                    indexColumns = null;
                    table = constraint.getTable();
                    if (this.hideTable(table, session)) continue;
                    index = constraint.getUniqueIndex();
                    uniqueIndexName = null;
                    if (index != null) {
                        uniqueIndexName = index.getName();
                    }
                    if (!this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    if (constraintType == Constraint.Type.CHECK) {
                        checkExpression = ((ConstraintCheck)constraint).getExpression().getSQL(true);
                    } else if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    columnList = null;
                    if (indexColumns != null) {
                        builder = new StringBuilder();
                        length = indexColumns.length;
                        for (i = 0; i < length; ++i) {
                            if (i > 0) {
                                builder.append(',');
                            }
                            builder.append(indexColumns[i].column.getName());
                        }
                        columnList = builder.toString();
                    }
                    this.add(rows, new Object[]{catalog, constraint.getSchema().getName(), constraint.getName(), constraintType == Constraint.Type.PRIMARY_KEY ? constraintType.getSqlName() : constraintType.name(), catalog, table.getSchema().getName(), tableName, uniqueIndexName, checkExpression, columnList, MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInt.get(constraint.getId())});
                }
                break;
            }
            case 22: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(11)) {
                    constant = (Constant)obj;
                    expr = constant.getValue();
                    this.add(rows, new Object[]{catalog, constant.getSchema().getName(), constant.getName(), ValueInt.get(DataType.convertTypeToSQLType(expr.getType().getValueType())), MetaTable.replaceNullWithEmpty(constant.getComment()), expr.getSQL(true), ValueInt.get(constant.getId())});
                }
                break;
            }
            case 23: {
                for (Domain dt : this.database.getAllDomains()) {
                    col = dt.getColumn();
                    this.add(rows, new Object[]{catalog, this.database.getMainSchema().getName(), dt.getName(), col.getDefaultSQL(), col.isNullable() != false ? "YES" : "NO", ValueInt.get(col.getDataType().sqlType), ValueInt.get(col.getPrecisionAsInt()), ValueInt.get(col.getType().getScale()), col.getDataType().name, ValueInt.get(col.getSelectivity()), col.getCheckConstraintSQL(session, "VALUE"), MetaTable.replaceNullWithEmpty(dt.getComment()), dt.getCreateSQL(), ValueInt.get(dt.getId())});
                }
                break;
            }
            case 24: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(4)) {
                    trigger = (TriggerObject)obj;
                    table = trigger.getTable();
                    this.add(rows, new Object[]{catalog, trigger.getSchema().getName(), trigger.getName(), trigger.getTypeNameList(new StringBuilder()).toString(), catalog, table.getSchema().getName(), table.getName(), ValueBoolean.get(trigger.isBefore()), trigger.getTriggerClassName(), ValueInt.get(trigger.getQueueSize()), ValueBoolean.get(trigger.isNoWait()), MetaTable.replaceNullWithEmpty(trigger.getComment()), trigger.getCreateSQL(), ValueInt.get(trigger.getId())});
                }
                break;
            }
            case 25: {
                for (Session s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    command = s.getCurrentCommand();
                    blockingSessionId = s.getBlockingSessionId();
                    this.add(rows, new Object[]{ValueInt.get(s.getId()), s.getUser().getName(), DateTimeUtils.timestampTimeZoneFromMillis(s.getSessionStart()), command == null ? null : command.toString(), command == null ? null : s.getCurrentCommandStart(), ValueBoolean.get(s.containsUncommitted()), String.valueOf((Object)s.getState()), blockingSessionId == 0 ? null : ValueInt.get(blockingSessionId)});
                }
                break;
            }
            case 26: {
                for (Session s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    for (Table table : s.getLocks()) {
                        this.add(rows, new Object[]{table.getSchema().getName(), table.getName(), ValueInt.get(s.getId()), table.isLockedExclusivelyBy(s) != false ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                for (String name : session.getVariableNames()) {
                    v = session.getVariable(name);
                    builder = new StringBuilder().append("SET @").append(name).append(' ');
                    v.getSQL(builder);
                    this.add(rows, new Object[]{"@" + name, builder.toString()});
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(rows, new Object[]{"TABLE " + table.getName(), table.getCreateSQL()});
                }
                path = session.getSchemaSearchPath();
                if (path != null && path.length > 0) {
                    builder = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    l = path.length;
                    for (i = 0; i < l; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        StringUtils.quoteIdentifier(builder, path[i]);
                    }
                    this.add(rows, new Object[]{"SCHEMA_SEARCH_PATH", builder.toString()});
                }
                if ((schema = session.getCurrentSchemaName()) == null) break;
                this.add(rows, new Object[]{"SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), schema).toString()});
                break;
            }
            case 28: {
                control = this.database.getQueryStatisticsData();
                if (control == null) break;
                for (QueryStatisticsData.QueryEntry entry : control.getQueries()) {
                    this.add(rows, new Object[]{entry.sqlStatement, ValueInt.get(entry.count), ValueDouble.get((double)entry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(entry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(entry.getExecutionTimeStandardDeviation() / 1000000.0), ValueInt.get(entry.rowCountMin), ValueInt.get(entry.rowCountMax), ValueLong.get(entry.rowCountCumulative), ValueDouble.get(entry.rowCountMean), ValueDouble.get(entry.getRowCountStandardDeviation())});
                }
                break;
            }
            case 29: {
                for (TableSynonym synonym : this.database.getAllSynonyms()) {
                    this.add(rows, new Object[]{catalog, synonym.getSchema().getName(), synonym.getName(), synonym.getSynonymForName(), synonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(synonym.getComment()), ValueInt.get(synonym.getId())});
                }
                break;
            }
            case 30: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    table = constraint.getTable();
                    if (this.hideTable(table, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    this.add(rows, new Object[]{catalog, constraint.getSchema().getName(), constraint.getName(), constraintType.getSqlName(), catalog, table.getSchema().getName(), tableName, "NO", "NO"});
                }
                break;
            }
            case 31: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    indexColumns = null;
                    table = constraint.getTable();
                    if (this.hideTable(table, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    if (indexColumns == null) continue;
                    referenced = constraintType == Constraint.Type.REFERENTIAL ? MetaTable.lookupUniqueForReferential((ConstraintReferential)constraint) : null;
                    for (i = 0; i < indexColumns.length; ++i) {
                        indexColumn = indexColumns[i];
                        ordinalPosition = ValueInt.get(i + 1);
                        if (constraintType != Constraint.Type.REFERENTIAL) ** GOTO lbl469
                        positionInUniqueConstraint = ordinalPosition;
                        if (referenced == null) ** GOTO lbl470
                        c = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                        refColumns = referenced.getColumns();
                        for (j = 0; j < refColumns.length; ++j) {
                            if (!refColumns[j].column.equals(c)) continue;
                            positionInUniqueConstraint = ValueInt.get(j + 1);
                            ** GOTO lbl470
                        }
                        ** GOTO lbl470
lbl469:
                        // 1 sources

                        positionInUniqueConstraint = null;
lbl470:
                        // 4 sources

                        this.add(rows, new Object[]{catalog, constraint.getSchema().getName(), constraint.getName(), catalog, table.getSchema().getName(), tableName, indexColumn.columnName, ordinalPosition, positionInUniqueConstraint});
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)obj).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(table = (constraint = (ConstraintReferential)obj).getTable(), session)) continue;
                    unique = MetaTable.lookupUniqueForReferential(constraint);
                    if (unique == null) {
                        unique = constraint.getUniqueIndex();
                    }
                    this.add(rows, new Object[]{catalog, constraint.getSchema().getName(), constraint.getName(), catalog, unique.getSchema().getName(), unique.getName(), "NONE", constraint.getUpdateAction().getSqlName(), constraint.getDeleteAction().getSqlName()});
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private static short getRefAction(ConstraintActionType action) {
        switch (action) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)action));
    }

    private static ConstraintUnique lookupUniqueForReferential(ConstraintReferential referential) {
        Table table = referential.getRefTable();
        for (Constraint c : table.getConstraints()) {
            ConstraintUnique unique;
            if (c.getConstraintType() != Constraint.Type.UNIQUE || !(unique = (ConstraintUnique)c).getReferencedColumns(table).equals(referential.getReferencedColumns(table))) continue;
            return unique;
        }
        return null;
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s2) {
    }

    private void addPrivileges(ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, int rightMask) {
        if ((rightMask & 1) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, String right) {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).isAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), right, isGrantable);
        } else {
            this.add(rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), column, right, isGrantable);
        }
    }

    private void add(ArrayList<Row> rows, Object ... stringsOrValues) {
        Value[] values = new Value[stringsOrValues.length];
        for (int i = 0; i < stringsOrValues.length; ++i) {
            Object s2 = stringsOrValues[i];
            ValueNull v = s2 == null ? ValueNull.INSTANCE : (s2 instanceof String ? ValueString.get((String)s2) : (Value)s2);
            values[i] = this.columns[i].convert(v);
        }
        Row row = this.database.createRow(values, 1);
        row.setKey(rows.size());
        rows.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> list = new ArrayList<Index>(2);
        if (this.metaIndex == null) {
            return list;
        }
        list.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        list.add(this.metaIndex);
        return list;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 33;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

