/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.function.FunctionCall;
import org.gridgain.internal.h2.expression.function.TableFunction;
import org.gridgain.internal.h2.index.FunctionIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;
    private ResultInterface cachedResult;
    private Value cachedValue;

    public FunctionTable(Schema schema, Session session, Expression functionExpr, FunctionCall function) {
        super(schema, 0, function.getName(), false, true);
        this.functionExpr = functionExpr;
        this.function = function;
        this.rowCount = function instanceof TableFunction ? ((TableFunction)function).getRowCount() : Long.MAX_VALUE;
        function.optimize(session);
        int type = function.getValueType();
        if (type != 18) {
            throw DbException.get(90000, function.getName());
        }
        Expression[] args = function.getArgs();
        int numParams = args.length;
        Expression[] columnListArgs = new Expression[numParams];
        for (int i = 0; i < numParams; ++i) {
            args[i] = args[i].optimize(session);
            columnListArgs[i] = args[i];
        }
        ValueResultSet template = function.getValueForColumnList(session, columnListArgs);
        if (template == null) {
            throw DbException.get(90000, function.getName());
        }
        ResultInterface result = template.getResult();
        int columnCount = result.getVisibleColumnCount();
        Column[] cols = new Column[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            cols[i] = new Column(result.getColumnName(i), result.getColumnType(i));
        }
        this.setColumns(cols);
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canDrop() {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public ResultInterface getResult(Session session) {
        ValueResultSet v = this.getValueResultSet(session);
        if (v == null) {
            return null;
        }
        if (this.cachedResult != null && this.cachedValue == v) {
            this.cachedResult.reset();
            return this.cachedResult;
        }
        ResultInterface result = v.getResult();
        if (this.function.isDeterministic()) {
            this.cachedResult = result;
            this.cachedValue = v;
        }
        return result;
    }

    public ResultInterface getResultSet(Session session) {
        ValueResultSet v = this.getValueResultSet(session);
        return v == null ? null : v.getResult();
    }

    private ValueResultSet getValueResultSet(Session session) {
        this.functionExpr = this.functionExpr.optimize(session);
        Value v = this.functionExpr.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return null;
        }
        return (ValueResultSet)v;
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.function.isBufferResultSetToLocalTemp();
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public String getSQL(boolean alwaysQuote) {
        return this.function.getSQL(alwaysQuote);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return builder.append(this.function.getSQL(alwaysQuote));
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

