/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.server.Service;
import org.gridgain.internal.h2.server.ShutdownHandler;
import org.gridgain.internal.h2.server.TcpServerThread;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.NetUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Tool;

public class TcpServer
implements Service {
    private static final int SHUTDOWN_NORMAL = 0;
    private static final int SHUTDOWN_FORCE = 1;
    private static final String MANAGEMENT_DB_PREFIX = "management_db_";
    private static final ConcurrentHashMap<Integer, TcpServer> SERVERS = new ConcurrentHashMap();
    private int port;
    private boolean portIsSet;
    private boolean trace;
    private boolean ssl;
    private boolean stop;
    private ShutdownHandler shutdownHandler;
    private ServerSocket serverSocket;
    private final Set<TcpServerThread> running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists = true;
    private Connection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private Thread listenerThread;
    private int nextThreadId;
    private String key;
    private String keyDatabase;

    public static String getManagementDbName(int port) {
        return "mem:management_db_" + port;
    }

    private void initManagementDb() throws SQLException {
        Connection conn;
        Properties prop = new Properties();
        prop.setProperty("user", "");
        prop.setProperty("password", this.managementPassword);
        this.managementDb = conn = Driver.load().connect("jdbc:gg-h2:" + TcpServer.getManagementDbName(this.port), prop);
        try (Statement stat = conn.createStatement();){
            stat.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + TcpServer.class.getName() + ".stopServer\"");
            stat.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.managementDbAdd = conn.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.managementDbRemove = conn.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        SERVERS.put(this.port, this);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    synchronized void addConnection(int id, String url, String user) {
        try {
            this.managementDbAdd.setInt(1, id);
            this.managementDbAdd.setString(2, url);
            this.managementDbAdd.setString(3, user);
            this.managementDbAdd.execute();
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
    }

    synchronized void removeConnection(int id) {
        try {
            this.managementDbRemove.setInt(1, id);
            this.managementDbRemove.execute();
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
    }

    private synchronized void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException e) {
                DbException.traceThrowable(e);
            }
            this.managementDb = null;
        }
    }

    @Override
    public void init(String ... args) {
        this.port = 9092;
        for (int i = 0; args != null && i < args.length; ++i) {
            String a = args[i];
            if (Tool.isOption(a, "-trace")) {
                this.trace = true;
                continue;
            }
            if (Tool.isOption(a, "-tcpSSL")) {
                this.ssl = true;
                continue;
            }
            if (Tool.isOption(a, "-tcpPort")) {
                this.port = Integer.decode(args[++i]);
                this.portIsSet = true;
                continue;
            }
            if (Tool.isOption(a, "-tcpPassword")) {
                this.managementPassword = args[++i];
                continue;
            }
            if (Tool.isOption(a, "-baseDir")) {
                this.baseDir = args[++i];
                continue;
            }
            if (Tool.isOption(a, "-key")) {
                this.key = args[++i];
                this.keyDatabase = args[++i];
                continue;
            }
            if (Tool.isOption(a, "-tcpAllowOthers")) {
                this.allowOthers = true;
                continue;
            }
            if (Tool.isOption(a, "-tcpDaemon")) {
                this.isDaemon = true;
                continue;
            }
            if (Tool.isOption(a, "-ifExists")) {
                this.ifExists = true;
                continue;
            }
            if (!Tool.isOption(a, "-ifNotExists")) continue;
            this.ifExists = false;
        }
        Driver.load();
    }

    @Override
    public String getURL() {
        return (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException e) {
            this.traceError(e);
            return false;
        }
    }

    @Override
    public synchronized void start() throws SQLException {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        }
        catch (DbException e) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, this.ssl);
            }
            throw e;
        }
        this.port = this.serverSocket.getLocalPort();
        this.initManagementDb();
    }

    @Override
    public void listen() {
        block3: {
            this.listenerThread = Thread.currentThread();
            String threadName = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Socket s2 = this.serverSocket.accept();
                    TcpServerThread c = new TcpServerThread(s2, this, this.nextThreadId++);
                    this.running.add(c);
                    Thread thread = new Thread((Runnable)c, threadName + " thread");
                    thread.setDaemon(this.isDaemon);
                    c.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception e) {
                if (this.stop) break block3;
                DbException.traceThrowable(e);
            }
        }
        this.stopManagementDb();
    }

    @Override
    public synchronized boolean isRunning(boolean traceError) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s2 = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s2.close();
            return true;
        }
        catch (Exception e) {
            if (traceError) {
                this.traceError(e);
            }
            return false;
        }
    }

    @Override
    public void stop() {
        SERVERS.remove(this.port);
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    DbException.traceThrowable(e);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException e) {
                    DbException.traceThrowable(e);
                }
            }
        }
        for (TcpServerThread c : new ArrayList<TcpServerThread>(this.running)) {
            if (c == null) continue;
            c.close();
            try {
                c.getThread().join(100L);
            }
            catch (Exception e) {
                DbException.traceThrowable(e);
            }
        }
    }

    public static void stopServer(int port, String password, int shutdownMode) {
        if (port == 0) {
            Integer[] integerArray = ((ConcurrentHashMap.CollectionView)((Object)SERVERS.keySet())).toArray(new Integer[0]);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int p = integerArray[i];
                if (p == 0) continue;
                TcpServer.stopServer(p, password, shutdownMode);
            }
            return;
        }
        TcpServer server = SERVERS.get(port);
        if (server == null) {
            return;
        }
        if (!server.managementPassword.equals(password)) {
            return;
        }
        if (shutdownMode == 0) {
            server.stopManagementDb();
            server.stop = true;
            try {
                Socket s2 = NetUtils.createLoopbackSocket(port, false);
                s2.close();
            }
            catch (Exception exception) {}
        } else if (shutdownMode == 1) {
            server.stop();
        }
        server.shutdown();
    }

    void remove(TcpServerThread t2) {
        this.running.remove(t2);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void trace(String s2) {
        if (this.trace) {
            System.out.println(s2);
        }
    }

    void traceError(Throwable e) {
        if (this.trace) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "TCP";
    }

    @Override
    public String getName() {
        return "H2 TCP Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(String url, String password, boolean force, boolean all) throws SQLException {
        try {
            String p;
            int port = 9092;
            int idx = url.lastIndexOf(58);
            if (idx >= 0 && StringUtils.isNumber(p = url.substring(idx + 1))) {
                port = Integer.decode(p);
            }
            String db = TcpServer.getManagementDbName(port);
            try {
                Driver.load();
            }
            catch (Throwable e) {
                throw DbException.convert(e);
            }
            for (int i = 0; i < 2; ++i) {
                Connection conn = null;
                PreparedStatement prep = null;
                try {
                    block13: {
                        conn = DriverManager.getConnection("jdbc:gg-h2:" + url + "/" + db, "", password);
                        prep = conn.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                        prep.setInt(1, all ? 0 : port);
                        prep.setString(2, password);
                        prep.setInt(3, force ? 1 : 0);
                        try {
                            prep.execute();
                        }
                        catch (SQLException e) {
                            if (force || e.getErrorCode() == 90067) break block13;
                            throw e;
                        }
                    }
                    JdbcUtils.closeSilently(prep);
                }
                catch (SQLException e) {
                    if (i != 1) continue;
                    throw e;
                }
                finally {
                    JdbcUtils.closeSilently(prep);
                    JdbcUtils.closeSilently(conn);
                }
                JdbcUtils.closeSilently(conn);
                break;
            }
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    void cancelStatement(String sessionId, int statementId) {
        for (TcpServerThread c : new ArrayList<TcpServerThread>(this.running)) {
            if (c == null) continue;
            c.cancelStatement(sessionId, statementId);
        }
    }

    public String checkKeyAndGetDatabaseName(String db) {
        if (this.key == null) {
            return db;
        }
        if (this.key.equals(db)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

