/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.schema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gridgain.internal.h2.command.ddl.CreateSynonymData;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.DbObjectBase;
import org.gridgain.internal.h2.engine.DbSettings;
import org.gridgain.internal.h2.engine.FunctionAlias;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.schema.Constant;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.SchemaObjectBase;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableLink;
import org.gridgain.internal.h2.table.TableSynonym;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class Schema
extends DbObjectBase {
    private User owner;
    private final boolean system;
    private ArrayList<String> tableEngineParams;
    private final ConcurrentHashMap<String, Table> tablesAndViews;
    private final ConcurrentHashMap<String, TableSynonym> synonyms;
    private final ConcurrentHashMap<String, Index> indexes;
    private final ConcurrentHashMap<String, Sequence> sequences;
    private final ConcurrentHashMap<String, TriggerObject> triggers;
    private final ConcurrentHashMap<String, Constraint> constraints;
    private final ConcurrentHashMap<String, Constant> constants;
    private final ConcurrentHashMap<String, FunctionAlias> functions;
    private final HashSet<String> temporaryUniqueNames = new HashSet();

    public Schema(Database database, int id, String schemaName, User owner, boolean system) {
        super(database, id, schemaName, 8);
        this.tablesAndViews = database.newConcurrentStringMap();
        this.synonyms = database.newConcurrentStringMap();
        this.indexes = database.newConcurrentStringMap();
        this.sequences = database.newConcurrentStringMap();
        this.triggers = database.newConcurrentStringMap();
        this.constraints = database.newConcurrentStringMap();
        this.constants = database.newConcurrentStringMap();
        this.functions = database.newConcurrentStringMap();
        this.owner = owner;
        this.system = system;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuilder builder = new StringBuilder("CREATE SCHEMA IF NOT EXISTS ");
        this.getSQL(builder, true).append(" AUTHORIZATION ");
        this.owner.getSQL(builder, true);
        return builder.toString();
    }

    @Override
    public int getType() {
        return 10;
    }

    public boolean isEmpty() {
        return this.tablesAndViews.isEmpty() && this.synonyms.isEmpty() && this.indexes.isEmpty() && this.sequences.isEmpty() && this.triggers.isEmpty() && this.constraints.isEmpty() && this.constants.isEmpty() && this.functions.isEmpty();
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = Utils.newSmallArrayList();
        ArrayList<Right> rights = this.database.getAllRights();
        for (Right right : rights) {
            if (right.getGrantedObject() != this) continue;
            children.add(right);
        }
        return children;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        SchemaObject obj;
        SchemaObjectBase obj2;
        while (this.triggers != null && this.triggers.size() > 0) {
            obj2 = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, obj2);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            obj2 = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, obj2);
        }
        boolean runLoopAgain = false;
        do {
            runLoopAgain = false;
            if (this.tablesAndViews == null) continue;
            for (Table obj3 : new ArrayList<Table>(this.tablesAndViews.values())) {
                if (obj3.getName() == null) continue;
                if (this.database.getDependentTable(obj3, obj3) == null) {
                    this.database.removeSchemaObject(session, obj3);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        while (this.indexes != null && this.indexes.size() > 0) {
            obj = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            obj = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constants != null && this.constants.size() > 0) {
            obj = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.functions != null && this.functions.size() > 0) {
            obj = (FunctionAlias)this.functions.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    public ArrayList<String> getTableEngineParams() {
        return this.tableEngineParams;
    }

    public void setTableEngineParams(ArrayList<String> tableEngineParams) {
        this.tableEngineParams = tableEngineParams;
    }

    private Map<String, SchemaObject> getMap(int type) {
        ConcurrentHashMap<String, SchemaObject> result;
        switch (type) {
            case 0: {
                result = this.tablesAndViews;
                break;
            }
            case 15: {
                result = this.synonyms;
                break;
            }
            case 3: {
                result = this.sequences;
                break;
            }
            case 1: {
                result = this.indexes;
                break;
            }
            case 4: {
                result = this.triggers;
                break;
            }
            case 5: {
                result = this.constraints;
                break;
            }
            case 11: {
                result = this.constants;
                break;
            }
            case 9: {
                result = this.functions;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        return result;
    }

    public void add(SchemaObject obj) {
        if (obj.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String name = obj.getName();
        Map<String, SchemaObject> map = this.getMap(obj.getType());
        if (SysProperties.CHECK && map.get(name) != null) {
            DbException.throwInternalError("object already exists: " + name);
        }
        map.put(name, obj);
        this.freeUniqueName(name);
    }

    public void rename(SchemaObject obj, String newName) {
        int type = obj.getType();
        Map<String, SchemaObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                DbException.throwInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                DbException.throwInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        map.remove(obj.getName());
        this.freeUniqueName(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.freeUniqueName(newName);
    }

    public Table findTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Table resolveTableOrView(Session session, String name) {
        TableSynonym synonym;
        Table table = this.findTableOrView(session, name);
        if (table == null && (synonym = this.synonyms.get(name)) != null) {
            return synonym.getSynonymFor();
        }
        return table;
    }

    public TableSynonym getSynonym(String name) {
        return this.synonyms.get(name);
    }

    public Index findIndex(Session session, String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            index = session.findLocalTempTableIndex(name);
        }
        return index;
    }

    public TriggerObject findTrigger(String name) {
        return this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(Session session, String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(name);
        }
        return constraint;
    }

    public Constant findConstant(String constantName) {
        return this.constants.get(constantName);
    }

    public FunctionAlias findFunction(String functionAlias) {
        return this.functions.get(functionAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String name) {
        if (name != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(DbObject obj, Map<String, ? extends SchemaObject> map, String prefix) {
        String hash = StringUtils.toUpperEnglish(Integer.toHexString(obj.getName().hashCode()));
        String name = null;
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int i;
            int len = hash.length();
            for (i = 1; i < len && (map.containsKey(name = prefix + hash.substring(0, i)) || this.temporaryUniqueNames.contains(name)); ++i) {
                name = null;
            }
            if (name == null) {
                prefix = prefix + hash + "_";
                i = 0;
                while (map.containsKey(name = prefix + i) || this.temporaryUniqueNames.contains(name)) {
                    ++i;
                }
            }
            this.temporaryUniqueNames.add(name);
        }
        return name;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        AbstractMap tableConstraints = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, tableConstraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String prefix) {
        AbstractMap tableIndexes = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, tableIndexes, prefix);
    }

    public Table getTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(name);
            }
            if (table == null) {
                throw DbException.get(42102, name);
            }
        }
        return table;
    }

    public Index getIndex(String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            throw DbException.get(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            throw DbException.get(90057, name);
        }
        return constraint;
    }

    public Constant getConstant(String constantName) {
        Constant constant = this.constants.get(constantName);
        if (constant == null) {
            throw DbException.get(90115, constantName);
        }
        return constant;
    }

    public Sequence getSequence(String sequenceName) {
        Sequence sequence = this.sequences.get(sequenceName);
        if (sequence == null) {
            throw DbException.get(90036, sequenceName);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll(ArrayList<SchemaObject> addTo) {
        if (addTo == null) {
            addTo = Utils.newSmallArrayList();
        }
        addTo.addAll(this.tablesAndViews.values());
        addTo.addAll(this.synonyms.values());
        addTo.addAll(this.sequences.values());
        addTo.addAll(this.indexes.values());
        addTo.addAll(this.triggers.values());
        addTo.addAll(this.constraints.values());
        addTo.addAll(this.constants.values());
        addTo.addAll(this.functions.values());
        return addTo;
    }

    public ArrayList<SchemaObject> getAll(int type, ArrayList<SchemaObject> addTo) {
        Collection<SchemaObject> values = this.getMap(type).values();
        if (addTo != null) {
            addTo.addAll(values);
        } else {
            addTo = new ArrayList<SchemaObject>(values);
        }
        return addTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Table> getAllTablesAndViews() {
        Database database = this.database;
        synchronized (database) {
            return new ArrayList<Table>(this.tablesAndViews.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TableSynonym> getAllSynonyms() {
        Database database = this.database;
        synchronized (database) {
            return new ArrayList<TableSynonym>(this.synonyms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableOrViewByName(String name) {
        Database database = this.database;
        synchronized (database) {
            return this.tablesAndViews.get(name);
        }
    }

    public void remove(SchemaObject obj) {
        String objName = obj.getName();
        Map<String, SchemaObject> map = this.getMap(obj.getType());
        if (map.remove(objName) == null) {
            DbException.throwInternalError("not found: " + objName);
        }
        this.freeUniqueName(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData data) {
        Database database = this.database;
        synchronized (database) {
            if (!data.temporary || data.globalTemporary) {
                this.database.lockMeta(data.session);
            }
            data.schema = this;
            if (data.tableEngine == null) {
                DbSettings s2 = this.database.getSettings();
                if (s2.defaultTableEngine != null) {
                    data.tableEngine = s2.defaultTableEngine;
                } else if (s2.mvStore) {
                    data.tableEngine = MVTableEngine.class.getName();
                }
            }
            if (data.tableEngine != null) {
                if (data.tableEngineParams == null) {
                    data.tableEngineParams = this.tableEngineParams;
                }
                return this.database.getTableEngine(data.tableEngine).createTable(data);
            }
            return new PageStoreTable(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableSynonym createSynonym(CreateSynonymData data) {
        Database database = this.database;
        synchronized (database) {
            this.database.lockMeta(data.session);
            data.schema = this;
            return new TableSynonym(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int id, String tableName, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, id, tableName, driver, url, user, password, originalSchema, originalTable, emitUpdates, force);
        }
    }
}

