/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.internal.h2.compress.CompressDeflate;
import org.gridgain.internal.h2.compress.CompressLZF;
import org.gridgain.internal.h2.compress.Compressor;
import org.gridgain.internal.h2.mvstore.Chunk;
import org.gridgain.internal.h2.mvstore.Cursor;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.FileStore;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.Page;
import org.gridgain.internal.h2.mvstore.RootReference;
import org.gridgain.internal.h2.mvstore.WriteBuffer;
import org.gridgain.internal.h2.mvstore.cache.CacheLongKeyLIRS;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int MARKED_FREE = 10000000;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private final int keysPerPage;
    final CacheLongKeyLIRS<Page> cache;
    final CacheLongKeyLIRS<int[]> cacheChunkRef;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final Map<Integer, Chunk> freedPageSpace = new HashMap<Integer, Chunk>();
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private WriteBuffer writeBuffer;
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private long lastStoredVersion = -1L;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile IllegalStateException panicException;
    private long lastTimeAbsolute;
    private long lastFreeUnusedChunks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> config) {
        this.compressionLevel = DataUtils.getConfigParam(config, "compress", 0);
        String fileName = (String)config.get("fileName");
        FileStore fileStore = (FileStore)config.get("fileStore");
        boolean bl = this.fileStoreIsProvided = fileStore != null;
        if (fileStore == null && fileName != null) {
            fileStore = new FileStore();
        }
        this.fileStore = fileStore;
        int pgSplitSize = 48;
        CacheLongKeyLIRS.Config cc = null;
        if (this.fileStore != null) {
            int mb = DataUtils.getConfigParam(config, "cacheSize", 16);
            if (mb > 0) {
                cc = new CacheLongKeyLIRS.Config();
                cc.maxMemory = (long)mb * 1024L * 1024L;
                Object o = config.get("cacheConcurrency");
                if (o != null) {
                    cc.segmentCount = (Integer)o;
                }
            }
            pgSplitSize = 16384;
        }
        if (cc != null) {
            this.cache = new CacheLongKeyLIRS(cc);
            cc.maxMemory /= 4L;
            this.cacheChunkRef = new CacheLongKeyLIRS(cc);
        } else {
            this.cache = null;
            this.cacheChunkRef = null;
        }
        pgSplitSize = DataUtils.getConfigParam(config, "pageSplitSize", pgSplitSize);
        if (this.cache != null && (long)pgSplitSize > this.cache.getMaxItemSize()) {
            pgSplitSize = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = pgSplitSize;
        this.keysPerPage = DataUtils.getConfigParam(config, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)config.get("backgroundExceptionHandler");
        this.meta = new MVMap(this);
        if (this.fileStore != null) {
            String key2;
            this.retentionTime = this.fileStore.getDefaultRetentionTime();
            int kb = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
            kb = DataUtils.getConfigParam(config, "autoCommitBufferSize", kb);
            this.autoCommitMemory = kb * 1024;
            this.autoCompactFillRate = DataUtils.getConfigParam(config, "autoCompactFillRate", 40);
            char[] encryptionKey = (char[])config.get("encryptionKey");
            try {
                if (!this.fileStoreIsProvided) {
                    boolean readOnly = config.containsKey("readOnly");
                    this.fileStore.open(fileName, readOnly, encryptionKey);
                }
                if (this.fileStore.size() == 0L) {
                    this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                    this.storeHeader.put("H", 2);
                    this.storeHeader.put("blockSize", 4096);
                    this.storeHeader.put("format", 1);
                    this.storeHeader.put("created", this.creationTime);
                    this.writeStoreHeader();
                } else {
                    this.readStoreHeader();
                }
            }
            catch (IllegalStateException e) {
                this.panic(e);
            }
            finally {
                if (encryptionKey != null) {
                    Arrays.fill(encryptionKey, '\u0000');
                }
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            HashSet<String> rootsToRemove = new HashSet<String>();
            Iterator<String> it = this.meta.keyIterator("root.");
            while (it.hasNext() && (key2 = it.next()).startsWith("root.")) {
                String mapId = key2.substring(key2.lastIndexOf(46) + 1);
                if (this.meta.containsKey("map." + mapId)) continue;
                rootsToRemove.add(key2);
            }
            for (String key2 : rootsToRemove) {
                this.meta.remove(key2);
                this.markMetaChanged();
            }
            int delay = DataUtils.getConfigParam(config, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(delay);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
        }
    }

    private void panic(IllegalStateException e) {
        if (this.isOpen()) {
            this.handleException(e);
            this.panicException = e;
            this.closeImmediately();
        }
        throw e;
    }

    public IllegalStateException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String fileName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("fileName", fileName);
        return new MVStore(config);
    }

    long getRootPos(int mapId, long version) {
        MVMap<String, String> oldMeta = this.getMetaMap(version);
        return MVStore.getRootPos(oldMeta, mapId);
    }

    public <K, V> MVMap<K, V> openMap(String name) {
        return this.openMap(name, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String name, MVMap.MapBuilder<M, K, V> builder) {
        Object map;
        int id = this.getMapId(name);
        if (id >= 0) {
            map = this.openMap(id, builder);
            assert (builder.getKeyType() == null || ((MVMap)map).getKeyType().getClass().equals(builder.getKeyType().getClass()));
            assert (builder.getValueType() == null || ((MVMap)map).getValueType().getClass().equals(builder.getValueType().getClass()));
        } else {
            HashMap<String, Object> c = new HashMap<String, Object>();
            id = this.lastMapId.incrementAndGet();
            assert (this.getMap(id) == null);
            c.put("id", id);
            c.put("createVersion", this.currentVersion);
            map = builder.create(this, c);
            String x = Integer.toHexString(id);
            this.meta.put(MVMap.getMapKey(id), ((MVMap)map).asString(name));
            this.meta.put("name." + name, x);
            ((MVMap)map).setRootPos(0L, this.lastStoredVersion);
            this.markMetaChanged();
            MVMap<?, ?> existingMap = this.maps.putIfAbsent(id, (MVMap<?, ?>)map);
            if (existingMap != null) {
                map = existingMap;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends MVMap<K, V>, K, V> M openMap(int id, MVMap.MapBuilder<M, K, V> builder) {
        this.storeLock.lock();
        try {
            MVMap<K, V> map = this.getMap(id);
            if (map == null) {
                String configAsString = this.meta.get(MVMap.getMapKey(id));
                HashMap<String, Object> config = configAsString != null ? new HashMap<String, String>(DataUtils.parseMap(configAsString)) : new HashMap<String, Integer>();
                config.put("id", id);
                map = builder.create(this, config);
                long root = MVStore.getRootPos(this.meta, id);
                map.setRootPos(root, this.lastStoredVersion);
                this.maps.put(id, map);
            }
            MVMap<K, V> mVMap = map;
            return (M)mVMap;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public <K, V> MVMap<K, V> getMap(int id) {
        this.checkOpen();
        MVMap<?, ?> map = this.maps.get(id);
        return map;
    }

    public Set<String> getMapNames() {
        String x;
        HashSet<String> set = new HashSet<String>();
        this.checkOpen();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (x = it.next()).startsWith("name.")) {
            String mapName = x.substring("name.".length());
            set.add(mapName);
        }
        return set;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long version) {
        Chunk c = this.getChunkForVersion(version);
        DataUtils.checkArgument(c != null, "Unknown version {0}", version);
        c = this.readChunkHeader(c.block);
        MVMap<String, String> oldMeta = this.meta.openReadOnly(c.metaRootPos, version);
        return oldMeta;
    }

    private Chunk getChunkForVersion(long version) {
        Chunk newest = null;
        for (Chunk c : this.chunks.values()) {
            if (c.version > version || newest != null && c.id <= newest.id) continue;
            newest = c;
        }
        return newest;
    }

    public boolean hasMap(String name) {
        return this.meta.containsKey("name." + name);
    }

    public boolean hasData(String name) {
        return this.hasMap(name) && MVStore.getRootPos(this.meta, this.getMapId(name)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        Chunk newest = null;
        boolean validStoreHeader = false;
        ByteBuffer fileHeaderBlocks = this.fileStore.readFully(0L, 8192);
        byte[] buff = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            fileHeaderBlocks.get(buff);
            try {
                HashMap<String, String> m4 = DataUtils.parseChecksummedMap(buff);
                if (m4 == null) continue;
                int blockSize = DataUtils.readHexInt(m4, "blockSize", 4096);
                if (blockSize != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", blockSize);
                }
                long version = DataUtils.readHexLong(m4, "version", 0L);
                if (newest != null && version <= newest.version) continue;
                validStoreHeader = true;
                this.storeHeader.putAll(m4);
                this.creationTime = DataUtils.readHexLong(m4, "created", 0L);
                int chunkId = DataUtils.readHexInt(m4, "chunk", 0);
                long block = DataUtils.readHexLong(m4, "block", 0L);
                Chunk test = this.readChunkHeaderAndFooter(block);
                if (test == null || test.id != chunkId) continue;
                newest = test;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!validStoreHeader) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long format = DataUtils.readHexLong(this.storeHeader, "format", 1L);
        if (format > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", format, 1);
        }
        if ((format = DataUtils.readHexLong(this.storeHeader, "formatRead", format)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", format, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.creationTime = now - (long)this.fileStore.getDefaultRetentionTime();
        } else if (now < this.creationTime) {
            this.creationTime = now;
            this.storeHeader.put("created", this.creationTime);
        }
        Chunk test = this.readChunkFooter(this.fileStore.size());
        if (test != null && (test = this.readChunkHeaderAndFooter(test.block)) != null && (newest == null || test.version > newest.version)) {
            newest = test;
        }
        long blocksInStore = this.fileStore.size() / 4096L;
        PriorityQueue<Chunk> lastChunkCandidates = new PriorityQueue<Chunk>(Math.max(32, (int)(blocksInStore / 4L)), new Comparator<Chunk>(){

            @Override
            public int compare(Chunk one, Chunk two) {
                int result = Long.compare(two.version, one.version);
                if (result == 0) {
                    result = Long.compare(one.block, two.block);
                }
                return result;
            }
        });
        HashMap<Long, Chunk> validChunkCacheByLocation = new HashMap<Long, Chunk>();
        if (newest != null) {
            while (true) {
                validChunkCacheByLocation.put(newest.block, newest);
                lastChunkCandidates.add(newest);
                if (newest.next == 0L || newest.next >= blocksInStore || (test = this.readChunkHeaderAndFooter(newest.next)) == null || test.id <= newest.id) break;
                newest = test;
            }
        }
        boolean verified = false;
        while (!verified && this.setLastChunk((Chunk)lastChunkCandidates.poll()) != null) {
            verified = true;
            Cursor<String, String> cursor = this.meta.cursor("chunk.");
            while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                Chunk c = Chunk.fromString(cursor.getValue());
                assert (c.version <= this.currentVersion);
                this.chunks.putIfAbsent(c.id, c);
                long block = c.block;
                test = (Chunk)validChunkCacheByLocation.get(block);
                if (test == null) {
                    test = this.readChunkHeaderAndFooter(block);
                    if (test != null && test.id == c.id) {
                        validChunkCacheByLocation.put(block, test);
                        lastChunkCandidates.offer(test);
                        continue;
                    }
                } else if (test.id == c.id) continue;
                verified = false;
            }
        }
        this.fileStore.clear();
        for (Chunk c : this.chunks.values()) {
            long start = c.block * 4096L;
            int length = c.len * 4096;
            this.fileStore.markUsed(start, length);
        }
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
        this.setWriteVersion(this.currentVersion);
        if (this.lastStoredVersion == -1L) {
            this.lastStoredVersion = this.currentVersion - 1L;
        }
    }

    private Chunk setLastChunk(Chunk last) {
        this.chunks.clear();
        this.lastChunk = last;
        if (last == null) {
            this.lastMapId.set(0);
            this.currentVersion = 0L;
            this.lastStoredVersion = -1L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId.set(last.mapId);
            this.currentVersion = last.version;
            this.chunks.put(last.id, last);
            this.lastStoredVersion = this.currentVersion - 1L;
            this.meta.setRootPos(last.metaRootPos, this.lastStoredVersion);
        }
        return last;
    }

    private Chunk readChunkHeaderAndFooter(long block) {
        Chunk header;
        try {
            header = this.readChunkHeader(block);
        }
        catch (Exception e) {
            return null;
        }
        if (header == null) {
            return null;
        }
        Chunk footer = this.readChunkFooter((block + (long)header.len) * 4096L);
        if (footer == null || footer.id != header.id) {
            return null;
        }
        return header;
    }

    private Chunk readChunkFooter(long end) {
        try {
            long pos = end - 128L;
            if (pos < 0L) {
                return null;
            }
            ByteBuffer lastBlock = this.fileStore.readFully(pos, 128);
            byte[] buff = new byte[128];
            lastBlock.get(buff);
            HashMap<String, String> m4 = DataUtils.parseChecksummedMap(buff);
            if (m4 != null) {
                int chunk = DataUtils.readHexInt(m4, "chunk", 0);
                Chunk c = new Chunk(chunk);
                c.version = DataUtils.readHexLong(m4, "version", 0L);
                c.block = DataUtils.readHexLong(m4, "block", 0L);
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder buff = new StringBuilder(112);
        if (this.lastChunk != null) {
            this.storeHeader.put("block", this.lastChunk.block);
            this.storeHeader.put("chunk", this.lastChunk.id);
            this.storeHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(buff, this.storeHeader);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, "fletcher", checksum);
        buff.append('\n');
        bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer header = ByteBuffer.allocate(8192);
        header.put(bytes);
        header.position(4096);
        header.put(bytes);
        header.rewind();
        this.write(0L, header);
    }

    private void write(long pos, ByteBuffer buffer) {
        try {
            this.fileStore.writeFully(pos, buffer);
        }
        catch (IllegalStateException e) {
            this.panic(e);
        }
    }

    @Override
    public void close() {
        this.closeStore(true);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean normalShutdown) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(normalShutdown);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (normalShutdown && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> map : this.maps.values()) {
                                if (!map.isClosed() || this.meta.remove(MVMap.getMapRootKey(map.getId())) == null) continue;
                                this.markMetaChanged();
                            }
                            this.commit();
                            this.shrinkFileIfPossible(0);
                        }
                        this.state = 2;
                        if (this.cache != null) {
                            this.cache.clear();
                        }
                        if (this.cacheChunkRef != null) {
                            this.cacheChunkRef.clear();
                        }
                        for (MVMap<?, ?> m4 : new ArrayList(this.maps.values())) {
                            m4.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || this.fileStoreIsProvided) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    ByteBuffer readBufferForPage(long pos, int expectedMapId) {
        int length;
        ByteBuffer buff;
        Chunk c = this.getChunk(pos);
        long filePos = c.block * 4096L;
        if ((filePos += (long)DataUtils.getPageOffset(pos)) < 0L) {
            throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", filePos, pos, c.toString());
        }
        long maxPos = (c.block + (long)c.len) * 4096L;
        int maxLength = DataUtils.getPageMaxLength(pos);
        if (maxLength == 0x200000) {
            buff = this.fileStore.readFully(filePos, 128);
            maxLength = buff.getInt();
        }
        if ((length = (maxLength = (int)Math.min(maxPos - filePos, (long)maxLength))) < 0) {
            throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", length, filePos, maxPos);
        }
        buff = this.fileStore.readFully(filePos, length);
        int chunkId = DataUtils.getPageChunkId(pos);
        int offset = DataUtils.getPageOffset(pos);
        int start = buff.position();
        int remaining = buff.remaining();
        int pageLength = buff.getInt();
        if (pageLength > remaining || pageLength < 4) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", chunkId, remaining, pageLength);
        }
        buff.limit(start + pageLength);
        short check = buff.getShort();
        int mapId = DataUtils.readVarInt(buff);
        if (mapId != expectedMapId) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", chunkId, expectedMapId, mapId);
        }
        int checkTest = DataUtils.getCheckValue(chunkId) ^ DataUtils.getCheckValue(offset) ^ DataUtils.getCheckValue(pageLength);
        if (check != (short)checkTest) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", chunkId, checkTest, check);
        }
        return buff;
    }

    private Chunk getChunk(long pos) {
        int chunkId = DataUtils.getPageChunkId(pos);
        Chunk c = this.chunks.get(chunkId);
        if (c == null) {
            this.checkOpen();
            String s2 = this.meta.get(Chunk.getMetaKey(chunkId));
            if (s2 == null) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} not found", chunkId);
            }
            c = Chunk.fromString(s2);
            if (c.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunkId);
            }
            this.chunks.put(c.id, c);
        }
        return c;
    }

    private void setWriteVersion(long version) {
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            if (map.setWriteVersion(version) != null) continue;
            assert (map.isClosed());
            assert (map.getVersion() < this.getOldestVersionToKeep());
            this.meta.remove(MVMap.getMapRootKey(map.getId()));
            this.markMetaChanged();
            iter.remove();
        }
        this.meta.setWriteVersion(version);
        this.onVersionChange(version);
    }

    public long tryCommit() {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    private void store() {
        try {
            if (this.isOpenOrStopping() && this.hasUnsavedChangesInternal()) {
                this.currentStoreVersion = this.currentVersion;
                if (this.fileStore == null) {
                    this.lastStoredVersion = this.currentVersion++;
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
                    }
                    try {
                        this.storeNow();
                    }
                    catch (IllegalStateException e) {
                        this.panic(e);
                    }
                    catch (Throwable e) {
                        this.panic(DataUtils.newIllegalStateException(3, e.toString(), e));
                    }
                }
            }
        }
        finally {
            this.currentStoreVersion = -1L;
        }
    }

    private void storeNow() {
        boolean storeAtEndOfFile;
        Chunk old;
        int lastChunkId;
        assert (this.storeLock.isHeldByCurrentThread());
        long time = this.getTimeSinceCreation();
        this.freeUnusedIfNeeded(time);
        int currentUnsavedPageCount = this.unsavedMemory;
        long storeVersion = this.currentStoreVersion;
        long version = ++this.currentVersion;
        this.lastCommitTime = time;
        if (this.lastChunk == null) {
            lastChunkId = 0;
        } else {
            lastChunkId = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(lastChunkId), this.lastChunk.asString());
            this.markMetaChanged();
            time = Math.max(this.lastChunk.time, time);
        }
        int newChunkId = lastChunkId;
        while ((old = this.chunks.get(newChunkId = newChunkId + 1 & 0x3FFFFFF)) != null) {
            if (old.block != Long.MAX_VALUE) continue;
            IllegalStateException e = DataUtils.newIllegalStateException(3, "Last block {0} not stored, possibly due to out-of-memory", old);
            this.panic(e);
        }
        Chunk c = new Chunk(newChunkId);
        c.pageCount = Integer.MAX_VALUE;
        c.pageCountLive = Integer.MAX_VALUE;
        c.maxLen = Long.MAX_VALUE;
        c.maxLenLive = Long.MAX_VALUE;
        c.metaRootPos = Long.MAX_VALUE;
        c.block = Long.MAX_VALUE;
        c.len = Integer.MAX_VALUE;
        c.time = time;
        c.version = version;
        c.mapId = this.lastMapId.get();
        c.next = Long.MAX_VALUE;
        this.chunks.put(c.id, c);
        ArrayList<Page> changed = new ArrayList<Page>();
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            RootReference rootReference = map.setWriteVersion(version);
            if (rootReference == null) {
                assert (map.isClosed());
                assert (map.getVersion() < this.getOldestVersionToKeep());
                this.meta.remove(MVMap.getMapRootKey(map.getId()));
                iter.remove();
                continue;
            }
            if (map.getCreateVersion() > storeVersion || map.isVolatile() || !map.hasChangesSince(this.lastStoredVersion)) continue;
            assert (rootReference.version <= version) : rootReference.version + " > " + version;
            Page rootPage = rootReference.root;
            if (rootPage.isSaved() && !rootPage.isLeaf()) continue;
            changed.add(rootPage);
        }
        WriteBuffer buff = this.getWriteBuffer();
        c.writeChunkHeader(buff, 0);
        int headerLength = buff.position();
        c.pageCount = 0;
        c.pageCountLive = 0;
        c.maxLen = 0L;
        c.maxLenLive = 0L;
        for (Page p : changed) {
            String key = MVMap.getMapRootKey(p.getMapId());
            if (p.getTotalCount() == 0L) {
                this.meta.remove(key);
                continue;
            }
            p.writeUnsavedRecursive(c, buff);
            long root = p.getPos();
            this.meta.put(key, Long.toHexString(root));
        }
        this.applyFreedSpace();
        RootReference metaRootReference = this.meta.setWriteVersion(version);
        assert (metaRootReference != null);
        assert (metaRootReference.version == version) : metaRootReference.version + " != " + version;
        this.metaChanged = false;
        this.onVersionChange(version);
        Page metaRoot = metaRootReference.root;
        metaRoot.writeUnsavedRecursive(c, buff);
        int chunkLength = buff.position();
        int length = MathUtils.roundUpInt(chunkLength + 128, 4096);
        buff.limit(length);
        long filePos = this.allocateFileSpace(length, !this.reuseSpace);
        c.block = filePos / 4096L;
        c.len = length / 4096;
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + c;
        c.metaRootPos = metaRoot.getPos();
        c.next = this.reuseSpace ? this.fileStore.predictAllocation(c.len * 4096) / 4096L : 0L;
        buff.position(0);
        c.writeChunkHeader(buff, headerLength);
        buff.position(buff.limit() - 128);
        buff.put(c.getFooterBytes());
        buff.position(0);
        this.write(filePos, buff.getBuffer());
        this.releaseWriteBuffer(buff);
        boolean writeStoreHeader = false;
        boolean bl = storeAtEndOfFile = filePos + (long)length >= this.fileStore.size();
        if (!storeAtEndOfFile) {
            if (this.lastChunk == null) {
                writeStoreHeader = true;
            } else if (this.lastChunk.next != c.block) {
                writeStoreHeader = true;
            } else {
                long headerVersion = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (this.lastChunk.version - headerVersion > 20L) {
                    writeStoreHeader = true;
                } else {
                    int chunkId = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (true) {
                        Chunk old2;
                        if ((old2 = this.chunks.get(chunkId)) == null) {
                            writeStoreHeader = true;
                            break;
                        }
                        if (chunkId == this.lastChunk.id) break;
                        ++chunkId;
                    }
                }
            }
        }
        this.lastChunk = c;
        if (writeStoreHeader) {
            this.writeStoreHeader();
        }
        if (!storeAtEndOfFile) {
            this.shrinkFileIfPossible(1);
        }
        for (Page p : changed) {
            p.writeEnd();
        }
        metaRoot.writeEnd();
        this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedPageCount);
        this.lastStoredVersion = storeVersion;
    }

    private void freeUnusedIfNeeded(long time) {
        int freeDelay = this.retentionTime / 5;
        if (time - this.lastFreeUnusedChunks >= (long)freeDelay) {
            this.lastFreeUnusedChunks = time;
            this.freeUnusedChunks(true);
        }
    }

    private void freeUnusedChunks(boolean fast) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (this.lastChunk != null && this.reuseSpace) {
            Set<Integer> referenced = this.collectReferencedChunks(fast);
            long time = this.getTimeSinceCreation();
            Iterator<Chunk> iterator = this.chunks.values().iterator();
            while (iterator.hasNext()) {
                Chunk c = iterator.next();
                if (c.block == Long.MAX_VALUE || referenced.contains(c.id)) continue;
                if (this.canOverwriteChunk(c, time)) {
                    iterator.remove();
                    if (this.meta.remove(Chunk.getMetaKey(c.id)) != null) {
                        this.markMetaChanged();
                    }
                    long start = c.block * 4096L;
                    int length = c.len * 4096;
                    this.fileStore.free(start, length);
                    assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
                    continue;
                }
                if (c.unused != 0L) continue;
                c.unused = time;
                this.meta.put(Chunk.getMetaKey(c.id), c.asString());
                this.markMetaChanged();
            }
            this.lastFreeUnusedChunks = this.getTimeSinceCreation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> collectReferencedChunks(boolean fast) {
        assert (this.lastChunk != null);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.keysPerPage + 1));
        AtomicInteger executingThreadCounter = new AtomicInteger();
        try {
            ChunkIdsCollector collector = new ChunkIdsCollector(this.meta.getId());
            long oldestVersionToKeep = this.getOldestVersionToKeep();
            RootReference rootReference = this.meta.flushAndGetRoot();
            if (fast) {
                RootReference previous;
                while (rootReference.version >= oldestVersionToKeep && (previous = rootReference.previous) != null) {
                    rootReference = previous;
                }
                this.inspectVersion(rootReference, collector, executorService, executingThreadCounter, null);
                Page rootPage = rootReference.root;
                long pos = rootPage.getPos();
                assert (rootPage.isSaved());
                int chunkId = DataUtils.getPageChunkId(pos);
                while (++chunkId <= this.lastChunk.id) {
                    collector.registerChunk(chunkId);
                }
            } else {
                HashSet<Long> inspectedRoots = new HashSet<Long>();
                do {
                    this.inspectVersion(rootReference, collector, executorService, executingThreadCounter, inspectedRoots);
                } while (rootReference.version >= oldestVersionToKeep && (rootReference = rootReference.previous) != null);
            }
            Set<Integer> set = collector.getReferenced();
            return set;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void inspectVersion(RootReference rootReference, ChunkIdsCollector collector, ThreadPoolExecutor executorService, AtomicInteger executingThreadCounter, Set<Long> inspectedRoots) {
        String key;
        Page rootPage = rootReference.root;
        long pos = rootPage.getPos();
        if (rootPage.isSaved()) {
            if (inspectedRoots != null && !inspectedRoots.add(pos)) {
                return;
            }
            collector.setMapId(this.meta.getId());
            collector.visit(pos, executorService, executingThreadCounter);
        }
        Cursor c = new Cursor(rootPage, "root.");
        while (c.hasNext() && (key = c.next()).startsWith("root.")) {
            pos = DataUtils.parseHexLong((String)c.getValue());
            if (!DataUtils.isPageSaved(pos) || inspectedRoots != null && !inspectedRoots.add(pos)) continue;
            int mapId = DataUtils.parseHexInt(key.substring(key.lastIndexOf(46) + 1));
            collector.setMapId(mapId);
            collector.visit(pos, executorService, executingThreadCounter);
        }
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer buff;
        if (this.writeBuffer != null) {
            buff = this.writeBuffer;
            buff.clear();
        } else {
            buff = new WriteBuffer();
        }
        return buff;
    }

    private void releaseWriteBuffer(WriteBuffer buff) {
        if (buff.capacity() <= 0x400000) {
            this.writeBuffer = buff;
        }
    }

    private boolean canOverwriteChunk(Chunk c, long time) {
        if (this.retentionTime >= 0) {
            if (c.time + (long)this.retentionTime > time) {
                return false;
            }
            if (c.unused == 0L || c.unused + (long)(this.retentionTime / 2) > time) {
                return false;
            }
        }
        return true;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFreedSpace() {
        while (true) {
            ArrayList<Chunk> modified = new ArrayList<Chunk>();
            Map<Integer, Chunk> map = this.freedPageSpace;
            synchronized (map) {
                for (Chunk f : this.freedPageSpace.values()) {
                    Chunk c = this.chunks.get(f.id);
                    if (c == null) continue;
                    c.maxLenLive += f.maxLenLive;
                    c.pageCountLive += f.pageCountLive;
                    if (c.pageCountLive < 0 && c.pageCountLive > -10000000) {
                        c.pageCountLive = 0;
                    }
                    if (c.maxLenLive < 0L && c.maxLenLive > -10000000L) {
                        c.maxLenLive = 0L;
                    }
                    modified.add(c);
                }
                this.freedPageSpace.clear();
            }
            if (modified.isEmpty()) break;
            for (Chunk c : modified) {
                this.meta.put(Chunk.getMetaKey(c.id), c.asString());
            }
            this.markMetaChanged();
        }
    }

    private void shrinkFileIfPossible(int minPercent) {
        long fileSize;
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.fileStore.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(end);
    }

    private long getFileLengthInUse() {
        long result = this.fileStore.getFileLengthInUse();
        assert (result == this.measureFileLengthInUse()) : result + " != " + this.measureFileLengthInUse();
        return result;
    }

    private long measureFileLengthInUse() {
        long size = 2L;
        for (Chunk c : this.chunks.values()) {
            if (c.len == Integer.MAX_VALUE) continue;
            size = Math.max(size, c.block + (long)c.len);
        }
        return size * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> m4 : this.maps.values()) {
            if (m4.isClosed() || !m4.hasChangesSince(this.lastStoredVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsavedChangesInternal() {
        if (this.meta.hasChangesSince(this.lastStoredVersion)) {
            return true;
        }
        return this.hasUnsavedChanges();
    }

    private Chunk readChunkHeader(long block) {
        long p = block * 4096L;
        ByteBuffer buff = this.fileStore.readFully(p, 1024);
        return Chunk.readChunkHeader(buff, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compactRewriteFully() {
        this.storeLock.lock();
        try {
            this.checkOpen();
            if (this.lastChunk == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
            while (iterator.hasNext()) {
                MVMap<?, ?> m4;
                MVMap<?, ?> map = m4 = iterator.next();
                Cursor<Object, ?> cursor = map.cursor(null);
                Page lastPage = null;
                while (cursor.hasNext()) {
                    cursor.next();
                    Page p = cursor.getPage();
                    if (p == lastPage) continue;
                    Object k = p.getKey(0);
                    Object v = p.getValue(0);
                    map.put(k, v);
                    lastPage = p;
                }
            }
            this.commit();
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactMoveChunks(int targetFillRate, long moveSize) {
        block7: {
            this.storeLock.lock();
            try {
                this.checkOpen();
                if (this.lastChunk == null || !this.reuseSpace) break block7;
                int oldRetentionTime = this.retentionTime;
                boolean oldReuse = this.reuseSpace;
                try {
                    this.retentionTime = -1;
                    this.freeUnusedChunks(false);
                    if (this.fileStore.getFillRate() <= targetFillRate) {
                        long start = this.fileStore.getFirstFree() / 4096L;
                        ArrayList<Chunk> move = this.findChunksToMove(start, moveSize);
                        this.compactMoveChunks(move);
                    }
                }
                finally {
                    this.reuseSpace = oldReuse;
                    this.retentionTime = oldRetentionTime;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private ArrayList<Chunk> findChunksToMove(long startBlock, long moveSize) {
        ArrayList<Chunk> move = new ArrayList<Chunk>();
        for (Chunk c : this.chunks.values()) {
            if (c.block <= startBlock) continue;
            move.add(c);
        }
        Collections.sort(move, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                return Long.signum(o1.block - o2.block);
            }
        });
        int count = 0;
        long size = 0L;
        for (Chunk c : move) {
            long chunkSize = (long)c.len * 4096L;
            if ((size += chunkSize) > moveSize) break;
            ++count;
        }
        while (move.size() > count && move.size() > 1) {
            move.remove(1);
        }
        return move;
    }

    private void compactMoveChunks(ArrayList<Chunk> move) {
        for (Chunk c : move) {
            this.moveChunk(c, true);
        }
        this.reuseSpace = false;
        this.commit();
        this.sync();
        Chunk chunk = this.lastChunk;
        this.reuseSpace = true;
        for (Chunk c : move) {
            if (!this.chunks.containsKey(c.id)) continue;
            this.moveChunk(c, false);
        }
        this.commit();
        this.sync();
        if (this.chunks.containsKey(chunk.id)) {
            this.moveChunk(chunk, false);
            this.commit();
        }
        this.shrinkFileIfPossible(0);
        this.sync();
    }

    private void moveChunk(Chunk c, boolean toTheEnd) {
        WriteBuffer buff = this.getWriteBuffer();
        long start = c.block * 4096L;
        int length = c.len * 4096;
        buff.limit(length);
        ByteBuffer readBuff = this.fileStore.readFully(start, length);
        Chunk.readChunkHeader(readBuff, start);
        int chunkHeaderLen = readBuff.position();
        buff.position(chunkHeaderLen);
        buff.put(readBuff);
        long pos = this.allocateFileSpace(length, toTheEnd);
        this.fileStore.free(start, length);
        c.block = pos / 4096L;
        c.next = 0L;
        buff.position(0);
        c.writeChunkHeader(buff, chunkHeaderLen);
        buff.position(length - 128);
        buff.put(c.getFooterBytes());
        buff.position(0);
        this.write(pos, buff.getBuffer());
        this.releaseWriteBuffer(buff);
        this.meta.put(Chunk.getMetaKey(c.id), c.asString());
        this.markMetaChanged();
    }

    private long allocateFileSpace(int length, boolean atTheEnd) {
        long filePos;
        if (atTheEnd) {
            filePos = this.getFileLengthInUse();
            this.fileStore.markUsed(filePos, length);
        } else {
            filePos = this.fileStore.allocate(length);
        }
        return filePos;
    }

    public void sync() {
        this.checkOpen();
        FileStore f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(int targetFillRate, int write) {
        if (!this.reuseSpace) {
            return false;
        }
        this.checkOpen();
        try {
            if (this.storeLock.isHeldByCurrentThread()) return false;
            if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) return false;
            try {
                ArrayList<Chunk> old = this.findOldChunks(targetFillRate, write);
                if (old == null || old.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.compactRewrite(old);
                boolean bl = true;
                return bl;
            }
            finally {
                this.storeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getCurrentFillRate() {
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            maxLengthSum += c.maxLen;
            if (c.time + (long)this.retentionTime > time) {
                maxLengthLiveSum += c.maxLen;
                continue;
            }
            maxLengthLiveSum += c.maxLenLive;
        }
        if (maxLengthSum <= 0L) {
            maxLengthSum = 1L;
        }
        int fillRate = (int)(100L * maxLengthLiveSum / maxLengthSum);
        return fillRate;
    }

    private ArrayList<Chunk> findOldChunks(int targetFillRate, int write) {
        if (this.lastChunk == null) {
            return null;
        }
        long time = this.getTimeSinceCreation();
        int fillRate = this.getCurrentFillRate();
        if (fillRate >= targetFillRate) {
            return null;
        }
        ArrayList<Chunk> old = new ArrayList<Chunk>();
        Chunk last = this.chunks.get(this.lastChunk.id);
        for (Chunk c : this.chunks.values()) {
            if (c.time + (long)this.retentionTime > time) continue;
            long age = last.version - c.version + 1L;
            c.collectPriority = (int)((long)(c.getFillRate() * 1000) / Math.max(1L, age));
            old.add(c);
        }
        if (old.isEmpty()) {
            return null;
        }
        Collections.sort(old, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                int comp = Integer.compare(o1.collectPriority, o2.collectPriority);
                if (comp == 0) {
                    comp = Long.compare(o1.maxLenLive, o2.maxLenLive);
                }
                return comp;
            }
        });
        long written = 0L;
        int chunkCount = 0;
        Chunk move = null;
        for (Chunk c : old) {
            if (move != null && c.collectPriority > 0 && written > (long)write) break;
            written += c.maxLenLive;
            ++chunkCount;
            move = c;
        }
        if (chunkCount < 1) {
            return null;
        }
        boolean remove = false;
        Iterator it = old.iterator();
        while (it.hasNext()) {
            Chunk c = (Chunk)it.next();
            if (move == c) {
                remove = true;
                continue;
            }
            if (!remove) continue;
            it.remove();
        }
        return old;
    }

    private void compactRewrite(Iterable<Chunk> old) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Chunk chunk : old) {
            set.add(chunk.id);
        }
        for (MVMap mVMap : this.maps.values()) {
            MVMap map = mVMap;
            if (map.isClosed()) continue;
            map.rewrite(set);
        }
        this.meta.rewrite(set);
        this.freeUnusedChunks(false);
        this.commit();
    }

    Page readPage(MVMap<?, ?> map, long pos) {
        Page p;
        if (!DataUtils.isPageSaved(pos)) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page = p = this.cache == null ? null : this.cache.get(pos);
        if (p == null) {
            ByteBuffer buff = this.readBufferForPage(pos, map.getId());
            p = Page.read(buff, pos, map);
            this.cachePage(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePage(long pos, int memory) {
        if (!DataUtils.isPageSaved(pos)) {
            this.unsavedMemory = Math.max(0, this.unsavedMemory - memory);
            return;
        }
        int chunkId = DataUtils.getPageChunkId(pos);
        Map<Integer, Chunk> map = this.freedPageSpace;
        synchronized (map) {
            Chunk chunk = this.freedPageSpace.get(chunkId);
            if (chunk == null) {
                chunk = new Chunk(chunkId);
                this.freedPageSpace.put(chunkId, chunk);
            }
            chunk.maxLenLive -= (long)DataUtils.getPageMaxLength(pos);
            --chunk.pageCountLive;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    public void setVersionsToKeep(int count) {
        this.versionsToKeep = count;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    public long getOldestVersionToKeep() {
        long v = this.oldestVersionToKeep.get();
        if (this.fileStore == null) {
            v = Math.max(v - (long)this.versionsToKeep + 1L, -1L);
            return v;
        }
        long storeVersion = this.currentStoreVersion;
        if (storeVersion != -1L && storeVersion < v) {
            v = storeVersion;
        }
        return v;
    }

    private void setOldestVersionToKeep(long oldestVersionToKeep) {
        long current;
        boolean success;
        while (!(success = oldestVersionToKeep <= (current = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(current, oldestVersionToKeep))) {
        }
    }

    private boolean isKnownVersion(long version) {
        if (version > this.currentVersion || version < 0L) {
            return false;
        }
        if (version == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk c = this.getChunkForVersion(version);
        if (c == null) {
            return false;
        }
        MVMap<String, String> oldMeta = this.getMetaMap(version);
        if (oldMeta == null) {
            return false;
        }
        try {
            String chunkKey;
            Iterator<String> it = oldMeta.keyIterator("chunk.");
            while (it.hasNext() && (chunkKey = it.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(chunkKey)) continue;
                String s2 = oldMeta.get(chunkKey);
                Chunk c2 = Chunk.fromString(s2);
                Chunk test = this.readChunkHeaderAndFooter(c2.block);
                if (test != null && test.id == c2.id) continue;
                return false;
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public void registerUnsavedPage(int memory) {
        this.unsavedMemory += memory;
        int newValue = this.unsavedMemory;
        if (newValue > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    public boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> map) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping()) {
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                if (3 * this.unsavedMemory > 4 * this.autoCommitMemory) {
                    this.commit();
                } else {
                    this.tryCommit();
                }
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String x = this.meta.get("setting.storeVersion");
        return x == null ? 0 : DataUtils.parseHexInt(x);
    }

    public void setStoreVersion(int version) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(version));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long version) {
        this.storeLock.lock();
        try {
            TxCounter txCounter;
            this.checkOpen();
            if (version == 0L) {
                for (MVMap<?, ?> m4 : this.maps.values()) {
                    m4.close();
                }
                this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                this.chunks.clear();
                if (this.fileStore != null) {
                    this.fileStore.clear();
                }
                this.maps.clear();
                this.lastChunk = null;
                Map<Integer, Chunk> map = this.freedPageSpace;
                synchronized (map) {
                    this.freedPageSpace.clear();
                }
                this.versions.clear();
                this.currentVersion = version;
                this.setWriteVersion(version);
                this.metaChanged = false;
                this.lastStoredVersion = -1L;
                return;
            }
            DataUtils.checkArgument(this.isKnownVersion(version), "Unknown version {0}", version);
            for (MVMap<?, ?> m5 : this.maps.values()) {
                m5.rollbackTo(version);
            }
            while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= version) {
                this.versions.removeLast();
            }
            this.currentTxCounter = new TxCounter(version);
            this.meta.rollbackTo(version);
            this.metaChanged = false;
            boolean loadFromFile = false;
            ArrayList<Integer> remove = new ArrayList<Integer>();
            Chunk keep = null;
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.version > version) {
                    remove.add(chunk.id);
                    continue;
                }
                if (keep != null && keep.id >= chunk.id) continue;
                keep = chunk;
            }
            if (!remove.isEmpty()) {
                Collections.sort(remove, Collections.reverseOrder());
                loadFromFile = true;
                Iterator<Object> iterator = remove.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    Chunk c = this.chunks.remove(n);
                    long start = c.block * 4096L;
                    int length = c.len * 4096;
                    this.fileStore.free(start, length);
                    assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
                    WriteBuffer buff = this.getWriteBuffer();
                    buff.limit(length);
                    Arrays.fill(buff.getBuffer().array(), (byte)0);
                    this.write(start, buff.getBuffer());
                    this.releaseWriteBuffer(buff);
                    this.sync();
                }
                this.lastChunk = keep;
                this.writeStoreHeader();
                this.readStoreHeader();
            }
            for (MVMap mVMap : new ArrayList(this.maps.values())) {
                int id = mVMap.getId();
                if (mVMap.getCreateVersion() >= version) {
                    mVMap.close();
                    this.maps.remove(id);
                    continue;
                }
                if (loadFromFile) {
                    mVMap.setRootPos(MVStore.getRootPos(this.meta, id), version);
                    continue;
                }
                mVMap.rollbackRoot(version);
            }
            this.currentVersion = version;
            if (this.lastStoredVersion == -1L) {
                this.lastStoredVersion = this.currentVersion - 1L;
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private static long getRootPos(MVMap<String, String> map, int mapId) {
        String root = map.get(MVMap.getMapRootKey(mapId));
        return root == null ? 0L : DataUtils.parseHexLong(root);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public long getLastStoredVersion() {
        return this.lastStoredVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> map, String newName) {
        this.checkOpen();
        DataUtils.checkArgument(map != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int id = map.getId();
        String oldName = this.getMapName(id);
        if (oldName != null && !oldName.equals(newName)) {
            String idHexStr = Integer.toHexString(id);
            String existingIdHexStr = this.meta.putIfAbsent("name." + newName, idHexStr);
            DataUtils.checkArgument(existingIdHexStr == null || existingIdHexStr.equals(idHexStr), "A map named {0} already exists", newName);
            this.meta.put(MVMap.getMapKey(id), map.asString(newName));
            this.meta.remove("name." + oldName);
            this.markMetaChanged();
        }
    }

    public void removeMap(MVMap<?, ?> map) {
        this.removeMap(map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> map, boolean delayed) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(map != this.meta, "Removing the meta map is not allowed", new Object[0]);
            map.close();
            RootReference rootReference = map.getRoot();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int id = map.getId();
            String name = this.getMapName(id);
            this.removeMap(name, id, delayed);
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private void removeMap(String name, int id, boolean delayed) {
        if (this.meta.remove(MVMap.getMapKey(id)) != null) {
            this.markMetaChanged();
        }
        if (this.meta.remove("name." + name) != null) {
            this.markMetaChanged();
        }
        if (!delayed) {
            if (this.meta.remove(MVMap.getMapRootKey(id)) != null) {
                this.markMetaChanged();
            }
            this.maps.remove(id);
        }
    }

    public void removeMap(String name) {
        int id = this.getMapId(name);
        if (id > 0) {
            this.removeMap(name, id, false);
        }
    }

    public String getMapName(int id) {
        this.checkOpen();
        String m4 = this.meta.get(MVMap.getMapKey(id));
        return m4 == null ? null : DataUtils.getMapName(m4);
    }

    private int getMapId(String name) {
        String m4 = this.meta.get("name." + name);
        return m4 == null ? -1 : DataUtils.parseHexInt(m4);
    }

    void writeInBackground() {
        try {
            if (!this.isOpenOrStopping()) {
                return;
            }
            long time = this.getTimeSinceCreation();
            if (time <= this.lastCommitTime + (long)this.autoCommitDelay) {
                return;
            }
            this.tryCommit();
            if (this.autoCompactFillRate > 0) {
                long fileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                boolean fileOps = this.autoCompactLastFileOpCount != fileOpCount;
                int targetFillRate = fileOps ? this.autoCompactFillRate / 3 : this.autoCompactFillRate;
                this.compact(targetFillRate, this.autoCommitMemory);
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable ex) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), ex);
                }
                catch (Throwable ignore) {
                    if (ex == ignore) break block3;
                    ex.addSuppressed(ignore);
                }
            }
        }
    }

    public void setCacheSize(int mb) {
        long bytes = (long)mb * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(bytes);
            this.cache.clear();
        }
        if (this.cacheChunkRef != null) {
            this.cacheChunkRef.setMaxMemory(bytes / 4L);
            this.cacheChunkRef.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            assert (this.state == 3);
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean waitForIt) {
        BackgroundWriterThread t2;
        while ((t2 = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(t2, null)) continue;
            if (t2 == Thread.currentThread()) break;
            Object object = t2.sync;
            synchronized (object) {
                t2.sync.notifyAll();
            }
            if (!waitForIt) break;
            try {
                t2.join();
            }
            catch (Exception exception) {}
            break;
        }
    }

    public void setAutoCommitDelay(int millis) {
        int sleep;
        BackgroundWriterThread t2;
        if (this.autoCommitDelay == millis) {
            return;
        }
        this.autoCommitDelay = millis;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (millis > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, t2 = new BackgroundWriterThread(this, sleep = Math.max(1, millis / 10), this.fileStore.toString()))) {
            t2.start();
        }
    }

    boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public double getUpdateFailureRatio() {
        long updateCounter = this.updateCounter;
        long updateAttemptCounter = this.updateAttemptCounter;
        RootReference rootReference = this.meta.getRoot();
        updateCounter += rootReference.updateCounter;
        updateAttemptCounter += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> map : this.maps.values()) {
            RootReference root = map.getRoot();
            updateCounter += root.updateCounter;
            updateAttemptCounter += root.updateAttemptCounter;
        }
        return updateAttemptCounter == 0L ? 0.0 : 1.0 - (double)updateCounter / (double)updateAttemptCounter;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while (true) {
            txCounter = this.currentTxCounter;
            if (txCounter.counter.getAndIncrement() >= 0) break;
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.counter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (txCounter != null && txCounter.counter.decrementAndGet() <= 0 && !this.storeLock.isHeldByCurrentThread() && this.storeLock.tryLock()) {
            try {
                this.dropUnusedVersions();
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private void onVersionChange(long version) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.counter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(version);
        txCounter.counter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.counter.get() < 0) {
            this.versions.poll();
        }
        this.setOldestVersionToKeep(txCounter != null ? txCounter.version : this.currentTxCounter.version);
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> config) {
            this.config = config;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int kb) {
            return this.set("autoCommitBufferSize", kb);
        }

        public Builder autoCompactFillRate(int percent) {
            return this.set("autoCompactFillRate", percent);
        }

        public Builder fileName(String fileName) {
            return this.set("fileName", fileName);
        }

        public Builder encryptionKey(char[] password) {
            return this.set("encryptionKey", password);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int mb) {
            return this.set("cacheSize", mb);
        }

        public Builder cacheConcurrency(int concurrency) {
            return this.set("cacheConcurrency", concurrency);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int pageSplitSize) {
            return this.set("pageSplitSize", pageSplitSize);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            return this.set("backgroundExceptionHandler", exceptionHandler);
        }

        public Builder fileStore(FileStore store) {
            return this.set("fileStore", store);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String s2) {
            return new Builder(DataUtils.parseMap(s2));
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore store, int sleep, String fileStoreName) {
            super("MVStore background writer " + fileStoreName);
            this.store = store;
            this.sleep = sleep;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        public final AtomicInteger counter = new AtomicInteger();

        TxCounter(long version) {
            this.version = version;
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }

    final class ChunkIdsCollector {
        private final ConcurrentHashMap<Integer, Integer> referencedChunks = new ConcurrentHashMap();
        private final ChunkIdsCollector parent;
        private int mapId;

        ChunkIdsCollector(int mapId) {
            this.parent = null;
            this.mapId = mapId;
        }

        private ChunkIdsCollector(ChunkIdsCollector parent) {
            this.parent = parent;
            this.mapId = parent.mapId;
        }

        public int getMapId() {
            return this.mapId;
        }

        public void setMapId(int mapId) {
            this.mapId = mapId;
        }

        public Set<Integer> getReferenced() {
            return new HashSet<Integer>(this.referencedChunks.keySet());
        }

        public void visit(Page page, ThreadPoolExecutor executorService, AtomicInteger executingThreadCounter) {
            int count;
            long pos = page.getPos();
            if (DataUtils.isPageSaved(pos)) {
                this.registerChunk(DataUtils.getPageChunkId(pos));
            }
            if ((count = page.map.getChildPageCount(page)) == 0) {
                return;
            }
            ChunkIdsCollector childCollector = DataUtils.isPageSaved(pos) && MVStore.this.cacheChunkRef != null ? new ChunkIdsCollector(this) : this;
            for (int i = 0; i < count; ++i) {
                Page childPage = page.getChildPageIfLoaded(i);
                if (childPage != null) {
                    childCollector.visit(childPage, executorService, executingThreadCounter);
                    continue;
                }
                childCollector.visit(page.getChildPagePos(i), executorService, executingThreadCounter);
            }
            this.cacheCollectedChunkIds(pos, childCollector);
        }

        public void visit(long pos, ThreadPoolExecutor executorService, AtomicInteger executingThreadCounter) {
            int[] chunkIds;
            if (!DataUtils.isPageSaved(pos)) {
                return;
            }
            this.registerChunk(DataUtils.getPageChunkId(pos));
            if (DataUtils.getPageType(pos) == 0) {
                return;
            }
            if (MVStore.this.cacheChunkRef != null && (chunkIds = MVStore.this.cacheChunkRef.get(pos)) != null) {
                for (int chunkId : chunkIds) {
                    this.registerChunk(chunkId);
                }
            } else {
                Page page;
                ChunkIdsCollector childCollector;
                ChunkIdsCollector chunkIdsCollector = childCollector = MVStore.this.cacheChunkRef != null ? new ChunkIdsCollector(this) : this;
                if (MVStore.this.cache != null && (page = MVStore.this.cache.get(pos)) != null) {
                    childCollector.visit(page, executorService, executingThreadCounter);
                } else {
                    ByteBuffer buff = MVStore.this.readBufferForPage(pos, this.getMapId());
                    Page.readChildrenPositions(buff, pos, childCollector, executorService, executingThreadCounter);
                }
                this.cacheCollectedChunkIds(pos, childCollector);
            }
        }

        void registerChunk(int chunkId) {
            if (this.referencedChunks.put(chunkId, 1) == null && this.parent != null) {
                this.parent.registerChunk(chunkId);
            }
        }

        private void cacheCollectedChunkIds(long pos, ChunkIdsCollector childCollector) {
            if (childCollector != this) {
                int[] chunkIds = new int[childCollector.referencedChunks.size()];
                int index = 0;
                for (Integer chunkId : childCollector.referencedChunks.keySet()) {
                    chunkIds[index++] = chunkId;
                }
                MVStore.this.cacheChunkRef.put(pos, chunkIds, 24 + 4 * chunkIds.length);
            }
        }
    }
}

