/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.message;

import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.message.TraceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceWriterAdapter
implements TraceWriter {
    private String name;
    private final Logger logger = LoggerFactory.getLogger("h2database");

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEnabled(int level) {
        switch (level) {
            case 3: {
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isInfoEnabled();
            }
            case 1: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void write(int level, int moduleId, String s2, Throwable t2) {
        this.write(level, Trace.MODULE_NAMES[moduleId], s2, t2);
    }

    @Override
    public void write(int level, String module, String s2, Throwable t2) {
        if (this.isEnabled(level)) {
            s2 = this.name != null ? this.name + ":" + module + " " + s2 : module + " " + s2;
            switch (level) {
                case 3: {
                    this.logger.debug(s2, t2);
                    break;
                }
                case 2: {
                    this.logger.info(s2, t2);
                    break;
                }
                case 1: {
                    this.logger.error(s2, t2);
                    break;
                }
            }
        }
    }
}

