/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jmx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.gridgain.internal.h2.util.Utils;

public class DocumentedMBean
extends StandardMBean {
    private final String interfaceName;
    private Properties resources;

    public <T> DocumentedMBean(T impl2, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl2, mbeanInterface);
        this.interfaceName = impl2.getClass().getName() + "MBean";
    }

    private Properties getResources() {
        if (this.resources == null) {
            this.resources = new Properties();
            String resourceName = "/org/gridgain/internal/h2/res/javadoc.properties";
            try {
                byte[] buff = Utils.getResource(resourceName);
                if (buff != null) {
                    this.resources.load(new ByteArrayInputStream(buff));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.resources;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String s2 = this.getResources().getProperty(this.interfaceName);
        return s2 == null ? super.getDescription(info) : s2;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        String s2 = this.getResources().getProperty(this.interfaceName + "." + op.getName());
        return s2 == null ? super.getDescription(op) : s2;
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String prefix = info.isIs() ? "is" : "get";
        String s2 = this.getResources().getProperty(this.interfaceName + "." + prefix + info.getName());
        return s2 == null ? super.getDescription(info) : s2;
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        if (info.getName().startsWith("list")) {
            return 0;
        }
        return 1;
    }
}

