/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jmx;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.engine.Constants;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.jmx.DatabaseInfoMBean;
import org.gridgain.internal.h2.jmx.DocumentedMBean;
import org.gridgain.internal.h2.store.PageStore;
import org.gridgain.internal.h2.table.Table;

public class DatabaseInfo
implements DatabaseInfoMBean {
    private static final Map<String, ObjectName> MBEANS = new HashMap<String, ObjectName>();
    private final Database database;

    private DatabaseInfo(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' must not be null");
        }
        this.database = database;
    }

    private static ObjectName getObjectName(String name, String path) throws JMException {
        name = name.replace(':', '_');
        path = path.replace(':', '_');
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("name", name);
        map.put("path", path);
        return new ObjectName("org.gridgain.internal.h2", map);
    }

    public static void registerMBean(ConnectionInfo connectionInfo, Database database) throws JMException {
        String path = connectionInfo.getName();
        if (!MBEANS.containsKey(path)) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            String name = database.getShortName();
            ObjectName mbeanObjectName = DatabaseInfo.getObjectName(name, path);
            MBEANS.put(path, mbeanObjectName);
            DatabaseInfo info = new DatabaseInfo(database);
            DocumentedMBean mbean = new DocumentedMBean(info, DatabaseInfoMBean.class);
            mbeanServer.registerMBean(mbean, mbeanObjectName);
        }
    }

    public static void unregisterMBean(String name) throws Exception {
        ObjectName mbeanObjectName = MBEANS.remove(name);
        if (mbeanObjectName != null) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.unregisterMBean(mbeanObjectName);
        }
    }

    @Override
    public boolean isExclusive() {
        return this.database.getExclusiveSession() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public String getMode() {
        return this.database.getMode().getName();
    }

    @Override
    public boolean isMultiThreaded() {
        return this.database.isMultiThreaded();
    }

    @Override
    @Deprecated
    public boolean isMvcc() {
        return this.database.isMVStore();
    }

    @Override
    public int getLogMode() {
        return this.database.getLogMode();
    }

    @Override
    public void setLogMode(int value) {
        this.database.setLogMode(value);
    }

    @Override
    public int getTraceLevel() {
        return this.database.getTraceSystem().getLevelFile();
    }

    @Override
    public void setTraceLevel(int level) {
        this.database.getTraceSystem().setLevelFile(level);
    }

    @Override
    public long getFileWriteCountTotal() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getWriteCountTotal();
        }
        return 0L;
    }

    @Override
    public long getFileWriteCount() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getWriteCount();
        }
        return this.database.getStore().getMvStore().getFileStore().getReadCount();
    }

    @Override
    public long getFileReadCount() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getReadCount();
        }
        return this.database.getStore().getMvStore().getFileStore().getReadCount();
    }

    @Override
    public long getFileSize() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getPageCount() * p.getPageSize() / 1024;
        }
        return this.database.getStore().getMvStore().getFileStore().size();
    }

    @Override
    public int getCacheSizeMax() {
        if (!this.database.isPersistent()) {
            return 0;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getCache().getMaxMemory();
        }
        return this.database.getStore().getMvStore().getCacheSize() * 1024;
    }

    @Override
    public void setCacheSizeMax(int kb) {
        if (this.database.isPersistent()) {
            this.database.setCacheSize(kb);
        }
    }

    @Override
    public int getCacheSize() {
        if (!this.database.isPersistent()) {
            return 0;
        }
        PageStore p = this.database.getPageStore();
        if (p != null) {
            return p.getCache().getMemory();
        }
        return this.database.getStore().getMvStore().getCacheSizeUsed() * 1024;
    }

    @Override
    public String getVersion() {
        return Constants.getFullVersion();
    }

    @Override
    public String listSettings() {
        StringBuilder buff = new StringBuilder();
        for (Map.Entry<String, String> e : new TreeMap<String, String>(this.database.getSettings().getSettings()).entrySet()) {
            buff.append(e.getKey()).append(" = ").append(e.getValue()).append('\n');
        }
        return buff.toString();
    }

    @Override
    public String listSessions() {
        StringBuilder buff = new StringBuilder();
        for (Session session : this.database.getSessions(false)) {
            Table[] t2;
            buff.append("session id: ").append(session.getId());
            buff.append(" user: ").append(session.getUser().getName()).append('\n');
            buff.append("connected: ").append(new Timestamp(session.getSessionStart())).append('\n');
            Command command = session.getCurrentCommand();
            if (command != null) {
                buff.append("statement: ").append(command).append('\n').append("started: ").append(session.getCurrentCommandStart().getString()).append('\n');
            }
            if ((t2 = session.getLocks()).length > 0) {
                for (Table table : session.getLocks()) {
                    if (table.isLockedExclusivelyBy(session)) {
                        buff.append("write lock on ");
                    } else {
                        buff.append("read lock on ");
                    }
                    buff.append(table.getSchema().getName()).append('.').append(table.getName()).append('\n');
                }
            }
            buff.append('\n');
        }
        return buff.toString();
    }
}

