/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.RangeCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.RangeTable;
import org.gridgain.internal.h2.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable table, IndexColumn[] columns) {
        super(table, 0, "RANGE_INDEX", columns, IndexType.createNonUnique(true));
        this.rangeTable = table;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        long v2;
        long min2 = this.rangeTable.getMin(session);
        long max = this.rangeTable.getMax(session);
        long step = this.rangeTable.getStep(session);
        if (first != null) {
            try {
                v2 = first.getValue(0).getLong();
                if (step > 0L) {
                    if (v2 > min2) {
                        min2 += (v2 - min2 + step - 1L) / step * step;
                    }
                } else if (v2 > max) {
                    max = v2;
                }
            }
            catch (DbException v2) {
                // empty catch block
            }
        }
        if (last != null) {
            try {
                v2 = last.getValue(0).getLong();
                if (step > 0L) {
                    if (v2 < max) {
                        max = v2;
                    }
                } else if (v2 < min2) {
                    min2 -= (min2 - v2 - step - 1L) / step * step;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return new RangeCursor(session, min2, max, step);
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        long pos = first ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, pos, pos);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rangeTable.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

