/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IntervalUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

final class Percentile {
    static final BigDecimal HALF = BigDecimal.valueOf(0.5);

    private static boolean isNullsLast(Index index) {
        IndexColumn ic = index.getIndexColumns()[0];
        int sortType = ic.sortType;
        return (sortType & 4) != 0 || (sortType & 2) == 0 && (sortType & 1) != 0 ^ SysProperties.SORT_NULLS_HIGH;
    }

    static Index getColumnIndex(Expression on) {
        if (on instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)on;
            Column column = col.getColumn();
            TableFilter filter = col.getTableFilter();
            if (filter != null) {
                Table table = filter.getTable();
                ArrayList<Index> indexes = table.getIndexes();
                Index result = null;
                if (indexes != null) {
                    boolean nullable = column.isNullable();
                    int size = indexes.size();
                    for (int i = 1; i < size; ++i) {
                        Index index = indexes.get(i);
                        if (!index.canFindNext() || !index.isFirstColumn(column) || result != null && result.getColumns().length <= index.getColumns().length && (!nullable || !Percentile.isNullsLast(result) || Percentile.isNullsLast(index))) continue;
                        result = index;
                    }
                }
                return result;
            }
        }
        return null;
    }

    static Value getValue(Database database, Value[] array, int dataType, ArrayList<SelectOrderBy> orderByList, BigDecimal percentile, boolean interpolate) {
        int rowIdx2;
        CompareMode compareMode = database.getCompareMode();
        Arrays.sort(array, compareMode);
        int count = array.length;
        boolean reverseIndex = orderByList != null && (orderByList.get((int)0).sortType & 1) != 0;
        BigDecimal fpRow = BigDecimal.valueOf(count - 1).multiply(percentile);
        int rowIdx1 = fpRow.intValue();
        BigDecimal factor = fpRow.subtract(BigDecimal.valueOf(rowIdx1));
        if (factor.signum() == 0) {
            interpolate = false;
            rowIdx2 = rowIdx1;
        } else {
            rowIdx2 = rowIdx1 + 1;
            if (!interpolate) {
                if (factor.compareTo(HALF) > 0) {
                    rowIdx1 = rowIdx2;
                } else {
                    rowIdx2 = rowIdx1;
                }
            }
        }
        if (reverseIndex) {
            rowIdx1 = count - 1 - rowIdx1;
            rowIdx2 = count - 1 - rowIdx2;
        }
        Value v = array[rowIdx1];
        if (!interpolate) {
            return v.convertTo(dataType);
        }
        return Percentile.interpolate(v, array[rowIdx2], factor, dataType, database.getMode(), compareMode);
    }

    static Value getFromIndex(Session session, Expression expression, int dataType, ArrayList<SelectOrderBy> orderByList, BigDecimal percentile, boolean interpolate) {
        long rowIdx2;
        long rowIdx1;
        Index index = Percentile.getColumnIndex(expression);
        long count = index.getRowCount(session);
        if (count == 0L) {
            return ValueNull.INSTANCE;
        }
        Cursor cursor = index.find(session, null, null);
        cursor.next();
        int columnId = index.getColumns()[0].getColumnId();
        ExpressionColumn expr = (ExpressionColumn)expression;
        if (expr.getColumn().isNullable()) {
            boolean hasNulls = false;
            while (count > 0L) {
                SearchRow row = cursor.getSearchRow();
                if (row == null) {
                    return ValueNull.INSTANCE;
                }
                if (row.getValue(columnId) != ValueNull.INSTANCE) break;
                --count;
                cursor.next();
                hasNulls = true;
            }
            if (count == 0L) {
                return ValueNull.INSTANCE;
            }
            if (!hasNulls && Percentile.isNullsLast(index)) {
                TableFilter tableFilter = expr.getTableFilter();
                SearchRow check = tableFilter.getTable().getTemplateSimpleRow(true);
                check.setValue(columnId, ValueNull.INSTANCE);
                Cursor nullsCursor = index.find(session, check, check);
                while (nullsCursor.next()) {
                    --count;
                }
                if (count <= 0L) {
                    return ValueNull.INSTANCE;
                }
            }
        }
        boolean reverseIndex = (orderByList != null ? orderByList.get((int)0).sortType & 1 : 0) != (index.getIndexColumns()[0].sortType & 1);
        BigDecimal fpRow = BigDecimal.valueOf(count - 1L).multiply(percentile);
        BigDecimal factor = fpRow.subtract(BigDecimal.valueOf(rowIdx1 = fpRow.longValue()));
        if (factor.signum() == 0) {
            interpolate = false;
            rowIdx2 = rowIdx1;
        } else {
            rowIdx2 = rowIdx1 + 1L;
            if (!interpolate) {
                if (factor.compareTo(HALF) > 0) {
                    rowIdx1 = rowIdx2;
                } else {
                    rowIdx2 = rowIdx1;
                }
            }
        }
        long skip = reverseIndex ? count - 1L - rowIdx2 : rowIdx1;
        int i = 0;
        while ((long)i < skip) {
            cursor.next();
            ++i;
        }
        SearchRow row = cursor.getSearchRow();
        if (row == null) {
            return ValueNull.INSTANCE;
        }
        Value v = row.getValue(columnId);
        if (v == ValueNull.INSTANCE) {
            return v;
        }
        if (interpolate) {
            cursor.next();
            row = cursor.getSearchRow();
            if (row == null) {
                return v;
            }
            Value v2 = row.getValue(columnId);
            if (v2 == ValueNull.INSTANCE) {
                return v;
            }
            Database database = session.getDatabase();
            if (reverseIndex) {
                Value t2 = v;
                v = v2;
                v2 = t2;
            }
            return Percentile.interpolate(v, v2, factor, dataType, database.getMode(), database.getCompareMode());
        }
        return v.convertTo(dataType);
    }

    private static Value interpolate(Value v0, Value v1, BigDecimal factor, int dataType, Mode databaseMode, CompareMode compareMode) {
        if (v0.compareTo(v1, databaseMode, compareMode) == 0) {
            return v0.convertTo(dataType);
        }
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(v0.getInt()), BigDecimal.valueOf(v1.getInt()), factor));
            }
            case 5: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(v0.getLong()), BigDecimal.valueOf(v1.getLong()), factor));
            }
            case 6: {
                return ValueDecimal.get(Percentile.interpolateDecimal(v0.getBigDecimal(), v1.getBigDecimal(), factor));
            }
            case 7: 
            case 8: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(v0.getDouble()), BigDecimal.valueOf(v1.getDouble()), factor));
            }
            case 9: {
                ValueTime t0 = (ValueTime)v0.convertTo(9);
                ValueTime t1 = (ValueTime)v1.convertTo(9);
                BigDecimal n0 = BigDecimal.valueOf(t0.getNanos());
                BigDecimal n1 = BigDecimal.valueOf(t1.getNanos());
                return ValueTime.fromNanos(Percentile.interpolateDecimal(n0, n1, factor).longValue());
            }
            case 10: {
                ValueDate d0 = (ValueDate)v0.convertTo(10);
                ValueDate d1 = (ValueDate)v1.convertTo(10);
                BigDecimal a0 = BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(d0.getDateValue()));
                BigDecimal a1 = BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(d1.getDateValue()));
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(Percentile.interpolateDecimal(a0, a1, factor).longValue()));
            }
            case 11: {
                ValueTimestamp ts0 = (ValueTimestamp)v0.convertTo(11);
                ValueTimestamp ts1 = (ValueTimestamp)v1.convertTo(11);
                BigDecimal a0 = Percentile.timestampToDecimal(ts0.getDateValue(), ts0.getTimeNanos());
                BigDecimal a1 = Percentile.timestampToDecimal(ts1.getDateValue(), ts1.getTimeNanos());
                BigInteger[] dr = Percentile.interpolateDecimal(a0, a1, factor).toBigInteger().divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                long absoluteDay = dr[0].longValue();
                long timeNanos = dr[1].longValue();
                if (timeNanos < 0L) {
                    timeNanos += 86400000000000L;
                    --absoluteDay;
                }
                return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos);
            }
            case 24: {
                ValueTimestampTimeZone ts0 = (ValueTimestampTimeZone)v0.convertTo(24);
                ValueTimestampTimeZone ts1 = (ValueTimestampTimeZone)v1.convertTo(24);
                BigDecimal a0 = Percentile.timestampToDecimal(ts0.getDateValue(), ts0.getTimeNanos());
                BigDecimal a1 = Percentile.timestampToDecimal(ts1.getDateValue(), ts1.getTimeNanos());
                BigDecimal offset = BigDecimal.valueOf(ts0.getTimeZoneOffsetMins()).multiply(BigDecimal.ONE.subtract(factor)).add(BigDecimal.valueOf(ts1.getTimeZoneOffsetMins()).multiply(factor));
                short shortOffset = offset.shortValue();
                BigDecimal shortOffsetBD = BigDecimal.valueOf(shortOffset);
                BigDecimal bd = Percentile.interpolateDecimal(a0, a1, factor);
                if (offset.compareTo(shortOffsetBD) != 0) {
                    bd = bd.add(offset.subtract(shortOffsetBD).multiply(BigDecimal.valueOf(60000000000L)));
                }
                BigInteger[] dr = bd.toBigInteger().divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                long absoluteDay = dr[0].longValue();
                long timeNanos = dr[1].longValue();
                if (timeNanos < 0L) {
                    timeNanos += 86400000000000L;
                    --absoluteDay;
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos, shortOffset);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(dataType - 26), Percentile.interpolateDecimal(new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)v0)), new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)v1)), factor).toBigInteger());
            }
        }
        return (factor.compareTo(HALF) > 0 ? v1 : v0).convertTo(dataType);
    }

    private static BigDecimal timestampToDecimal(long dateValue, long timeNanos) {
        return new BigDecimal(BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(dateValue)).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(timeNanos)));
    }

    private static BigDecimal interpolateDecimal(BigDecimal d0, BigDecimal d1, BigDecimal factor) {
        return d0.multiply(BigDecimal.ONE.subtract(factor)).add(d1.multiply(factor));
    }

    private Percentile() {
    }
}

