/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public class AggregateDataDefault
extends AggregateData {
    private final AggregateType aggregateType;
    private final int dataType;
    private long count;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(AggregateType aggregateType, int dataType) {
        this.aggregateType = aggregateType;
        this.dataType = dataType;
    }

    private AggregateDataDefault(AggregateType aggregateType, int dataType, long count, double m22, double mean, Value value) {
        this.aggregateType = aggregateType;
        this.dataType = dataType;
        this.count = count;
        this.value = value;
        this.m2 = m22;
        this.mean = mean;
    }

    @Override
    void add(Session ses, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                v = v.convertTo(this.value.getValueType());
                this.value = this.value.add(v);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = v.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                v = v.convertTo(this.value.getValueType());
                this.value = this.value.add(v);
                break;
            }
            case MIN: {
                if (this.value != null && ses.getDatabase().compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case MAX: {
                if (this.value != null && ses.getDatabase().compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double x = v.getDouble();
                if (this.count == 1L) {
                    this.mean = x;
                    this.m2 = 0.0;
                    break;
                }
                double delta = x - this.mean;
                this.mean += delta / (double)this.count;
                this.m2 += delta * (x - this.mean);
                break;
            }
            case EVERY: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && v.getBoolean());
                break;
            }
            case ANY: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || v.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & v.getLong()).convertTo(this.dataType);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | v.getLong()).convertTo(this.dataType);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    public void mergeAggregate(Session ses, AggregateData agg) {
        assert (agg != null);
        assert (agg instanceof AggregateDataDefault) : agg.getClass();
        assert (((AggregateDataDefault)agg).aggregateType == this.aggregateType) : "this=" + (Object)((Object)this.aggregateType) + ", other=" + (Object)((Object)((AggregateDataDefault)agg).aggregateType);
        AggregateDataDefault a = (AggregateDataDefault)agg;
        Value v = a.value;
        if (v == ValueNull.INSTANCE || a.count == 0L) {
            return;
        }
        this.count += a.count;
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                v = v.convertTo(this.value.getValueType());
                this.value = this.value.add(v);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = v.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                v = v.convertTo(this.value.getValueType());
                this.value = this.value.add(v);
                break;
            }
            case MIN: {
                if (this.value != null && ses.getDatabase().compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case MAX: {
                if (this.value != null && ses.getDatabase().compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                throw DbException.throwInternalError(" aggregate merging is not supported: type=" + (Object)((Object)this.aggregateType));
            }
            case EVERY: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && v.getBoolean());
                break;
            }
            case ANY: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || v.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & v.getLong()).convertTo(this.dataType);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | v.getLong()).convertTo(this.dataType);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int dataType) {
        Value v = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case EVERY: 
            case ANY: 
            case BIT_AND: 
            case BIT_OR: {
                v = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                v = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return v == null ? ValueNull.INSTANCE : v.convertTo(dataType);
    }

    private static Value divide(Value a, long by) {
        if (by == 0L) {
            return ValueNull.INSTANCE;
        }
        int type = Value.getHigherOrder(a.getValueType(), 5);
        Value b = ValueLong.get(by).convertTo(type);
        a = a.convertTo(type).divide(b);
        return a;
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public int dataType() {
        return this.dataType;
    }

    public long count() {
        return this.count;
    }

    public Value value() {
        return this.value;
    }

    public double mean() {
        return this.mean;
    }

    public double m2() {
        return this.m2;
    }

    public static AggregateDataDefault from(AggregateType aggregateType, int dataType, long count, double m22, double mean, Value value) {
        return new AggregateDataDefault(aggregateType, dataType, count, m22, mean, value);
    }

    @Override
    public long getMemory() {
        return 24 + (this.value == null ? 0 : this.value.getMemory()) + 4 + 32;
    }
}

