/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Subquery;
import org.gridgain.internal.h2.expression.aggregate.AbstractAggregate;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCollecting;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataDefault;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataEnvelope;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.expression.aggregate.LongDataCounter;
import org.gridgain.internal.h2.expression.aggregate.Percentile;
import org.gridgain.internal.h2.expression.analysis.Window;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVSpatialIndex;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueString;

public class Aggregate
extends AbstractAggregate {
    private static final HashMap<String, AggregateType> AGGREGATES = new HashMap(64);
    private final AggregateType aggregateType;
    private ArrayList<SelectOrderBy> orderByList;
    private SortOrder orderBySort;

    public Aggregate(AggregateType aggregateType, Expression[] args, Select select, boolean distinct) {
        super(select, args, distinct);
        if (distinct && aggregateType == AggregateType.COUNT_ALL) {
            throw DbException.throwInternalError();
        }
        this.aggregateType = aggregateType;
    }

    private static void addAggregate(String name, AggregateType type) {
        AGGREGATES.put(name, type);
    }

    public static AggregateType getAggregateType(String name) {
        return AGGREGATES.get(name);
    }

    public void setOrderByList(ArrayList<SelectOrderBy> orderByList) {
        this.orderByList = orderByList;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    private void sortWithOrderBy(Value[] array) {
        final SortOrder sortOrder = this.orderBySort;
        if (sortOrder != null) {
            Arrays.sort(array, new Comparator<Value>(){

                @Override
                public int compare(Value v1, Value v2) {
                    return sortOrder.compare(((ValueArray)v1).getList(), ((ValueArray)v2).getList());
                }
            });
        } else {
            Arrays.sort(array, this.select.getSession().getDatabase().getCompareMode());
        }
    }

    @Override
    protected void updateAggregate(Session session, Object aggregateData) {
        AggregateData data = (AggregateData)aggregateData;
        Value v = this.args.length == 0 ? null : this.args[0].getValue(session);
        this.updateData(session, data, v, null);
    }

    private void updateData(Session session, AggregateData data, Value v, Value[] remembered) {
        switch (this.aggregateType) {
            case LISTAGG: {
                if (v != ValueNull.INSTANCE) {
                    v = this.updateCollecting(session, v.convertTo(13), remembered);
                }
                if (this.args.length < 2) break;
                ((AggregateDataCollecting)data).setSharedArgument(remembered != null ? remembered[1] : this.args[1].getValue(session));
                break;
            }
            case ARRAY_AGG: {
                if (v == ValueNull.INSTANCE) break;
                v = this.updateCollecting(session, v, remembered);
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                int i;
                int count = this.args.length;
                Value[] a = new Value[count];
                for (i = 0; i < count; ++i) {
                    a[i] = remembered != null ? remembered[i] : this.args[i].getValue(session);
                }
                ((AggregateDataCollecting)data).setSharedArgument(ValueRow.get(a));
                a = new Value[count];
                for (i = 0; i < count; ++i) {
                    a[i] = remembered != null ? remembered[count + i] : this.orderByList.get((int)i).expression.getValue(session);
                }
                v = ValueRow.get(a);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                ((AggregateDataCollecting)data).setSharedArgument(v);
                v = remembered != null ? remembered[1] : this.orderByList.get((int)0).expression.getValue(session);
                break;
            }
            case MODE: {
                v = remembered != null ? remembered[0] : this.orderByList.get((int)0).expression.getValue(session);
                break;
            }
        }
        data.add(session, v);
    }

    @Override
    protected void updateGroupAggregates(Session session, int stage) {
        super.updateGroupAggregates(session, stage);
        for (Expression arg : this.args) {
            arg.updateAggregate(session, stage);
        }
        if (this.orderByList != null) {
            for (SelectOrderBy orderBy : this.orderByList) {
                orderBy.expression.updateAggregate(session, stage);
            }
        }
    }

    private Value updateCollecting(Session session, Value v, Value[] remembered) {
        if (this.orderByList != null) {
            int size = this.orderByList.size();
            Value[] array = new Value[1 + size];
            array[0] = v;
            if (remembered == null) {
                for (int i = 0; i < size; ++i) {
                    SelectOrderBy o = this.orderByList.get(i);
                    array[i + 1] = o.expression.getValue(session);
                }
            } else {
                System.arraycopy(remembered, 1, array, 1, size);
            }
            v = ValueArray.get(array);
        }
        return v;
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.orderByList != null) {
            n += this.orderByList.size();
        }
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(Session session, Value[] array) {
        int offset = 0;
        for (Expression arg : this.args) {
            array[offset++] = arg.getValue(session);
        }
        if (this.orderByList != null) {
            for (SelectOrderBy o : this.orderByList) {
                array[offset++] = o.expression.getValue(session);
            }
        }
        if (this.filterCondition != null) {
            array[offset] = ValueBoolean.get(this.filterCondition.getBooleanValue(session));
        }
    }

    @Override
    protected void updateFromExpressions(Session session, Object aggregateData, Value[] array) {
        if (this.filterCondition == null || array[this.getNumExpressions() - 1].getBoolean()) {
            AggregateData data = (AggregateData)aggregateData;
            Value v = this.args.length == 0 ? null : array[0];
            this.updateData(session, data, v, array);
        }
    }

    @Override
    protected Object createAggregateData() {
        return AggregateData.create(this.aggregateType, this.distinct, this.type.getValueType());
    }

    @Override
    public Value getValue(Session session) {
        return this.select.isQuickAggregateQuery() ? this.getValueQuick(session) : super.getValue(session);
    }

    private Value getValueQuick(Session session) {
        switch (this.aggregateType) {
            case COUNT: 
            case COUNT_ALL: {
                Table table = this.select.getTopTableFilter().getTable();
                return ValueLong.get(table.getRowCount(session));
            }
            case MIN: 
            case MAX: {
                Cursor cursor;
                SearchRow row;
                boolean first = this.aggregateType == AggregateType.MIN;
                Index index = this.getMinMaxColumnIndex();
                int sortType = index.getIndexColumns()[0].sortType;
                if ((sortType & 1) != 0) {
                    first = !first;
                }
                Value v = (row = (cursor = index.findFirstOrLast(session, first)).getSearchRow()) == null ? ValueNull.INSTANCE : row.getValue(index.getColumns()[0].getColumnId());
                return v;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Value v = this.args[0].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal arg = v.getBigDecimal();
                if (arg.signum() >= 0 && arg.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getFromIndex(session, this.orderByList.get((int)0).expression, this.type.getValueType(), this.orderByList, arg, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", arg);
            }
            case MEDIAN: {
                return Percentile.getFromIndex(session, this.args[0], this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case ENVELOPE: {
                return ((MVSpatialIndex)AggregateDataEnvelope.getGeometryColumnIndex(this.args[0])).getBounds(session);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
    }

    @Override
    public Value getAggregatedValue(Session session, Object aggregateData) {
        AggregateData data = (AggregateData)aggregateData;
        if (data == null) {
            data = (AggregateData)this.createAggregateData();
        }
        switch (this.aggregateType) {
            case COUNT: {
                if (!this.distinct) break;
                return ValueLong.get(((AggregateDataCollecting)data).getCount());
            }
            case SUM: 
            case AVG: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (!this.distinct) break;
                AggregateDataCollecting c = (AggregateDataCollecting)data;
                if (c.getCount() == 0) {
                    return ValueNull.INSTANCE;
                }
                AggregateDataDefault d = new AggregateDataDefault(this.aggregateType, this.type.getValueType());
                Database db = session.getDatabase();
                int dataType = this.type.getValueType();
                for (Value v : c) {
                    d.add(session, v);
                }
                return d.getValue(db, dataType);
            }
            case HISTOGRAM: {
                return this.getHistogram(session, data);
            }
            case LISTAGG: {
                return this.getListagg(session, data);
            }
            case ARRAY_AGG: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                if (this.orderByList != null || this.distinct) {
                    this.sortWithOrderBy(array);
                }
                if (this.orderByList != null) {
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = ((ValueArray)array[i]).getList()[0];
                    }
                }
                return ValueArray.get(array);
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                return this.getHypotheticalSet(session, data);
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
                Value[] array = collectingData.getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                Value v = collectingData.getSharedArgument();
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal arg = v.getBigDecimal();
                if (arg.signum() >= 0 && arg.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getValue(session.getDatabase(), array, this.type.getValueType(), this.orderByList, arg, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", arg);
            }
            case MEDIAN: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                return Percentile.getValue(session.getDatabase(), array, this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case MODE: {
                return this.getMode(session, data);
            }
        }
        return data.getValue(session.getDatabase(), this.type.getValueType());
    }

    private Value getHypotheticalSet(Session session, AggregateData data) {
        AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
        Value arg = collectingData.getSharedArgument();
        if (arg == null) {
            switch (this.aggregateType) {
                case RANK: 
                case DENSE_RANK: {
                    return ValueInt.get(1);
                }
                case PERCENT_RANK: {
                    return ValueDouble.ZERO;
                }
                case CUME_DIST: {
                    return ValueDouble.ONE;
                }
            }
            throw DbException.getUnsupportedException("aggregateType=" + (Object)((Object)this.aggregateType));
        }
        collectingData.add(session, arg);
        Value[] array = collectingData.getArray();
        Comparator<Value> sort = this.orderBySort.getRowValueComparator();
        Arrays.sort(array, sort);
        return this.aggregateType == AggregateType.CUME_DIST ? Aggregate.getCumeDist(array, arg, sort) : this.getRank(array, arg, sort);
    }

    private Value getRank(Value[] ordered, Value arg, Comparator<Value> sort) {
        int size = ordered.length;
        int number = 0;
        for (int i = 0; i < size; ++i) {
            int nm;
            Value row = ordered[i];
            if (i == 0) {
                number = 1;
            } else if (sort.compare(ordered[i - 1], row) != 0) {
                number = this.aggregateType == AggregateType.DENSE_RANK ? ++number : i + 1;
            }
            Value v = this.aggregateType == AggregateType.PERCENT_RANK ? ((nm = number - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)nm / (double)(size - 1))) : ValueLong.get(number);
            if (sort.compare(row, arg) != 0) continue;
            return v;
        }
        throw DbException.throwInternalError();
    }

    private static Value getCumeDist(Value[] ordered, Value arg, Comparator<Value> sort) {
        int size = ordered.length;
        int start = 0;
        while (start < size) {
            int end;
            Value array = ordered[start];
            for (end = start + 1; end < size && sort.compare(array, ordered[end]) == 0; ++end) {
            }
            ValueDouble v = ValueDouble.get((double)end / (double)size);
            for (int i = start; i < end; ++i) {
                if (sort.compare(ordered[i], arg) != 0) continue;
                return v;
            }
            start = end;
        }
        throw DbException.throwInternalError();
    }

    private Value getListagg(Session session, AggregateData data) {
        AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
        Value[] array = collectingData.getArray();
        if (array == null) {
            return ValueNull.INSTANCE;
        }
        if (this.orderByList != null || this.distinct) {
            this.sortWithOrderBy(array);
        }
        StringBuilder builder = new StringBuilder();
        String sep = this.args.length < 2 ? "," : collectingData.getSharedArgument().getString();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            Value val = array[i];
            String s2 = this.orderByList != null ? ((ValueArray)val).getList()[0].getString() : val.getString();
            if (sep != null && i > 0) {
                builder.append(sep);
            }
            builder.append(s2);
        }
        return ValueString.get(builder.toString());
    }

    private Value getHistogram(Session session, AggregateData data) {
        TreeMap<Value, LongDataCounter> distinctValues = ((AggregateDataDistinctWithCounts)data).getValues();
        if (distinctValues == null) {
            return ValueArray.getEmpty();
        }
        Value[] values = new ValueArray[distinctValues.size()];
        int i = 0;
        for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
            LongDataCounter d = entry.getValue();
            values[i] = ValueArray.get(new Value[]{entry.getKey(), ValueLong.get(this.distinct ? 1L : d.count)});
            ++i;
        }
        Database db = session.getDatabase();
        final Mode mode = db.getMode();
        final CompareMode compareMode = db.getCompareMode();
        Arrays.sort(values, new Comparator<ValueArray>(){

            @Override
            public int compare(ValueArray v1, ValueArray v2) {
                Value a1 = v1.getList()[0];
                Value a2 = v2.getList()[0];
                return a1.compareTo(a2, mode, compareMode);
            }
        });
        return ValueArray.get(values);
    }

    private Value getMode(Session session, AggregateData data) {
        Value v = ValueNull.INSTANCE;
        TreeMap<Value, LongDataCounter> distinctValues = ((AggregateDataDistinctWithCounts)data).getValues();
        if (distinctValues == null) {
            return v;
        }
        long count = 0L;
        if (this.orderByList != null) {
            boolean desc = (this.orderByList.get((int)0).sortType & 1) != 0;
            for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
                long c = entry.getValue().count;
                if (c > count) {
                    v = entry.getKey();
                    count = c;
                    continue;
                }
                if (c != count) continue;
                Value v2 = entry.getKey();
                int cmp = session.getDatabase().compareTypeSafe(v, v2);
                if (desc ? cmp >= 0 : cmp <= 0) continue;
                v = v2;
            }
        } else {
            for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
                long c = entry.getValue().count;
                if (c <= count) continue;
                v = entry.getKey();
                count = c;
            }
        }
        return v.convertTo(this.type.getValueType());
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.orderByList != null) {
            for (SelectOrderBy o : this.orderByList) {
                o.expression.mapColumns(resolver, level, innerState);
            }
        }
        super.mapColumnsAnalysis(resolver, level, innerState);
    }

    @Override
    public Expression optimize(Session session) {
        super.optimize(session);
        if (this.args.length == 1) {
            this.type = this.args[0].getType();
        }
        if (this.orderByList != null) {
            int offset;
            for (SelectOrderBy o : this.orderByList) {
                o.expression = o.expression.optimize(session);
            }
            switch (this.aggregateType) {
                case LISTAGG: 
                case ARRAY_AGG: {
                    offset = 1;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
            this.orderBySort = Aggregate.createOrder(session, this.orderByList, offset);
        }
        switch (this.aggregateType) {
            case LISTAGG: {
                this.type = TypeInfo.TYPE_STRING;
                break;
            }
            case COUNT: 
            case COUNT_ALL: {
                this.type = TypeInfo.TYPE_LONG;
                break;
            }
            case SELECTIVITY: {
                this.type = TypeInfo.TYPE_INT;
                break;
            }
            case HISTOGRAM: {
                this.type = TypeInfo.TYPE_ARRAY;
                break;
            }
            case SUM: {
                int dataType = this.type.getValueType();
                if (dataType == 1) {
                    this.type = TypeInfo.TYPE_LONG;
                    break;
                }
                if (!DataType.supportsAdd(dataType)) {
                    throw DbException.get(90015, this.getSQL(false));
                }
                this.type = TypeInfo.getTypeInfo(DataType.getAddProofType(dataType));
                break;
            }
            case AVG: {
                if (DataType.supportsAdd(this.type.getValueType())) break;
                throw DbException.get(90015, this.getSQL(false));
            }
            case MIN: 
            case MAX: {
                break;
            }
            case RANK: 
            case DENSE_RANK: {
                this.type = TypeInfo.TYPE_LONG;
                break;
            }
            case PERCENT_RANK: 
            case CUME_DIST: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case PERCENTILE_CONT: {
                this.type = this.orderByList.get((int)0).expression.getType();
            }
            case MEDIAN: {
                switch (this.type.getValueType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
                    }
                }
                break;
            }
            case PERCENTILE_DISC: 
            case MODE: {
                this.type = this.orderByList.get((int)0).expression.getType();
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case EVERY: 
            case ANY: {
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            case BIT_AND: 
            case BIT_OR: {
                if (DataType.supportsAdd(this.type.getValueType())) break;
                throw DbException.get(90015, this.getSQL(false));
            }
            case ARRAY_AGG: {
                this.type = TypeInfo.TYPE_ARRAY;
                break;
            }
            case ENVELOPE: {
                this.type = TypeInfo.TYPE_GEOMETRY;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.orderByList != null) {
            for (SelectOrderBy o : this.orderByList) {
                o.expression.setEvaluatable(tableFilter, b);
            }
        }
        super.setEvaluatable(tableFilter, b);
    }

    private StringBuilder getSQLArrayAggregate(StringBuilder builder, boolean alwaysQuote) {
        builder.append("ARRAY_AGG(");
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        this.args[0].getSQL(builder, alwaysQuote);
        Window.appendOrderBy(builder, this.orderByList, alwaysQuote);
        builder.append(')');
        return this.appendTailConditions(builder, alwaysQuote);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        String text;
        switch (this.aggregateType) {
            case COUNT_ALL: {
                return this.appendTailConditions(builder.append("COUNT(*)"), alwaysQuote);
            }
            case COUNT: {
                text = "COUNT";
                break;
            }
            case SELECTIVITY: {
                text = "SELECTIVITY";
                break;
            }
            case HISTOGRAM: {
                text = "HISTOGRAM";
                break;
            }
            case SUM: {
                text = "SUM";
                break;
            }
            case MIN: {
                text = "MIN";
                break;
            }
            case MAX: {
                text = "MAX";
                break;
            }
            case AVG: {
                text = "AVG";
                break;
            }
            case STDDEV_POP: {
                text = "STDDEV_POP";
                break;
            }
            case STDDEV_SAMP: {
                text = "STDDEV_SAMP";
                break;
            }
            case VAR_POP: {
                text = "VAR_POP";
                break;
            }
            case VAR_SAMP: {
                text = "VAR_SAMP";
                break;
            }
            case EVERY: {
                text = "EVERY";
                break;
            }
            case ANY: {
                text = "ANY";
                break;
            }
            case BIT_AND: {
                text = "BIT_AND";
                break;
            }
            case BIT_OR: {
                text = "BIT_OR";
                break;
            }
            case RANK: {
                text = "RANK";
                break;
            }
            case DENSE_RANK: {
                text = "DENSE_RANK";
                break;
            }
            case PERCENT_RANK: {
                text = "PERCENT_RANK";
                break;
            }
            case CUME_DIST: {
                text = "CUME_DIST";
                break;
            }
            case PERCENTILE_CONT: {
                text = "PERCENTILE_CONT";
                break;
            }
            case PERCENTILE_DISC: {
                text = "PERCENTILE_DISC";
                break;
            }
            case MEDIAN: {
                text = "MEDIAN";
                break;
            }
            case LISTAGG: {
                text = "LISTAGG";
                break;
            }
            case ARRAY_AGG: {
                return this.getSQLArrayAggregate(builder, alwaysQuote);
            }
            case MODE: {
                text = "MODE";
                break;
            }
            case ENVELOPE: {
                text = "ENVELOPE";
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        builder.append(text);
        if (this.distinct) {
            builder.append("(DISTINCT ");
        } else {
            builder.append('(');
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression arg;
            if (i > 0) {
                builder.append(", ");
            }
            if ((arg = this.args[i]) instanceof Subquery) {
                arg.getSQL(builder, alwaysQuote);
                continue;
            }
            arg.getUnenclosedSQL(builder, alwaysQuote);
        }
        builder.append(')');
        if (this.orderByList != null) {
            builder.append(" WITHIN GROUP (");
            Window.appendOrderBy(builder, this.orderByList, alwaysQuote);
            builder.append(')');
        }
        return this.appendTailConditions(builder, alwaysQuote);
    }

    private Index getMinMaxColumnIndex() {
        Expression arg = this.args[0];
        if (arg instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)arg;
            Column column = col.getColumn();
            TableFilter filter = col.getTableFilter();
            if (filter != null) {
                Table table = filter.getTable();
                return table.getIndexForColumn(column, true, false);
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        if (this.filterCondition != null && !this.filterCondition.isEverything(visitor)) {
            return false;
        }
        if (visitor.getType() == 1) {
            switch (this.aggregateType) {
                case COUNT: {
                    if (!this.distinct && this.args[0].getNullable() == 0) {
                        return visitor.getTable().canGetRowCount();
                    }
                    return false;
                }
                case COUNT_ALL: {
                    return visitor.getTable().canGetRowCount();
                }
                case MIN: 
                case MAX: {
                    Index index = this.getMinMaxColumnIndex();
                    return index != null;
                }
                case PERCENTILE_CONT: 
                case PERCENTILE_DISC: {
                    return this.args[0].isConstant() && Percentile.getColumnIndex(this.orderByList.get((int)0).expression) != null;
                }
                case MEDIAN: {
                    if (this.distinct) {
                        return false;
                    }
                    return Percentile.getColumnIndex(this.args[0]) != null;
                }
                case ENVELOPE: {
                    return AggregateDataEnvelope.getGeometryColumnIndex(this.args[0]) != null;
                }
            }
            return false;
        }
        for (Expression arg : this.args) {
            if (arg.isEverything(visitor)) continue;
            return false;
        }
        if (this.orderByList != null) {
            for (SelectOrderBy o : this.orderByList) {
                if (o.expression.isEverything(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        for (Expression arg : this.args) {
            cost += arg.getCost();
        }
        if (this.orderByList != null) {
            for (SelectOrderBy o : this.orderByList) {
                cost += o.expression.getCost();
            }
        }
        if (this.filterCondition != null) {
            cost += this.filterCondition.getCost();
        }
        return cost;
    }

    static {
        Aggregate.addAggregate("COUNT", AggregateType.COUNT);
        Aggregate.addAggregate("SUM", AggregateType.SUM);
        Aggregate.addAggregate("MIN", AggregateType.MIN);
        Aggregate.addAggregate("MAX", AggregateType.MAX);
        Aggregate.addAggregate("AVG", AggregateType.AVG);
        Aggregate.addAggregate("LISTAGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("GROUP_CONCAT", AggregateType.LISTAGG);
        Aggregate.addAggregate("STRING_AGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("STDDEV_SAMP", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV_POP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("STDDEVP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("VAR_POP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VARP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VAR_SAMP", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VAR", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VARIANCE", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("ANY", AggregateType.ANY);
        Aggregate.addAggregate("SOME", AggregateType.ANY);
        Aggregate.addAggregate("BOOL_OR", AggregateType.ANY);
        Aggregate.addAggregate("EVERY", AggregateType.EVERY);
        Aggregate.addAggregate("BOOL_AND", AggregateType.EVERY);
        Aggregate.addAggregate("SELECTIVITY", AggregateType.SELECTIVITY);
        Aggregate.addAggregate("HISTOGRAM", AggregateType.HISTOGRAM);
        Aggregate.addAggregate("BIT_OR", AggregateType.BIT_OR);
        Aggregate.addAggregate("BIT_AND", AggregateType.BIT_AND);
        Aggregate.addAggregate("RANK", AggregateType.RANK);
        Aggregate.addAggregate("DENSE_RANK", AggregateType.DENSE_RANK);
        Aggregate.addAggregate("PERCENT_RANK", AggregateType.PERCENT_RANK);
        Aggregate.addAggregate("CUME_DIST", AggregateType.CUME_DIST);
        Aggregate.addAggregate("PERCENTILE_CONT", AggregateType.PERCENTILE_CONT);
        Aggregate.addAggregate("PERCENTILE_DISC", AggregateType.PERCENTILE_DISC);
        Aggregate.addAggregate("MEDIAN", AggregateType.MEDIAN);
        Aggregate.addAggregate("ARRAY_AGG", AggregateType.ARRAY_AGG);
        Aggregate.addAggregate("MODE", AggregateType.MODE);
        Aggregate.addAggregate("STATS_MODE", AggregateType.MODE);
        Aggregate.addAggregate("ENVELOPE", AggregateType.ENVELOPE);
    }
}

