/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.function.DateTimeFunctions;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IntervalUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class IntervalOperation
extends Expression {
    private final IntervalOpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo type;

    private static BigInteger nanosFromValue(Value v) {
        long[] a = DateTimeUtils.dateAndTimeFromValue(v);
        return BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(a[0])).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(a[1]));
    }

    public IntervalOperation(IntervalOpType opType, Expression left, Expression right) {
        this.opType = opType;
        this.left = left;
        this.right = right;
        int l = left.getType().getValueType();
        int r = right.getType().getValueType();
        switch (opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                this.type = TypeInfo.getTypeInfo(Value.getHigherOrder(l, r));
                break;
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                this.type = left.getType();
                break;
            }
            case DATETIME_MINUS_DATETIME: {
                this.type = l == 9 && r == 9 ? TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND : (l == 10 && r == 10 ? TypeInfo.TYPE_INTERVAL_DAY : TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND);
            }
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(builder, alwaysQuote).append(')');
    }

    private char getOperationToken() {
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case DATETIME_PLUS_INTERVAL: {
                return '+';
            }
            case INTERVAL_MINUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case DATETIME_MINUS_DATETIME: {
                return '-';
            }
            case INTERVAL_MULTIPLY_NUMERIC: {
                return '*';
            }
            case INTERVAL_DIVIDE_NUMERIC: {
                return '/';
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        Value r = this.right.getValue(session);
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int lType = l.getValueType();
        int rType = r.getValueType();
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                BigInteger a1 = IntervalUtils.intervalToAbsolute((ValueInterval)l);
                BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(Value.getHigherOrder(lType, rType) - 26), this.opType == IntervalOpType.INTERVAL_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2));
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: {
                return this.getDateTimeWithInterval(l, r, lType, rType);
            }
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                BigDecimal a1 = new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)l));
                BigDecimal a2 = r.getBigDecimal();
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(lType - 26), (this.opType == IntervalOpType.INTERVAL_MULTIPLY_NUMERIC ? a1.multiply(a2) : a1.divide(a2)).toBigInteger());
            }
            case DATETIME_MINUS_DATETIME: {
                if (lType == 9 && rType == 9) {
                    boolean negative;
                    long diff = ((ValueTime)l).getNanos() - ((ValueTime)r).getNanos();
                    boolean bl = negative = diff < 0L;
                    if (negative) {
                        diff = -diff;
                    }
                    return ValueInterval.from(IntervalQualifier.HOUR_TO_SECOND, negative, diff / 3600000000000L, diff % 3600000000000L);
                }
                if (lType == 10 && rType == 10) {
                    boolean negative;
                    long diff = DateTimeUtils.absoluteDayFromDateValue(((ValueDate)l).getDateValue()) - DateTimeUtils.absoluteDayFromDateValue(((ValueDate)r).getDateValue());
                    boolean bl = negative = diff < 0L;
                    if (negative) {
                        diff = -diff;
                    }
                    return ValueInterval.from(IntervalQualifier.DAY, negative, diff, 0L);
                }
                BigInteger diff = IntervalOperation.nanosFromValue(l).subtract(IntervalOperation.nanosFromValue(r));
                if (lType == 24 || rType == 24) {
                    l = l.convertTo(24);
                    r = r.convertTo(24);
                    diff = diff.add(BigInteger.valueOf((long)(((ValueTimestampTimeZone)r).getTimeZoneOffsetMins() - ((ValueTimestampTimeZone)l).getTimeZoneOffsetMins()) * 60000000000L));
                }
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.DAY_TO_SECOND, diff);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    private Value getDateTimeWithInterval(Value l, Value r, int lType, int rType) {
        switch (lType) {
            case 9: {
                BigInteger n;
                if (DataType.isYearMonthIntervalType(rType)) {
                    throw DbException.throwInternalError("type=" + rType);
                }
                BigInteger a1 = BigInteger.valueOf(((ValueTime)l).getNanos());
                BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
                BigInteger bigInteger = n = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2);
                if (n.signum() < 0 || n.compareTo(IntervalUtils.NANOS_PER_DAY_BI) >= 0) {
                    throw DbException.get(22003, n.toString());
                }
                return ValueTime.fromNanos(n.longValue());
            }
            case 10: 
            case 11: 
            case 24: {
                if (DataType.isYearMonthIntervalType(rType)) {
                    long m4 = IntervalUtils.intervalToAbsolute((ValueInterval)r).longValue();
                    if (this.opType == IntervalOpType.DATETIME_MINUS_INTERVAL) {
                        m4 = -m4;
                    }
                    return DateTimeFunctions.dateadd("MONTH", m4, l);
                }
                BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
                if (lType == 10) {
                    BigInteger a1 = BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(((ValueDate)l).getDateValue()));
                    a2 = a2.divide(IntervalUtils.NANOS_PER_DAY_BI);
                    BigInteger n = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2);
                    return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(n.longValue()));
                }
                long[] a = DateTimeUtils.dateAndTimeFromValue(l);
                long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(a[0]);
                long timeNanos = a[1];
                BigInteger[] dr = a2.divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                if (this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL) {
                    absoluteDay += dr[0].longValue();
                    timeNanos += dr[1].longValue();
                } else {
                    absoluteDay -= dr[0].longValue();
                    timeNanos -= dr[1].longValue();
                }
                if (timeNanos >= 86400000000000L) {
                    timeNanos -= 86400000000000L;
                    ++absoluteDay;
                } else if (timeNanos < 0L) {
                    timeNanos += 86400000000000L;
                    --absoluteDay;
                }
                return DateTimeUtils.dateTimeToValue(l, DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos, false);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        if (this.right != null) {
            this.right.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public IntervalOpType getOpType() {
        return this.opType;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public static enum IntervalOpType {
        INTERVAL_PLUS_INTERVAL,
        INTERVAL_MINUS_INTERVAL,
        DATETIME_PLUS_INTERVAL,
        DATETIME_MINUS_INTERVAL,
        INTERVAL_MULTIPLY_NUMERIC,
        INTERVAL_DIVIDE_NUMERIC,
        DATETIME_MINUS_DATETIME;

    }
}

