/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import java.util.HashSet;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;

public class ExpressionVisitor {
    public static final int INDEPENDENT = 0;
    public static final ExpressionVisitor INDEPENDENT_VISITOR;
    public static final int OPTIMIZABLE_AGGREGATE = 1;
    public static final int DETERMINISTIC = 2;
    public static final ExpressionVisitor DETERMINISTIC_VISITOR;
    public static final int EVALUATABLE = 3;
    public static final ExpressionVisitor EVALUATABLE_VISITOR;
    private static final int CACHED = 8;
    private static final ExpressionVisitor[] INDEPENDENT_VISITORS;
    private static final ExpressionVisitor[] EVALUATABLE_VISITORS;
    public static final int SET_MAX_DATA_MODIFICATION_ID = 4;
    public static final int READONLY = 5;
    public static final ExpressionVisitor READONLY_VISITOR;
    public static final int NOT_FROM_RESOLVER = 6;
    public static final int GET_DEPENDENCIES = 7;
    public static final int QUERY_COMPARABLE = 8;
    public static final int GET_COLUMNS1 = 9;
    public static final int GET_COLUMNS2 = 10;
    public static final int CLEANUP = 11;
    public static final ExpressionVisitor QUERY_COMPARABLE_VISITOR;
    private final int type;
    private final int queryLevel;
    private final HashSet<DbObject> dependencies;
    private final AllColumnsForPlan columns1;
    private final Table table;
    private final long[] maxDataModificationId;
    private final ColumnResolver resolver;
    private final HashSet<Column> columns2;

    private ExpressionVisitor(int type, int queryLevel, HashSet<DbObject> dependencies, AllColumnsForPlan columns1, Table table, ColumnResolver resolver, long[] maxDataModificationId, HashSet<Column> columns2) {
        this.type = type;
        this.queryLevel = queryLevel;
        this.dependencies = dependencies;
        this.columns1 = columns1;
        this.table = table;
        this.resolver = resolver;
        this.maxDataModificationId = maxDataModificationId;
        this.columns2 = columns2;
    }

    private ExpressionVisitor(int type) {
        this.type = type;
        this.queryLevel = 0;
        this.dependencies = null;
        this.columns1 = null;
        this.columns2 = null;
        this.table = null;
        this.resolver = null;
        this.maxDataModificationId = null;
    }

    private ExpressionVisitor(int type, int queryLevel) {
        this.type = type;
        this.queryLevel = queryLevel;
        this.dependencies = null;
        this.columns1 = null;
        this.columns2 = null;
        this.table = null;
        this.resolver = null;
        this.maxDataModificationId = null;
    }

    public static ExpressionVisitor getDependenciesVisitor(HashSet<DbObject> dependencies) {
        return new ExpressionVisitor(7, 0, dependencies, null, null, null, null, null);
    }

    public static ExpressionVisitor getOptimizableVisitor(Table table) {
        return new ExpressionVisitor(1, 0, null, null, table, null, null, null);
    }

    public static ExpressionVisitor getNotFromResolverVisitor(ColumnResolver resolver) {
        return new ExpressionVisitor(6, 0, null, null, null, resolver, null, null);
    }

    public static ExpressionVisitor getColumnsVisitor(AllColumnsForPlan columns) {
        return new ExpressionVisitor(9, 0, null, columns, null, null, null, null);
    }

    public static ExpressionVisitor getColumnsVisitor(HashSet<Column> columns, Table table) {
        return new ExpressionVisitor(10, 0, null, null, table, null, null, columns);
    }

    public static ExpressionVisitor getMaxModificationIdVisitor() {
        return new ExpressionVisitor(4, 0, null, null, null, null, new long[1], null);
    }

    public static ExpressionVisitor getCleanupVisitor() {
        return new ExpressionVisitor(11);
    }

    public void addDependency(DbObject obj) {
        this.dependencies.add(obj);
    }

    void addColumn1(Column column) {
        this.columns1.add(column);
    }

    void addColumn2(Column column) {
        if (this.table == null || this.table == column.getTable()) {
            this.columns2.add(column);
        }
    }

    public HashSet<DbObject> getDependencies() {
        return this.dependencies;
    }

    public ExpressionVisitor incrementQueryLevel(int offset) {
        if (this.type == 0) {
            return (offset += this.queryLevel) < 8 ? INDEPENDENT_VISITORS[offset] : new ExpressionVisitor(0, offset);
        }
        if (this.type == 3) {
            return (offset += this.queryLevel) < 8 ? EVALUATABLE_VISITORS[offset] : new ExpressionVisitor(3, offset);
        }
        return this;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public void addDataModificationId(long value) {
        long m4 = this.maxDataModificationId[0];
        if (value > m4) {
            this.maxDataModificationId[0] = value;
        }
    }

    public long getMaxDataModificationId() {
        return this.maxDataModificationId[0];
    }

    int getQueryLevel() {
        assert (this.type == 0 || this.type == 3);
        return this.queryLevel;
    }

    public Table getTable() {
        return this.table;
    }

    public int getType() {
        return this.type;
    }

    public static void allColumnsForTableFilters(TableFilter[] filters, AllColumnsForPlan allColumnsSet) {
        for (TableFilter filter : filters) {
            if (filter.getSelect() == null) continue;
            filter.getSelect().isEverything(ExpressionVisitor.getColumnsVisitor(allColumnsSet));
        }
    }

    static {
        int i;
        INDEPENDENT_VISITOR = new ExpressionVisitor(0);
        DETERMINISTIC_VISITOR = new ExpressionVisitor(2);
        EVALUATABLE_VISITOR = new ExpressionVisitor(3);
        ExpressionVisitor[] a = new ExpressionVisitor[8];
        a[0] = INDEPENDENT_VISITOR;
        for (i = 1; i < 8; ++i) {
            a[i] = new ExpressionVisitor(0, i);
        }
        INDEPENDENT_VISITORS = a;
        a = new ExpressionVisitor[8];
        a[0] = EVALUATABLE_VISITOR;
        for (i = 1; i < 8; ++i) {
            a[i] = new ExpressionVisitor(3, i);
        }
        EVALUATABLE_VISITORS = a;
        READONLY_VISITOR = new ExpressionVisitor(5);
        QUERY_COMPARABLE_VISITOR = new ExpressionVisitor(8);
    }
}

