/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.Subquery;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObjectBase;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.SourceCompiler;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueNull;

public class FunctionAlias
extends SchemaObjectBase {
    private String className;
    private String methodName;
    private String source;
    private JavaMethod[] javaMethods;
    private boolean deterministic;
    private boolean bufferResultSetToLocalTemp = true;

    private FunctionAlias(Schema schema, int id, String name) {
        super(schema, id, name, 3);
    }

    public static FunctionAlias newInstance(Schema schema, int id, String name, String javaClassMethod, boolean force, boolean bufferResultSetToLocalTemp) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        int paren = javaClassMethod.indexOf(40);
        int lastDot = javaClassMethod.lastIndexOf(46, paren < 0 ? javaClassMethod.length() : paren);
        if (lastDot < 0) {
            throw DbException.get(42000, javaClassMethod);
        }
        alias.className = javaClassMethod.substring(0, lastDot);
        alias.methodName = javaClassMethod.substring(lastDot + 1);
        alias.bufferResultSetToLocalTemp = bufferResultSetToLocalTemp;
        alias.init(force);
        return alias;
    }

    public static FunctionAlias newInstanceFromSource(Schema schema, int id, String name, String source, boolean force, boolean bufferResultSetToLocalTemp) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        alias.source = source;
        alias.bufferResultSetToLocalTemp = bufferResultSetToLocalTemp;
        alias.init(force);
        return alias;
    }

    private void init(boolean force) {
        block2: {
            try {
                this.load();
            }
            catch (DbException e) {
                if (force) break block2;
                throw e;
            }
        }
    }

    private synchronized void load() {
        if (this.javaMethods != null) {
            return;
        }
        if (this.source != null) {
            this.loadFromSource();
        } else {
            this.loadClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSource() {
        SourceCompiler compiler;
        SourceCompiler sourceCompiler = compiler = this.database.getCompiler();
        synchronized (sourceCompiler) {
            String fullClassName = "org.gridgain.internal.h2.dynamic." + this.getName();
            compiler.setSource(fullClassName, this.source);
            try {
                Method m4 = compiler.getMethod(fullClassName);
                JavaMethod method = new JavaMethod(m4, 0);
                this.javaMethods = new JavaMethod[]{method};
            }
            catch (DbException e) {
                throw e;
            }
            catch (Exception e) {
                throw DbException.get(42000, e, this.source);
            }
        }
    }

    private void loadClass() {
        Class javaClass = JdbcUtils.loadUserClass(this.className);
        Method[] methods = javaClass.getMethods();
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>(1);
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            Method m4 = methods[i];
            if (!Modifier.isStatic(m4.getModifiers()) || !m4.getName().equals(this.methodName) && !FunctionAlias.getMethodSignature(m4).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(m4, i);
            for (JavaMethod old : list) {
                if (old.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, old.toString(), javaMethod.toString());
            }
            list.add(javaMethod);
        }
        if (list.isEmpty()) {
            throw DbException.get(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = list.toArray(new JavaMethod[0]);
        Arrays.sort(this.javaMethods);
    }

    private static String getMethodSignature(Method m4) {
        StringBuilder buff = new StringBuilder(m4.getName());
        buff.append('(');
        Class<?>[] parameterTypes = m4.getParameterTypes();
        int length = parameterTypes.length;
        for (int i = 0; i < length; ++i) {
            Class<?> p;
            if (i > 0) {
                buff.append(',');
            }
            if ((p = parameterTypes[i]).isArray()) {
                buff.append(p.getComponentType().getName()).append("[]");
                continue;
            }
            buff.append(p.getName());
        }
        return buff.append(')').toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL(true);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this.database.getSettings().functionsInSchema || this.getSchema().getId() != 0) {
            return super.getSQL(builder, alwaysQuote);
        }
        return Parser.quoteIdentifier(builder, this.getName(), alwaysQuote);
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("CREATE FORCE ALIAS ");
        buff.append(this.getSQL(true));
        if (this.deterministic) {
            buff.append(" DETERMINISTIC");
        }
        if (!this.bufferResultSetToLocalTemp) {
            buff.append(" NOBUFFER");
        }
        if (this.source != null) {
            buff.append(" AS ");
            StringUtils.quoteStringSQL(buff, this.source);
        } else {
            buff.append(" FOR ");
            Parser.quoteIdentifier(buff, this.className + "." + this.methodName, true);
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] args) {
        this.load();
        int parameterCount = args.length;
        for (JavaMethod m4 : this.javaMethods) {
            int count = m4.getParameterCount();
            if (count != parameterCount && (!m4.isVarArgs() || count > parameterCount + 1)) continue;
            return m4;
        }
        throw DbException.get(90087, this.getName() + " (" + this.className + ", parameter count: " + parameterCount + ")");
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.bufferResultSetToLocalTemp;
    }

    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final int dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int id) {
            Class<?> lastArg;
            Class<?> paramClass;
            this.method = method;
            this.id = id;
            Class<?>[] paramClasses = method.getParameterTypes();
            this.paramCount = paramClasses.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(paramClass = paramClasses[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (lastArg = paramClasses[paramClasses.length - 1]).isArray() && method.isVarArgs()) {
                this.varArgs = true;
                this.varArgClass = lastArg.getComponentType();
            }
            Class<?> returnClass = method.getReturnType();
            this.dataType = DataType.getTypeFromClass(returnClass);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] args, boolean columnList) {
            Value[] argsValues;
            Class<?>[] paramClasses = this.method.getParameterTypes();
            Object[] params = new Object[paramClasses.length];
            int p = 0;
            if (this.hasConnectionParam && params.length > 0) {
                params[p++] = session.createConnection(columnList);
            }
            if (args.length == 1 && args[0] instanceof Subquery) {
                Subquery q = (Subquery)args[0];
                argsValues = q.getAllRows(session).toArray(new Value[0]);
            } else {
                argsValues = new Value[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Value v;
                    Expression e = args[i];
                    argsValues[i] = v = e.getValue(session);
                }
            }
            Object varArg = null;
            if (this.varArgs) {
                int len = argsValues.length - params.length + 1 + (this.hasConnectionParam ? 1 : 0);
                params[params.length - 1] = varArg = Array.newInstance(this.varArgClass, len);
            }
            int a = 0;
            int len = argsValues.length;
            while (a < len) {
                Object[] o;
                boolean currentIsVarArg = this.varArgs && p >= paramClasses.length - 1;
                Class<?> paramClass = currentIsVarArg ? this.varArgClass : paramClasses[p];
                int type = DataType.getTypeFromClass(paramClass);
                Value v = argsValues[a];
                if (Value.class.isAssignableFrom(paramClass)) {
                    o = v;
                } else if (v.getValueType() == 17 && paramClass.isArray() && paramClass.getComponentType() != Object.class) {
                    Value[] array = ((ValueArray)v).getList();
                    Object[] objArray = (Object[])Array.newInstance(paramClass.getComponentType(), array.length);
                    int componentType = DataType.getTypeFromClass(paramClass.getComponentType());
                    Mode mode = session.getDatabase().getMode();
                    for (int i = 0; i < objArray.length; ++i) {
                        objArray[i] = array[i].convertTo(componentType, mode).getObject();
                    }
                    o = objArray;
                } else {
                    v = v.convertTo(type, session.getDatabase().getMode());
                    o = v.getObject();
                }
                if (o == null) {
                    if (paramClass.isPrimitive()) {
                        if (!columnList) return ValueNull.INSTANCE;
                        o = DataType.getDefaultForPrimitiveType(paramClass);
                    }
                } else if (!paramClass.isAssignableFrom(o.getClass()) && !paramClass.isPrimitive()) {
                    o = DataType.convertTo(session.createConnection(false), v, paramClass);
                }
                if (currentIsVarArg) {
                    Array.set(varArg, p - params.length + 1, o);
                } else {
                    params[p] = o;
                }
                ++a;
                ++p;
            }
            boolean old = session.getAutoCommit();
            Value identity = session.getLastScopeIdentity();
            boolean defaultConnection = session.getDatabase().getSettings().defaultConnection;
            try {
                Object returnValue;
                session.setAutoCommit(false);
                try {
                    if (defaultConnection) {
                        Driver.setDefaultConnection(session.createConnection(columnList));
                    }
                    if ((returnValue = this.method.invoke(null, params)) == null) {
                        ValueNull type = ValueNull.INSTANCE;
                        return type;
                    }
                }
                catch (InvocationTargetException e) {
                    StringBuilder builder = new StringBuilder(this.method.getName()).append('(');
                    int length = params.length;
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        builder.append(params[i]);
                    }
                    builder.append(')');
                    throw DbException.convertInvocation(e, builder.toString());
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
                if (Value.class.isAssignableFrom(this.method.getReturnType())) {
                    Value e = (Value)returnValue;
                    return e;
                }
                Value ret = DataType.convertToValue(session, returnValue, this.dataType);
                Value value = ret.convertTo(this.dataType);
                return value;
            }
            finally {
                session.setLastScopeIdentity(identity);
                session.setAutoCommit(old);
                if (defaultConnection) {
                    Driver.setDefaultConnection(null);
                }
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod m4) {
            if (this.varArgs != m4.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != m4.paramCount) {
                return this.paramCount - m4.paramCount;
            }
            if (this.hasConnectionParam != m4.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - m4.id;
        }
    }
}

