/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gridgain.internal.h2.command.CommandInterface;
import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbSettings;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SessionFactory;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.security.auth.AuthenticationException;
import org.gridgain.internal.h2.security.auth.AuthenticationInfo;
import org.gridgain.internal.h2.security.auth.Authenticator;
import org.gridgain.internal.h2.store.FileLock;
import org.gridgain.internal.h2.store.FileLockMethod;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.ParserUtil;
import org.gridgain.internal.h2.util.ThreadDeadlockDetector;
import org.gridgain.internal.h2.util.Utils;

public class Engine
implements SessionFactory {
    private static final Engine INSTANCE = new Engine();
    private static final Map<String, Database> DATABASES = new HashMap<String, Database>();
    private volatile long wrongPasswordDelay = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private boolean jmx;

    private Engine() {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            ThreadDeadlockDetector.init();
        }
    }

    public static Engine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession(ConnectionInfo ci, boolean ifExists, String cipher) {
        Database database;
        String name = ci.getName();
        ci.removeProperty("NO_UPGRADE", false);
        boolean openNew = ci.getProperty("OPEN_NEW", false);
        boolean opened = false;
        User user = null;
        Map<String, Database> map = DATABASES;
        synchronized (map) {
            database = openNew || ci.isUnnamedInMemory() ? null : DATABASES.get(name);
            if (database == null) {
                if (ifExists && !Database.exists(name)) {
                    throw DbException.get(90146, name);
                }
                database = new Database(ci, cipher);
                opened = true;
                if (database.getAllUsers().isEmpty()) {
                    user = new User(database, database.allocateObjectId(), ci.getUserName(), false);
                    user.setAdmin(true);
                    user.setUserPasswordHash(ci.getUserPasswordHash());
                    database.setMasterUser(user);
                }
                if (!ci.isUnnamedInMemory()) {
                    DATABASES.put(name, database);
                }
            }
        }
        if (opened) {
            database.opened();
        }
        if (database.isClosing()) {
            return null;
        }
        if (user == null) {
            if (database.validateFilePasswordHash(cipher, ci.getFilePasswordHash())) {
                if (ci.getProperty("AUTHREALM") == null) {
                    user = database.findUser(ci.getUserName());
                    if (user != null && !user.validateUserPasswordHash(ci.getUserPasswordHash())) {
                        user = null;
                    }
                } else {
                    Authenticator authenticator = database.getAuthenticator();
                    if (authenticator == null) {
                        throw DbException.get(90144, name);
                    }
                    try {
                        AuthenticationInfo authenticationInfo = new AuthenticationInfo(ci);
                        user = database.getAuthenticator().authenticate(authenticationInfo, database);
                    }
                    catch (AuthenticationException authenticationError) {
                        database.getTrace(2).error(authenticationError, "an error occurred during authentication; user: \"" + ci.getUserName() + "\"");
                    }
                }
            }
            if (opened && (user == null || !user.isAdmin())) {
                database.setEventListener(null);
            }
        }
        if (user == null) {
            DbException er = DbException.get(28000);
            database.getTrace(2).error(er, "wrong user or password; user: \"" + ci.getUserName() + "\"");
            database.removeSession(null);
            throw er;
        }
        ci.cleanAuthenticationInfo();
        Engine.checkClustering(ci, database);
        Session session = database.createSession(user);
        if (session == null) {
            return null;
        }
        if (ci.getProperty("JMX", false)) {
            try {
                Utils.callStaticMethod("org.gridgain.internal.h2.jmx.DatabaseInfo.registerMBean", ci, database);
            }
            catch (Exception e) {
                database.removeSession(session);
                throw DbException.get(50100, e, "JMX");
            }
            this.jmx = true;
        }
        return session;
    }

    @Override
    public Session createSession(ConnectionInfo ci) {
        return INSTANCE.createSessionAndValidate(ci);
    }

    private Session createSessionAndValidate(ConnectionInfo ci) {
        try {
            ConnectionInfo backup = null;
            String lockMethodName = ci.getProperty("FILE_LOCK", null);
            FileLockMethod fileLockMethod = FileLock.getFileLockMethod(lockMethodName);
            if (fileLockMethod == FileLockMethod.SERIALIZED) {
                ci.setProperty("OPEN_NEW", "TRUE");
                try {
                    backup = ci.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw DbException.convert(e);
                }
            }
            Session session = this.openSession(ci);
            this.validateUserAndPassword(true);
            if (backup != null) {
                session.setConnectionInfo(backup);
            }
            return session;
        }
        catch (DbException e) {
            if (e.getErrorCode() == 28000) {
                this.validateUserAndPassword(false);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session openSession(ConnectionInfo ci) {
        Session session;
        boolean ifExists = ci.removeProperty("IFEXISTS", false);
        boolean ignoreUnknownSetting = ci.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String cipher = ci.removeProperty("CIPHER", null);
        String init = ci.removeProperty("INIT", null);
        long start = System.nanoTime();
        while ((session = this.openSession(ci, ifExists, cipher)) == null) {
            if (System.nanoTime() - start > 60000000000L) {
                throw DbException.get(90020, "Waited for database closing longer than 1 minute");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw DbException.get(90121);
            }
        }
        Session session2 = session;
        synchronized (session2) {
            block16: {
                session.setAllowLiterals(true);
                DbSettings defaultSettings = DbSettings.getDefaultSettings();
                for (String setting : ci.getKeys()) {
                    if (defaultSettings.containsKey(setting)) continue;
                    String value = ci.getProperty(setting);
                    if (!ParserUtil.isSimpleIdentifier(setting, false, false)) {
                        throw DbException.get(90113, setting);
                    }
                    try {
                        CommandInterface command = session.prepareCommand("SET " + setting + ' ' + value, Integer.MAX_VALUE);
                        command.executeUpdate(false);
                    }
                    catch (DbException e) {
                        if (e.getErrorCode() == 90040) {
                            session.getTrace().error(e, "admin rights required; user: \"" + ci.getUserName() + "\"");
                        } else {
                            session.getTrace().error(e, "");
                        }
                        if (ignoreUnknownSetting) continue;
                        session.close();
                        throw e;
                    }
                }
                if (init != null) {
                    try {
                        CommandInterface command = session.prepareCommand(init, Integer.MAX_VALUE);
                        command.executeUpdate(false);
                    }
                    catch (DbException e) {
                        if (ignoreUnknownSetting) break block16;
                        session.close();
                        throw e;
                    }
                }
            }
            session.setAllowLiterals(false);
            session.commit(true);
        }
        return session;
    }

    private static void checkClustering(ConnectionInfo ci, Database database) {
        String clusterSession = ci.getProperty(13, null);
        if ("''".equals(clusterSession)) {
            return;
        }
        String clusterDb = database.getCluster();
        if (!("''".equals(clusterDb) || "TRUE".equals(clusterSession) || Objects.equals(clusterSession, clusterDb))) {
            if (clusterDb.equals("''")) {
                throw DbException.get(90093);
            }
            throw DbException.get(90094, clusterDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String name) {
        if (this.jmx) {
            try {
                Utils.callStaticMethod("org.gridgain.internal.h2.jmx.DatabaseInfo.unregisterMBean", name);
            }
            catch (Exception e) {
                throw DbException.get(50100, e, "JMX");
            }
        }
        Map<String, Database> map = DATABASES;
        synchronized (map) {
            DATABASES.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUserAndPassword(boolean correct) {
        int min2 = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (correct) {
            long delay = this.wrongPasswordDelay;
            if (delay > (long)min2 && delay > 0L) {
                Engine engine = INSTANCE;
                synchronized (engine) {
                    delay = MathUtils.secureRandomInt((int)delay);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrongPasswordDelay = min2;
                }
            }
        } else {
            Engine engine = INSTANCE;
            synchronized (engine) {
                long delay = this.wrongPasswordDelay;
                int max = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (max <= 0) {
                    max = Integer.MAX_VALUE;
                }
                this.wrongPasswordDelay += this.wrongPasswordDelay;
                if (this.wrongPasswordDelay > (long)max || this.wrongPasswordDelay < 0L) {
                    this.wrongPasswordDelay = max;
                }
                if (min2 > 0) {
                    delay += Math.abs(MathUtils.secureRandomLong() % 100L);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw DbException.get(28000);
            }
        }
    }
}

