/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.internal.h2.api.DatabaseEventListener;
import org.gridgain.internal.h2.api.JavaObjectSerializer;
import org.gridgain.internal.h2.api.TableEngine;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.command.dml.SetTypes;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.Comment;
import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.DbSettings;
import org.gridgain.internal.h2.engine.DelayedDatabaseCloser;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.Engine;
import org.gridgain.internal.h2.engine.MetaRecord;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.OnExitDatabaseCloser;
import org.gridgain.internal.h2.engine.QueryStatisticsData;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.Setting;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.engine.UserAggregate;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.message.TraceSystem;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.result.LocalResultFactory;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.RowFactory;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.security.auth.Authenticator;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileLock;
import org.gridgain.internal.h2.store.FileLockMethod;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.store.InDoubtTransaction;
import org.gridgain.internal.h2.store.LobStorageBackend;
import org.gridgain.internal.h2.store.LobStorageInterface;
import org.gridgain.internal.h2.store.LobStorageMap;
import org.gridgain.internal.h2.store.PageStore;
import org.gridgain.internal.h2.store.WriterThread;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.MetaTable;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableLinkConnection;
import org.gridgain.internal.h2.table.TableSynonym;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.tools.DeleteDbFiles;
import org.gridgain.internal.h2.tools.Server;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.NetUtils;
import org.gridgain.internal.h2.util.SmallLRUCache;
import org.gridgain.internal.h2.util.SourceCompiler;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.TempFileDeleter;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CaseInsensitiveConcurrentMap;
import org.gridgain.internal.h2.value.CaseInsensitiveMap;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;

public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private static final boolean ASSERT;
    private static final ThreadLocal<Session> META_LOCK_DEBUGGING;
    private static final ThreadLocal<Database> META_LOCK_DEBUGGING_DB;
    private static final ThreadLocal<Throwable> META_LOCK_DEBUGGING_STACK;
    private static final Session[] EMPTY_SESSION_ARRAY;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final byte[] fileEncryptionKey;
    private final HashMap<String, Role> roles = new HashMap();
    private final HashMap<String, User> users = new HashMap();
    private final HashMap<String, Setting> settings = new HashMap();
    private final HashMap<String, Schema> schemas = new HashMap();
    private final HashMap<String, Right> rights = new HashMap();
    private final HashMap<String, Domain> domains = new HashMap();
    private final HashMap<String, UserAggregate> aggregates = new HashMap();
    private final HashMap<String, Comment> comments = new HashMap();
    private final HashMap<String, TableEngine> tableEngines = new HashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<Session> exclusiveSession = new AtomicReference();
    private final BitSet objectIds = new BitSet();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private int nextTempTableId;
    private User systemUser;
    private Session systemSession;
    private Session lobSession;
    private Table meta;
    private Index metaIdIndex;
    private FileLock lock;
    private WriterThread writer;
    private volatile boolean starting;
    private TraceSystem traceSystem;
    private Trace trace;
    private final FileLockMethod fileLockMethod;
    private Role publicRole;
    private final AtomicLong modificationDataId = new AtomicLong();
    private final AtomicLong modificationMetaId = new AtomicLong();
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = SysProperties.MAX_MEMORY_ROWS;
    private int maxMemoryUndo = 50000;
    private int lockMode = 3;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private volatile int closeDelay;
    private DelayedDatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private final String cacheType;
    private final String accessModeData;
    private boolean referentialIntegrity = true;
    private Mode mode = Mode.getRegular();
    private boolean multiThreaded;
    private int maxOperationMemory = 100000;
    private SmallLRUCache<String, String[]> lobFileListCache;
    private final boolean autoServerMode;
    private final int autoServerPort;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private final TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private volatile int checkpointAllowed;
    private volatile boolean checkpointRunning;
    private final Object reconnectSync = new Object();
    private int cacheSize;
    private int compactMode;
    private SourceCompiler compiler;
    private volatile boolean metaTablesInitialized;
    private boolean flushOnEachCommit;
    private LobStorageInterface lobStorage;
    private final int pageSize;
    private int defaultTableType = 0;
    private final DbSettings dbSettings;
    private final long reconnectCheckDelayNs;
    private int logMode;
    private MVTableEngine.Store store;
    private int retentionTime;
    private boolean allowBuiltinAliasOverride;
    private final AtomicReference<DbException> backgroundException = new AtomicReference();
    private JavaObjectSerializer javaObjectSerializer;
    private String javaObjectSerializerName;
    private volatile boolean javaObjectSerializerInitialized;
    private boolean queryStatistics;
    private int queryStatisticsMaxEntries = 100;
    private QueryStatisticsData queryStatisticsData;
    private RowFactory rowFactory = RowFactory.DEFAULT;
    private LocalResultFactory resultFactory = LocalResultFactory.DEFAULT;
    private Authenticator authenticator;

    public Database(ConnectionInfo ci, String cipher) {
        String modeName;
        if (ASSERT) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
        String name = ci.getName();
        this.dbSettings = ci.getDbSettings();
        this.reconnectCheckDelayNs = TimeUnit.MILLISECONDS.toNanos(this.dbSettings.reconnectCheckDelay);
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = ci.isPersistent();
        this.filePasswordHash = ci.getFilePasswordHash();
        this.fileEncryptionKey = ci.getFileEncryptionKey();
        this.databaseName = name;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = 256;
        this.cipher = cipher;
        String lockMethodName = ci.getProperty("FILE_LOCK", null);
        this.accessModeData = StringUtils.toLowerEnglish(ci.getProperty("ACCESS_MODE_DATA", "rw"));
        this.autoServerMode = ci.getProperty("AUTO_SERVER", false);
        this.autoServerPort = ci.getProperty("AUTO_SERVER_PORT", 0);
        int defaultCacheSize = Utils.scaleForAvailableMemory(65536);
        this.cacheSize = ci.getProperty("CACHE_SIZE", defaultCacheSize);
        this.pageSize = ci.getProperty("PAGE_SIZE", 4096);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = this.dbSettings.mvStore && lockMethodName == null ? (this.autoServerMode ? FileLockMethod.FILE : FileLockMethod.FS) : FileLock.getFileLockMethod(lockMethodName);
        if (this.dbSettings.mvStore && this.fileLockMethod == FileLockMethod.SERIALIZED) {
            throw DbException.getUnsupportedException("MV_STORE combined with FILE_LOCK=SERIALIZED");
        }
        this.databaseURL = ci.getURL();
        String listener = ci.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (listener != null) {
            listener = StringUtils.trim(listener, true, true, "'");
            this.setEventListenerClass(listener);
        }
        if ((modeName = ci.removeProperty("MODE", null)) != null) {
            this.mode = Mode.getInstance(modeName);
            if (this.mode == null) {
                throw DbException.get(90088, modeName);
            }
        }
        this.logMode = ci.getProperty("LOG", 2);
        this.javaObjectSerializerName = ci.getProperty("JAVA_OBJECT_SERIALIZER", null);
        this.multiThreaded = ci.getProperty("MULTI_THREADED", this.dbSettings.mvStore);
        this.allowBuiltinAliasOverride = ci.getProperty("BUILTIN_ALIAS_OVERRIDE", false);
        boolean closeAtVmShutdown = this.dbSettings.dbCloseOnExit;
        int traceLevelFile = ci.getIntProperty(10, 1);
        int traceLevelSystemOut = ci.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(ci.removeProperty("CACHE_TYPE", "LRU"));
        this.openDatabase(traceLevelFile, traceLevelSystemOut, closeAtVmShutdown, ci);
    }

    private void openDatabase(int traceLevelFile, int traceLevelSystemOut, boolean closeAtVmShutdown, ConnectionInfo ci) {
        try {
            this.open(traceLevelFile, traceLevelSystemOut, ci);
            if (closeAtVmShutdown) {
                OnExitDatabaseCloser.register(this);
            }
        }
        catch (Throwable e) {
            try {
                boolean alreadyOpen;
                if (e instanceof OutOfMemoryError) {
                    e.fillInStackTrace();
                }
                boolean bl = alreadyOpen = e instanceof DbException && ((DbException)e).getErrorCode() == 90020;
                if (alreadyOpen) {
                    this.stopServer();
                }
                if (this.traceSystem != null) {
                    if (e instanceof DbException && !alreadyOpen) {
                        this.trace.error(e, "opening {0}", this.databaseName);
                    }
                    this.traceSystem.close();
                }
                this.closeOpenFilesAndUnlock(false);
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
            throw DbException.convert(e);
        }
    }

    public int getLockTimeout() {
        Setting setting = this.findSetting(SetTypes.getTypeName(6));
        return setting == null ? 2000 : setting.getIntValue();
    }

    public Row createRow(Value[] data, int memory) {
        return this.rowFactory.createRow(data, memory);
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    public LocalResultFactory getResultFactory() {
        return this.resultFactory;
    }

    public void setResultFactory(LocalResultFactory resultFactory) {
        this.resultFactory = resultFactory;
    }

    public static void setInitialPowerOffCount(int count) {
        initialPowerOffCount = count;
    }

    public void setPowerOffCount(int count) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = count;
    }

    public MVTableEngine.Store getStore() {
        return this.store;
    }

    public void setStore(MVTableEngine.Store store) {
        this.store = store;
        this.retentionTime = store.getMvStore().getRetentionTime();
    }

    public boolean areEqual(Value a, Value b) {
        return a.compareTo(b, this.mode, this.compareMode) == 0;
    }

    public int compare(Value a, Value b) {
        return a.compareTo(b, this.mode, this.compareMode);
    }

    public int compareWithNull(Value a, Value b, boolean forEquality) {
        return a.compareWithNull(b, forEquality, this.mode, this.compareMode);
    }

    public int compareTypeSafe(Value a, Value b) {
        return a.compareTypeSafe(b, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId.get();
    }

    private synchronized boolean reconnectModified(boolean pending) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return true;
        }
        try {
            if (pending == this.reconnectChangePending) {
                long now = System.nanoTime();
                if (now > this.reconnectCheckNext) {
                    if (pending) {
                        String pos = this.pageStore == null ? null : Long.toString(this.pageStore.getWriteCountTotal());
                        this.lock.setProperty("logPos", pos);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = now + this.reconnectCheckDelayNs;
                }
                return true;
            }
            Properties old = this.lock.load();
            if (pending) {
                if (old.getProperty("changePending") != null) {
                    return false;
                }
                this.trace.debug("wait before writing");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                Properties now = this.lock.load();
                if (!now.equals(old)) {
                    return false;
                }
            }
            String pos = this.pageStore == null ? null : Long.toString(this.pageStore.getWriteCountTotal());
            this.lock.setProperty("logPos", pos);
            if (pending) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.nanoTime() + 2L * this.reconnectCheckDelayNs;
            old = this.lock.save();
            if (pending) {
                this.trace.debug("wait before writing again");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                Properties now = this.lock.load();
                if (!now.equals(old)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = old;
            this.reconnectChangePending = pending;
            this.reconnectCheckNext = System.nanoTime() + this.reconnectCheckDelayNs;
            return true;
        }
        catch (Exception e) {
            this.trace.error(e, "pending {0}", pending);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return this.modificationDataId.incrementAndGet();
    }

    public long getModificationMetaId() {
        return this.modificationMetaId.get();
    }

    public long getNextModificationMetaId() {
        this.modificationDataId.incrementAndGet();
        return this.modificationMetaId.incrementAndGet() - 1L;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPowerOff() {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.stopWriter();
                if (this.store != null) {
                    this.store.closeImmediately();
                }
                Database database = this;
                synchronized (database) {
                    if (this.pageStore != null) {
                        try {
                            this.pageStore.close();
                        }
                        catch (DbException dbException) {
                            // empty catch block
                        }
                        this.pageStore = null;
                    }
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException e) {
                DbException.traceThrowable(e);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw DbException.get(90098);
    }

    static boolean exists(String name) {
        if (FileUtils.exists(name + ".h2.db")) {
            return true;
        }
        return FileUtils.exists(name + ".mv.db");
    }

    public Trace getTrace(int moduleId) {
        return this.traceSystem.getTrace(moduleId);
    }

    @Override
    public FileStore openFile(String name, String openMode, boolean mustExist) {
        if (mustExist && !FileUtils.exists(name)) {
            throw DbException.get(90124, name);
        }
        FileStore store = FileStore.open(this, name, openMode, this.cipher, this.filePasswordHash);
        try {
            store.init();
        }
        catch (DbException e) {
            store.closeSilently();
            throw e;
        }
        return store;
    }

    boolean validateFilePasswordHash(String testCipher, byte[] testHash) {
        if (!Objects.equals(testCipher, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(testHash, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        String n = this.databaseName;
        if (n.endsWith(":")) {
            n = null;
        }
        if (n != null) {
            StringTokenizer tokenizer = new StringTokenizer(n, "/\\:,;");
            while (tokenizer.hasMoreTokens()) {
                n = tokenizer.nextToken();
            }
        }
        if (n == null || n.isEmpty()) {
            n = "unnamed";
        }
        return this.dbSettings.databaseToUpper ? StringUtils.toUpperEnglish(n) : (this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(n) : n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized void open(int traceLevelFile, int traceLevelSystemOut, ConnectionInfo ci) {
        Object rec;
        if (this.persistent) {
            String dataFileName = this.databaseName + ".data.db";
            boolean existsData = FileUtils.exists(dataFileName);
            String pageFileName = this.databaseName + ".h2.db";
            String mvFileName = this.databaseName + ".mv.db";
            boolean existsPage = FileUtils.exists(pageFileName);
            boolean existsMv = FileUtils.exists(mvFileName);
            if (existsData && !existsPage && !existsMv) {
                throw DbException.get(90048, "Old database: " + dataFileName + " - please convert the database to a SQL script and re-create it.");
            }
            if (existsPage && !FileUtils.canWrite(pageFileName)) {
                this.readOnly = true;
            }
            if (existsMv && !FileUtils.canWrite(mvFileName)) {
                this.readOnly = true;
            }
            if (existsPage && !existsMv) {
                this.dbSettings.mvStore = false;
                this.multiThreaded = ci.getProperty("MULTI_THREADED", false);
            }
            if (this.readOnly) {
                if (traceLevelFile >= 3) {
                    String traceFile = Utils.getProperty("java.io.tmpdir", ".") + "/h2_" + System.currentTimeMillis();
                    this.traceSystem = new TraceSystem(traceFile + ".trace.db");
                } else {
                    this.traceSystem = new TraceSystem(null);
                }
            } else {
                this.traceSystem = new TraceSystem(this.databaseName + ".trace.db");
            }
            this.traceSystem.setLevelFile(traceLevelFile);
            this.traceSystem.setLevelSystemOut(traceLevelSystemOut);
            this.trace = this.traceSystem.getTrace(2);
            this.trace.info("opening {0} (build {1})", this.databaseName, 199);
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == FileLockMethod.NO || this.fileLockMethod == FileLockMethod.SERIALIZED || this.fileLockMethod == FileLockMethod.FS)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED || fileLockMethod == FS || inMemory)");
            }
            String lockFileName = this.databaseName + ".lock.db";
            if (this.readOnly && FileUtils.exists(lockFileName)) {
                throw DbException.get(90020, "Lock file exists: " + lockFileName);
            }
            if (!this.readOnly && this.fileLockMethod != FileLockMethod.NO && this.fileLockMethod != FileLockMethod.FS) {
                this.lock = new FileLock(this.traceSystem, lockFileName, 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            if (SysProperties.MODIFY_ON_WRITE) {
                while (this.isReconnectNeeded()) {
                }
            } else {
                while (this.isReconnectNeeded() && !this.beforeWriting()) {
                }
            }
            this.deleteOldTempFiles();
            this.starting = true;
            if (SysProperties.MODIFY_ON_WRITE) {
                try {
                    this.getPageStore();
                }
                catch (DbException e) {
                    if (e.getErrorCode() != 90097) {
                        throw e;
                    }
                    this.pageStore = null;
                    while (!this.beforeWriting()) {
                    }
                    this.getPageStore();
                }
            } else {
                this.getPageStore();
            }
            this.starting = false;
            if (this.store == null) {
                this.writer = WriterThread.create(this, this.writeDelay);
            } else {
                this.setWriteDelay(this.writeDelay);
            }
        } else {
            if (this.autoServerMode) {
                throw DbException.getUnsupportedException("autoServerMode && inMemory");
            }
            this.traceSystem = new TraceSystem(null);
            this.trace = this.traceSystem.getTrace(2);
            if (this.dbSettings.mvStore) {
                this.getPageStore();
            }
        }
        if (this.store != null) {
            this.store.getTransactionStore().init();
        }
        this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
        this.mainSchema = new Schema(this, 0, this.sysIdentifier("PUBLIC"), this.systemUser, true);
        this.infoSchema = new Schema(this, -1, this.sysIdentifier("INFORMATION_SCHEMA"), this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, this.sysIdentifier("PUBLIC"), true);
        this.roles.put(this.publicRole.getName(), this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        this.lobSession = new Session(this, this.systemUser, ++this.nextSessionId);
        CreateTableData data = new CreateTableData();
        ArrayList<Column> cols = data.columns;
        Column columnId = new Column("ID", 4);
        columnId.setNullable(false);
        cols.add(columnId);
        cols.add(new Column("HEAD", 4));
        cols.add(new Column("TYPE", 4));
        cols.add(new Column("SQL", 13));
        boolean create = true;
        if (this.pageStore != null) {
            create = this.pageStore.isNew();
        }
        data.tableName = "SYS";
        data.id = 0;
        data.temporary = false;
        data.persistData = this.persistent;
        data.persistIndexes = this.persistent;
        data.create = create;
        data.isHidden = true;
        data.session = this.systemSession;
        this.starting = true;
        this.meta = this.mainSchema.createTable(data);
        this.handleUpgradeIssues();
        IndexColumn[] pkCols = IndexColumn.wrap(new Column[]{columnId});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, pkCols, IndexType.createPrimaryKey(false, false), true, null);
        this.systemSession.commit(true);
        this.objectIds.set(0);
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ArrayList<Object> records = new ArrayList<Object>((int)this.metaIdIndex.getRowCountApproximation(this.systemSession));
        while (cursor.next()) {
            rec = new MetaRecord(cursor.get());
            this.objectIds.set(((MetaRecord)rec).getId());
            records.add(rec);
        }
        Collections.sort(records);
        rec = this.systemSession;
        synchronized (rec) {
            for (MetaRecord metaRecord : records) {
                metaRecord.execute(this, this.systemSession, this.eventListener);
            }
        }
        this.systemSession.commit(true);
        if (this.store != null) {
            this.store.getTransactionStore().endLeftoverTransactions();
            this.store.removeTemporaryMaps(this.objectIds);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        if (!this.readOnly) {
            String name = SetTypes.getTypeName(33);
            if (this.settings.get(name) == null) {
                Setting setting = new Setting(this, this.allocateObjectId(), name);
                setting.setIntValue(199);
                this.lockMeta(this.systemSession);
                this.addDatabaseObject(this.systemSession, setting);
            }
            this.setSortSetting(37, SysProperties.SORT_BINARY_UNSIGNED, true);
            this.setSortSetting(50, SysProperties.SORT_UUID_UNSIGNED, false);
            if (this.pageStore != null) {
                void var13_20;
                BitSet f = this.pageStore.getObjectIds();
                boolean bl = false;
                int len = f.length();
                while (var13_20 < len) {
                    if (f.get((int)var13_20) && !this.objectIds.get((int)var13_20)) {
                        this.trace.info("unused object id: " + (int)var13_20);
                        this.objectIds.set((int)var13_20);
                    }
                    ++var13_20;
                }
            }
        }
        this.getLobStorage().init();
        this.systemSession.commit(true);
        this.trace.info("opened {0}", this.databaseName);
        if (this.checkpointAllowed > 0) {
            this.afterWriting();
        }
    }

    private void setSortSetting(int type, boolean defValue, boolean oldDefault) {
        if (defValue == oldDefault) {
            return;
        }
        String name = SetTypes.getTypeName(type);
        if (this.settings.get(name) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(), name);
            setting.setStringValue(defValue ? "UNSIGNED" : "SIGNED");
            this.lockMeta(this.systemSession);
            this.addDatabaseObject(this.systemSession, setting);
        }
    }

    private void handleUpgradeIssues() {
        MVStore mvStore;
        if (this.store != null && !this.isReadOnly() && (mvStore = this.store.getMvStore()).hasMap("index.0")) {
            Index scanIndex = this.meta.getScanIndex(this.systemSession);
            Cursor curs = scanIndex.find(this.systemSession, null, null);
            ArrayList<Row> allMetaRows = new ArrayList<Row>();
            boolean needRepair = false;
            while (curs.next()) {
                Row row = curs.get();
                allMetaRows.add(row);
                long rowId = row.getKey();
                int id = row.getValue(0).getInt();
                if ((long)id == rowId) continue;
                needRepair = true;
                row.setKey(id);
            }
            if (needRepair) {
                Row[] array = allMetaRows.toArray(new Row[0]);
                Arrays.sort(array, new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        return Integer.compare(o1.getValue(0).getInt(), o2.getValue(0).getInt());
                    }
                });
                this.meta.truncate(this.systemSession);
                for (Row row : array) {
                    this.meta.addRow(this.systemSession, row);
                }
                this.systemSession.commit(true);
            }
            mvStore.removeMap("index.0");
            mvStore.commit();
        }
    }

    private void startServer(String key) {
        try {
            this.server = Server.createTcpServer("-tcpPort", Integer.toString(this.autoServerPort), "-tcpAllowOthers", "-tcpDaemon", "-key", key, this.databaseName);
            this.server.start();
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        String localAddress = NetUtils.getLocalAddress();
        String address = localAddress + ":" + this.server.getPort();
        this.lock.setProperty("server", address);
        String hostName = NetUtils.getHostName(localAddress);
        this.lock.setProperty("hostName", hostName);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server s2 = this.server;
            this.server = null;
            s2.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        boolean atLeastOneRecompiledSuccessfully;
        do {
            atLeastOneRecompiledSuccessfully = false;
            for (Table obj : this.getAllTablesAndViews(false)) {
                TableView view;
                if (!(obj instanceof TableView) || !(view = (TableView)obj).isInvalid()) continue;
                view.recompile(session, true, false);
                if (view.isInvalid()) continue;
                atLeastOneRecompiledSuccessfully = true;
            }
        } while (atLeastOneRecompiledSuccessfully);
        TableView.clearIndexCaches(session.getDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaTables() {
        if (this.metaTablesInitialized) {
            return;
        }
        Schema schema = this.infoSchema;
        synchronized (schema) {
            if (!this.metaTablesInitialized) {
                int count = MetaTable.getMetaTableTypeCount();
                for (int type = 0; type < count; ++type) {
                    MetaTable m4 = new MetaTable(this.infoSchema, -1 - type, type);
                    this.infoSchema.add(m4);
                }
                this.metaTablesInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMeta(Session session, DbObject obj) {
        assert (Thread.holdsLock(this));
        int id = obj.getId();
        if (id > 0 && !this.starting && !obj.isTemporary()) {
            Row r = this.meta.getTemplateRow();
            MetaRecord.populateRowFromDBObject(obj, r);
            BitSet bitSet = this.objectIds;
            synchronized (bitSet) {
                this.objectIds.set(id);
            }
            if (SysProperties.CHECK) {
                this.verifyMetaLocked(session);
            }
            this.meta.addRow(session, r);
        }
    }

    public void verifyMetaLocked(Session session) {
        if (this.meta != null && !this.meta.isLockedExclusivelyBy(session) && this.lockMode != 0) {
            throw DbException.throwInternalError();
        }
    }

    public boolean lockMeta(Session session) {
        if (this.meta == null) {
            return true;
        }
        if (ASSERT && META_LOCK_DEBUGGING_DB.get() != null && META_LOCK_DEBUGGING_DB.get() != this) {
            Session prev = META_LOCK_DEBUGGING.get();
            if (prev == null) {
                META_LOCK_DEBUGGING.set(session);
                META_LOCK_DEBUGGING_DB.set(this);
                META_LOCK_DEBUGGING_STACK.set(new Throwable("Last meta lock granted in this stack trace, this is debug information for following IllegalStateException"));
            } else if (prev != session) {
                META_LOCK_DEBUGGING_STACK.get().printStackTrace();
                throw new IllegalStateException("meta currently locked by " + prev + ", sessionid=" + prev.getId() + " and trying to be locked by different session, " + session + ", sessionid=" + session.getId() + " on same thread");
            }
        }
        return this.meta.lock(session, true, true);
    }

    public void unlockMeta(Session session) {
        if (this.meta != null) {
            this.unlockMetaDebug(session);
            this.meta.unlock(session);
            session.unlock(this.meta);
        }
    }

    public void unlockMetaDebug(Session session) {
        if (ASSERT && META_LOCK_DEBUGGING.get() == session) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeta(Session session, int id) {
        if (id > 0 && !this.starting) {
            SearchRow r = this.meta.getTemplateSimpleRow(false);
            r.setValue(0, ValueInt.get(id));
            boolean wasLocked = this.lockMeta(session);
            try {
                Cursor cursor = this.metaIdIndex.find(session, r, r);
                if (cursor.next()) {
                    if (this.lockMode != 0 && !wasLocked) {
                        throw DbException.throwInternalError();
                    }
                    Row found = cursor.get();
                    this.meta.removeRow(session, found);
                    if (SysProperties.CHECK) {
                        this.checkMetaFree(session, id);
                    }
                }
            }
            finally {
                if (!wasLocked) {
                    this.unlockMeta(session);
                }
            }
            if (this.isMVStore()) {
                session.scheduleDatabaseObjectIdForRelease(id);
            } else {
                Database database = this;
                synchronized (database) {
                    this.objectIds.clear(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseDatabaseObjectIds(BitSet idsToRelease) {
        BitSet bitSet = this.objectIds;
        synchronized (bitSet) {
            this.objectIds.andNot(idsToRelease);
        }
    }

    private HashMap<String, DbObject> getMap(int type) {
        HashMap<String, DbObject> result;
        switch (type) {
            case 2: {
                result = this.users;
                break;
            }
            case 6: {
                result = this.settings;
                break;
            }
            case 7: {
                result = this.roles;
                break;
            }
            case 8: {
                result = this.rights;
                break;
            }
            case 10: {
                result = this.schemas;
                break;
            }
            case 12: {
                result = this.domains;
                break;
            }
            case 13: {
                result = this.comments;
                break;
            }
            case 14: {
                result = this.aggregates;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(Session session, SchemaObject obj) {
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        this.lockMeta(session);
        Database database = this;
        synchronized (database) {
            obj.getSchema().add(obj);
            this.addMeta(session, obj);
        }
    }

    public synchronized void addDatabaseObject(Session session, DbObject obj) {
        User user;
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> map = this.getMap(obj.getType());
        if (obj.getType() == 2 && (user = (User)obj).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(user.getName());
        }
        String name = obj.getName();
        if (SysProperties.CHECK && map.get(name) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.lockMeta(session);
        this.addMeta(session, obj);
        map.put(name, obj);
    }

    public UserAggregate findAggregate(String name) {
        return this.aggregates.get(name);
    }

    public Comment findComment(DbObject object) {
        if (object.getType() == 13) {
            return null;
        }
        String key = Comment.getKey(object);
        return this.comments.get(key);
    }

    public Role findRole(String roleName) {
        return this.roles.get(StringUtils.toUpperEnglish(roleName));
    }

    public Schema findSchema(String schemaName) {
        Schema schema = this.schemas.get(schemaName);
        if (schema == this.infoSchema) {
            this.initMetaTables();
        }
        return schema;
    }

    public Setting findSetting(String name) {
        return this.settings.get(name);
    }

    public User findUser(String name) {
        return this.users.get(StringUtils.toUpperEnglish(name));
    }

    public Domain findDomain(String name) {
        return this.domains.get(name);
    }

    public User getUser(String name) {
        User user = this.findUser(name);
        if (user == null) {
            throw DbException.get(90032, name);
        }
        return user;
    }

    synchronized Session createSession(User user) {
        if (this.closing) {
            return null;
        }
        if (this.exclusiveSession.get() != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.trace.info("connecting session #{0} to {1}", session.getId(), this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            this.exclusiveSession.compareAndSet(session, null);
            this.userSessions.remove(session);
            if (session != this.systemSession && session != this.lobSession) {
                this.trace.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.userSessions.isEmpty() && session != this.systemSession && session != this.lobSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DelayedDatabaseCloser(this, this.closeDelay * 1000);
            }
        }
        if (session != this.systemSession && session != this.lobSession && session != null) {
            this.trace.info("disconnected session #{0}", session.getId());
        }
    }

    private synchronized void closeAllSessionsException(Session except) {
        Session[] all;
        for (Session s2 : all = this.userSessions.toArray(EMPTY_SESSION_ARRAY)) {
            if (s2 == except) continue;
            try {
                s2.close();
            }
            catch (DbException e) {
                this.trace.error(e, "disconnecting session #{0}", s2.getId());
            }
        }
    }

    void close(boolean fromShutdownHook) {
        DbException b = this.backgroundException.getAndSet(null);
        try {
            this.closeImpl(fromShutdownHook);
        }
        catch (Throwable t2) {
            if (b != null) {
                t2.addSuppressed(b);
            }
            throw t2;
        }
        if (b != null) {
            throw DbException.get(b.getErrorCode(), b, b.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeImpl(boolean fromShutdownHook) {
        block33: {
            var2_2 = this;
            synchronized (var2_2) {
                if (this.closing) {
                    // MONITOREXIT @DISABLED, blocks:[0, 12, 30] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                    Engine.getInstance().close(this.databaseName);
                    return;
                }
                if (this.fileLockMethod != FileLockMethod.SERIALIZED || this.reconnectChangePending) ** break block32
            }
            {
                try {
                    this.closeOpenFilesAndUnlock(false);
                }
                catch (DbException var3_6) {
                    // empty catch block
                }
                this.traceSystem.close();
            }
            Engine.getInstance().close(this.databaseName);
            return;
            {
                this.closing = true;
                this.stopServer();
                if (!this.userSessions.isEmpty()) {
                    if (!fromShutdownHook) {
                        // MONITOREXIT @DISABLED, blocks:[28, 12, 29] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                        Engine.getInstance().close(this.databaseName);
                        return;
                    }
                    this.trace.info("closing {0} from shutdown hook", new Object[]{this.databaseName});
                    this.closeAllSessionsException(null);
                }
                this.trace.info("closing {0}", new Object[]{this.databaseName});
                if (this.eventListener != null) {
                    this.closing = false;
                    e = this.eventListener;
                    this.eventListener = null;
                    e.closingDatabase();
                    if (!this.userSessions.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[26, 27, 12] lbl37 : MonitorExitStatement: MONITOREXIT : var2_2
                        Engine.getInstance().close(this.databaseName);
                        return;
                    }
                    ** try [egrp 6[TRYBLOCK] [15 : 208->544)] { 
lbl41:
                    // 1 sources

                    this.closing = true;
                }
                if (!this.isReadOnly()) {
                    this.removeOrphanedLobs();
                }
            }
            try {
                if (this.systemSession == null) break block33;
                if (this.powerOffCount != -1) {
                    for (Table table : this.getAllTablesAndViews(false)) {
                        if (table.isGlobalTemporary()) {
                            table.removeChildrenAndResources(this.systemSession);
                            continue;
                        }
                        table.close(this.systemSession);
                    }
                    for (SchemaObject obj : this.getAllSchemaObjects(3)) {
                        sequence = (Sequence)obj;
                        sequence.close();
                    }
                }
                for (SchemaObject obj : this.getAllSchemaObjects(4)) {
                    trigger = (TriggerObject)obj;
                    try {
                        trigger.close();
                    }
                    catch (SQLException e) {
                        this.trace.error(e, "close");
                    }
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
            }
            catch (DbException e) {
                this.trace.error(e, "close");
            }
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
        this.trace.info("closed");
        this.traceSystem.close();
        OnExitDatabaseCloser.unregister(this);
        if (this.deleteFilesOnDisconnect == false) return;
        if (this.persistent == false) return;
        this.deleteFilesOnDisconnect = false;
        try {
            directory = FileUtils.getParent(this.databaseName);
            name = FileUtils.getName(this.databaseName);
            DeleteDbFiles.execute(directory, name, true);
            return;
        }
        catch (Exception var2_5) {
            // empty catch block
            return;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                Engine.getInstance().close(this.databaseName);
            }
        }
    }

    private void removeOrphanedLobs() {
        if (!this.persistent) {
            return;
        }
        boolean lobStorageIsUsed = this.infoSchema.findTableOrView(this.systemSession, "LOB_DATA") != null;
        if (!(lobStorageIsUsed |= this.store != null)) {
            return;
        }
        try {
            this.getLobStorage();
            this.lobStorage.removeAllForTable(-1);
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeOpenFilesAndUnlock(boolean flush) {
        try {
            MVStore mvStore;
            this.stopWriter();
            if (this.pageStore != null && flush) {
                try {
                    this.pageStore.checkpoint();
                    if (!this.readOnly) {
                        this.lockMeta(this.pageStore.getPageStoreSession());
                        this.pageStore.compact(this.compactMode);
                        this.unlockMeta(this.pageStore.getPageStoreSession());
                    }
                }
                catch (DbException e) {
                    int code;
                    if (ASSERT && (code = e.getErrorCode()) != 90098 && code != 50200 && code != 90031) {
                        e.printStackTrace();
                    }
                    this.trace.error(e, "close");
                }
                catch (Throwable t2) {
                    if (ASSERT) {
                        t2.printStackTrace();
                    }
                    this.trace.error(t2, "close");
                }
            }
            this.reconnectModified(false);
            if (this.store != null && (mvStore = this.store.getMvStore()) != null && !mvStore.isClosed()) {
                boolean compactFully;
                boolean bl = compactFully = this.compactMode == 82 || this.compactMode == 84 || this.getSettings().defragAlways;
                if (!compactFully && !mvStore.isReadOnly()) {
                    if (this.dbSettings.maxCompactTime > 0) {
                        try {
                            this.store.compactFile(this.dbSettings.maxCompactTime);
                        }
                        catch (Throwable t3) {
                            this.trace.error(t3, "compactFile");
                        }
                    } else {
                        mvStore.commit();
                    }
                }
                this.store.close(compactFully);
            }
            if (this.systemSession != null) {
                this.systemSession.close();
                this.systemSession = null;
            }
            if (this.lobSession != null) {
                this.lobSession.close();
                this.lobSession = null;
            }
            this.closeFiles();
            if (this.persistent && this.lock == null && this.fileLockMethod != FileLockMethod.NO && this.fileLockMethod != FileLockMethod.FS) {
                return;
            }
            if (this.persistent) {
                this.deleteOldTempFiles();
            }
        }
        finally {
            if (this.lock != null) {
                if (this.fileLockMethod == FileLockMethod.SERIALIZED && this.lock.load().containsKey("changePending")) {
                    try {
                        Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                    }
                    catch (InterruptedException e) {
                        this.trace.error(e, "close");
                    }
                }
                this.lock.unlock();
                this.lock = null;
            }
        }
    }

    private synchronized void closeFiles() {
        try {
            if (this.store != null) {
                this.store.closeImmediately();
            }
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
    }

    private void checkMetaFree(Session session, int id) {
        SearchRow r = this.meta.getTemplateSimpleRow(false);
        r.setValue(0, ValueInt.get(id));
        Cursor cursor = this.metaIdIndex.find(session, r, r);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateObjectId() {
        int i;
        Object lock;
        Object object = lock = this.isMVStore() ? this.objectIds : this;
        synchronized (object) {
            i = this.objectIds.nextClearBit(0);
            this.objectIds.set(i);
        }
        return i;
    }

    public Schema getMainSchema() {
        return this.mainSchema;
    }

    public ArrayList<UserAggregate> getAllAggregates() {
        return new ArrayList<UserAggregate>(this.aggregates.values());
    }

    public ArrayList<Comment> getAllComments() {
        return new ArrayList<Comment>(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return new ArrayList<Right>(this.rights.values());
    }

    public ArrayList<Role> getAllRoles() {
        return new ArrayList<Role>(this.roles.values());
    }

    public ArrayList<SchemaObject> getAllSchemaObjects() {
        this.initMetaTables();
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (Schema schema : this.schemas.values()) {
            schema.getAll(list);
        }
        return list;
    }

    public ArrayList<SchemaObject> getAllSchemaObjects(int type) {
        if (type == 0) {
            this.initMetaTables();
        }
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (Schema schema : this.schemas.values()) {
            schema.getAll(type, list);
        }
        return list;
    }

    public ArrayList<Table> getAllTablesAndViews(boolean includeMeta) {
        if (includeMeta) {
            this.initMetaTables();
        }
        ArrayList<Table> list = new ArrayList<Table>();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAllTablesAndViews());
        }
        return list;
    }

    public ArrayList<TableSynonym> getAllSynonyms() {
        ArrayList<TableSynonym> list = new ArrayList<TableSynonym>();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAllSynonyms());
        }
        return list;
    }

    public ArrayList<Table> getTableOrViewByName(String name) {
        ArrayList<Table> list = new ArrayList<Table>(1);
        for (Schema schema : this.schemas.values()) {
            Table table = schema.getTableOrViewByName(name);
            if (table == null) continue;
            list.add(table);
        }
        return list;
    }

    public ArrayList<Schema> getAllSchemas() {
        this.initMetaTables();
        return new ArrayList<Schema>(this.schemas.values());
    }

    public ArrayList<Setting> getAllSettings() {
        return new ArrayList<Setting>(this.settings.values());
    }

    public ArrayList<Domain> getAllDomains() {
        return new ArrayList<Domain>(this.domains.values());
    }

    public ArrayList<User> getAllUsers() {
        return new ArrayList<User>(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    @Override
    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.toRealPath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean includingSystemSession) {
        ArrayList<Session> list;
        Set<Session> set = this.userSessions;
        synchronized (set) {
            list = new ArrayList<Session>(this.userSessions);
        }
        Session sys = this.systemSession;
        Session lob = this.lobSession;
        if (includingSystemSession && sys != null) {
            list.add(sys);
        }
        if (includingSystemSession && lob != null) {
            list.add(lob);
        }
        return list.toArray(new Session[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeta(Session session, DbObject obj) {
        if (this.isMVStore()) {
            int id = obj.getId();
            if (id > 0) {
                if (!this.starting && !obj.isTemporary()) {
                    Row newRow = this.meta.getTemplateRow();
                    MetaRecord.populateRowFromDBObject(obj, newRow);
                    Row oldRow = this.metaIdIndex.getRow(session, id);
                    if (oldRow != null) {
                        this.meta.updateRow(session, oldRow, newRow);
                    }
                }
                BitSet bitSet = this.objectIds;
                synchronized (bitSet) {
                    this.objectIds.set(id);
                }
            }
        } else {
            boolean metaWasLocked = this.lockMeta(session);
            Database database = this;
            synchronized (database) {
                int id = obj.getId();
                this.removeMeta(session, id);
                this.addMeta(session, obj);
                if (id > 0) {
                    this.objectIds.set(id);
                }
            }
            if (!metaWasLocked) {
                this.unlockMeta(session);
            }
        }
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject obj, String newName) {
        this.checkWritingAllowed();
        obj.getSchema().rename(obj, newName);
        this.updateMetaAndFirstLevelChildren(session, obj);
    }

    private synchronized void updateMetaAndFirstLevelChildren(Session session, DbObject obj) {
        ArrayList<DbObject> list = obj.getChildren();
        Comment comment = this.findComment(obj);
        if (comment != null) {
            DbException.throwInternalError(comment.toString());
        }
        this.updateMeta(session, obj);
        if (list != null) {
            for (DbObject o : list) {
                if (o.getCreateSQL() == null) continue;
                this.updateMeta(session, o);
            }
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject obj, String newName) {
        this.checkWritingAllowed();
        int type = obj.getType();
        HashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                DbException.throwInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                DbException.throwInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        map.remove(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.updateMetaAndFirstLevelChildren(session, obj);
    }

    public String createTempFile() {
        try {
            boolean inTempDir = this.readOnly;
            String name = this.databaseName;
            if (!this.persistent) {
                name = "memFS:" + name;
            }
            return FileUtils.createTempFile(name, ".temp.db", inTempDir);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.databaseName);
        }
    }

    private void deleteOldTempFiles() {
        String path = FileUtils.getParent(this.databaseName);
        for (String name : FileUtils.newDirectoryStream(path)) {
            if (!name.endsWith(".temp.db") || !name.startsWith(this.databaseName)) continue;
            FileUtils.tryDelete(name);
        }
    }

    public Schema getSchema(String schemaName) {
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            throw DbException.get(90079, schemaName);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject obj) {
        this.checkWritingAllowed();
        String objName = obj.getName();
        int type = obj.getType();
        HashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK && !map.containsKey(objName)) {
            DbException.throwInternalError("not found: " + objName);
        }
        Comment comment = this.findComment(obj);
        this.lockMeta(session);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        int id = obj.getId();
        obj.removeChildrenAndResources(session);
        map.remove(objName);
        this.removeMeta(session, id);
    }

    public Table getDependentTable(SchemaObject obj, Table except) {
        switch (obj.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> set = new HashSet<DbObject>();
        for (Table t2 : this.getAllTablesAndViews(false)) {
            if (except == t2 || TableType.VIEW == t2.getTableType()) continue;
            set.clear();
            t2.addDependencies(set);
            if (!set.contains(obj)) continue;
            return t2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(Session session, SchemaObject obj) {
        Constraint constraint;
        Table table;
        int type = obj.getType();
        if (type == 0) {
            Table table2 = (Table)obj;
            if (table2.isTemporary() && !table2.isGlobalTemporary()) {
                session.removeLocalTempTable(table2);
                return;
            }
        } else if (type == 1) {
            Index index = (Index)obj;
            table = index.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex(index);
                return;
            }
        } else if (type == 5 && (table = (constraint = (Constraint)obj).getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint(constraint);
            return;
        }
        this.checkWritingAllowed();
        this.lockMeta(session);
        Database database = this;
        synchronized (database) {
            Comment comment = this.findComment(obj);
            if (comment != null) {
                this.removeDatabaseObject(session, comment);
            }
            obj.getSchema().remove(obj);
            int id = obj.getId();
            if (!this.starting) {
                Table t2 = this.getDependentTable(obj, null);
                if (t2 != null) {
                    obj.getSchema().add(obj);
                    throw DbException.get(90107, obj.getSQL(false), t2.getSQL(false));
                }
                obj.removeChildrenAndResources(session);
            }
            this.removeMeta(session, id);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int kb) {
        if (this.starting) {
            int max = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            kb = Math.min(kb, max);
        }
        this.cacheSize = kb;
        if (this.pageStore != null) {
            this.pageStore.setMaxCacheMemory(kb);
        }
        if (this.store != null) {
            this.store.setCacheSize(Math.max(1, kb));
        }
    }

    public synchronized void setMasterUser(User user) {
        this.lockMeta(this.systemSession);
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public synchronized String getTempTableName(String baseName, Session session) {
        String tempName;
        while (this.mainSchema.findTableOrView(session, tempName = baseName + "_COPY_" + session.getId() + "_" + this.nextTempTableId++) != null) {
        }
        return tempName;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
        if (this.fileLockMethod == FileLockMethod.SERIALIZED && !this.reconnectChangePending) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int value) {
        this.writeDelay = value;
        if (this.writer != null) {
            this.writer.setWriteDelay(value);
            boolean bl = this.flushOnEachCommit = this.writeDelay < 5;
        }
        if (this.store != null) {
            int millis = value < 0 ? 0 : value;
            this.store.getMvStore().setAutoCommitDelay(millis);
        }
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int value) {
        this.retentionTime = value;
        if (this.store != null) {
            this.store.getMvStore().setRetentionTime(value);
        }
    }

    public void setAllowBuiltinAliasOverride(boolean b) {
        this.allowBuiltinAliasOverride = b;
    }

    public boolean isAllowBuiltinAliasOverride() {
        return this.allowBuiltinAliasOverride;
    }

    public boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        if (this.store != null) {
            return this.store.getInDoubtTransactions();
        }
        return this.pageStore == null ? null : this.pageStore.getInDoubtTransactions();
    }

    synchronized void prepareCommit(Session session, String transaction) {
        if (this.readOnly) {
            return;
        }
        if (this.store != null) {
            this.store.prepareCommit(session, transaction);
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.flushLog();
            this.pageStore.prepareCommit(session, transaction);
        }
    }

    synchronized void commit(Session session) {
        this.throwLastBackgroundException();
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.commit(session);
        }
        session.setAllCommitted();
    }

    private void throwLastBackgroundException() {
        DbException b = this.backgroundException.getAndSet(null);
        if (b != null) {
            throw DbException.get(b.getErrorCode(), b, b.getMessage());
        }
    }

    public void setBackgroundException(DbException e) {
        TraceSystem t2;
        if (this.backgroundException.compareAndSet(null, e) && (t2 = this.getTraceSystem()) != null) {
            t2.getTrace(2).error(e, "flush");
        }
    }

    public Throwable getBackgroundException() {
        IllegalStateException exception = this.store.getMvStore().getPanicException();
        if (exception != null) {
            return exception;
        }
        return this.backgroundException.getAndSet(null);
    }

    public synchronized void flush() {
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.flushLog();
        }
        if (this.store != null) {
            try {
                this.store.flush();
            }
            catch (RuntimeException e) {
                this.backgroundException.compareAndSet(null, DbException.convert(e));
                throw e;
            }
        }
    }

    public void setEventListener(DatabaseEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setEventListenerClass(String className) {
        if (className == null || className.isEmpty()) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)JdbcUtils.loadUserClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String url = this.databaseURL;
                if (this.cipher != null) {
                    url = url + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(url);
            }
            catch (Throwable e) {
                throw DbException.get(90099, e, className, e.toString());
            }
        }
    }

    public void setProgress(int state, String name, int x, int max) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(state, name, x, max);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException e, String sql) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(e, sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        if (this.readOnly) {
            return;
        }
        if (this.store != null) {
            this.store.sync();
        }
        if (this.pageStore != null) {
            this.pageStore.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int value) {
        this.maxMemoryRows = value;
    }

    public void setMaxMemoryUndo(int value) {
        this.maxMemoryUndo = value;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int lockMode) {
        switch (lockMode) {
            case 0: {
                if (!this.multiThreaded || this.isMVStore()) break;
                throw DbException.get(90021, "MV_STORE=FALSE & LOCK_MODE=0 & MULTI_THREADED=TRUE");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", lockMode);
            }
        }
        this.lockMode = lockMode;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void setCloseDelay(int value) {
        this.closeDelay = value;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int value) {
        this.maxLengthInplaceLob = value;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.maxLengthInplaceLob;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean b) {
        this.deleteFilesOnDisconnect = b;
    }

    @Override
    public String getLobCompressionAlgorithm(int type) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String stringValue) {
        this.lobCompressionAlgorithm = stringValue;
    }

    public synchronized void setMaxLogSize(long value) {
        if (this.pageStore != null) {
            this.pageStore.setMaxLogSize(value);
        }
    }

    public void setAllowLiterals(int value) {
        this.allowLiterals = value;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean b) {
        this.optimizeReuseResults = b;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean b) {
        this.referentialIntegrity = b;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatistics(boolean b) {
        this.queryStatistics = b;
        Database database = this;
        synchronized (database) {
            if (!b) {
                this.queryStatisticsData = null;
            }
        }
    }

    public boolean getQueryStatistics() {
        return this.queryStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatisticsMaxEntries(int n) {
        this.queryStatisticsMaxEntries = n;
        if (this.queryStatisticsData != null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData != null) {
                    this.queryStatisticsData.setMaxQueryEntries(this.queryStatisticsMaxEntries);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStatisticsData getQueryStatisticsData() {
        if (!this.queryStatistics) {
            return null;
        }
        if (this.queryStatisticsData == null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData == null) {
                    this.queryStatisticsData = new QueryStatisticsData(this.queryStatisticsMaxEntries);
                }
            }
        }
        return this.queryStatisticsData;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMVStore() {
        return this.dbSettings.mvStore;
    }

    void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
        if (this.writer != null) {
            this.writer.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean multiThreaded) {
        if (multiThreaded && this.multiThreaded != multiThreaded && this.lockMode == 0 && !this.isMVStore()) {
            throw DbException.get(90021, "MV_STORE=FALSE & LOCK_MODE=0 & MULTI_THREADED=TRUE");
        }
        this.multiThreaded = multiThreaded;
    }

    public void setMaxOperationMemory(int maxOperationMemory) {
        this.maxOperationMemory = maxOperationMemory;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession.get();
    }

    public void setExclusiveSession(Session session, boolean closeOthers) {
        this.exclusiveSession.set(session);
        if (closeOthers) {
            this.closeAllSessionsException(session);
        }
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        if (this.lobFileListCache == null) {
            this.lobFileListCache = SmallLRUCache.newInstance(128);
        }
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public boolean isSysTableLockedBy(Session session) {
        return this.meta == null || this.meta.isLockedExclusivelyBy(session);
    }

    public TableLinkConnection getLinkConnection(String driver, String url, String user, String password) {
        if (this.linkConnections == null) {
            this.linkConnections = new HashMap();
        }
        return TableLinkConnection.open(this.linkConnections, driver, url, user, password, this.dbSettings.shareLinkedConnections);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.closing = true;
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageStore getPageStore() {
        if (this.dbSettings.mvStore) {
            if (this.store == null) {
                this.store = MVTableEngine.init(this);
            }
            return null;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore == null) {
                this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
                if (this.pageSize != 4096) {
                    this.pageStore.setPageSize(this.pageSize);
                }
                if (!this.readOnly && this.fileLockMethod == FileLockMethod.FS) {
                    this.pageStore.setLockFile(true);
                }
                this.pageStore.setLogMode(this.logMode);
                this.pageStore.open();
            }
            return this.pageStore;
        }
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden() || table.getSchema().getId() == -1 && table.getName().equalsIgnoreCase("LOB_BLOCKS")) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long now = System.nanoTime();
        if (now < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = now + this.reconnectCheckDelayNs;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties prop;
            Properties first = prop = this.lock.load();
            while (true) {
                if (prop.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (prop.getProperty("changePending", null) == null) break;
                if (System.nanoTime() > now + this.reconnectCheckDelayNs * 10L && first.equals(prop)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.trace.debug("delay (change pending)");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.reconnectCheckDelayNs));
                prop = this.lock.load();
            }
            this.reconnectLastLock = prop;
        }
        catch (Exception e) {
            this.trace.error(e, "readOnly {0}", this.readOnly);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long now = System.nanoTime();
        if (now > this.reconnectCheckNext + this.reconnectCheckDelayNs) {
            if (this.checkpointAllowed < 0) {
                DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
            }
            Object object = this.reconnectSync;
            synchronized (object) {
                if (this.checkpointAllowed > 0) {
                    return;
                }
                this.checkpointRunning = true;
            }
            object = this;
            synchronized (object) {
                this.trace.debug("checkpoint start");
                this.flushSequences();
                this.checkpoint();
                this.reconnectModified(false);
                this.trace.debug("checkpoint end");
            }
            object = this.reconnectSync;
            synchronized (object) {
                this.checkpointRunning = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == FileLockMethod.SERIALIZED;
    }

    private void flushSequences() {
        for (SchemaObject obj : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)obj;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.persistent) {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.checkpoint();
                }
            }
            if (this.store != null) {
                this.store.flush();
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return true;
        }
        while (this.checkpointRunning) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                if (++this.checkpointAllowed > 20) {
                    throw DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
                }
                return true;
            }
        }
        this.reconnectCheckNext = System.nanoTime() - 1L;
        this.reconnectLastLock = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return;
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            --this.checkpointAllowed;
        }
        if (this.checkpointAllowed < 0) {
            throw DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCompactMode(int compactMode) {
        this.compactMode = compactMode;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorageInterface getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = this.dbSettings.mvStore ? new LobStorageMap(this) : new LobStorageBackend(this);
        }
        return this.lobStorage;
    }

    public JdbcConnection getLobConnectionForInit() {
        String url = "jdbc:default:connection";
        JdbcConnection conn = new JdbcConnection(this.systemSession, this.systemUser.getName(), url);
        conn.setTraceLevel(0);
        return conn;
    }

    public JdbcConnection getLobConnectionForRegularUse() {
        String url = "jdbc:default:connection";
        JdbcConnection conn = new JdbcConnection(this.lobSession, this.systemUser.getName(), url);
        conn.setTraceLevel(0);
        return conn;
    }

    public Session getLobSession() {
        return this.lobSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogMode(int log) {
        if (log < 0 || log > 2) {
            throw DbException.getInvalidValueException("LOG", log);
        }
        if (this.store != null) {
            this.logMode = log;
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore != null) {
                if (log != 2 || this.pageStore.getLogMode() != 2) {
                    this.trace.error(null, "log {0}", log);
                }
                this.logMode = log;
                this.pageStore.setLogMode(log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogMode() {
        if (this.store != null) {
            return this.logMode;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore != null) {
                return this.pageStore.getLogMode();
            }
        }
        return 0;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void setDefaultTableType(int defaultTableType) {
        this.defaultTableType = defaultTableType;
    }

    public DbSettings getSettings() {
        return this.dbSettings;
    }

    public <V> HashMap<String, V> newStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveMap() : new HashMap();
    }

    public <V> ConcurrentHashMap<String, V> newConcurrentStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveConcurrentMap() : new ConcurrentHashMap();
    }

    public boolean equalsIdentifiers(String a, String b) {
        return a.equals(b) || this.dbSettings.caseInsensitiveIdentifiers && a.equalsIgnoreCase(b);
    }

    public String sysIdentifier(String upperName) {
        assert (Database.isUpperSysIdentifier(upperName));
        return this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(upperName) : upperName;
    }

    private static boolean isUpperSysIdentifier(String upperName) {
        int l = upperName.length();
        if (l == 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char ch = upperName.charAt(i);
            if (ch >= 'A' && (ch <= 'Z' || ch == '_')) continue;
            return false;
        }
        return true;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.throwInternalError();
    }

    public byte[] getFileEncryptionKey() {
        return this.fileEncryptionKey;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        this.initJavaObjectSerializer();
        return this.javaObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJavaObjectSerializer() {
        if (this.javaObjectSerializerInitialized) {
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.javaObjectSerializerInitialized) {
                return;
            }
            String serializerName = this.javaObjectSerializerName;
            if (serializerName != null && !(serializerName = serializerName.trim()).isEmpty() && !serializerName.equals("null")) {
                try {
                    this.javaObjectSerializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(serializerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            }
            this.javaObjectSerializerInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectSerializerName(String serializerName) {
        Database database = this;
        synchronized (database) {
            this.javaObjectSerializerInitialized = false;
            this.javaObjectSerializerName = serializerName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectSerializer(JavaObjectSerializer serializer) {
        Database database = this;
        synchronized (database) {
            this.javaObjectSerializer = serializer;
            this.javaObjectSerializerInitialized = true;
        }
    }

    public TableEngine getTableEngine(String tableEngine) {
        assert (Thread.holdsLock(this));
        TableEngine engine = this.tableEngines.get(tableEngine);
        if (engine == null) {
            try {
                engine = (TableEngine)JdbcUtils.loadUserClass(tableEngine).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
            this.tableEngines.put(tableEngine, engine);
        }
        return engine;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (authenticator != null) {
            authenticator.init(this);
        }
        this.authenticator = authenticator;
    }

    static {
        EMPTY_SESSION_ARRAY = new Session[0];
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT = a;
        if (a) {
            META_LOCK_DEBUGGING = new ThreadLocal();
            META_LOCK_DEBUGGING_DB = new ThreadLocal();
            META_LOCK_DEBUGGING_STACK = new ThreadLocal();
        } else {
            META_LOCK_DEBUGGING = null;
            META_LOCK_DEBUGGING_DB = null;
            META_LOCK_DEBUGGING_STACK = null;
        }
    }
}

