/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.SetTypes;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.Setting;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LocalResultFactory;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.RowFactory;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.security.auth.AuthenticatorFactory;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.tools.CompressTool;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.ValueInt;

public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 34: 
            case 35: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Database database = this.session.getDatabase();
        String name = SetTypes.getTypeName(this.type);
        block7 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", this.getIntValue());
                }
                database.setAllowLiterals(value);
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            case 8: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 13: {
                Session sysSession;
                String value;
                if ("TRUE".equals(this.stringValue) || (value = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!value.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(value);
                Session session = sysSession = database.getSystemSession();
                synchronized (session) {
                    Database database2 = database;
                    synchronized (database2) {
                        this.addOrUpdateSetting(sysSession, name, value, 0);
                        sysSession.commit(true);
                    }
                }
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                CompareMode currentMode = database.getCompareMode();
                boolean binaryUnsigned = currentMode.isBinaryUnsigned();
                boolean uuidUnsigned = currentMode.isUuidUnsigned();
                StringBuilder buff = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0, binaryUnsigned, uuidUnsigned);
                } else {
                    int strength = this.getIntValue();
                    buff.append(" STRENGTH ");
                    if (strength == 3) {
                        buff.append("IDENTICAL");
                    } else if (strength == 0) {
                        buff.append("PRIMARY");
                    } else if (strength == 1) {
                        buff.append("SECONDARY");
                    } else if (strength == 2) {
                        buff.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, strength, binaryUnsigned, uuidUnsigned);
                }
                CompareMode old = database.getCompareMode();
                if (old.equals(compareMode)) break;
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL(false));
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 37: {
                Table table;
                boolean unsigned;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    unsigned = false;
                } else if (this.stringValue.equals("UNSIGNED")) {
                    unsigned = true;
                } else {
                    throw DbException.getInvalidValueException("BINARY_COLLATION", this.stringValue);
                }
                CompareMode currentMode = database.getCompareMode();
                if (currentMode.isBinaryUnsigned() != unsigned && (table = database.getFirstUserTable()) != null) {
                    throw DbException.get(90089, table.getSQL(false));
                }
                CompareMode newMode = CompareMode.getInstance(currentMode.getName(), currentMode.getStrength(), unsigned, currentMode.isUuidUnsigned());
                this.addOrUpdateSetting(name, this.stringValue, 0);
                database.setCompareMode(newMode);
                break;
            }
            case 50: {
                Table table;
                boolean unsigned;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    unsigned = false;
                } else if (this.stringValue.equals("UNSIGNED")) {
                    unsigned = true;
                } else {
                    throw DbException.getInvalidValueException("UUID_COLLATION", this.stringValue);
                }
                CompareMode currentMode = database.getCompareMode();
                if (currentMode.isUuidUnsigned() != unsigned && (table = database.getFirstUserTable()) != null) {
                    throw DbException.get(90089, table.getSQL(false));
                }
                CompareMode newMode = CompareMode.getInstance(currentMode.getName(), currentMode.getStrength(), currentMode.isBinaryUnsigned(), unsigned);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                database.setCompareMode(newMode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int algo = CompressTool.getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(algo == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int value = this.getIntValue();
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                int x = this.getIntValue();
                if (x != -1 && x < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", x);
                }
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 6: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                database.setDefaultTableType(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 32: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                switch (value) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block7;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block7;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block7;
                    }
                }
                throw DbException.getInvalidValueException("EXCLUSIVE", value);
            }
            case 38: {
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90141, table.getSQL(false));
                }
                database.setJavaObjectSerializerName(this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 5: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 19: {
                int value = this.getIntValue();
                if (!database.isPersistent() || value == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(value);
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 2: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LOG_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 16: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 31: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                database.setMaxOperationMemory(value);
                break;
            }
            case 3: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                this.session.getColumnNamerConfiguration().configure(mode.getEnum());
                break;
            }
            case 25: {
                boolean v;
                boolean bl = v = this.getIntValue() == 1;
                if (database.isMultiThreaded() == v) break;
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(v);
                break;
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 35: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", this.getIntValue());
                }
                int value = this.getIntValue();
                this.session.setQueryTimeout(value);
                break;
            }
            case 36: {
                int value = this.getIntValue();
                this.session.setRedoLogBinary(value == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", this.getIntValue());
                }
                database.setReferentialIntegrity(value == 1);
                break;
            }
            case 40: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", this.getIntValue());
                }
                database.setQueryStatistics(value == 1);
                break;
            }
            case 41: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", this.getIntValue());
                }
                database.setQueryStatisticsMaxEntries(value);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int size = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", this.getIntValue());
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 29: {
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", this.getIntValue());
                }
                this.session.setUndoLogEnabled(value == 1);
                break;
            }
            case 34: {
                Expression expr = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expr.getValue(this.session));
                break;
            }
            case 14: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 39: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setRetentionTime(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 42: {
                RowFactory rowFactory;
                this.session.getUser().checkAdmin();
                String rowFactoryName = this.expression.getColumnName();
                Class rowFactoryClass = JdbcUtils.loadUserClass(rowFactoryName);
                try {
                    rowFactory = (RowFactory)rowFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
                database.setRowFactory(rowFactory);
                break;
            }
            case 43: {
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("BATCH_JOINS", this.getIntValue());
                }
                this.session.setJoinBatchEnabled(value == 1);
                break;
            }
            case 44: {
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("FORCE_JOIN_ORDER", value);
                }
                this.session.setForceJoinOrder(value == 1);
                break;
            }
            case 45: {
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("LAZY_QUERY_EXECUTION", value);
                }
                this.session.setLazyQueryExecution(value == 1);
                break;
            }
            case 46: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("BUILTIN_ALIAS_OVERRIDE", value);
                }
                database.setAllowBuiltinAliasOverride(value == 1);
                break;
            }
            case 47: {
                this.session.getUser().checkAdmin();
                this.session.getColumnNamerConfiguration().configure(this.expression.getColumnName());
                break;
            }
            case 48: {
                this.session.getUser().checkAdmin();
                try {
                    if (this.expression.getBooleanValue(this.session)) {
                        database.setAuthenticator(AuthenticatorFactory.createAuthenticator());
                    } else {
                        database.setAuthenticator(null);
                    }
                    this.addOrUpdateSetting(name, this.expression.getValue(this.session).getString(), 0);
                    break;
                }
                catch (Exception e) {
                    if (database.isStarting()) {
                        database.getTrace(2).error(e, "{0}: failed to set authenticator during database start ", this.expression.toString());
                        break;
                    }
                    throw DbException.convert(e);
                }
            }
            case 49: {
                this.session.getUser().checkAdmin();
                String localResultFactoryName = this.expression.getColumnName();
                Class localResultFactoryClass = JdbcUtils.loadUserClass(localResultFactoryName);
                try {
                    LocalResultFactory localResultFactory = (LocalResultFactory)localResultFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    database.setResultFactory(localResultFactory);
                    break;
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            }
            case 51: {
                this.session.setHashJoinEnabled(this.getIntValue() == 1);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInt.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s2, int v) {
        this.addOrUpdateSetting(this.session, name, s2, v);
    }

    private void addOrUpdateSetting(Session session, String name, String s2, int v) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId();
            setting = new Setting(database, id, name);
        }
        if (s2 != null) {
            if (!addNew && setting.getStringValue().equals(s2)) {
                return;
            }
            setting.setStringValue(s2);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] list) {
        this.stringValueList = list;
    }

    @Override
    public int getType() {
        return 67;
    }
}

