/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.CommandWithValues;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.GeneratedKeys;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVPrimaryIndex;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;

public class Merge
extends CommandWithValues {
    private Table targetTable;
    private TableFilter targetTableFilter;
    private Column[] columns;
    private Column[] keys;
    private Query query;
    private Prepared update;
    private boolean explicitKeys;

    public Merge(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setKeys(Column[] keys) {
        this.explicitKeys = true;
        this.keys = keys;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    @Override
    public int update() {
        int count;
        this.session.getUser().checkRight(this.targetTable, 4);
        this.session.getUser().checkRight(this.targetTable, 8);
        this.setCurrentRowNumber(0L);
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        Mode mode = this.session.getDatabase().getMode();
        if (!this.valuesExpressionList.isEmpty()) {
            count = 0;
            generatedKeys.initialize(this.targetTable);
            int size = this.valuesExpressionList.size();
            for (int x = 0; x < size; ++x) {
                this.setCurrentRowNumber(x + 1);
                generatedKeys.nextRow();
                Expression[] expr = (Expression[])this.valuesExpressionList.get(x);
                Row newRow = this.targetTable.getTemplateRow();
                int len = this.columns.length;
                for (int i = 0; i < len; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    try {
                        Value v = c.convert(e.getValue(this.session), mode);
                        newRow.setValue(index, v);
                        if (!e.isGeneratedKey()) continue;
                        generatedKeys.add(c);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, count, Merge.getSimpleSQL(expr));
                    }
                }
                this.merge(newRow);
                ++count;
            }
        } else {
            this.query.setNeverLazy(true);
            ResultInterface rows = this.query.query(0);
            count = 0;
            this.targetTable.fire(this.session, 3, true);
            this.targetTable.lock(this.session, true, false);
            while (rows.next()) {
                generatedKeys.nextRow();
                Value[] r = rows.currentRow();
                Row newRow = this.targetTable.getTemplateRow();
                this.setCurrentRowNumber(++count);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column c = this.columns[j];
                    int index = c.getColumnId();
                    try {
                        Value v = c.convert(r[j], mode);
                        newRow.setValue(index, v);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, count, Merge.getSQL(r));
                    }
                }
                this.merge(newRow);
            }
            rows.close();
            this.targetTable.fire(this.session, 3, false);
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(Row row) {
        Parameter p;
        Value v;
        Column col;
        int i;
        ArrayList<Parameter> k = this.update.getParameters();
        for (i = 0; i < this.columns.length; ++i) {
            col = this.columns[i];
            v = row.getValue(col.getColumnId());
            p = k.get(i);
            p.setValue(v);
        }
        for (i = 0; i < this.keys.length; ++i) {
            col = this.keys[i];
            v = row.getValue(col.getColumnId());
            if (v == null) {
                throw DbException.get(90081, col.getSQL(false));
            }
            p = k.get(this.columns.length + i);
            p.setValue(v);
        }
        int count = this.update.update();
        if (count == 0) {
            try {
                this.targetTable.validateConvertUpdateSequence(this.session, row);
                boolean done = this.targetTable.fireBeforeRow(this.session, null, row);
                if (done) return;
                this.targetTable.lock(this.session, true, false);
                this.targetTable.addRow(this.session, row);
                this.session.getGeneratedKeys().confirmRow(row);
                this.session.log(this.targetTable, (short)0, row);
                this.targetTable.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException e) {
                boolean indexMatchesKeys;
                Column[] indexColumns;
                Index index;
                if (e.getErrorCode() != 23505 || (index = (Index)e.getSource()) == null) throw e;
                if (index instanceof MVPrimaryIndex) {
                    MVPrimaryIndex foundMV = (MVPrimaryIndex)index;
                    indexColumns = new Column[]{foundMV.getIndexColumns()[foundMV.getMainIndexColumn()].column};
                } else {
                    indexColumns = index.getColumns();
                }
                if (indexColumns.length <= this.keys.length) {
                    indexMatchesKeys = true;
                    for (int i2 = 0; i2 < indexColumns.length; ++i2) {
                        if (indexColumns[i2] == this.keys[i2]) continue;
                        indexMatchesKeys = false;
                        break;
                    }
                } else {
                    indexMatchesKeys = false;
                }
                if (!indexMatchesKeys) throw e;
                throw DbException.get(90131, this.targetTable.getName());
            }
        }
        if (count == 1) return;
        throw DbException.get(23505, this.targetTable.getSQL(false));
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        StringBuilder builder = new StringBuilder("MERGE INTO ");
        this.targetTable.getSQL(builder, alwaysQuote).append('(');
        Column.writeColumns(builder, this.columns, alwaysQuote);
        builder.append(')');
        if (this.keys != null) {
            builder.append(" KEY(");
            Column.writeColumns(builder, this.keys, alwaysQuote);
            builder.append(')');
        }
        builder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            builder.append("VALUES ");
            int row = 0;
            for (Expression[] expr : this.valuesExpressionList) {
                if (row++ > 0) {
                    builder.append(", ");
                }
                builder.append('(');
                Expression.writeExpressions(builder, expr, alwaysQuote);
                builder.append(')');
            }
        } else {
            builder.append(this.query.getPlanSQL(alwaysQuote));
        }
        return builder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.targetTable.getVisibleColums();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expr : this.valuesExpressionList) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expr.length; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    expr[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            Index idx = this.targetTable.getPrimaryKey();
            if (idx == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = new Column[]{idx.getTable().getColumn(0)};
        }
        StringBuilder builder = new StringBuilder("UPDATE ");
        this.targetTable.getSQL(builder, true).append(" SET ");
        Column.writeColumns(builder, this.columns, ", ", "=?", true).append(" WHERE ");
        Column.writeColumns(builder, this.keys, " AND ", "=?", true);
        this.update = this.session.prepare(builder.toString());
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public void setTargetTableFilter(TableFilter targetTableFilter) {
        this.targetTableFilter = targetTableFilter;
        this.setTargetTable(targetTableFilter.getTable());
    }

    public boolean isExplicitKeys() {
        return this.explicitKeys;
    }
}

