/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.passcode;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.gridgain.grid.internal.util.security.GridSecurityPermissionSetJsonParser;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;

public class AuthenticationAclBasicProvider
implements AuthenticationAclProvider {
    private Map<SecurityCredentials, SecurityPermissionSet> perms;

    public AuthenticationAclBasicProvider(Map<SecurityCredentials, String> perms) throws IgniteCheckedException {
        this.perms = this.parsePermissions(perms);
    }

    private AuthenticationAclBasicProvider() {
    }

    public static AuthenticationAclBasicProvider createFrom(Map<SecurityCredentials, SecurityPermissionSet> perms) {
        AuthenticationAclBasicProvider provider = new AuthenticationAclBasicProvider();
        provider.perms = perms;
        return provider;
    }

    private Map<SecurityCredentials, SecurityPermissionSet> parsePermissions(Map<SecurityCredentials, String> perm) throws IgniteCheckedException {
        HashMap<SecurityCredentials, SecurityPermissionSet> res = new HashMap<SecurityCredentials, SecurityPermissionSet>();
        for (Map.Entry<SecurityCredentials, String> entry : perm.entrySet()) {
            res.put(entry.getKey(), new GridSecurityPermissionSetJsonParser(entry.getValue()).parse());
        }
        return res;
    }

    @Override
    public Map<SecurityCredentials, SecurityPermissionSet> acl() {
        return this.perms;
    }
}

