/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotProgress;

public class SnapshotStatus
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final SnapshotOperationInfo operation;
    private final IgniteUuid opId;
    private final Map<UUID, Double> progress = Collections.emptyMap();
    private final Map<UUID, long[]> progressDetailed;
    private long startStageTime;
    private int stageNum;
    private final long startTime;
    private final boolean notCancelable;

    public SnapshotStatus(IgniteUuid opId, SnapshotOperationInfo operation, Map<UUID, SnapshotProgress> progress, long startTime, long startStageTime, int stageNum, boolean notCancelable) {
        this.opId = opId;
        this.operation = operation;
        this.progressDetailed = new HashMap<UUID, long[]>(progress.size());
        for (Map.Entry<UUID, SnapshotProgress> entry : progress.entrySet()) {
            this.progressDetailed.put(entry.getKey(), this.progressToArray(entry.getValue()));
        }
        this.startTime = startTime;
        this.startStageTime = startStageTime;
        this.stageNum = stageNum;
        this.notCancelable = notCancelable;
    }

    public IgniteUuid operationId() {
        return this.opId;
    }

    public SnapshotOperationInfo operation() {
        return this.operation;
    }

    public long startTime() {
        return this.startTime;
    }

    public Map<UUID, SnapshotProgress> progress() {
        HashMap<UUID, SnapshotProgress> result = new HashMap<UUID, SnapshotProgress>(this.progressDetailed.size());
        for (Map.Entry<UUID, long[]> entry : this.progressDetailed.entrySet()) {
            result.put(entry.getKey(), this.arrayToProgress(entry.getValue()));
        }
        return result;
    }

    public int getStageNum() {
        return this.stageNum;
    }

    public long getStartStageTime() {
        return this.startStageTime;
    }

    public boolean notCancellable() {
        return this.notCancelable;
    }

    public String toString() {
        StringBuilder progressStr = new StringBuilder("{");
        if (this.progressDetailed != null) {
            for (Map.Entry<UUID, long[]> entry : this.progressDetailed.entrySet()) {
                progressStr.append(entry.getKey()).append("-").append(this.arrayToProgress(entry.getValue())).append(", ");
            }
        } else {
            for (Map.Entry<UUID, Double> entry : this.progress.entrySet()) {
                progressStr.append(entry.getKey()).append("-").append(entry.getValue()).append(", ");
            }
        }
        progressStr.append("}");
        return "SnapshotStatus [operation=" + this.operation + ", opId=" + this.opId + ", progress=" + progressStr + ", startStageTime=" + this.startStageTime + ", stage=" + this.stageNum + ", startTime=" + this.startTime + ", notCancelable=" + this.notCancelable + ']';
    }

    private SnapshotProgress arrayToProgress(long[] arr) {
        if (arr == null) {
            return null;
        }
        return new SnapshotProgress(arr[0], arr[1], Double.longBitsToDouble(arr[2]), arr[3]);
    }

    private long[] progressToArray(SnapshotProgress progress) {
        if (progress == null) {
            return null;
        }
        long[] result = new long[]{progress.getProcessed(), progress.getTotal(), Double.doubleToLongBits(progress.getOperationProgress()), progress.getFinishTime()};
        return result;
    }
}

