/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class SnapshotProgress
implements Comparable<SnapshotProgress>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final long processed;
    private final long total;
    private final double operationProgress;
    private final long finishTime;

    public SnapshotProgress(long processed, long total, double operationProgress, long finishTime) {
        this.processed = processed;
        this.total = total;
        this.operationProgress = operationProgress;
        this.finishTime = finishTime;
    }

    public long getProcessed() {
        return this.processed;
    }

    public long getTotal() {
        return this.total;
    }

    public Double getProgress() {
        if (this.total == 0L) {
            return -1.0;
        }
        return (double)this.processed / (double)this.total;
    }

    public double getOperationProgress() {
        return this.operationProgress;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String toString() {
        return "SnapshotProgress{processed=" + this.processed + ", total=" + this.total + ", operationProgress=" + this.operationProgress + ", finishTime=" + this.finishTime + '}';
    }

    @Override
    public int compareTo(@NotNull SnapshotProgress other) {
        return Double.compare(this.getOperationProgress(), other.getOperationProgress());
    }
}

