/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore;

import java.io.File;
import java.net.URI;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SnapshotPath {
    private URI uri;
    private File path;
    private String keyAlias;

    private SnapshotPath() {
    }

    public static SftpSnapshotPathBuilder sftp() {
        return new SftpSnapshotPathBuilder();
    }

    public static FileSnapshotPathBuilder file() {
        return new FileSnapshotPathBuilder();
    }

    public URI uri() {
        return this.uri;
    }

    public File path() {
        return this.path;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String toString() {
        return S.toString(SnapshotPath.class, this);
    }

    public static final class FileSnapshotPathBuilder {
        private File path;

        private FileSnapshotPathBuilder() {
        }

        public FileSnapshotPathBuilder path(File path) {
            this.path = path;
            return this;
        }

        public SnapshotPath build() {
            SnapshotPath snapshotPath = new SnapshotPath();
            snapshotPath.path = this.path;
            return snapshotPath;
        }
    }

    public static final class SftpSnapshotPathBuilder {
        private URI uri;
        private String keyAlias;

        private SftpSnapshotPathBuilder() {
        }

        public SftpSnapshotPathBuilder uri(URI uri) {
            if (!"sftp".equals(uri.getScheme())) {
                throw new IllegalArgumentException("Scheme must be \"sftp\"!");
            }
            this.uri = uri;
            return this;
        }

        public SftpSnapshotPathBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public SnapshotPath build() {
            SnapshotPath snapshotPath = new SnapshotPath();
            snapshotPath.uri = this.uri;
            snapshotPath.keyAlias = this.keyAlias;
            return snapshotPath;
        }
    }
}

