/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.jetbrains.annotations.Nullable;

public class VisorSecurityPermissionSet
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean dfltAllowAll;
    private Map<String, Collection<SecurityPermission>> taskPerms;
    private Map<String, Collection<SecurityPermission>> cachePerms;
    private Map<String, Collection<SecurityPermission>> srvPerms;
    private List<SecurityPermission> sysPerms;

    public VisorSecurityPermissionSet() {
    }

    public VisorSecurityPermissionSet(SecurityPermissionSet set) {
        this.dfltAllowAll = set.defaultAllowAll();
        this.taskPerms = set.taskPermissions();
        this.cachePerms = set.cachePermissions();
        this.srvPerms = set.servicePermissions();
        this.sysPerms = VisorSecurityPermissionSet.toList(set.systemPermissions());
    }

    public boolean isDefaultAllowAll() {
        return this.dfltAllowAll;
    }

    public Map<String, Collection<SecurityPermission>> getTaskPermissions() {
        return this.taskPerms;
    }

    public Map<String, Collection<SecurityPermission>> getCachePermissions() {
        return this.cachePerms;
    }

    public Map<String, Collection<SecurityPermission>> getServicePermissions() {
        return this.srvPerms;
    }

    @Nullable
    public List<SecurityPermission> getSystemPermissions() {
        return this.sysPerms;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.dfltAllowAll);
        U.writeMap(out, this.taskPerms);
        U.writeMap(out, this.cachePerms);
        U.writeMap(out, this.srvPerms);
        U.writeCollection(out, this.sysPerms);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.dfltAllowAll = in.readBoolean();
        this.taskPerms = U.readMap(in);
        this.cachePerms = U.readMap(in);
        this.srvPerms = U.readMap(in);
        this.sysPerms = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorSecurityPermissionSet.class, this);
    }
}

