/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.license;

import java.util.UUID;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.visor.license.VisorLicenseUpdateTaskArg;
import org.gridgain.grid.internal.visor.license.VisorLicenseUpdateTaskResult;
import org.gridgain.grid.product.ProductLicense;
import org.gridgain.grid.product.ProductLicenseException;

@GridInternal
public class VisorLicenseUpdateTask
extends VisorOneNodeTask<VisorLicenseUpdateTaskArg, VisorEither<VisorLicenseUpdateTaskResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorLicenseUpdateJob job(VisorLicenseUpdateTaskArg arg) {
        return new VisorLicenseUpdateJob(arg, this.debug);
    }

    private static class VisorLicenseUpdateJob
    extends VisorJob<VisorLicenseUpdateTaskArg, VisorEither<VisorLicenseUpdateTaskResult>> {
        private static final long serialVersionUID = 0L;

        private VisorLicenseUpdateJob(VisorLicenseUpdateTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorLicenseUpdateTaskResult> run(VisorLicenseUpdateTaskArg arg) {
            GridGain gg = (GridGain)this.ignite.plugin("GridGain");
            try {
                UUID newLicId = arg.getLicenseId();
                if (newLicId != null) {
                    ProductLicense lic = gg.product().license();
                    if (lic == null) {
                        return new VisorEither<ProductLicenseException>(new ProductLicenseException("Missing licence to compare id", null));
                    }
                    if (lic.id().equals(newLicId)) {
                        return new VisorEither<VisorLicenseUpdateTaskResult>(new VisorLicenseUpdateTaskResult(lic.id()));
                    }
                }
                gg.product().updateLicense(arg.getLicense());
                return new VisorEither<VisorLicenseUpdateTaskResult>(new VisorLicenseUpdateTaskResult(gg.product().license().id()));
            }
            catch (ProductLicenseException e) {
                return new VisorEither<ProductLicenseException>(e);
            }
            catch (Exception e) {
                return new VisorEither<ProductLicenseException>(new ProductLicenseException("Failed to load licence", null, e));
            }
        }

        public String toString() {
            return S.toString(VisorLicenseUpdateJob.class, this);
        }
    }
}

