/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.internal.visor.security.VisorSecuritySubject;

public class VisorGridAuthorizationEvent
extends VisorGridEvent {
    private static final long serialVersionUID = 0L;
    private SecurityPermission operation;
    private VisorSecuritySubject subject;

    public VisorGridAuthorizationEvent() {
    }

    public VisorGridAuthorizationEvent(int typeId, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay, SecurityPermission operation, SecuritySubject subject) {
        super(typeId, id, name, nid, ts, msg, shortDisplay);
        this.operation = operation;
        this.subject = new VisorSecuritySubject(subject);
    }

    public SecurityPermission getOperation() {
        return this.operation;
    }

    public VisorSecuritySubject getSubject() {
        return this.subject;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte(super.getProtocolVersion());
            super.writeExternalData(dtout);
        }
        U.writeEnum(out, this.operation);
        out.writeObject(this.subject);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), dtin);
        }
        this.operation = SecurityPermission.fromOrdinal(in.readByte());
        this.subject = (VisorSecuritySubject)in.readObject();
    }

    @Override
    public String toString() {
        return S.toString(VisorGridAuthorizationEvent.class, this);
    }
}

