/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskResult;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrTopologyTask
extends VisorMultiNodeTask<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult, VisorDrTopologyTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult> job(VisorDrTopologyTaskArgs arg) {
        return new VisorDrTopologyJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorDrTopologyTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        byte dataCenterId = 0;
        int serverNodesCnt = 0;
        int clientNodesCnt = 0;
        ArrayList<T3<UUID, String, String>> senderHubs = new ArrayList<T3<UUID, String, String>>();
        ArrayList<T3<UUID, String, String>> receiverHubs = new ArrayList<T3<UUID, String, String>>();
        ArrayList<T2<UUID, String>> dataNodes = new ArrayList<T2<UUID, String>>();
        ArrayList<T3<UUID, String, String>> otherNodes = new ArrayList<T3<UUID, String, String>>();
        for (ComputeJobResult result : results) {
            VisorDrTopologyTaskResult data = (VisorDrTopologyTaskResult)result.getData();
            if (data == null) continue;
            dataCenterId = data.getDataCenterId();
            serverNodesCnt += data.getServerNodesCount();
            clientNodesCnt += data.getClientNodesCount();
            senderHubs.addAll(data.getSenderHubs());
            receiverHubs.addAll(data.getReceiverHubs());
            dataNodes.addAll(data.getDataNodes());
            otherNodes.addAll(data.getOtherNodes());
        }
        return new VisorDrTopologyTaskResult(dataCenterId, serverNodesCnt, clientNodesCnt, senderHubs, receiverHubs, dataNodes, otherNodes);
    }

    private static class VisorDrTopologyJob
    extends VisorJob<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrTopologyJob(VisorDrTopologyTaskArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorDrTopologyTaskResult run(@Nullable VisorDrTopologyTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            ClusterNode locNode = this.ignite.localNode();
            UUID locNodeId = locNode.id();
            String addresses = locNode.addresses().toString();
            boolean isLocNodeClient = locNode.isClient();
            String locNodeMode = isLocNodeClient ? "Client" : "Server";
            ArrayList<T3<UUID, String, String>> senderHubs = new ArrayList<T3<UUID, String, String>>(1);
            ArrayList<T3<UUID, String, String>> receiverHubs = new ArrayList<T3<UUID, String, String>>(1);
            ArrayList<T2<UUID, String>> dataNodes = new ArrayList<T2<UUID, String>>(1);
            ArrayList<T3<UUID, String, String>> otherNodes = new ArrayList<T3<UUID, String, String>>(1);
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridGainConfiguration pluginCfg = plugin.configuration();
            if (pluginCfg.getDrSenderConfiguration() != null) {
                senderHubs.add(new T3<UUID, String, String>(locNodeId, addresses, locNodeMode));
            }
            if (pluginCfg.getDrReceiverConfiguration() != null) {
                DrReceiverConfiguration cfg = pluginCfg.getDrReceiverConfiguration();
                String addr = cfg.getLocalInboundHost() + ":" + cfg.getLocalInboundPort();
                receiverHubs.add(new T3<UUID, String, String>(locNodeId, addr, locNodeMode));
            }
            if (CU.baselineNode(locNode, this.ignite.context().state().clusterState())) {
                dataNodes.add(new T2<UUID, String>(locNodeId, addresses));
            }
            if (senderHubs.isEmpty() && receiverHubs.isEmpty() && dataNodes.isEmpty()) {
                otherNodes.add(new T3<UUID, String, String>(locNodeId, addresses, locNodeMode));
            }
            return new VisorDrTopologyTaskResult(pluginCfg.getDataCenterId(), isLocNodeClient ? 0 : 1, isLocNodeClient ? 1 : 0, arg.senderHubs() ? senderHubs : Collections.emptyList(), arg.receiverHubs() ? receiverHubs : Collections.emptyList(), arg.dataNodes() ? dataNodes : Collections.emptyList(), arg.otherNodes() ? otherNodes : Collections.emptyList());
        }
    }
}

