/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.gridgain.grid.dr.DrReceiverLoadBalancingMode;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.jetbrains.annotations.Nullable;

public class VisorDrSenderHubConnectionConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private byte dataCenterId;
    private byte[] ignoredDataCenterIds;
    private String locOutboundAddr;
    private List<String> receiverHubAddrs;
    private DrReceiverLoadBalancingMode receiverHubLoadBalancingMode;
    private String locOutboundHost;
    private boolean awaitAck;
    private String store;

    public VisorDrSenderHubConnectionConfiguration() {
    }

    public VisorDrSenderHubConnectionConfiguration(DrSenderConnectionConfiguration rmtCfg) {
        assert (rmtCfg != null);
        this.dataCenterId = rmtCfg.getDataCenterId();
        this.ignoredDataCenterIds = rmtCfg.getIgnoredDataCenterIds();
        this.locOutboundAddr = rmtCfg.getLocalOutboundAddress();
        this.receiverHubAddrs = Arrays.asList(rmtCfg.getReceiverAddresses());
        this.receiverHubLoadBalancingMode = rmtCfg.getLoadBalancingMode();
        this.locOutboundHost = rmtCfg.getLocalOutboundHost();
        this.awaitAck = rmtCfg.isAwaitAcknowledge();
        this.store = VisorTaskUtils.compactClass(rmtCfg.getStore());
    }

    public byte getDataCenterId() {
        return this.dataCenterId;
    }

    public byte[] getIgnoredDataCenterIds() {
        return this.ignoredDataCenterIds;
    }

    @Nullable
    public String getLocalOutboundAddress() {
        return this.locOutboundAddr;
    }

    public List<String> getReceiverHubAddresses() {
        return this.receiverHubAddrs;
    }

    public DrReceiverLoadBalancingMode getReceiverHubLoadBalancingMode() {
        return this.receiverHubLoadBalancingMode;
    }

    @Deprecated
    public String getLocalOutboundHost() {
        return this.locOutboundHost;
    }

    public boolean isAwaitAcknowledge() {
        return this.awaitAck;
    }

    @Nullable
    public String getStore() {
        return this.store;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.dataCenterId);
        out.writeObject(this.ignoredDataCenterIds);
        U.writeCutString(out, this.locOutboundAddr);
        U.writeCollection(out, this.receiverHubAddrs);
        U.writeEnum(out, this.receiverHubLoadBalancingMode);
        U.writeCutString(out, this.locOutboundHost);
        out.writeBoolean(this.awaitAck);
        U.writeCutString(out, this.store);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataCenterId = in.readByte();
        this.ignoredDataCenterIds = (byte[])in.readObject();
        this.locOutboundAddr = U.readString(in);
        this.receiverHubAddrs = U.readList(in);
        this.receiverHubLoadBalancingMode = DrReceiverLoadBalancingMode.fromOrdinal(in.readByte());
        this.locOutboundHost = U.readString(in);
        this.awaitAck = in.readBoolean();
        this.store = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorDrSenderHubConnectionConfiguration.class, this);
    }
}

