/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubConnectionConfiguration;
import org.gridgain.grid.internal.visor.util.VisorTaskUtilsEnt;
import org.jetbrains.annotations.Nullable;

public class VisorDrSenderHubConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<VisorDrSenderHubConnectionConfiguration> connConfiguration;
    private int maxFailedConnectAttempts;
    private int maxErrors;
    private long maxHealthCheckFreq;
    private long sysReqTimeout;
    private long readTimeout;
    private int maxQueueSize;
    private long reconnectOnFailureTimeout;
    private List<String> cacheNames;
    private int sockSndBufSize;
    private int sockRcvBufSize;
    private String sslCtxFactory;
    private boolean useIgniteSslCtxFactory;
    private String store;
    private List<String> sndGroups;

    public VisorDrSenderHubConfiguration() {
    }

    public VisorDrSenderHubConfiguration(DrSenderConfiguration sndCfg) {
        ArrayList<VisorDrSenderHubConnectionConfiguration> rmtCfgs = new ArrayList<VisorDrSenderHubConnectionConfiguration>();
        for (DrSenderConnectionConfiguration rmtCfg : sndCfg.getConnectionConfiguration()) {
            if (rmtCfg == null) continue;
            rmtCfgs.add(new VisorDrSenderHubConnectionConfiguration(rmtCfg));
        }
        this.connConfiguration = rmtCfgs;
        this.maxFailedConnectAttempts = sndCfg.getMaxFailedConnectAttempts();
        this.maxErrors = sndCfg.getMaxErrors();
        this.maxHealthCheckFreq = sndCfg.getHealthCheckFrequency();
        this.sysReqTimeout = sndCfg.getSystemRequestTimeout();
        this.readTimeout = sndCfg.getReadTimeout();
        this.maxQueueSize = sndCfg.getMaxQueueSize();
        this.reconnectOnFailureTimeout = sndCfg.getReconnectOnFailureTimeout();
        this.cacheNames = sndCfg.getCacheNames() != null ? Arrays.asList(sndCfg.getCacheNames()) : new ArrayList<String>();
        this.sockRcvBufSize = sndCfg.getSocketReceiveBufferSize();
        this.sockSndBufSize = sndCfg.getSocketSendBufferSize();
        this.sslCtxFactory = VisorTaskUtils.compactClass(sndCfg.getSslContextFactory());
        this.useIgniteSslCtxFactory = sndCfg.isUseIgniteSslContextFactory();
        this.store = VisorTaskUtilsEnt.compactClassEnt(sndCfg.getStore());
        this.sndGroups = sndCfg.getSenderGroups() != null ? Arrays.asList(DrUtils.effectiveSenderGroups(sndCfg)) : new ArrayList<String>();
    }

    public List<VisorDrSenderHubConnectionConfiguration> getConnectionConfiguration() {
        return this.connConfiguration;
    }

    public int getMaxFailedConnectAttempts() {
        return this.maxFailedConnectAttempts;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public long getMaxHealthCheckFrequency() {
        return this.maxHealthCheckFreq;
    }

    public long getSystemRequestTimeout() {
        return this.sysReqTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public long getReconnectOnFailureTimeout() {
        return this.reconnectOnFailureTimeout;
    }

    public List<String> getCacheNames() {
        return this.cacheNames;
    }

    public int getSocketReceiveBufferSize() {
        return this.sockRcvBufSize;
    }

    public int getSocketSendBufferSize() {
        return this.sockSndBufSize;
    }

    @Nullable
    public String getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public boolean isUseIgniteSslContextFactory() {
        return this.useIgniteSslCtxFactory;
    }

    @Nullable
    public String getStore() {
        return this.store;
    }

    public List<String> getSenderGroups() {
        return this.sndGroups;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.connConfiguration);
        out.writeInt(this.maxFailedConnectAttempts);
        out.writeInt(this.maxErrors);
        out.writeLong(this.maxHealthCheckFreq);
        out.writeLong(this.sysReqTimeout);
        out.writeLong(this.readTimeout);
        out.writeInt(this.maxQueueSize);
        out.writeLong(this.reconnectOnFailureTimeout);
        U.writeCollection(out, this.cacheNames);
        out.writeInt(this.sockRcvBufSize);
        out.writeInt(this.sockSndBufSize);
        U.writeCutString(out, this.sslCtxFactory);
        out.writeBoolean(this.useIgniteSslCtxFactory);
        U.writeCutString(out, this.store);
        U.writeCollection(out, this.sndGroups);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.connConfiguration = U.readList(in);
        this.maxFailedConnectAttempts = in.readInt();
        this.maxErrors = in.readInt();
        this.maxHealthCheckFreq = in.readLong();
        this.sysReqTimeout = in.readLong();
        this.readTimeout = in.readLong();
        this.maxQueueSize = in.readInt();
        this.reconnectOnFailureTimeout = in.readLong();
        this.cacheNames = U.readList(in);
        this.sockRcvBufSize = in.readInt();
        this.sockSndBufSize = in.readInt();
        this.sslCtxFactory = U.readString(in);
        this.useIgniteSslCtxFactory = in.readBoolean();
        this.store = U.readString(in);
        if (protoVer >= 2) {
            this.sndGroups = U.readList(in);
        } else {
            new ArrayList();
        }
    }

    public String toString() {
        return S.toString(VisorDrSenderHubConfiguration.class, this);
    }
}

