/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.dr.DrReceiverInMetrics;

public class VisorDrReceiverHubInMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesReceived;
    private long entriesReceived;
    private long bytesReceived;

    public VisorDrReceiverHubInMetrics() {
    }

    public VisorDrReceiverHubInMetrics(DrReceiverInMetrics m4) {
        assert (m4 != null);
        this.batchesReceived = m4.batchesReceived();
        this.entriesReceived = m4.entriesReceived();
        this.bytesReceived = m4.bytesReceived();
    }

    public static VisorDrReceiverHubInMetrics aggregated(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        try {
            return new VisorDrReceiverHubInMetrics(dr.receiverAggregatedInMetrics());
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public static Map<Byte, VisorDrReceiverHubInMetrics> map(GridGain plugin) {
        assert (plugin != null);
        GridDr dr = plugin.dr();
        HashMap<Byte, VisorDrReceiverHubInMetrics> map = new HashMap<Byte, VisorDrReceiverHubInMetrics>();
        for (byte rmtDrId = 0; rmtDrId < 32; rmtDrId = (byte)(rmtDrId + 1)) {
            try {
                DrReceiverInMetrics m4 = dr.receiverAggregatedInMetrics(rmtDrId);
                if (m4.batchesReceived() <= 0 && m4.entriesReceived() <= 0L && m4.bytesReceived() <= 0L) continue;
                map.put(rmtDrId, new VisorDrReceiverHubInMetrics(m4));
                continue;
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                // empty catch block
            }
        }
        return map;
    }

    public int getBatchesReceived() {
        return this.batchesReceived;
    }

    public long getEntriesReceived() {
        return this.entriesReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesReceived);
        out.writeLong(this.entriesReceived);
        out.writeLong(this.bytesReceived);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesReceived = in.readInt();
        this.entriesReceived = in.readLong();
        this.bytesReceived = in.readLong();
    }

    public String toString() {
        return S.toString(VisorDrReceiverHubInMetrics.class, this);
    }
}

