/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.jetbrains.annotations.Nullable;

public class VisorDrCacheStatus
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean paused;
    private CacheDrPauseReason reason;
    private String errMsg;

    public VisorDrCacheStatus() {
    }

    public VisorDrCacheStatus(CacheDrStatus status) {
        this.paused = status.stopped();
        this.reason = status.reason();
        this.errMsg = status.error();
    }

    public boolean isPaused() {
        return this.paused;
    }

    @Nullable
    public CacheDrPauseReason getReason() {
        return this.reason;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errMsg;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.paused);
        U.writeEnum(out, this.reason);
        U.writeCutString(out, this.errMsg);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.paused = in.readBoolean();
        this.reason = CacheDrPauseReason.fromOrdinal(in.readByte());
        this.errMsg = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorDrCacheStatus.class, this);
    }
}

