/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubOutMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubOutMetrics;

public class VisorDr
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private byte id;
    private Map<String, VisorDrSenderHubInMetrics> sndHubInMetrics;
    private VisorDrSenderHubInMetrics sndHubAggInMetrics;
    private Map<Byte, VisorDrSenderHubOutMetrics> sndHubOutMetrics;
    private VisorDrSenderHubOutMetrics sndHubAggOutMetrics;
    private Map<Byte, VisorDrReceiverHubInMetrics> rcvHubInMetrics;
    private VisorDrReceiverHubInMetrics rcvHubAggInMetrics;
    private VisorDrReceiverHubOutMetrics rcvHubOutMetrics;

    public VisorDr() {
    }

    public VisorDr(IgniteEx ignite, GridGain plugin) {
        assert (plugin != null);
        this.id = plugin.configuration().getDataCenterId();
        this.sndHubInMetrics = VisorDrSenderHubInMetrics.map(ignite, plugin);
        this.sndHubAggInMetrics = VisorDrSenderHubInMetrics.aggregated(plugin);
        this.sndHubOutMetrics = VisorDrSenderHubOutMetrics.map(plugin);
        this.sndHubAggOutMetrics = VisorDrSenderHubOutMetrics.aggregated(plugin);
        this.rcvHubInMetrics = VisorDrReceiverHubInMetrics.map(plugin);
        this.rcvHubAggInMetrics = VisorDrReceiverHubInMetrics.aggregated(plugin);
        this.rcvHubOutMetrics = VisorDrReceiverHubOutMetrics.aggregated(plugin);
    }

    public byte getId() {
        return this.id;
    }

    public Map<String, VisorDrSenderHubInMetrics> getSenderHubInMetrics() {
        return this.sndHubInMetrics;
    }

    public VisorDrSenderHubInMetrics getSenderHubAggregatedInMetrics() {
        return this.sndHubAggInMetrics;
    }

    public Map<Byte, VisorDrSenderHubOutMetrics> getSenderHubOutMetrics() {
        return this.sndHubOutMetrics;
    }

    public VisorDrSenderHubOutMetrics getSenderHubAggregated() {
        return this.sndHubAggOutMetrics;
    }

    public Map<Byte, VisorDrReceiverHubInMetrics> getReceiverHubInMetrics() {
        return this.rcvHubInMetrics;
    }

    public VisorDrReceiverHubInMetrics getReceiverHubAggregatedInMetrics() {
        return this.rcvHubAggInMetrics;
    }

    public VisorDrReceiverHubOutMetrics getReceiverHubOutMetrics() {
        return this.rcvHubOutMetrics;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.id);
        U.writeMap(out, this.sndHubInMetrics);
        out.writeObject(this.sndHubAggInMetrics);
        U.writeMap(out, this.sndHubOutMetrics);
        out.writeObject(this.sndHubAggOutMetrics);
        U.writeMap(out, this.rcvHubInMetrics);
        out.writeObject(this.rcvHubAggInMetrics);
        out.writeObject(this.rcvHubOutMetrics);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readByte();
        this.sndHubInMetrics = U.readMap(in);
        this.sndHubAggInMetrics = (VisorDrSenderHubInMetrics)in.readObject();
        this.sndHubOutMetrics = U.readMap(in);
        this.sndHubAggOutMetrics = (VisorDrSenderHubOutMetrics)in.readObject();
        this.rcvHubInMetrics = U.readMap(in);
        this.rcvHubAggInMetrics = (VisorDrReceiverHubInMetrics)in.readObject();
        this.rcvHubOutMetrics = (VisorDrReceiverHubOutMetrics)in.readObject();
    }

    public String toString() {
        return S.toString(VisorDr.class, this);
    }
}

