/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderConfiguration;
import org.jetbrains.annotations.Nullable;

public class VisorGridGainCacheConfiguration
extends VisorCacheConfiguration {
    private static final long serialVersionUID = 0L;
    private String conflictRslvr;
    private VisorDrSenderConfiguration drSndCfg;
    private boolean drReceiverEnabled;
    private CacheConflictMode conflictRslvrMode;

    public VisorGridGainCacheConfiguration() {
    }

    public VisorGridGainCacheConfiguration(IgniteEx ignite, CacheConfiguration ccfg, IgniteUuid dynamicDeploymentId) {
        super(ignite, ccfg, dynamicDeploymentId);
        GridGainCacheConfiguration ggCcfg = GridCacheUtils.cachePluginConfiguration(ccfg, GridGainCacheConfiguration.class);
        if (ggCcfg != null) {
            this.conflictRslvr = VisorTaskUtils.compactClass(ggCcfg.getConflictResolver());
            if (ggCcfg.getDrSenderConfiguration() != null) {
                this.drSndCfg = new VisorDrSenderConfiguration(ggCcfg.getDrSenderConfiguration());
            }
            this.drReceiverEnabled = ggCcfg.isDrReceiverEnabled();
            this.conflictRslvrMode = ggCcfg.getConflictResolverMode();
        }
    }

    public String getConflictResolver() {
        return this.conflictRslvr;
    }

    @Nullable
    public VisorDrSenderConfiguration getDrSendConfiguration() {
        return this.drSndCfg;
    }

    public boolean getDrReceiverEnabled() {
        return this.drReceiverEnabled;
    }

    public CacheConflictMode getConflictResolverMode() {
        return this.conflictRslvrMode;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte(super.getProtocolVersion());
            super.writeExternalData(dtout);
        }
        U.writeString(out, this.conflictRslvr);
        out.writeBoolean(this.drReceiverEnabled);
        out.writeObject(this.drSndCfg);
        U.writeEnum(out, this.conflictRslvrMode);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), dtin);
        }
        this.conflictRslvr = U.readString(in);
        this.drReceiverEnabled = in.readBoolean();
        this.drSndCfg = (VisorDrSenderConfiguration)in.readObject();
        this.conflictRslvrMode = CacheConflictMode.fromOrdinal(in.readByte());
    }

    @Override
    public String toString() {
        return S.toString(VisorGridGainCacheConfiguration.class, this);
    }
}

