/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.util.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.jetbrains.annotations.Nullable;

public class GridSecurityPermissionSetJsonParser {
    public static final String DEFAULT_ALLOW = "defaultAllow";
    public static final String TASK = "task";
    public static final String SERVICE = "service";
    public static final String CACHE = "cache";
    public static final String TRACING = "tracing";
    public static final String SYSTEM = "system";
    public static final String PERMISSIONS = "permissions";
    private JsonLexer lexer;
    private String src;
    private static final Comparator<PermissionElement> CMP = new Comparator<PermissionElement>(){

        @Override
        public int compare(PermissionElement o1, PermissionElement o2) {
            int len2;
            int len1 = o1.name == null ? 0 : o1.name.length();
            int n = len2 = o2.name == null ? 0 : o2.name.length();
            if (len1 < len2) {
                return 1;
            }
            if (len1 > len2) {
                return -1;
            }
            return len1 == 0 ? 0 : o2.name.compareTo(o1.name);
        }
    };

    public GridSecurityPermissionSetJsonParser(String str) {
        this.src = str;
        this.lexer = new JsonLexer(str);
    }

    @Nullable
    public SecurityPermissionSet parse() throws IgniteCheckedException {
        Token t2;
        this.matchToken("'{'", 0);
        Boolean dfltAllowAll = null;
        ArrayList<PermissionElement> taskPerms = new ArrayList<PermissionElement>();
        ArrayList<PermissionElement> cachePerms = new ArrayList<PermissionElement>();
        ArrayList<PermissionElement> srvcPerms = new ArrayList<PermissionElement>();
        PermissionElement tracingPerms = null;
        PermissionElement sysPerms = null;
        while (true) {
            if ((t2 = this.matchToken("value, '{' or '}'", 0, 1, 6)).type() == 0) {
                this.unread(t2);
                PermissionElement el = this.matchPermissionElement();
                if (el.type == 1) {
                    taskPerms.add(el);
                } else if (el.type == 0) {
                    cachePerms.add(el);
                } else if (el.type == 3) {
                    srvcPerms.add(el);
                } else if (el.type == 4) {
                    if (tracingPerms != null) {
                        throw new IgniteCheckedException("Duplicate entry for 'tracing' permission element [pos=" + t2.pos + ']');
                    }
                    tracingPerms = el;
                } else {
                    assert (el.type == 2);
                    if (sysPerms != null) {
                        throw new IgniteCheckedException("Duplicate entry for 'system' permission element [pos=" + t2.pos + ']');
                    }
                    sysPerms = el;
                }
                if ((t2 = this.matchToken("value, ',' or '}'", 6, 5, 1)).type() == 5) continue;
                this.unread(t2);
                continue;
            }
            if (t2.type() != 6) break;
            this.unread(t2);
            dfltAllowAll = this.matchDefaultAllowAll(dfltAllowAll);
            t2 = this.matchToken("value, ',' or '}'", 6, 5, 1);
            if (t2.type() == 5) continue;
            this.unread(t2);
        }
        assert (t2.type() == 1);
        t2 = this.token();
        if (t2 != null) {
            throw new IgniteCheckedException("Unexpected token at the end of JSON string [src=" + this.src + ", pos=" + t2.position() + ']');
        }
        if (dfltAllowAll == null) {
            throw new IgniteCheckedException("Missing 'defaultAllow' configuration property: " + this.src);
        }
        return new SecurityPermissionsUnmodifiableSet(dfltAllowAll, this.sort(taskPerms), this.sort(cachePerms), this.sort(srvcPerms), tracingPerms == null ? null : tracingPerms.values, sysPerms == null ? null : sysPerms.values);
    }

    private Map<String, Collection<SecurityPermission>> sort(List<PermissionElement> perms) throws IgniteCheckedException {
        Collections.sort(perms, CMP);
        LinkedHashMap<String, Collection<SecurityPermission>> res = new LinkedHashMap<String, Collection<SecurityPermission>>();
        for (PermissionElement el : perms) {
            Collection<SecurityPermission> old = res.put(el.name, el.values);
            if (old == null) continue;
            throw new IgniteCheckedException("Duplicate permission rule for " + (el.type == 1 ? TASK : CACHE) + ": " + el.name);
        }
        return res;
    }

    private boolean matchDefaultAllowAll(Boolean dfltAllowAll) throws IgniteCheckedException {
        Token t2 = this.token();
        assert (t2.type() == 6);
        if (!DEFAULT_ALLOW.equalsIgnoreCase(t2.value())) {
            throw this.unexpected(t2, "'defaultAllow'");
        }
        if (dfltAllowAll != null) {
            throw new IgniteCheckedException("Duplicate 'defaultAllow' statement [src=" + this.src + ", pos=" + t2.position() + ']');
        }
        this.matchToken("':'", 4);
        t2 = this.matchToken("'true' or 'false'", 6);
        if ("true".equalsIgnoreCase(t2.value())) {
            return true;
        }
        if ("false".equalsIgnoreCase(t2.value())) {
            return false;
        }
        throw this.unexpected(t2, "'true' or 'false'");
    }

    private PermissionElement matchPermissionElement() throws IgniteCheckedException {
        PermissionElement el = new PermissionElement();
        this.matchToken("{", 0);
        Token t2 = this.matchToken("value", 6);
        if (TASK.equalsIgnoreCase(t2.value())) {
            el.type = 1;
        } else if (CACHE.equalsIgnoreCase(t2.value())) {
            el.type = 0;
        } else if (SERVICE.equalsIgnoreCase(t2.value())) {
            el.type = 3;
        } else if (TRACING.equalsIgnoreCase(t2.value())) {
            el.type = 4;
        } else if (SYSTEM.equalsIgnoreCase(t2.value())) {
            el.type = 2;
        } else {
            throw this.unexpected(t2, "'task', 'cache', 'service', 'tracing' or 'system'");
        }
        this.matchToken("':'", 4);
        if (el.type == 2 || el.type == 4) {
            el.values = this.matchValues();
        } else {
            t2 = this.matchToken("value", 6);
            el.name = t2.value();
            if (el.type == 1 && el.name == null) {
                throw new IgniteCheckedException("Task name cannot be null [src=" + this.src + ", pos=" + t2.position() + ']');
            }
            if (el.type == 3 && el.name == null) {
                throw new IgniteCheckedException("Service name cannot be null [src=" + this.src + ", pos=" + t2.position() + ']');
            }
            this.matchToken("','", 5);
            t2 = this.matchToken("value", 6);
            if (!PERMISSIONS.equalsIgnoreCase(t2.value())) {
                throw this.unexpected(t2, "'permissions'");
            }
            this.matchToken("':'", 4);
            el.values = this.matchValues();
        }
        this.matchToken("'}'", 1);
        return el;
    }

    private Collection<SecurityPermission> matchValues() throws IgniteCheckedException {
        ArrayList<SecurityPermission> res;
        block4: {
            Token t2;
            res = new ArrayList<SecurityPermission>();
            this.matchToken("[", 2);
            while ((t2 = this.matchToken("value or ']'", 6, 3)).type() == 6) {
                try {
                    res.add(SecurityPermission.valueOf(t2.value().toUpperCase()));
                }
                catch (IllegalArgumentException ignore) {
                    throw this.unexpected(t2, "one of " + Arrays.toString((Object[])SecurityPermission.values()));
                }
                t2 = this.matchToken("',' or ']'", 5, 3);
                if (t2.type() != 3) continue;
                break block4;
            }
            assert (t2.type() == 3);
        }
        return Collections.unmodifiableList(res);
    }

    private Token matchToken(String exp, int ... types) throws IgniteCheckedException {
        Token t2 = this.token();
        if (t2 == null) {
            throw new IgniteCheckedException("Unexpected end of input sequence: " + this.src);
        }
        for (int type : types) {
            if (t2.type != type) continue;
            return t2;
        }
        throw this.unexpected(t2, exp);
    }

    private IgniteCheckedException unexpected(Token t2, String exp) {
        return new IgniteCheckedException("Unexpected token (expected " + exp + ") [src=" + this.src + ", pos=" + t2.position() + ']');
    }

    private Token token() throws IgniteCheckedException {
        return this.lexer.nextToken();
    }

    private void unread(Token t2) {
        this.lexer.unread(t2);
    }

    private static class SecurityPermissionsUnmodifiableSet
    implements SecurityPermissionSet {
        private static final long serialVersionUID = -7878336190274652686L;
        private boolean dfltAllowAll;
        @GridToStringInclude
        private Map<String, Collection<SecurityPermission>> taskPermissions;
        @GridToStringInclude
        private Map<String, Collection<SecurityPermission>> cachePermissions;
        @GridToStringInclude
        private Collection<SecurityPermission> sysPermissions;
        @GridToStringInclude
        private transient Map<String, Collection<SecurityPermission>> srvcPerms;

        private SecurityPermissionsUnmodifiableSet(boolean dfltAllowAll, Map<String, Collection<SecurityPermission>> taskPermissions, Map<String, Collection<SecurityPermission>> cachePermissions, Map<String, Collection<SecurityPermission>> srvcPerms, Collection<SecurityPermission> tracingPermissions, Collection<SecurityPermission> sysPermissions) {
            this.dfltAllowAll = dfltAllowAll;
            this.taskPermissions = taskPermissions;
            this.cachePermissions = cachePermissions;
            this.srvcPerms = srvcPerms;
            this.sysPermissions = sysPermissions;
            if (SecurityUtils.isSecurityCompatibilityMode()) {
                this.srvcPerms = SecurityUtils.compatibleServicePermissions();
            }
            if (tracingPermissions != null) {
                this.srvcPerms.put("Tracing permissions set", tracingPermissions);
            }
        }

        @Override
        public boolean defaultAllowAll() {
            return this.dfltAllowAll;
        }

        @Override
        public Map<String, Collection<SecurityPermission>> taskPermissions() {
            return this.taskPermissions;
        }

        @Override
        public Map<String, Collection<SecurityPermission>> cachePermissions() {
            return this.cachePermissions;
        }

        @Override
        public Map<String, Collection<SecurityPermission>> servicePermissions() {
            return F.view(this.srvcPerms, s2 -> !s2.equals("Tracing permissions set"));
        }

        @Override
        public Collection<SecurityPermission> systemPermissions() {
            return this.sysPermissions;
        }

        @Override
        public Collection<SecurityPermission> tracingPermissions() {
            return this.srvcPerms.getOrDefault("Tracing permissions set", Collections.emptySet());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SecurityPermissionsUnmodifiableSet)) {
                return false;
            }
            SecurityPermissionsUnmodifiableSet that = (SecurityPermissionsUnmodifiableSet)o;
            return this.dfltAllowAll == that.dfltAllowAll && F.eq(this.cachePermissions, that.cachePermissions) && F.eq(this.sysPermissions, that.sysPermissions) && F.eq(this.taskPermissions, that.taskPermissions) && F.eq(this.srvcPerms, that.srvcPerms);
        }

        public int hashCode() {
            int res = this.dfltAllowAll ? 1 : 0;
            res = 31 * res + (this.taskPermissions != null ? this.taskPermissions.hashCode() : 0);
            res = 31 * res + (this.cachePermissions != null ? this.cachePermissions.hashCode() : 0);
            res = 31 * res + (this.sysPermissions != null ? this.sysPermissions.hashCode() : 0);
            res = 31 * res + (this.srvcPerms != null ? this.srvcPerms.hashCode() : 0);
            return res;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (SecurityUtils.serializeVersion() >= 2) {
                U.writeMap(out, this.srvcPerms);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (SecurityUtils.serializeVersion() >= 2) {
                this.srvcPerms = U.readMap(in);
            }
            if (this.srvcPerms == null) {
                this.srvcPerms = SecurityUtils.serializeVersion() < 2 ? SecurityUtils.compatibleServicePermissions() : Collections.emptyMap();
            }
        }

        public String toString() {
            return S.toString(SecurityPermissionsUnmodifiableSet.class, this);
        }
    }

    private static class JsonLexer {
        private CharSequence src;
        private int idx;
        private int startIdx;
        private Token unread;

        private JsonLexer(CharSequence src) {
            this.src = src;
        }

        @Nullable
        private Token nextToken() throws IgniteCheckedException {
            Token tmp = this.unread;
            if (tmp != null) {
                this.unread = null;
                return tmp;
            }
            while (this.idx < this.src.length()) {
                char ch = this.src.charAt(this.idx++);
                switch (ch) {
                    case '{': {
                        return new Token(0, this.idx - 1);
                    }
                    case '}': {
                        return new Token(1, this.idx - 1);
                    }
                    case '[': {
                        return new Token(2, this.idx - 1);
                    }
                    case ']': {
                        return new Token(3, this.idx - 1);
                    }
                    case ',': {
                        return new Token(5, this.idx - 1);
                    }
                    case ':': {
                        return new Token(4, this.idx - 1);
                    }
                    case '\"': {
                        return this.doubleQuotedValue();
                    }
                    case '\'': {
                        return this.singleQuotedValue();
                    }
                }
                if (Character.isWhitespace(ch)) continue;
                if (Character.isJavaIdentifierStart(ch)) {
                    return this.value();
                }
                throw new IgniteCheckedException("Illegal character [src=" + this.src + ", pos=" + (this.idx - 1) + ']');
            }
            return null;
        }

        private void unread(Token t2) {
            assert (this.unread == null) : "Cannot unread more than one token";
            this.unread = t2;
        }

        private Token value() {
            this.startIdx = this.idx - 1;
            while (this.idx < this.src.length() && Character.isJavaIdentifierPart(this.src.charAt(this.idx))) {
                ++this.idx;
            }
            String val = this.src.subSequence(this.startIdx, this.idx).toString();
            if ("null".equals(val)) {
                val = null;
            }
            return new Token(val, this.startIdx);
        }

        private Token doubleQuotedValue() throws IgniteCheckedException {
            this.startIdx = this.idx;
            while (this.idx < this.src.length()) {
                if (this.src.charAt(this.idx++) != '\"') continue;
                return new Token(this.src.subSequence(this.startIdx, this.idx - 1).toString(), this.startIdx - 1);
            }
            throw new IgniteCheckedException("Missing terminating '\"' symbol [src=" + this.src + ", startPos=" + this.startIdx);
        }

        private Token singleQuotedValue() throws IgniteCheckedException {
            this.startIdx = this.idx;
            while (this.idx < this.src.length()) {
                if (this.src.charAt(this.idx++) != '\'') continue;
                return new Token(this.src.subSequence(this.startIdx, this.idx - 1).toString(), this.startIdx - 1);
            }
            throw new IgniteCheckedException("Missing terminating \"'\" symbol [src=" + this.src + ", startPos=" + this.startIdx);
        }
    }

    private static class Token {
        private static final int LBRACE = 0;
        private static final int RBRACE = 1;
        private static final int LBRACKET = 2;
        private static final int RBRACKET = 3;
        private static final int COLON = 4;
        private static final int COMMA = 5;
        private static final int VALUE = 6;
        private int type;
        private String val;
        private int pos;

        private Token(int type, int pos) {
            this.type = type;
            this.pos = pos;
        }

        private Token(String val, int pos) {
            this.pos = pos;
            this.type = 6;
            this.val = val;
        }

        private int type() {
            return this.type;
        }

        private int position() {
            return this.pos;
        }

        public String value() {
            return this.val;
        }
    }

    private static class PermissionElement {
        private static final int TYPE_CACHE = 0;
        private static final int TYPE_TASK = 1;
        private static final int TYPE_SYSTEM = 2;
        private static final int TYPE_SERVICE = 3;
        private static final int TYPE_TRACING = 4;
        private int type = -1;
        private String name;
        private Collection<SecurityPermission> values;

        private PermissionElement() {
        }
    }
}

