/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.grid.cache.store.local.CacheFileLocalStore;

public class GridUtils {
    private static final String[] ERR_DISK_FULL = new String[]{"No space left on device", "There is not enough space on the disk", "Not enough space"};

    public static void ensureNoCompactFootersForLocalStore(IgniteConfiguration cfg) throws IgniteException {
        if (GridUtils.hasBinaryCompactFooters(cfg)) {
            throw new IgniteException("\"BinaryConfiguration.compactFooter\" property must be set to \"false\" explicitly when " + CacheFileLocalStore.class + " is used (please do that using IgniteConfiguration.setBinaryConfiguration() method).");
        }
    }

    public static boolean hasBinaryCompactFooters(IgniteConfiguration cfg) {
        Marshaller marsh = cfg.getMarshaller();
        if (marsh == null || marsh instanceof BinaryMarshaller) {
            BinaryConfiguration binCfg = cfg.getBinaryConfiguration();
            if (binCfg == null) {
                binCfg = new BinaryConfiguration();
            }
            return binCfg.isCompactFooter();
        }
        return false;
    }

    public static boolean isDiskFullException(IOException ex) {
        if (ex == null || ex.getMessage() == null) {
            return false;
        }
        return Arrays.stream(ERR_DISK_FULL).anyMatch(e -> ex.getMessage().contains((CharSequence)e));
    }

    private GridUtils() {
    }
}

