/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.txdr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;

public class ReplicationSessionDescriptor
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private ClusterRole role;
    private ReplicationState state;
    private long lastSuccessfullySentWalIdx = -1L;
    private long lastCreatedCutId = -1L;
    private long lastSuccessfullyAppliedCutId;
    private long lastGloballyAppliedCutId;
    private long sesId;
    private List<String> essentialMessages = new ArrayList<String>();
    private boolean laggingBehind;
    private boolean readOnly;

    public ReplicationSessionDescriptor() {
        this.state(ReplicationState.STOPPED);
        this.role(ClusterRole.DISABLED);
    }

    public ReplicationSessionDescriptor(ClusterRole role) {
        this();
        this.role = role;
    }

    public ReplicationSessionDescriptor(ClusterRole role, ReplicationState state) {
        this.role = role;
        this.state = state;
    }

    public ReplicationSessionDescriptor(ReplicationSessionDescriptor cpFrom) {
        this();
        this.role(cpFrom.role());
        this.state(cpFrom.state());
        this.lastSuccessfullyAppliedCutId(cpFrom.lastSuccessfullyAppliedCutId());
        this.lastSuccessfullySentWalIndex(cpFrom.lastSuccessfullySentWalIndex());
        this.lastCreatedCutId(cpFrom.lastCreatedCutId());
        this.sessionId(cpFrom.sessionId());
        this.lastGloballyAppliedCutId(cpFrom.lastGloballyAppliedCutId());
        this.laggingBehind(cpFrom.laggingBehind);
        this.readOnly(cpFrom.readOnly);
        this.essentialMessages(cpFrom.essentialMessages);
    }

    public ClusterRole role() {
        return this.role;
    }

    public ReplicationSessionDescriptor role(ClusterRole role) {
        this.role = role;
        return this;
    }

    public ReplicationState state() {
        return this.state;
    }

    public ReplicationSessionDescriptor state(ReplicationState state) {
        this.state = state;
        return this;
    }

    public long lastSuccessfullySentWalIndex() {
        return this.lastSuccessfullySentWalIdx;
    }

    public ReplicationSessionDescriptor lastSuccessfullySentWalIndex(long lastSuccessfullySentWalIdx) {
        this.lastSuccessfullySentWalIdx = lastSuccessfullySentWalIdx;
        return this;
    }

    public long lastCreatedCutId() {
        return this.lastCreatedCutId;
    }

    public ReplicationSessionDescriptor lastCreatedCutId(long lastCreatedCutId) {
        this.lastCreatedCutId = lastCreatedCutId;
        return this;
    }

    public long lastSuccessfullyAppliedCutId() {
        return this.lastSuccessfullyAppliedCutId;
    }

    public ReplicationSessionDescriptor lastSuccessfullyAppliedCutId(long lastSuccessfullyAppliedCutId) {
        this.lastSuccessfullyAppliedCutId = lastSuccessfullyAppliedCutId;
        return this;
    }

    public long sessionId() {
        return this.sesId;
    }

    public ReplicationSessionDescriptor sessionId(long sesId) {
        this.sesId = sesId;
        return this;
    }

    public long lastGloballyAppliedCutId() {
        return this.lastGloballyAppliedCutId;
    }

    public ReplicationSessionDescriptor lastGloballyAppliedCutId(long lastGloballyAppliedCutId) {
        this.lastGloballyAppliedCutId = lastGloballyAppliedCutId;
        return this;
    }

    public boolean laggingBehind() {
        return this.laggingBehind;
    }

    public ReplicationSessionDescriptor laggingBehind(boolean laggingBehind) {
        this.laggingBehind = laggingBehind;
        return this;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public ReplicationSessionDescriptor readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public List<String> essentialMessages() {
        return this.essentialMessages;
    }

    public ReplicationSessionDescriptor essentialMessages(Iterable<String> essentialMessages) {
        ArrayList<String> msgList = new ArrayList<String>();
        essentialMessages.forEach(msgList::add);
        this.essentialMessages = msgList;
        return this;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.role);
        U.writeEnum(out, this.state);
        out.writeLong(this.sesId);
        out.writeLong(this.lastCreatedCutId);
        out.writeLong(this.lastSuccessfullySentWalIdx);
        out.writeLong(this.lastSuccessfullyAppliedCutId);
        out.writeBoolean(this.laggingBehind);
        out.writeBoolean(this.readOnly);
        out.writeLong(this.lastGloballyAppliedCutId);
        out.writeInt(this.essentialMessages.size());
        for (String msg : this.essentialMessages) {
            out.writeUTF(msg);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.role = ClusterRole.fromOrdinal(in.readByte());
        this.state = ReplicationState.fromOrdinal(in.readByte());
        this.sesId = in.readLong();
        this.lastCreatedCutId = in.readLong();
        this.lastSuccessfullySentWalIdx = in.readLong();
        this.lastSuccessfullyAppliedCutId = in.readLong();
        this.laggingBehind = in.readBoolean();
        this.readOnly = in.readBoolean();
        if (protoVer >= 2) {
            this.lastGloballyAppliedCutId = in.readLong();
            if (protoVer >= 3) {
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    this.essentialMessages.add(in.readUTF());
                }
            }
        }
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    public String toString() {
        return S.toString(ReplicationSessionDescriptor.class, this);
    }
}

